/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.geneditor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.PropertyStorage;

public final class ConfigurationPanelData
extends DefaultTraversablePanel {
    public static final String TITLE = "Translators";
    public static final String PAGE_TITLE = "Translation Options";
    public static final String[] DATEFORMATS = new String[]{"dd/mm/yyyy", "day/mon/yyyy"};
    private JTextField m_varPrefixTextField;
    private JTextField m_inParamTextField;
    private JComboBox m_dataFormatComboBox;
    private JComboBox m_queryAssignmentCombobox;
    private JCheckBox m_genEntireEmulationPkgField;
    private JPanel jPanelLevel = null;
    private JPanel jPanel1 = null;
    private JTextField m_dataFormatTextField;
    private boolean _inited = false;

    public ConfigurationPanelData() {
        this.setDefaultTitle(PAGE_TITLE);
        this.setHelpID("f1_configurationpaneldata_html");
    }

    private void jbInit() throws Exception {
        if (!this._inited) {
            this._inited = true;
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0));
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.add(this.getDateFormatComboBoxPanel());
            jPanel.add(this.getQueryAssignmentComboBoxPanel());
            jPanel.add(this.getVarPrefixPanel());
            jPanel.add(this.getInParamPrefixPanel());
            jPanel.add(this.getGenerateEntireEmulationPkgPanel());
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel, "North");
            this.setLayout(new BorderLayout());
            this.add(jPanel3, "North");
        }
    }

    private static ConfigurationData getConfigurationDataPrefs(TraversableContext traversableContext) {
        return ConfigurationData.getInstance((PropertyStorage)traversableContext.getPropertyStorage());
    }

    public void onEntry(TraversableContext traversableContext) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        ConfigurationData configurationData = ConfigurationPanelData.getConfigurationDataPrefs(traversableContext);
        this.load(configurationData);
    }

    public void onExit(TraversableContext traversableContext) {
        ConfigurationData configurationData = ConfigurationPanelData.getConfigurationDataPrefs(traversableContext);
        this.commit(configurationData);
    }

    private void load(ConfigurationData configurationData) {
        this.m_dataFormatTextField.setText(configurationData.getDateFormat());
        this.m_queryAssignmentCombobox.setSelectedItem(configurationData.getQueryAssignment());
        this.m_varPrefixTextField.setText(configurationData.getVarPrefix());
        this.m_inParamTextField.setText(configurationData.getInParamPrefix());
        this.m_genEntireEmulationPkgField.setSelected(configurationData.getGenerateEntireEmulationPkg());
    }

    private void commit(ConfigurationData configurationData) {
        configurationData.setDateFormat(this.m_dataFormatTextField.getText());
        configurationData.setQueryAssignment((String)this.m_queryAssignmentCombobox.getSelectedItem());
        configurationData.setVarPrefix(this.m_varPrefixTextField.getText());
        configurationData.setInParamPrefix(this.m_inParamTextField.getText());
        configurationData.setGenerateEntireEmulationPkg(this.m_genEntireEmulationPkgField.isSelected());
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout);
        }
        return this.jPanel1;
    }

    private JPanel getDateFormatComboBoxPanel() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel = new JPanel();
        this.m_dataFormatTextField = new JTextField(14);
        this.m_dataFormatTextField.setHorizontalAlignment(2);
        JLabel jLabel = new JLabel("Default Source Date Format");
        jLabel.setHorizontalAlignment(2);
        jPanel.setLayout(flowLayout);
        jPanel.setAlignmentY(0.0f);
        jPanel.add((Component)jLabel, null);
        jPanel.add((Component)this.m_dataFormatTextField, null);
        return jPanel;
    }

    private JPanel getQueryAssignmentComboBoxPanel() {
        String[] stringArray = new String[]{"SELECT INTO assignment", "SELECT INTO assignment with Exception Handling", "FOR rec IN (SELECT...) LOOP assignment --best emulation"};
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel = new JPanel();
        this.m_queryAssignmentCombobox = new JComboBox<String>(stringArray);
        JLabel jLabel = new JLabel("Query Assignment Translation");
        jLabel.setHorizontalAlignment(2);
        jPanel.setLayout(flowLayout);
        jPanel.setAlignmentY(0.0f);
        jPanel.add((Component)jLabel, null);
        jPanel.add((Component)this.m_queryAssignmentCombobox, null);
        return jPanel;
    }

    private JPanel getVarPrefixPanel() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel = new JPanel();
        this.m_varPrefixTextField = new JTextField(4);
        this.m_varPrefixTextField.setHorizontalAlignment(2);
        JLabel jLabel = new JLabel("Variable Name Prefix");
        jLabel.setHorizontalAlignment(2);
        jPanel.setLayout(flowLayout);
        jPanel.setAlignmentY(0.0f);
        jPanel.add((Component)jLabel, null);
        jPanel.add((Component)this.m_varPrefixTextField, null);
        return jPanel;
    }

    private JPanel getInParamPrefixPanel() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel = new JPanel();
        this.m_inParamTextField = new JTextField(4);
        this.m_inParamTextField.setHorizontalAlignment(2);
        JLabel jLabel = new JLabel("In Parameter Prefix");
        jLabel.setHorizontalAlignment(2);
        jPanel.setLayout(flowLayout);
        jPanel.setAlignmentY(0.0f);
        jPanel.add((Component)jLabel, null);
        jPanel.add((Component)this.m_inParamTextField, null);
        return jPanel;
    }

    private JPanel getGenerateEntireEmulationPkgPanel() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel = new JPanel();
        this.m_genEntireEmulationPkgField = new JCheckBox("Generate Entire Emulation Package");
        this.m_genEntireEmulationPkgField.setHorizontalAlignment(2);
        jPanel.setLayout(flowLayout);
        jPanel.setAlignmentY(0.0f);
        jPanel.add((Component)this.m_genEntireEmulationPkgField, null);
        return jPanel;
    }
}

