/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.geneditor.language;

import java.io.File;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.migration.gui.logger.GUILog;
import oracle.dbtools.migration.gui.logger.LoggerRosetta;
import oracle.dbtools.raptor.geneditor.language.Fragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FragmentList {
    protected ArrayList<Fragment> fragments = null;
    protected LoggerRosetta log = new GUILog();
    private int clipStart = 0;
    private int clipEnd = 100000;

    public FragmentList(int n, int n2) {
        this.clipStart = n;
        this.clipEnd = n2;
        this.init();
    }

    public FragmentList(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        this.clipStart = n;
        this.clipEnd = n2;
        this.init();
        this.setList(nArray, nArray2, nArray3);
    }

    public FragmentList(String string, boolean bl) {
        this.init();
        if (bl) {
            this.loadFromXML(string);
        } else {
            this.loadFromXMLString(string);
        }
    }

    public ArrayList getBlocks() {
        return this.fragments;
    }

    protected void init() {
        this.fragments = new ArrayList();
    }

    private boolean isBetween(int n) {
        return n >= this.clipStart && n <= this.clipEnd;
    }

    public void setList(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length < nArray2.length ? nArray.length : nArray2.length;
        for (int i = 0; i < n; ++i) {
            this.fragments.add(new Fragment(nArray[i], nArray2[i], nArray3[i]));
        }
    }

    protected void setList(Document document) {
        NodeList nodeList = document.getElementsByTagName("fragment");
        this.fragments.clear();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            try {
                int n = Integer.parseInt(namedNodeMap.getNamedItem("startIndex").getNodeValue());
                int n2 = Integer.parseInt(namedNodeMap.getNamedItem("endIndex").getNodeValue());
                int n3 = Integer.parseInt(namedNodeMap.getNamedItem("type").getNodeValue());
                if (!this.isBetween(n) || !this.isBetween(n2)) continue;
                this.fragments.add(new Fragment(n, n2, n3));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.log.writeLog(numberFormatException.getMessage());
                numberFormatException.printStackTrace();
            }
        }
    }

    public void loadFromXMLString(String string) {
        try {
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(stringBufferInputStream);
            this.setList(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log.writeLog(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            this.log.writeLog(sAXException.getMessage());
        }
        catch (Exception exception) {
            this.log.writeLog(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void loadFromXML(String string) {
        try {
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            this.setList(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log.writeLog(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            this.log.writeLog(sAXException.getMessage());
        }
        catch (Exception exception) {
            this.log.writeLog(exception.getMessage());
        }
    }

    public StyledFragmentsList appendStyledFragmentsList(StyledFragmentsList styledFragmentsList) {
        block6: for (int i = 0; i < this.fragments.size(); ++i) {
            Fragment fragment = this.fragments.get(i);
            switch (fragment.getType()) {
                case 3: {
                    styledFragmentsList.add("base-comment-style", fragment.getStartIndex(), fragment.getEndIndex());
                    continue block6;
                }
                case 1: {
                    styledFragmentsList.add("base-identifier-style", fragment.getStartIndex(), fragment.getEndIndex());
                    continue block6;
                }
                case 2: {
                    styledFragmentsList.add("base-keyword-style", fragment.getStartIndex(), fragment.getEndIndex());
                    continue block6;
                }
                case 4: {
                    styledFragmentsList.add("base-operator-style", fragment.getStartIndex(), fragment.getEndIndex());
                    continue block6;
                }
            }
        }
        return styledFragmentsList;
    }
}

