/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.geneditor.language;

import java.util.ArrayList;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.filter.highlighting.HighLightingBlock;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.ITranslationAnalysisResult;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;

abstract class GenericBlockRenderer
implements BlockRenderer {
    TextBuffer m_textBuffer = null;

    public GenericBlockRenderer(TextBuffer textBuffer) {
        this.m_textBuffer = textBuffer;
    }

    protected abstract String getParserString();

    public void renderBlock(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4) {
        ITranslationAll iTranslationAll = (ITranslationAll)ParserFactory.getParser((String)this.getParserString());
        ITranslationAnalysisResult iTranslationAnalysisResult = null;
        int n5 = 0;
        String string = this.m_textBuffer.getString(0, this.m_textBuffer.getLength());
        try {
            if (iTranslationAll == null) {
                return;
            }
            iTranslationAnalysisResult = iTranslationAll.lex(string);
            if (iTranslationAnalysisResult == null) {
                styledFragmentsList.add(this.getDefaultStyleName(), n5, string.length());
                return;
            }
            ArrayList arrayList = iTranslationAnalysisResult.getSyntaxHighLightingBlocks();
            if (arrayList == null) {
                styledFragmentsList.add(this.getDefaultStyleName(), n5, string.length());
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                HighLightingBlock highLightingBlock = (HighLightingBlock)arrayList.get(i);
                if (highLightingBlock.m_startIndex > n5) {
                    styledFragmentsList.add(this.getDefaultStyleName(), n5, highLightingBlock.m_startIndex);
                } else if (highLightingBlock.m_startIndex < n5) {
                    if (highLightingBlock.m_endIndex <= n5) continue;
                    styledFragmentsList.add(this.getDefaultStyleName(), n5, highLightingBlock.m_endIndex);
                    n5 = highLightingBlock.m_endIndex;
                    continue;
                }
                n5 = this.mapTokenToStyleName(styledFragmentsList, highLightingBlock);
            }
            if (n5 < string.length() - 1) {
                styledFragmentsList.add(this.getDefaultStyleName(), n5, string.length());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            styledFragmentsList.add(this.getDefaultStyleName(), n5, string.length());
        }
    }

    private int mapTokenToStyleName(StyledFragmentsList styledFragmentsList, HighLightingBlock highLightingBlock) {
        String string = "";
        switch (highLightingBlock.m_type) {
            case 3: {
                string = "base-comment-style";
                break;
            }
            case 1: {
                string = "base-identifier-style";
                break;
            }
            case 2: {
                string = "base-keyword-style";
                break;
            }
            case 4: {
                string = "base-operator-style";
                break;
            }
            case 5: {
                string = "base-string-style";
                break;
            }
            default: {
                string = this.getDefaultStyleName();
            }
        }
        styledFragmentsList.add(string, highLightingBlock.m_startIndex, highLightingBlock.m_endIndex);
        return highLightingBlock.m_endIndex;
    }

    protected String getDefaultStyleName() {
        return "base-plain-style";
    }
}

