/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.geneditor.language;

import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

class GenericStyles {
    public static final String SQL_COMMENT_STYLE = "sql-comment-style";
    public static final String SQL_KEYWORD_STYLE = "sql-keyword-style";
    public static final String SQL_IDENTIFIER_STYLE = "sql-identifier-style";
    public static final String SQL_STRING_STYLE = "sql-string-style";
    public static final String SQL_NUMBER_STYLE = "sql-number-style";
    public static final String SQL_BRACE_STYLE = "sql-brace-style";
    public static final String SQL_OPERATOR_STYLE = "sql-operator-style";
    public static final String[] STYLE_NAMES = new String[]{"sql-comment-style", "sql-keyword-style", "sql-identifier-style", "sql-string-style", "sql-number-style", "sql-brace-style", "sql-operator-style"};
    public static BaseStyle sqlPlainStyle;
    public static BaseStyle sqlCommentStyle;
    public static BaseStyle sqlKeywordStyle;
    public static BaseStyle sqlIdentifierStyle;
    public static BaseStyle sqlStringStyle;
    public static BaseStyle sqlNumberStyle;
    public static BaseStyle sqlBraceStyle;
    public static BaseStyle sqlOperatorStyle;

    public GenericStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String string;
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        sqlPlainStyle = builtInStyles.plainStyle;
        sqlCommentStyle = styleRegistry.lookupStyle(SQL_COMMENT_STYLE);
        if (sqlCommentStyle == null) {
            string = bundleHelper.getString("SQL_COMMENT_STYLE");
            sqlCommentStyle = styleRegistry.createStyle(SQL_COMMENT_STYLE, string, "base-comment-style");
        }
        if ((sqlStringStyle = styleRegistry.lookupStyle(SQL_STRING_STYLE)) == null) {
            string = bundleHelper.getString("SQL_STRING_STYLE");
            sqlStringStyle = styleRegistry.createStyle(SQL_STRING_STYLE, string, "base-string-style");
        }
        if ((sqlKeywordStyle = styleRegistry.lookupStyle(SQL_KEYWORD_STYLE)) == null) {
            string = bundleHelper.getString("SQL_KEYWORD_STYLE");
            sqlKeywordStyle = styleRegistry.createStyle(SQL_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((sqlIdentifierStyle = styleRegistry.lookupStyle(SQL_IDENTIFIER_STYLE)) == null) {
            string = bundleHelper.getString("SQL_IDENTIFIER_STYLE");
            sqlIdentifierStyle = styleRegistry.createStyle(SQL_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((sqlNumberStyle = styleRegistry.lookupStyle(SQL_NUMBER_STYLE)) == null) {
            string = bundleHelper.getString("SQL_NUMBER_STYLE");
            sqlNumberStyle = styleRegistry.createStyle(SQL_NUMBER_STYLE, string, "base-number-style");
        }
        if ((sqlBraceStyle = styleRegistry.lookupStyle(SQL_BRACE_STYLE)) == null) {
            string = bundleHelper.getString("SQL_BRACE_STYLE");
            sqlBraceStyle = styleRegistry.createStyle(SQL_BRACE_STYLE, string, "base-brace-style");
        }
        if ((sqlOperatorStyle = styleRegistry.lookupStyle(SQL_OPERATOR_STYLE)) == null) {
            string = bundleHelper.getString("SQL_OPERATOR_STYLE");
            sqlOperatorStyle = styleRegistry.createStyle(SQL_OPERATOR_STYLE, string, "base-operator-style");
        }
    }
}

