/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.geneditor.language;

import oracle.dbtools.raptor.geneditor.language.TSQLBlockRenderer;
import oracle.dbtools.raptor.geneditor.language.TSQLLanguageSupport;
import oracle.dbtools.raptor.geneditor.language.TSQLStyles;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class TSQLLanguageModule
extends LanguageModule {
    private static final String FILETYPE_TSQL = "tsql";
    private static final String[] supportedFileTypes = new String[]{"tsql"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("PLSQL_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return TSQLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- Create the department table first\n");
        stringBuffer.append("DROP TABLE dept;\n");
        stringBuffer.append("\n");
        stringBuffer.append("CREATE TABLE dept ( deptno NUMBER (2),\n");
        stringBuffer.append("                    dname VARCHAR2(10),\n");
        stringBuffer.append("                    loc VARCHAR2(9) );\n");
        stringBuffer.append("\n");
        stringBuffer.append("-- Insert some default values\n");
        stringBuffer.append("INSERT INTO dept VALUES ");
        stringBuffer.append("( 10, 'SALES', 'Boston' );\n");
        stringBuffer.append("INSERT INTO dept VALUES ");
        stringBuffer.append("( 20, 'EDUCATION', 'San Francisco' );\n");
        stringBuffer.append("INSERT INTO dept VALUES ");
        stringBuffer.append("( 30, 'CONSULTING', 'Seattle' );\n");
        stringBuffer.append("INSERT INTO dept VALUES ");
        stringBuffer.append("( 40, 'FINANCE', 'New York' );\n");
        stringBuffer.append("INSERT INTO dept VALUES ");
        stringBuffer.append("( 50, 'PERSONNEL', 'Chicago' );\n");
        stringBuffer.append("INSERT INTO dept VALUES ");
        stringBuffer.append("( 60, 'DEVELOPMENT', 'Seattle' );\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new TSQLStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new TSQLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new TSQLBlockRenderer(textBuffer);
    }
}

