/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class Peek {
    private GhostPointingPalette gPanel;
    private JComponent contentComp;
    private JScrollPane sp;
    private JLabel label;
    private JComponent comp;
    private Rectangle rect;

    private void $init$() {
        this.gPanel = new GhostPointingPalette();
        this.label = new JLabel();
    }

    public Peek(JComponent comp, JComponent contentComp) {
        this.$init$();
        this.comp = comp;
        this.contentComp = contentComp;
        this.gPanel = new 1();
        this.gPanel.setLayout((LayoutManager)new BorderLayout());
        this.gPanel.setLook(UIConstants.Look.DARK);
        this.gPanel.setCloseVisible(false);
        this.gPanel.setReceivesFocus(false);
        this.gPanel.setHideOnControlUp(true);
        this.sp = new JScrollPane(this.getContentComponent());
        this.sp.setBorder(null);
        this.gPanel.registerTransparentComponent((JComponent)this.sp.getViewport());
        JPanel footer = new JPanel(new BorderLayout());
        footer.setLayout(new BorderLayout());
        footer.add((Component)this.label, "After");
        footer.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.gPanel.add((Component)this.sp, (Object)"Center");
        this.gPanel.add((Component)footer, (Object)"South");
        this.label.setVisible(false);
    }

    public void hidePeek() {
        if (this.gPanel != null) {
            this.gPanel.hidePanel();
            this.gPanel = null;
            this.contentComp = null;
            this.comp = null;
        }
    }

    public boolean isShowing() {
        return this.gPanel != null && this.gPanel.isShowing();
    }

    public JComponent getContentComponent() {
        return this.contentComp;
    }

    public void setLabelText(String text) {
        if (text != null) {
            this.label.setText(text);
            this.label.setVisible(true);
        } else {
            this.label.setVisible(false);
        }
    }

    public void setLabelIcon(Icon labelIcon) {
        this.label.setIcon(labelIcon);
    }

    public void setRectangle(Rectangle rect) {
        this.rect = rect;
    }

    public void showPeek() {
        this.showPeek(Ide.getMainWindow().getLayeredPane());
    }

    public void showPeek(JLayeredPane layerPane) {
        this.gPanel.setPointing(this.comp, this.rect);
        Dimension epPrefSize = this.contentComp.getPreferredSize();
        this.contentComp.setPreferredSize(new Dimension(epPrefSize.width, epPrefSize.height + 10));
        this.gPanel.pack();
        this.rect = SwingUtilities.convertRectangle(this.comp, this.rect, layerPane);
        Point location = new Point(this.rect.x + this.rect.width / 2 - this.gPanel.getWidth() / 2, this.rect.y + this.rect.height + 15);
        location.x = Math.max(5, location.x);
        int heightOver = location.y + this.gPanel.getHeight() - layerPane.getHeight();
        Dimension prefSize = this.contentComp.getPreferredSize();
        if (layerPane.getHeight() - this.rect.y < prefSize.height + 50 && this.rect.y > layerPane.getHeight() / 2) {
            int topMostY = 75;
            int pointGap = 45;
            location.y = Math.max(topMostY, this.rect.y - prefSize.height - pointGap);
            if (prefSize.height > this.rect.y - topMostY - pointGap) {
                prefSize.height = this.rect.y - topMostY - pointGap;
                prefSize.width = (int)((double)prefSize.width + this.sp.getVerticalScrollBar().getPreferredSize().getWidth());
            }
            this.contentComp.setPreferredSize(prefSize);
            this.contentComp.setSize(prefSize);
            this.gPanel.pack();
        } else if (heightOver > 0) {
            prefSize.height -= heightOver + 30;
            prefSize.width = (int)((double)prefSize.width + this.sp.getVerticalScrollBar().getPreferredSize().getWidth());
            this.contentComp.setPreferredSize(prefSize);
            this.contentComp.setSize(prefSize);
            this.gPanel.pack();
        }
        int widthOver = location.x + this.gPanel.getWidth() - layerPane.getWidth();
        if (widthOver > 0) {
            location.x -= widthOver + 10;
            if (location.x < 10) {
                prefSize.width = prefSize.width + location.x - 10;
                location.x = 10;
            }
            prefSize.height = (int)((double)prefSize.height + this.sp.getHorizontalScrollBar().getPreferredSize().getHeight());
            this.contentComp.setPreferredSize(prefSize);
            this.contentComp.setSize(prefSize);
            this.gPanel.pack();
        }
        this.gPanel.setLocation(location);
        this.gPanel.show(layerPane, false, false);
    }

    public GhostPointingPalette getGhostPointingPalette() {
        return this.gPanel;
    }

    public GhostPalette getGhostPalette() {
        return this.gPanel;
    }

    public JComponent getComponent() {
        return this.comp;
    }

    static void wa$gPanel(Peek peek, GhostPointingPalette ghostPointingPalette) {
        peek.gPanel = ghostPointingPalette;
    }

    final class 1
    extends GhostPointingPalette {
        public void dispose() {
            super.dispose();
            Peek.wa$gPanel(Peek.this, null);
        }
    }
}

