/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.model.ImageNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PeekHelper {
    public static CodePeek createCodePeek(JComponent comp, String fileName, String text, String labelText, Rectangle rect) {
        if (text == null) {
            return null;
        }
        CodePeek peek = null;
        peek = new CodePeek(comp, fileName);
        rect.grow(1, 0);
        rect.translate(-1, -1);
        rect.x = Math.max(rect.x, 0);
        rect.y = Math.max(rect.y, 0);
        peek.setRectangle(rect);
        peek.setText(text);
        peek.setLabelText(labelText);
        return peek;
    }

    public static Peek createPeek(URL url, JComponent comp, Rectangle rect) {
        Node node;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            Peek peek = null;
            return peek;
        }
        catch (InstantiationException e) {
            Peek peek = null;
            return peek;
        }
        boolean opened = false;
        if (!node.isOpen()) {
            try {
                node.open();
                opened = true;
            }
            catch (IOException e) {
                node = null;
            }
        }
        Peek peek = null;
        if (node instanceof TextNode) {
            opened = false;
            peek = PeekHelper.createTextPeek((TextNode)node, comp, rect);
        } else if (node instanceof ImageNode) {
            peek = PeekHelper.createImagePeek((ImageNode)node, comp, rect);
        }
        if (peek != null) {
            peek.setLabelIcon(node.getIcon());
        }
        if (opened && node != null) {
            try {
                node.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Peek peek2 = null;
                return peek2;
            }
        }
        return peek;
    }

    public static Peek createTextPeek(TextNode textNode, JComponent comp, Rectangle rect) {
        String text = PeekHelper.getPeekText(textNode.getURL());
        CodePeek peek = PeekHelper.createCodePeek(comp, textNode.getShortLabel(), text, textNode.getShortLabel(), rect);
        return peek;
    }

    public static Peek createImagePeek(ImageNode node, JComponent comp, Rectangle rect) {
        Image image = node.getImage();
        if (image != null) {
            JLabel imageLabel = new JLabel(new ImageIcon(image));
            Peek peek = new Peek(comp, imageLabel);
            peek.setRectangle(rect);
            return peek;
        }
        return null;
    }

    public static String getPeekText(URL url, int line, int padLines) {
        Node node;
        Reader reader = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            String string = null;
            return string;
        }
        catch (InstantiationException e) {
            String string = null;
            return string;
        }
        boolean opened = false;
        if (!node.isOpen()) {
            try {
                node.open();
                opened = true;
            }
            catch (IOException e) {
                node = null;
            }
        }
        if (node instanceof TextNode) {
            TextNode tNode = (TextNode)node;
            try {
                reader = tNode.getReader();
                opened = false;
            }
            catch (IOException e) {
                reader = null;
            }
        }
        String text = null;
        text = line == -1 ? PeekHelper.readWholeNode(reader) : PeekHelper.readText(reader, line, padLines);
        if (opened) {
            try {
                node.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public static void addHighlight(CodePeek peek, int line, String styleName) {
        HighlightLayer hl = peek.getEditor().createHighlightLayer();
        EditorProperties properties = EditorProperties.getProperties();
        HighlightStyle style = properties.getHighlightRegistry().lookupStyle(styleName);
        hl.addLineHighlight(style, line);
    }

    public static Pair<String, Integer> getPeekTextByOffset(URL url, int offset, int padLines) {
        Node node;
        Reader reader = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            Pair<String, Integer> pair = null;
            return pair;
        }
        catch (InstantiationException e) {
            Pair<String, Integer> pair = null;
            return pair;
        }
        boolean opened = false;
        if (!node.isOpen()) {
            try {
                node.open();
                opened = true;
            }
            catch (IOException e) {
                node = null;
            }
        }
        if (node instanceof TextNode) {
            TextNode tNode = (TextNode)node;
            try {
                reader = tNode.getReader();
                opened = false;
            }
            catch (IOException e) {
                reader = null;
            }
        }
        Pair<String, Integer> ret = PeekHelper.readTextOffset(reader, offset, padLines);
        if (opened) {
            try {
                node.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private static Pair<String, Integer> readTextOffset(Reader r, int offset, int padLines) {
        StringBuffer sb = new StringBuffer();
        int lines = padLines + 1;
        int curOffset = 0;
        int curLine = 0;
        LinkedList<String> lineList = new LinkedList<String>();
        try {
            try {
                r = new BufferedReader(r);
                String aLine = ((BufferedReader)r).readLine();
                while (aLine != null) {
                    aLine = aLine + "\n";
                    lineList.addLast(aLine);
                    if (lineList.size() > lines) {
                        lineList.removeFirst();
                    }
                    if ((curOffset += aLine.length()) > offset) break;
                    aLine = ((BufferedReader)r).readLine();
                    ++curLine;
                }
                int endPad = 0;
                aLine = ((BufferedReader)r).readLine();
                while (aLine != null && endPad < padLines) {
                    ++endPad;
                    aLine = aLine + "\n";
                    lineList.addLast(aLine);
                    aLine = ((BufferedReader)r).readLine();
                }
                for (String line : lineList) {
                    sb.append(line);
                }
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
                    sb.deleteCharAt(sb.length() - 1);
                }
            }
            catch (IOException e) {}
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {}
        }
        String text = sb.length() > 0 ? sb.toString() : null;
        return new Pair((Object)text, (Object)curLine);
    }

    public static String getPeekText(URL url) {
        return PeekHelper.getPeekText(url, -1, -1);
    }

    private static String readWholeNode(Reader reader) {
        StringBuffer sb = new StringBuffer();
        if (reader == null) {
            return null;
        }
        BufferedReader bReader = new BufferedReader(reader);
        try {
            try {
                String s = bReader.readLine();
                while (s != null) {
                    sb.append(s);
                    sb.append('\n');
                    s = bReader.readLine();
                }
            }
            catch (IOException e) {
                String string = null;
                try {
                    bReader.close();
                }
                catch (IOException iOException) {
                    String string2 = null;
                    return string2;
                }
                return string;
            }
        }
        finally {
            try {
                bReader.close();
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readText(Reader r, int line, int padLines) {
        String text = "";
        try {
            try {
                r = new BufferedReader(r);
                int firstLine = Math.max(0, line - padLines);
                int lastLine = line + padLines;
                int curLine = 0;
                String aLine = ((BufferedReader)r).readLine();
                while (aLine != null) {
                    if (curLine > lastLine) {
                        return text;
                    }
                    if (curLine >= firstLine && curLine <= lastLine) {
                        if (curLine > firstLine) {
                            text = text + "\n";
                        }
                        text = text + aLine;
                    }
                    ++curLine;
                    aLine = ((BufferedReader)r).readLine();
                }
                return text;
            }
            catch (IOException e) {
                return text;
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

