/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class BufferedInputStream
extends FilterInputStream {
    private static int defaultBufferSize = 8192;
    protected volatile byte[] buf;
    private static final AtomicReferenceFieldUpdater<BufferedInputStream, byte[]> bufUpdater = AtomicReferenceFieldUpdater.newUpdater(BufferedInputStream.class, byte[].class, "buf");
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    private InputStream getInIfOpen() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream == null) {
            throw new IOException("Stream closed");
        }
        return inputStream;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] byArray = this.buf;
        if (byArray == null) {
            throw new IOException("Stream closed");
        }
        return byArray;
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, defaultBufferSize);
    }

    public BufferedInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n2];
    }

    private void fill() throws IOException {
        int n2;
        byte[] byArray = this.getBufIfOpen();
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= byArray.length) {
            if (this.markpos > 0) {
                n2 = this.pos - this.markpos;
                System.arraycopy(byArray, this.markpos, byArray, 0, n2);
                this.pos = n2;
                this.markpos = 0;
            } else if (byArray.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                n2 = this.pos * 2;
                if (n2 > this.marklimit) {
                    n2 = this.marklimit;
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, this.pos);
                if (!bufUpdater.compareAndSet(this, byArray, byArray2)) {
                    throw new IOException("Stream closed");
                }
                byArray = byArray2;
            }
        }
        this.count = this.pos;
        n2 = this.getInIfOpen().read(byArray, this.pos, byArray.length - this.pos);
        if (n2 > 0) {
            this.count = n2 + this.pos;
        }
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.count - this.pos;
        if (n4 <= 0) {
            if (n3 >= this.getBufIfOpen().length && this.markpos < 0) {
                return this.getInIfOpen().read(byArray, n2, n3);
            }
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.getBufIfOpen(), this.pos, byArray, n2, n5);
        this.pos += n5;
        return n5;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        InputStream inputStream;
        this.getBufIfOpen();
        if ((n2 | n3 | n2 + n3 | byArray.length - (n2 + n3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        do {
            int n5;
            if ((n5 = this.read1(byArray, n2 + n4, n3 - n4)) <= 0) {
                return n4 == 0 ? n5 : n4;
            }
            if ((n4 += n5) < n3) continue;
            return n4;
        } while ((inputStream = this.in) == null || inputStream.available() > 0);
        return n4;
    }

    public synchronized long skip(long l2) throws IOException {
        this.getBufIfOpen();
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = this.count - this.pos;
        if (l3 <= 0L) {
            if (this.markpos < 0) {
                return this.getInIfOpen().skip(l2);
            }
            this.fill();
            l3 = this.count - this.pos;
            if (l3 <= 0L) {
                return 0L;
            }
        }
        long l4 = l3 < l2 ? l3 : l2;
        this.pos = (int)((long)this.pos + l4);
        return l4;
    }

    public synchronized int available() throws IOException {
        return this.getInIfOpen().available() + (this.count - this.pos);
    }

    public synchronized void mark(int n2) {
        this.marklimit = n2;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.getBufIfOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        block2: {
            byte[] byArray;
            do {
                byArray = this.buf;
                if (this.buf == null) break block2;
            } while (!bufUpdater.compareAndSet(this, byArray, null));
            InputStream inputStream = this.in;
            this.in = null;
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
    }
}

