/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.Win32ShellFolderManager2;

final class Win32ShellFolder2
extends ShellFolder {
    private static final boolean is98;
    public static final int DESKTOP = 0;
    public static final int INTERNET = 1;
    public static final int PROGRAMS = 2;
    public static final int CONTROLS = 3;
    public static final int PRINTERS = 4;
    public static final int PERSONAL = 5;
    public static final int FAVORITES = 6;
    public static final int STARTUP = 7;
    public static final int RECENT = 8;
    public static final int SENDTO = 9;
    public static final int BITBUCKET = 10;
    public static final int STARTMENU = 11;
    public static final int DESKTOPDIRECTORY = 16;
    public static final int DRIVES = 17;
    public static final int NETWORK = 18;
    public static final int NETHOOD = 19;
    public static final int FONTS = 20;
    public static final int TEMPLATES = 21;
    public static final int COMMON_STARTMENU = 22;
    public static final int COMMON_PROGRAMS = 23;
    public static final int COMMON_STARTUP = 24;
    public static final int COMMON_DESKTOPDIRECTORY = 25;
    public static final int APPDATA = 26;
    public static final int PRINTHOOD = 27;
    public static final int ALTSTARTUP = 29;
    public static final int COMMON_ALTSTARTUP = 30;
    public static final int COMMON_FAVORITES = 31;
    public static final int INTERNET_CACHE = 32;
    public static final int COOKIES = 33;
    public static final int HISTORY = 34;
    public static final int ATTRIB_CANCOPY = 1;
    public static final int ATTRIB_CANMOVE = 2;
    public static final int ATTRIB_CANLINK = 4;
    public static final int ATTRIB_CANRENAME = 16;
    public static final int ATTRIB_CANDELETE = 32;
    public static final int ATTRIB_HASPROPSHEET = 64;
    public static final int ATTRIB_DROPTARGET = 256;
    public static final int ATTRIB_LINK = 65536;
    public static final int ATTRIB_SHARE = 131072;
    public static final int ATTRIB_READONLY = 262144;
    public static final int ATTRIB_GHOSTED = 524288;
    public static final int ATTRIB_HIDDEN = 524288;
    public static final int ATTRIB_FILESYSANCESTOR = 0x10000000;
    public static final int ATTRIB_FOLDER = 0x20000000;
    public static final int ATTRIB_FILESYSTEM = 0x40000000;
    public static final int ATTRIB_HASSUBFOLDER = Integer.MIN_VALUE;
    public static final int ATTRIB_VALIDATE = 0x1000000;
    public static final int ATTRIB_REMOVABLE = 0x2000000;
    public static final int ATTRIB_COMPRESSED = 0x4000000;
    public static final int ATTRIB_BROWSABLE = 0x8000000;
    public static final int ATTRIB_NONENUMERATED = 0x100000;
    public static final int ATTRIB_NEWCONTENT = 0x200000;
    public static final int SHGDN_NORMAL = 0;
    public static final int SHGDN_INFOLDER = 1;
    public static final int SHGDN_INCLUDE_NONFILESYS = 8192;
    public static final int SHGDN_FORADDRESSBAR = 16384;
    public static final int SHGDN_FORPARSING = 32768;
    private long pIShellFolder = 0L;
    private long relativePIDL = 0L;
    private long absolutePIDL = 0L;
    private long pIShellIcon = -1L;
    private String folderType = null;
    private String displayName = null;
    private Image smallIcon = null;
    private Image largeIcon = null;
    private Boolean isDir = null;
    private boolean isPersonal;
    private static Map smallSystemImages;
    private static Map largeSystemImages;
    private static Map smallLinkedSystemImages;
    private static Map largeLinkedSystemImages;
    static int[] fileChooserBitmapBits;
    static Image[] fileChooserIcons;
    private List topFolderList = null;

    private static native void initIDs();

    Win32ShellFolder2(ShellFolder shellFolder, int n2, boolean bl2) throws IOException {
        super(shellFolder, Win32ShellFolder2.getFileSystemPath(n2) == null ? "ShellFolder: 0x" + Integer.toHexString(n2) : Win32ShellFolder2.getFileSystemPath(n2));
        if (n2 == 0) {
            this.initDesktop();
        } else {
            this.initSpecial(this.getDesktop().getIShellFolder(), n2);
        }
    }

    Win32ShellFolder2(Win32ShellFolder2 win32ShellFolder2, long l2, long l3, String string) {
        super(win32ShellFolder2, string != null ? string : "ShellFolder: ");
        this.pIShellFolder = l2;
        this.relativePIDL = l3;
    }

    Win32ShellFolder2(Win32ShellFolder2 win32ShellFolder2, long l2) {
        super(win32ShellFolder2, Win32ShellFolder2.getFileSystemPath(win32ShellFolder2.getIShellFolder(), l2));
        this.relativePIDL = l2;
        String string = this.getAbsolutePath();
    }

    private native void initDesktop();

    private native void initSpecial(long var1, int var3);

    public void setIsPersonal() {
        this.isPersonal = true;
    }

    protected Object writeReplace() throws ObjectStreamException {
        File[] fileArray;
        if (this.isFileSystem()) {
            return new File(this.getPath());
        }
        Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDrives();
        if (win32ShellFolder2 != null && (fileArray = win32ShellFolder2.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                Win32ShellFolder2 win32ShellFolder22;
                if (!(fileArray[i2] instanceof Win32ShellFolder2) || !(win32ShellFolder22 = (Win32ShellFolder2)fileArray[i2]).isFileSystem() || win32ShellFolder22.hasAttribute(0x2000000)) continue;
                return new File(win32ShellFolder22.getPath());
            }
        }
        return new File("C:\\");
    }

    protected void finalize() throws Throwable {
        if (this.relativePIDL != 0L) {
            Win32ShellFolder2.releasePIDL(this.relativePIDL);
            this.relativePIDL = 0L;
        }
        if (this.absolutePIDL != 0L) {
            Win32ShellFolder2.releasePIDL(this.absolutePIDL);
            this.absolutePIDL = 0L;
        }
        if (this.pIShellFolder != 0L) {
            Win32ShellFolder2.releaseIShellFolder(this.pIShellFolder);
            this.pIShellFolder = 0L;
        }
    }

    static native long getNextPIDLEntry(long var0);

    static native long copyFirstPIDLEntry(long var0);

    private static native long combinePIDLs(long var0, long var2);

    static native void releasePIDL(long var0);

    private static native void releaseIShellFolder(long var0);

    public long getIShellFolder() {
        if (this.pIShellFolder == 0L) {
            assert (this.isDirectory());
            assert (this.parent != null);
            long l2 = this.getParentIShellFolder();
            if (l2 == 0L) {
                throw new InternalError("Parent IShellFolder was null for " + this.getAbsolutePath());
            }
            this.pIShellFolder = Win32ShellFolder2.bindToObject(l2, this.relativePIDL);
            if (this.pIShellFolder == 0L) {
                throw new InternalError("Unable to bind " + this.getAbsolutePath() + " to parent");
            }
        }
        return this.pIShellFolder;
    }

    public long getParentIShellFolder() {
        Win32ShellFolder2 win32ShellFolder2 = (Win32ShellFolder2)this.getParentFile();
        if (win32ShellFolder2 == null) {
            return this.getIShellFolder();
        }
        return win32ShellFolder2.getIShellFolder();
    }

    public long getRelativePIDL() {
        if (this.relativePIDL == 0L) {
            throw new InternalError("Should always have a relative PIDL");
        }
        return this.relativePIDL;
    }

    private long getAbsolutePIDL() {
        if (this.parent == null) {
            return this.getRelativePIDL();
        }
        if (this.absolutePIDL == 0L) {
            this.absolutePIDL = Win32ShellFolder2.combinePIDLs(((Win32ShellFolder2)this.parent).getAbsolutePIDL(), this.getRelativePIDL());
        }
        return this.absolutePIDL;
    }

    public Win32ShellFolder2 getDesktop() {
        return Win32ShellFolderManager2.getDesktop();
    }

    public long getDesktopIShellFolder() {
        return this.getDesktop().getIShellFolder();
    }

    private static boolean pathsEqual(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Win32ShellFolder2)) {
            if (!(object instanceof File)) {
                return super.equals(object);
            }
            return Win32ShellFolder2.pathsEqual(this.getPath(), ((File)object).getPath());
        }
        Win32ShellFolder2 win32ShellFolder2 = (Win32ShellFolder2)object;
        if (this.parent == null && win32ShellFolder2.parent != null || this.parent != null && win32ShellFolder2.parent == null) {
            return false;
        }
        if (this.isFileSystem() && win32ShellFolder2.isFileSystem()) {
            return Win32ShellFolder2.pathsEqual(this.getPath(), win32ShellFolder2.getPath());
        }
        if (this.parent == null || this.parent == win32ShellFolder2.parent || this.parent.equals(win32ShellFolder2.parent)) {
            return Win32ShellFolder2.pidlsEqual(this.getParentIShellFolder(), this.relativePIDL, win32ShellFolder2.relativePIDL);
        }
        return false;
    }

    private static boolean pidlsEqual(long l2, long l3, long l4) {
        return Win32ShellFolder2.compareIDs(l2, l3, l4) == 0;
    }

    private static native int compareIDs(long var0, long var2, long var4);

    public boolean isFileSystem() {
        return this.hasAttribute(0x40000000);
    }

    public boolean hasAttribute(int n2) {
        return (Win32ShellFolder2.getAttributes0(this.getParentIShellFolder(), this.getRelativePIDL(), n2) & n2) != 0;
    }

    private static native int getAttributes0(long var0, long var2, int var4);

    private static String getFileSystemPath(long l2, long l3) {
        return Win32ShellFolder2.getDisplayNameOf(l2, l3, 32768);
    }

    static native String getFileSystemPath(int var0) throws IOException;

    private static boolean isNetworkRoot(String string) {
        return string.equals("\\\\") || string.equals("\\") || string.equals("//") || string.equals("/");
    }

    public File getParentFile() {
        return this.parent;
    }

    public boolean isDirectory() {
        if (this.isDir == null) {
            ShellFolder shellFolder;
            this.isDir = (this.hasAttribute(Integer.MIN_VALUE) || this.hasAttribute(0x20000000)) && (!this.hasAttribute(0x8000000) || is98 && this.equals(Win32ShellFolderManager2.getPersonal())) ? Boolean.TRUE : (this.isLink() ? Boolean.valueOf((shellFolder = this.getLinkLocation(false)) != null && shellFolder.isDirectory()) : Boolean.FALSE);
        }
        return this.isDir;
    }

    private long getEnumObjects(long l2, boolean bl2) {
        boolean bl3 = l2 == this.getDesktopIShellFolder();
        return this.getEnumObjects(l2, bl3, bl2);
    }

    private native long getEnumObjects(long var1, boolean var3, boolean var4);

    private native long getNextChild(long var1);

    private native void releaseEnumObjects(long var1);

    private static native long bindToObject(long var0, long var2);

    public File[] listFiles(boolean bl2) {
        if (!this.isDirectory()) {
            return null;
        }
        if (this.isLink() && !this.hasAttribute(0x20000000)) {
            return new File[0];
        }
        Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
        Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.getPersonal();
        Object var4_4 = null;
        long l2 = this.getIShellFolder();
        ArrayList<Win32ShellFolder2> arrayList = new ArrayList<Win32ShellFolder2>();
        long l3 = this.getEnumObjects(l2, bl2);
        if (l3 != 0L) {
            long l4 = 0L;
            int n2 = 0x50000000;
            do {
                l4 = this.getNextChild(l3);
                boolean bl3 = true;
                if (l4 != 0L && (Win32ShellFolder2.getAttributes0(l2, l4, n2) & n2) != 0) {
                    Win32ShellFolder2 win32ShellFolder23 = null;
                    if (this.equals(win32ShellFolder2) && win32ShellFolder22 != null && Win32ShellFolder2.pidlsEqual(l2, l4, win32ShellFolder22.relativePIDL)) {
                        win32ShellFolder23 = win32ShellFolder22;
                    } else {
                        win32ShellFolder23 = new Win32ShellFolder2(this, l4);
                        bl3 = false;
                    }
                    arrayList.add(win32ShellFolder23);
                }
                if (!bl3) continue;
                Win32ShellFolder2.releasePIDL(l4);
            } while (l4 != 0L);
            this.releaseEnumObjects(l3);
        }
        return arrayList.toArray(new ShellFolder[arrayList.size()]);
    }

    Win32ShellFolder2 getChildByPath(String string) {
        long l2 = this.getIShellFolder();
        long l3 = this.getEnumObjects(l2, true);
        Win32ShellFolder2 win32ShellFolder2 = null;
        long l4 = 0L;
        while ((l4 = this.getNextChild(l3)) != 0L) {
            String string2;
            if (Win32ShellFolder2.getAttributes0(l2, l4, 0x40000000) != 0 && (string2 = Win32ShellFolder2.getFileSystemPath(l2, l4)) != null && string2.equalsIgnoreCase(string)) {
                long l5 = Win32ShellFolder2.bindToObject(l2, l4);
                win32ShellFolder2 = new Win32ShellFolder2(this, l5, l4, string2);
                break;
            }
            Win32ShellFolder2.releasePIDL(l4);
        }
        this.releaseEnumObjects(l3);
        return win32ShellFolder2;
    }

    public boolean isLink() {
        return this.hasAttribute(65536);
    }

    public boolean isHidden() {
        return this.hasAttribute(524288);
    }

    private native long getLinkLocation(long var1, long var3, boolean var5);

    public ShellFolder getLinkLocation() {
        return this.getLinkLocation(true);
    }

    private ShellFolder getLinkLocation(boolean bl2) {
        if (!this.isLink()) {
            return null;
        }
        Win32ShellFolder2 win32ShellFolder2 = null;
        long l2 = this.getLinkLocation(this.getParentIShellFolder(), this.getRelativePIDL(), bl2);
        if (l2 != 0L) {
            try {
                win32ShellFolder2 = Win32ShellFolderManager2.createShellFolderFromRelativePIDL(this.getDesktop(), l2);
            }
            catch (InternalError internalError) {
                // empty catch block
            }
        }
        return win32ShellFolder2;
    }

    long parseDisplayName(String string) throws FileNotFoundException {
        try {
            return Win32ShellFolder2.parseDisplayName0(this.getIShellFolder(), string);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Could not find file " + string);
        }
    }

    private static native long parseDisplayName0(long var0, String var2) throws IOException;

    private static native String getDisplayNameOf(long var0, long var2, int var4);

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Win32ShellFolder2.getDisplayNameOf(this.getParentIShellFolder(), this.getRelativePIDL(), 0);
        }
        return this.displayName;
    }

    private static native String getFolderType(long var0);

    public String getFolderType() {
        if (this.folderType == null) {
            this.folderType = Win32ShellFolder2.getFolderType(this.getAbsolutePIDL());
        }
        return this.folderType;
    }

    private native String getExecutableType(String var1);

    public String getExecutableType() {
        if (!this.isFileSystem()) {
            return null;
        }
        return this.getExecutableType(this.getAbsolutePath());
    }

    private static native long getIShellIcon(long var0);

    private static native int getIconIndex(long var0, long var2);

    private static native long getIcon(String var0, boolean var1);

    private static native long extractIcon(long var0, long var2, boolean var4);

    private static native long getSystemIcon(int var0);

    private static native int[] getIconBits(long var0, int var2);

    private static native void disposeIcon(long var0);

    public static native int[] getFileChooserBitmapBits();

    private long getIShellIcon() {
        if (this.pIShellIcon == -1L) {
            this.pIShellIcon = Win32ShellFolder2.getIShellIcon(this.getIShellFolder());
        }
        return this.pIShellIcon;
    }

    static Image getFileChooserIcon(int n2) {
        if (fileChooserIcons[n2] != null) {
            return fileChooserIcons[n2];
        }
        if (fileChooserBitmapBits == null) {
            fileChooserBitmapBits = Win32ShellFolder2.getFileChooserBitmapBits();
        }
        if (fileChooserBitmapBits != null) {
            int n3 = fileChooserBitmapBits.length / 256;
            int[] nArray = new int[256];
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i3 = 0; i3 < 16; ++i3) {
                    nArray[i2 * 16 + i3] = fileChooserBitmapBits[i2 * (n3 * 16) + n2 * 16 + i3];
                }
            }
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            bufferedImage.setRGB(0, 0, 16, 16, nArray, 0, 16);
            Win32ShellFolder2.fileChooserIcons[n2] = bufferedImage;
        }
        return fileChooserIcons[n2];
    }

    private static Image makeIcon(long l2, boolean bl2) {
        int n2;
        int[] nArray;
        if (l2 != 0L && l2 != -1L && (nArray = Win32ShellFolder2.getIconBits(l2, n2 = bl2 ? 32 : 16)) != null) {
            BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
            bufferedImage.setRGB(0, 0, n2, n2, nArray, 0, n2);
            return bufferedImage;
        }
        return null;
    }

    public Image getIcon(boolean bl2) {
        Image image;
        Image image2 = image = bl2 ? this.largeIcon : this.smallIcon;
        if (image == null) {
            Map map;
            int n2;
            long l2 = this.parent != null ? ((Win32ShellFolder2)this.parent).getIShellIcon() : 0L;
            long l3 = this.getRelativePIDL();
            if (this.isFileSystem() && (n2 = Win32ShellFolder2.getIconIndex(l2, l3)) > 0 && (image = (Image)(map = this.isLink() ? (bl2 ? largeLinkedSystemImages : smallLinkedSystemImages) : (bl2 ? largeSystemImages : smallSystemImages)).get(new Integer(n2))) == null) {
                long l4 = Win32ShellFolder2.getIcon(this.getAbsolutePath(), bl2);
                image = Win32ShellFolder2.makeIcon(l4, bl2);
                Win32ShellFolder2.disposeIcon(l4);
                if (image != null) {
                    map.put(new Integer(n2), image);
                }
            }
            if (image == null) {
                long l5 = Win32ShellFolder2.extractIcon(this.getParentIShellFolder(), this.getRelativePIDL(), bl2);
                image = Win32ShellFolder2.makeIcon(l5, bl2);
                Win32ShellFolder2.disposeIcon(l5);
            }
            if (bl2) {
                this.largeIcon = image;
            } else {
                this.smallIcon = image;
            }
        }
        if (image == null) {
            image = super.getIcon(bl2);
        }
        return image;
    }

    static Image getSystemIcon(SystemIcon systemIcon) {
        long l2 = Win32ShellFolder2.getSystemIcon(systemIcon.getIconID());
        Image image = Win32ShellFolder2.makeIcon(l2, true);
        Win32ShellFolder2.disposeIcon(l2);
        return image;
    }

    public File getCanonicalFile() throws IOException {
        return this;
    }

    public boolean isSpecial() {
        return this.isPersonal || !this.isFileSystem() || this == this.getDesktop();
    }

    public int compareTo(File file) {
        if (!(file instanceof Win32ShellFolder2)) {
            if (this.isFileSystem() && !this.isSpecial()) {
                return super.compareTo(file);
            }
            return -1;
        }
        return Win32ShellFolderManager2.compareShellFolders(this, (Win32ShellFolder2)file);
    }

    static {
        String string = System.getProperty("os.name");
        is98 = string != null && string.startsWith("Windows 98");
        Win32ShellFolder2.initIDs();
        smallSystemImages = new HashMap();
        largeSystemImages = new HashMap();
        smallLinkedSystemImages = new HashMap();
        largeLinkedSystemImages = new HashMap();
        fileChooserBitmapBits = null;
        fileChooserIcons = new Image[47];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SystemIcon {
        IDI_APPLICATION(32512),
        IDI_HAND(32513),
        IDI_ERROR(32513),
        IDI_QUESTION(32514),
        IDI_EXCLAMATION(32515),
        IDI_WARNING(32515),
        IDI_ASTERISK(32516),
        IDI_INFORMATION(32516),
        IDI_WINLOGO(32517);

        private final int iconID;

        private SystemIcon(int n3) {
            this.iconID = n3;
        }

        public int getIconID() {
            return this.iconID;
        }
    }
}

