/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.DrawerWindowConfig;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.navigator.ApplicationChangeNotifier;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.Res;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullIcon;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ideimpl.navigator.AppPickerUI;
import oracle.ideimpl.navigator.NavigatorArb;
import oracle.ideimpl.navigator.TaskButton;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.layout.VerticalFlowLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApplicationNavigatorWindow
extends DefaultNavigatorWindow
implements ApplicationChangeNotifier {
    private static final String ACTION_INVOKED_FROM_VALUE = "navigatorShortcut";
    private static final String INITIAL_WORKSPACE = "initial-workspace-url";
    private static final Icon NULL_ICON = new NullIcon();
    private URL _initialWorkspaceURL;
    private final ArrayList _applicationChangeListeners;
    private JComboBox _appPicker;
    boolean removingApplication6674339;
    private Workspace _currentWorkspace;
    private DrawerWindow _drawerWindow;
    private DockableWindow _firstDrawer;
    private final AppPickerUI _pickerUI;
    private JComponent topComponent;
    private boolean enabledNewApplication;
    private CardLayout guiCardLayout;
    private JPanel gui;
    final List<DockableWindow> hostedWindows;
    private boolean drawerLayoutLoaded;
    private boolean drawerLayoutSaved;
    private boolean doneLoadLayout;
    private boolean _activeView;

    private void $init$() {
        this._applicationChangeListeners = new ArrayList();
        this._appPicker = new JComboBox();
        this.removingApplication6674339 = false;
        this._currentWorkspace = null;
        this._pickerUI = new AppPickerUI();
        this.topComponent = new 3();
        this.enabledNewApplication = true;
        this.hostedWindows = new ArrayList<DockableWindow>();
        this._activeView = false;
    }

    @Override
    public Controller getController() {
        return this._drawerWindow != null ? this._drawerWindow.getController() : super.getController();
    }

    private void createDrawerWindow() {
        DrawerWindowConfig c = new DrawerWindowConfig();
        c.icon(this.getTabIcon());
        c.tabName(this.getTabName());
        c.titleName(this.getTitleName());
        c.topComponent(this.topComponent());
        c.type(this.getType());
        this._drawerWindow = new DrawerWindow(this.getId(), (View)this, c);
    }

    ApplicationNavigatorWindow(Context context, String viewId) {
        super(context, viewId);
        this.$init$();
        this.registerActivationListener();
        this._pickerUI.setComboBox(this._appPicker);
        this._appPicker.setSelectedItem(null);
        this._appPicker.addItem(Res.getString(2));
        this._appPicker.addItem(Res.getString(3));
        this._appPicker.setName(viewId + ".applicationPicker");
        this.topComponent.setLayout(new 1());
        Dimension minSize = this._appPicker.getMinimumSize();
        minSize.width = 0;
        this._appPicker.setMinimumSize(minSize);
        1L listener = new 1L();
        Node.addNodeListenerForType(Workspace.class, (NodeListener)listener);
        this._appPicker.addItemListener(listener);
        this._appPicker.addPopupMenuListener(listener);
        2 mouseListener = new 2();
        Component[] componentArray = this._appPicker.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component comp = componentArray[n];
            if (comp != null) {
                comp.addMouseListener(mouseListener);
            }
            ++n;
        }
        this._appPicker.setRenderer(new 1LCR());
        this.createDrawerWindow();
    }

    public boolean openContext(Context context) {
        boolean promptUserWhenNotFound = context.getBoolean("REFRESH_CMD_ID.promptUserWhenNotFound");
        context.setBoolean("REFRESH_CMD_ID.promptUserWhenNotFound", false);
        boolean found = false;
        List<DockableWindow> hostedDockables = this.getHostedDockables();
        if (hostedDockables != null) {
            Iterator<DockableWindow> iter = hostedDockables.iterator();
            while (iter.hasNext() && !found) {
                DockableWindow hostedDockable = iter.next();
                if (!(hostedDockable instanceof NavigatorWindow)) continue;
                try {
                    int dockableStatus = DockStation.getDockStation().getDockableStatus((Dockable)this);
                    if ((dockableStatus & 0x20) != 0) continue;
                }
                finally {
                    NavigatorWindow navigator = (NavigatorWindow)hostedDockable;
                    found = navigator.openContext(context, false);
                    if (found && context.getBoolean("REFRESH_CMD_ID.expandAndActivateOnFind")) {
                        this.show();
                        DockStation.getDockStation().activateDockable((Dockable)this);
                        if (!this._drawerWindow.showing((View)navigator)) {
                            this._drawerWindow.show((View)navigator);
                        }
                        this._drawerWindow.activate((View)navigator, true);
                        this._drawerWindow.expand((View)navigator);
                    }
                }
            }
            if (!found && promptUserWhenNotFound) {
                if (context.getWorkspace() != null) {
                    this.displayNodeNotFound(context.getNode().getShortLabel(), context.getWorkspace().getShortLabel());
                } else {
                    this.displayNodeNotFound(context.getNode().getShortLabel(), "Navigator");
                }
            }
        }
        return found;
    }

    private void displayNodeNotFound(String target, String searchSpaceName) {
        String prompt = NavigatorArb.format(5, target, searchSpaceName);
        String title = StringUtils.stripMnemonic((String)IdeArb.getString((int)473));
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)prompt, (String)title, null);
    }

    void selectApplication(Workspace application) {
        if (application != null) {
            this._appPicker.setSelectedItem(new DisplayURL((Node)application));
        }
    }

    @Override
    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (this._currentWorkspace != null) {
            Project project = this._currentWorkspace.currentActiveProject();
            context.setWorkspace(this._currentWorkspace);
            context.setNode((Node)this._currentWorkspace);
            context.setElement((Element)this._currentWorkspace);
            context.setProject(project);
        } else {
            context.setWorkspace(null);
            context.setProject(null);
        }
        return context;
    }

    @Override
    protected Workspace getCurrentWorkspace() {
        return this._currentWorkspace;
    }

    public boolean isUsingDrawer() {
        return true;
    }

    @Override
    public JComponent topComponent() {
        return this.topComponent;
    }

    @Override
    protected void addToNorth(JComponent comp) {
        this.topComponent = comp;
        if (this._drawerWindow != null) {
            this._drawerWindow.topComponent(comp);
        }
    }

    @Override
    public Component getGUI() {
        JPanel returnedGUI = this.gui;
        if (this.gui == null) {
            this.guiCardLayout = new CardLayout();
            this.gui = new JPanel(this.guiCardLayout);
            this.gui.setOpaque(false);
            JPanel startPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
            startPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(0xCCCCCC)));
            startPanel.setOpaque(false);
            Icon jwsIcon = OracleIcons.getIcon((String)"header/application.png");
            AbstractButton newButton = ApplicationNavigatorWindow.newStartButton(Res.getString(2), OracleIcons.getIcon((String)"header/createapplication.png"));
            newButton.addActionListener(new 4());
            startPanel.add(newButton);
            IdeAction action = IdeAction.find((String)"ObjectGalleryCommand");
            newButton.setEnabled(action.isEnabled());
            action.addPropertyChangeListener((PropertyChangeListener)new 5(this, newButton));
            AbstractButton openButton = ApplicationNavigatorWindow.newStartButton(Res.getString(3), jwsIcon);
            openButton.addActionListener(new 6());
            startPanel.add(openButton);
            startPanel.setBackground(UIManager.getColor("window"));
            this.gui.add((Component)startPanel, "start");
            Component navigatorGUI = this._drawerWindow.getGUI();
            super.initCommonItems();
            this.gui.add(navigatorGUI, "navigator");
            Workspaces workspaces = Ide.getWorkspaces();
            workspaces.attach((Observer)new 7());
            if (workspaces.size() > 0) {
                this.guiCardLayout.show(this.gui, "navigator");
            }
            returnedGUI = this.gui;
        }
        return returnedGUI;
    }

    private void invokeCreateNewApplication() {
        String newAppCmd = "oracle.jdeveloper.cmd.NewApplicationCommand";
        IdeAction action = IdeAction.find((String)"oracle.jdeveloper.cmd.NewApplicationCommand");
        if (action != null) {
            try {
                action.putValue("invokedFrom", (Object)ACTION_INVOKED_FROM_VALUE);
                action.performAction(this.getContext());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void invokeOpenApplication() {
        String openAppCmd = "ContentSetSupport.ADD_TO_PROJECT_CMD_ID";
        IdeAction action = IdeAction.find((String)"ContentSetSupport.ADD_TO_PROJECT_CMD_ID");
        if (action != null) {
            try {
                Workspaces workspaces = Ide.getWorkspaces();
                Context context = this.getContext();
                context.setElement((Element)workspaces);
                context.setWorkspace(null);
                context.setProject(null);
                context.setNode(null);
                action.putValue("invokedFrom", (Object)ACTION_INVOKED_FROM_VALUE);
                action.performAction(context);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static AbstractButton newStartButton(String text, Icon icon) {
        TaskButton button = new TaskButton();
        button.setText(text);
        button.setIcon(icon);
        button.setFont(button.getFont().deriveFont(1));
        return button;
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        this._drawerWindow.updateVisibleActions(updateMessage);
    }

    @Override
    public final void addApplicationChangeListener(ApplicationChangeListener listener) {
        if (listener != null && !this._applicationChangeListeners.contains(listener)) {
            this._applicationChangeListeners.add(listener);
        }
    }

    @Override
    public final void removeApplicationChangeListener(ApplicationChangeListener listener) {
        if (listener != null) {
            this._applicationChangeListeners.remove(listener);
        }
    }

    @Override
    public final void addHostedWindow(DockableWindow toHost) {
        this.addHostedWindowWithoutAddingDrawer(toHost);
        this._drawerWindow.addDrawer(toHost);
        if (this._firstDrawer == null) {
            this._firstDrawer = toHost;
            this.getGUI();
            this._drawerWindow.expand((View)this._firstDrawer);
        }
    }

    private void addHostedWindowWithoutAddingDrawer(DockableWindow toHost) {
        this.hostedWindows.add(toHost);
    }

    public List<DockableWindow> getHostedDockables() {
        return this.hostedWindows;
    }

    private void fireApplicationChangeEvent(ApplicationChangeEvent event) {
        this.fireApplicationChangeEventImpl(event, this.hostedWindows);
        this.fireApplicationChangeEventImpl(event, this._applicationChangeListeners);
    }

    private void fireApplicationChangeEventImpl(ApplicationChangeEvent event, Collection listeners) {
        for (Object listenerObj : listeners) {
            if (!(listenerObj instanceof ApplicationChangeListener)) continue;
            try {
                ApplicationChangeListener listener = (ApplicationChangeListener)listenerObj;
                long startTime = System.nanoTime();
                listener.applicationChanged(event);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ApplicationChangeListener.applicationChanged", listener.getClass().getName(), endTime - startTime);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                FeedbackManager.reportException((Throwable)t);
            }
        }
    }

    @Override
    protected void initToolbarArea() {
        Workspaces workspaces = Ide.getWorkspaces();
        Iterator iter = workspaces.getChildren();
        int i = 0;
        while (iter.hasNext()) {
            Object workspaceObj = iter.next();
            if (!(workspaceObj instanceof Workspace)) continue;
            Workspace workspace = (Workspace)workspaceObj;
            if (URLFileSystem.exists((URL)workspace.getURL())) {
                DisplayURL display = new DisplayURL((Node)workspace);
                this._appPicker.insertItemAt(display, i++);
                continue;
            }
            workspaces.remove((Element)workspace);
            NodeFactory.uncache((URL)workspace.getURL());
        }
        this.initSelectedApplication();
        this.topComponent.add(this._appPicker);
        8 nopAction = new 8("Application Menu", ModelArb.getIcon((int)45));
        ContextMenu contextMenu = this.getContextMenu();
        9 appMenu = new 9(this, nopAction, contextMenu);
        this.topComponent.add((Component)((Object)appMenu));
        this._pickerUI.setButton((AbstractButton)((Object)appMenu));
        super.initToolbarArea();
    }

    @Override
    protected void initSelection() {
        super.initSelection();
        this.initSelectedApplication();
    }

    private void initSelectedApplication() {
        int selectedIndex = -1;
        int n = this._appPicker.getItemCount();
        if (this._initialWorkspaceURL != null) {
            int i = 0;
            while (i < n) {
                DisplayURL displayURL;
                Object obj = this._appPicker.getItemAt(i);
                if (obj instanceof DisplayURL && URLFileSystem.equals((URL)DisplayURL.ra$_node(displayURL = (DisplayURL)obj).getURL(), (URL)this._initialWorkspaceURL)) {
                    this._appPicker.setSelectedItem(null);
                    this._appPicker.setSelectedIndex(i);
                    selectedIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (selectedIndex == -1) {
            if (n > 2) {
                this._appPicker.setSelectedIndex(0);
            } else {
                this._appPicker.setSelectedItem(null);
            }
        }
    }

    @Override
    public final void loadLayout(PropertyAccess layout) {
        if (!this.doneLoadLayout) {
            if (!this.drawerLayoutLoaded) {
                this.drawerLayoutLoaded = true;
                this._drawerWindow.loadLayout(layout);
                return;
            }
            String initialWorkspaceURLStr = layout.getProperty(INITIAL_WORKSPACE, null);
            if (initialWorkspaceURLStr != null) {
                this._initialWorkspaceURL = URLFactory.newURL((String)initialWorkspaceURLStr);
            }
            super.loadLayout(layout);
            this.loadDrawers();
            this.drawerLayoutLoaded = false;
            this.doneLoadLayout = true;
        }
    }

    private void loadDrawers() {
        for (View view : this._drawerWindow.drawerViews()) {
            this.addHostedWindowWithoutAddingDrawer((DockableWindow)view);
        }
    }

    @Override
    public final void saveLayout(PropertyAccess layout) {
        if (!this.drawerLayoutSaved) {
            this.drawerLayoutSaved = true;
            this._drawerWindow.saveLayout(layout);
            return;
        }
        super.saveLayout(layout);
        Object item = this._appPicker.getSelectedItem();
        if (item instanceof DisplayURL) {
            DisplayURL displayURL = (DisplayURL)item;
            String initialWorkspaceURLStr = DisplayURL.ra$_node(displayURL).getURL().toString();
            layout.setProperty(INITIAL_WORKSPACE, initialWorkspaceURLStr);
        } else {
            layout.removeProperty(INITIAL_WORKSPACE);
        }
        this.drawerLayoutSaved = false;
    }

    private void registerActivationListener() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener("permanentFocusOwner", new 10());
    }

    static JComboBox ra$_appPicker(ApplicationNavigatorWindow applicationNavigatorWindow) {
        return applicationNavigatorWindow._appPicker;
    }

    static Workspace ra$_currentWorkspace(ApplicationNavigatorWindow applicationNavigatorWindow) {
        return applicationNavigatorWindow._currentWorkspace;
    }

    static boolean ra$enabledNewApplication(ApplicationNavigatorWindow applicationNavigatorWindow) {
        return applicationNavigatorWindow.enabledNewApplication;
    }

    static void mav$fireApplicationChangeEvent(ApplicationNavigatorWindow applicationNavigatorWindow, ApplicationChangeEvent applicationChangeEvent) {
        applicationNavigatorWindow.fireApplicationChangeEvent(applicationChangeEvent);
    }

    static void wa$_currentWorkspace(ApplicationNavigatorWindow applicationNavigatorWindow, Workspace workspace) {
        applicationNavigatorWindow._currentWorkspace = workspace;
    }

    static void mav$fireViewSelectionChanged(ApplicationNavigatorWindow applicationNavigatorWindow, ViewSelectionEvent viewSelectionEvent) {
        applicationNavigatorWindow.fireViewSelectionChanged(viewSelectionEvent);
    }

    static Icon ra$NULL_ICON() {
        return NULL_ICON;
    }

    static boolean ra$_activeView(ApplicationNavigatorWindow applicationNavigatorWindow) {
        return applicationNavigatorWindow._activeView;
    }

    static JPanel ra$gui(ApplicationNavigatorWindow applicationNavigatorWindow) {
        return applicationNavigatorWindow.gui;
    }

    static AppPickerUI ra$_pickerUI(ApplicationNavigatorWindow applicationNavigatorWindow) {
        return applicationNavigatorWindow._pickerUI;
    }

    static void wa$_activeView(ApplicationNavigatorWindow applicationNavigatorWindow, boolean bl) {
        applicationNavigatorWindow._activeView = bl;
    }

    static void mav$invokeCreateNewApplication(ApplicationNavigatorWindow applicationNavigatorWindow) {
        applicationNavigatorWindow.invokeCreateNewApplication();
    }

    static void wa$enabledNewApplication(ApplicationNavigatorWindow applicationNavigatorWindow, boolean bl) {
        applicationNavigatorWindow.enabledNewApplication = bl;
    }

    static void mav$invokeOpenApplication(ApplicationNavigatorWindow applicationNavigatorWindow) {
        applicationNavigatorWindow.invokeOpenApplication();
    }

    static CardLayout ra$guiCardLayout(ApplicationNavigatorWindow applicationNavigatorWindow) {
        return applicationNavigatorWindow.guiCardLayout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 1
    implements LayoutManager {
        private <T extends Component> T getFirst(Container parent, Class<T> type) {
            int i = 0;
            while (i < parent.getComponentCount()) {
                if (type.isInstance(parent.getComponent(i))) {
                    return (T)((Component)type.cast(parent.getComponent(i)));
                }
                ++i;
            }
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            JComboBox box = this.getFirst(parent, JComboBox.class);
            AbstractButton button = this.getFirst(parent, AbstractButton.class);
            Dimension buttonPS = button.getPreferredSize();
            Insets insets = parent.getInsets();
            int w = parent.getWidth() - (insets.left + insets.right);
            int h = parent.getHeight() - (insets.top + insets.bottom);
            int buttonWidth = Math.max(34, buttonPS.width);
            box.setBounds(insets.left, insets.top, w - buttonWidth, h);
            button.setBounds(insets.left + box.getWidth(), insets.top, buttonWidth, h);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComboBox box = this.getFirst(parent, JComboBox.class);
            AbstractButton button = this.getFirst(parent, AbstractButton.class);
            Dimension d = new Dimension();
            Insets insets = parent.getInsets();
            d.width = insets.left + insets.right;
            d.height = insets.top + insets.bottom;
            d.width += box.getPreferredSize().width;
            d.width += Math.max(button.getPreferredSize().width, 34);
            d.height = Math.max(d.height, box.getPreferredSize().height);
            d.height = Math.max(d.height, button.getPreferredSize().height);
            d.height = Math.max(d.height, 26);
            return d;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }
    }

    class 1L
    extends NodeListener
    implements ItemListener,
    ActionListener,
    PopupMenuListener {
        boolean ignoreStateChangedEvent;
        boolean removing;
        private boolean _canceled;

        public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
            ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).repaint();
        }

        private void $init$() {
            this.ignoreStateChangedEvent = false;
            this.removing = false;
            this._canceled = false;
        }

        public void itemStateChanged(ItemEvent e) {
            if (this.ignoreStateChangedEvent) {
                return;
            }
            Object item = e.getItem();
            int stateChange = e.getStateChange();
            if (item instanceof DisplayURL) {
                DisplayURL display = (DisplayURL)item;
                try {
                    Workspace workspace = (Workspace)DisplayURL.ra$_node(display);
                    if (stateChange == 2 && ApplicationNavigatorWindow.this.removingApplication6674339 && ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).getItemCount() == 3) {
                        ApplicationNavigatorWindow.mav$fireApplicationChangeEvent(ApplicationNavigatorWindow.this, new ApplicationChangeEvent(1, workspace));
                    }
                    if (stateChange == 1 && ApplicationNavigatorWindow.ra$_currentWorkspace(ApplicationNavigatorWindow.this) != workspace) {
                        ApplicationNavigatorWindow.mav$fireApplicationChangeEvent(ApplicationNavigatorWindow.this, new ApplicationChangeEvent(1, ApplicationNavigatorWindow.ra$_currentWorkspace(ApplicationNavigatorWindow.this)));
                        ApplicationNavigatorWindow.wa$_currentWorkspace(ApplicationNavigatorWindow.this, workspace);
                        if (workspace != null) {
                            workspace.ensureOpen();
                        }
                        ApplicationNavigatorWindow.mav$fireApplicationChangeEvent(ApplicationNavigatorWindow.this, new ApplicationChangeEvent(2, workspace));
                        ViewSelectionEvent event = new ViewSelectionEvent((View)ApplicationNavigatorWindow.this);
                        ApplicationNavigatorWindow.mav$fireViewSelectionChanged(ApplicationNavigatorWindow.this, event);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Object item;
            if (ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).getItemCount() > 2 && (item = ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).getSelectedItem()) != null) {
                if (item.equals(Res.getString(2))) {
                    this.ignoreStateChangedEvent = true;
                    ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).setSelectedItem(new DisplayURL((Node)ApplicationNavigatorWindow.ra$_currentWorkspace(ApplicationNavigatorWindow.this)));
                    this.ignoreStateChangedEvent = false;
                    if (!this._canceled && ApplicationNavigatorWindow.ra$enabledNewApplication(ApplicationNavigatorWindow.this)) {
                        EventQueue.invokeLater(new 1());
                    }
                } else if (item.equals(Res.getString(3))) {
                    this.ignoreStateChangedEvent = true;
                    ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).setSelectedItem(new DisplayURL((Node)ApplicationNavigatorWindow.ra$_currentWorkspace(ApplicationNavigatorWindow.this)));
                    this.ignoreStateChangedEvent = false;
                    if (!this._canceled) {
                        EventQueue.invokeLater(new 2());
                    }
                }
            }
            this._canceled = false;
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            this._canceled = true;
        }

        1L() {
            this.$init$();
        }

        final class 1
        implements Runnable {
            public void run() {
                ApplicationNavigatorWindow.mav$invokeCreateNewApplication(ApplicationNavigatorWindow.this);
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                ApplicationNavigatorWindow.mav$invokeOpenApplication(ApplicationNavigatorWindow.this);
            }
        }
    }

    final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            Workspace curWorkspace = ApplicationNavigatorWindow.ra$_currentWorkspace(ApplicationNavigatorWindow.this);
            if (curWorkspace != null && SwingUtilities.isRightMouseButton(e)) {
                ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).requestFocus();
                Context workspaceContext = ApplicationNavigatorWindow.this.getContext(e);
                ApplicationNavigatorWindow.this.getContextMenu().show(workspaceContext);
            }
        }
    }

    class 1LCR
    extends DefaultListCellRenderer {
        private final Font _normal = UIManager.getFont("ComboBox.font");
        private final Font _italic = this._normal.deriveFont(2);

        1LCR() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DisplayURL) {
                WorkingSet currentWorkingSet;
                URL url = DisplayURL.ra$_node((DisplayURL)value).getURL();
                IconOverlayCache cache = IconOverlayCache.getInstance();
                Workspace workspace = (Workspace)NodeFactory.find((URL)url);
                String toolTipText = URLFileSystem.getPlatformPathName((URL)url);
                if (workspace == null) {
                    return comp;
                }
                Icon theIcon = cache.getRendererIcon((Element)workspace, workspace.getIcon());
                String overlayToolTipText = cache.getRendererToolTipText((Element)workspace, toolTipText);
                comp.setToolTipText(overlayToolTipText);
                if (workspace != null && workspace.isDirty()) {
                    comp.setFont(this._italic);
                } else {
                    comp.setFont(this._normal);
                }
                WorkingSets instance = WorkingSets.getInstance((Workspace)workspace);
                if (instance != null && (currentWorkingSet = instance.getCurrentWorkingSet()) != null && !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(currentWorkingSet.getName()) && currentWorkingSet.getExcludedProjectList() != null && currentWorkingSet.getExcludedProjectList().size() > 0) {
                    comp.setText(Res.format(1, this.getText()));
                }
                if (index < 0) {
                    if (workspace.isDirty()) {
                        ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).setFont(this._italic);
                    } else {
                        ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).setFont(this._normal);
                    }
                    ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).setToolTipText(overlayToolTipText);
                }
                comp.setIcon(theIcon);
            } else if (value instanceof String) {
                String itemName = (String)value;
                if (itemName.equals(Res.getString(2)) && !ApplicationNavigatorWindow.ra$enabledNewApplication(ApplicationNavigatorWindow.this)) {
                    comp.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                }
                comp.setFont(this._normal);
                comp.setIcon(ApplicationNavigatorWindow.ra$NULL_ICON());
            }
            return comp;
        }
    }

    final class 3
    extends Toolbar {
        private void $init$() {
            this.forcePrimaryViewToolbar(true);
        }

        protected boolean isActiveViewToolbar() {
            return ApplicationNavigatorWindow.ra$_activeView(ApplicationNavigatorWindow.this);
        }

        public 3() {
            this.$init$();
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ApplicationNavigatorWindow.mav$invokeCreateNewApplication(ApplicationNavigatorWindow.this);
        }
    }

    final class 5
    implements PropertyChangeListener {
        private final /* synthetic */ AbstractButton v$newButton;
        final /* synthetic */ ApplicationNavigatorWindow this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                boolean toEnable = Boolean.parseBoolean(evt.getNewValue().toString());
                this.v$newButton.setEnabled(toEnable);
                ApplicationNavigatorWindow.wa$enabledNewApplication(this.this$0, toEnable);
            }
        }

        public 5(ApplicationNavigatorWindow applicationNavigatorWindow, AbstractButton abstractButton) {
            this.v$newButton = abstractButton;
            this.this$0 = applicationNavigatorWindow;
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ApplicationNavigatorWindow.mav$invokeOpenApplication(ApplicationNavigatorWindow.this);
        }
    }

    final class 7
    implements Observer {
        public void update(Object observed, UpdateMessage change) {
            int mesgID = change.getMessageID();
            if (mesgID == UpdateMessage.CHILD_ADDED) {
                List addObjects = change.getAddObjects();
                if (addObjects != null) {
                    for (Object next : addObjects) {
                        if (!(next instanceof Workspace)) continue;
                        Workspace workspace = (Workspace)next;
                        DisplayURL display = new DisplayURL((Node)workspace);
                        int n = ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).getItemCount();
                        int i = 0;
                        while (i < n) {
                            Object obj = ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).getItemAt(i);
                            if (obj instanceof DisplayURL) {
                                DisplayURL cur = (DisplayURL)obj;
                                if (cur.toString().compareTo(display.toString()) > 0) {
                                    ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).insertItemAt(display, i);
                                    break;
                                }
                            } else {
                                ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).insertItemAt(display, i);
                                break;
                            }
                            ++i;
                        }
                        if (i == n) {
                            ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).insertItemAt(display, n);
                        }
                        ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).setSelectedItem(display);
                    }
                }
                ApplicationNavigatorWindow.ra$guiCardLayout(ApplicationNavigatorWindow.this).show(ApplicationNavigatorWindow.ra$gui(ApplicationNavigatorWindow.this), "navigator");
                if (ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).getItemCount() == 3) {
                    ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).requestFocus();
                }
            } else if (mesgID == UpdateMessage.CHILD_REMOVED) {
                List removeObjects = change.getRemoveObjects();
                if (removeObjects != null) {
                    for (Object next : removeObjects) {
                        if (!(next instanceof Workspace)) continue;
                        Workspace workspace = (Workspace)next;
                        DisplayURL display = new DisplayURL((Node)workspace);
                        ApplicationNavigatorWindow.this.removingApplication6674339 = true;
                        ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).removeItem(display);
                        ApplicationNavigatorWindow.this.removingApplication6674339 = false;
                    }
                }
                if (Ide.getWorkspaces().size() == 0) {
                    ApplicationNavigatorWindow.wa$_currentWorkspace(ApplicationNavigatorWindow.this, null);
                    ApplicationNavigatorWindow.ra$guiCardLayout(ApplicationNavigatorWindow.this).show(ApplicationNavigatorWindow.ra$gui(ApplicationNavigatorWindow.this), "start");
                    ViewSelectionEvent event = new ViewSelectionEvent((View)ApplicationNavigatorWindow.this);
                    ApplicationNavigatorWindow.mav$fireViewSelectionChanged(ApplicationNavigatorWindow.this, event);
                } else {
                    ApplicationNavigatorWindow.ra$_appPicker(ApplicationNavigatorWindow.this).setSelectedIndex(0);
                }
            }
        }
    }

    private static class DisplayURL {
        private final Node _node;

        DisplayURL(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            this._node = node;
        }

        public String toString() {
            URL url = this._node.getURL();
            if (URLFileSystem.hasSuffix((URL)url, (String)".jws")) {
                String fileName = URLFileSystem.getFileName((URL)url);
                return fileName.substring(0, fileName.length() - ".jws".length());
            }
            return URLFileSystem.getName((URL)this._node.getURL());
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            DisplayURL other = (DisplayURL)o;
            return this._node == other._node;
        }

        static Node ra$_node(DisplayURL displayURL) {
            return displayURL._node;
        }
    }

    final class 8
    extends ToggleAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 8(String string, Icon icon) {
            super(string, icon);
        }
    }

    final class 9
    extends MenuToolButton {
        private PopupMenuListener _popupMenuListener;
        private final /* synthetic */ ContextMenu v$contextMenu;
        final /* synthetic */ ApplicationNavigatorWindow this$0;

        private void $init$() {
            this._popupMenuListener = new 1();
        }

        private void removePML() {
            this.getModel().setArmed(false);
            this.setSelected(false);
            this._popup.removePopupMenuListener(this._popupMenuListener);
        }

        protected JPopupMenu createPopupMenu() {
            this._popup = (JPopupMenu)this.v$contextMenu.getGUI(true);
            return this._popup;
        }

        protected ItemListener createButtonItemListener() {
            ItemListener superListener = super.createButtonItemListener();
            return new 2(this, superListener);
        }

        public 9(ApplicationNavigatorWindow applicationNavigatorWindow, ToggleAction toggleAction, ContextMenu contextMenu) {
            this.v$contextMenu = contextMenu;
            this.this$0 = applicationNavigatorWindow;
            super(toggleAction);
            this.$init$();
        }

        static void mav$removePML(9 var0) {
            var0.removePML();
        }

        static ContextMenu ra$v$contextMenu(9 var0) {
            return var0.v$contextMenu;
        }

        static JPopupMenu ra$_popup(9 var0) {
            return var0._popup;
        }

        static PopupMenuListener ra$_popupMenuListener(9 var0) {
            return var0._popupMenuListener;
        }

        final class 1
        implements PopupMenuListener {
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                9.mav$removePML(9.this);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }

        final class 2
        implements ItemListener {
            private final /* synthetic */ ItemListener v$superListener;
            final /* synthetic */ 9 this$0;

            public void itemStateChanged(ItemEvent e) {
                Context context = this.this$0.this$0.getContext();
                Workspace workspace = context.getWorkspace();
                context.setElement((Element)workspace);
                this.this$0.this$0.getGUI().requestFocus();
                context.setProject(null);
                context.setNode((Node)workspace);
                9.ra$v$contextMenu(this.this$0).prepareShow(context);
                9.ra$_popup(this.this$0).addPopupMenuListener(9.ra$_popupMenuListener(this.this$0));
                this.v$superListener.itemStateChanged(e);
            }

            public 2(9 var1_1, ItemListener itemListener) {
                this.v$superListener = itemListener;
                this.this$0 = var1_1;
            }
        }
    }

    final class 10
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Component c = (Component)evt.getNewValue();
            boolean activeView = ApplicationNavigatorWindow.ra$gui(ApplicationNavigatorWindow.this) != null && c != null && SwingUtilities.isDescendingFrom(c, ApplicationNavigatorWindow.ra$gui(ApplicationNavigatorWindow.this));
            ApplicationNavigatorWindow.ra$_pickerUI(ApplicationNavigatorWindow.this).setInActiveView(activeView);
            ApplicationNavigatorWindow.wa$_activeView(ApplicationNavigatorWindow.this, activeView);
        }
    }
}

