/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.navigator.ApplicationNavigatorWindow;
import oracle.ide.navigator.ApplicationWrapper;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public abstract class ProjectNavigatorManager
extends DefaultNavigatorManager {
    private final ArrayList _initFactories;
    public static final String SUB_PREFIX = "_SUB_";

    private void $init$() {
        this._initFactories = new ArrayList();
    }

    public void initialize() {
        super.initialize();
        ViewId defaultViewId = this.getDefaultViewId();
        String subViewTypeStr = SUB_PREFIX + defaultViewId.getType();
        String subViewNameStr = SUB_PREFIX + defaultViewId.getName();
        ViewId subViewId = new ViewId(subViewTypeStr, subViewNameStr);
        DockableFactory factory = this.createDockableFactory();
        1 factoryWrapper = new 1(this, factory);
        DockStation.getDockStation().registerDockableFactory(subViewTypeStr, (DockableFactory)factoryWrapper);
        this.registerHostedDockable(subViewId);
    }

    protected NavigatorWindow getShowTarget(NavigatorWindow navWin) {
        if (navWin instanceof ApplicationNavigatorWindow) {
            ApplicationNavigatorWindow anw = (ApplicationNavigatorWindow)navWin;
            List<DockableWindow> hostedDockables = anw.getHostedDockables();
            for (DockableWindow dockable : hostedDockables) {
                if (!(dockable instanceof ProjectNavigatorWindow)) continue;
                return (NavigatorWindow)dockable;
            }
        }
        return navWin;
    }

    public static void refreshAllProjectsInNavigator(Context context) {
        NavigatorWindow navWin;
        TreeExplorer treeExplorer;
        View view = context.getView();
        if (view instanceof NavigatorWindow && (treeExplorer = (navWin = (NavigatorWindow)view).getTreeExplorer()) != null) {
            TNode root = treeExplorer.getRoot();
            List expandDataList = ExplorerContext.storeExpansionState((TNode)root, (TreeExplorer)treeExplorer);
            ProjectNavigatorManager.refreshProjectNodes(root);
            ExplorerContext.restoreExpansionState((TNode)root, (TreeExplorer)treeExplorer, (List)expandDataList);
        }
    }

    private static void refreshProjectNodes(TNode node) {
        if (node != null) {
            Element data = node.getData();
            if (data instanceof Project) {
                node.getOwner().refresh(node, Project.class);
            } else if (node.isSet(TNodeConstants.IS_OPENED)) {
                Enumeration iter = node.getChildTNodes();
                while (iter.hasMoreElements()) {
                    ProjectNavigatorManager.refreshProjectNodes((TNode)iter.nextElement());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatorInit(NavigatorInitFactory initFactory) {
        ArrayList arrayList = this._initFactories;
        synchronized (arrayList) {
            if (initFactory != null) {
                this._initFactories.add(initFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        ActionEvent actionEvent;
        ArrayList initFactories;
        ArrayList arrayList = this._initFactories;
        synchronized (arrayList) {
            initFactories = new ArrayList(this._initFactories);
        }
        EventObject eventObject = context.getEvent();
        if (eventObject instanceof ActionEvent && (actionEvent = (ActionEvent)eventObject).getActionCommand().equals(IdeArb.getString((int)93)) && context.getNode() instanceof Project) {
            String projectLabel = ((Project)context.getNode()).getShortLabel();
            String tabName = projectLabel.substring(0, projectLabel.indexOf(".jpr"));
            ProjectNavigatorWindow projectNav = new ProjectNavigatorWindow(context, viewId, initFactories, tabName);
            projectNav.setRootVisible(true);
            return projectNav;
        }
        if (viewId.getId().startsWith(SUB_PREFIX)) {
            ProjectNavigatorWindow projectNav = new ProjectNavigatorWindow(new ApplicationWrapper(), context, viewId, initFactories);
            projectNav.setRootVisible(false);
            return projectNav;
        }
        ApplicationNavigatorWindow navigator = new ApplicationNavigatorWindow(context, viewId.getId());
        return navigator;
    }

    protected void initNavigatorWindowComparator(DefaultNavigatorWindow navigator) {
    }

    public ProjectNavigatorManager() {
        this.$init$();
    }

    final class 1
    implements DockableFactory {
        private final /* synthetic */ DockableFactory v$factory;
        final /* synthetic */ ProjectNavigatorManager this$0;

        public Dockable getDockable(ViewId viewId) {
            return this.v$factory.getDockable(viewId);
        }

        public void install() {
        }

        public 1(ProjectNavigatorManager projectNavigatorManager, DockableFactory dockableFactory) {
            this.v$factory = dockableFactory;
            this.this$0 = projectNavigatorManager;
        }
    }
}

