/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.explorer.IconOverlayTreeCellRenderer;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Attributes;
import oracle.ide.model.AutoExpandable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.util.Assert;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.CustomTreeKeyNavigation;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideimpl.explorer.NodeUpdateListener;
import oracle.ideimpl.explorer.dnd.DragDropListener;
import oracle.ideimpl.explorer.dnd.JTreeDragHandler;
import oracle.ideimpl.explorer.dnd.JTreeDropHandler;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;

public class BaseTreeExplorer
extends TreeExplorer
implements NodeUpdateListener,
TreeSelectionListener,
TreeExpansionListener,
KeyListener,
MouseListener,
ActionListener,
FocusListener,
IdeListener,
DragDropListener {
    protected CustomTree tree;
    private final JScrollPane _gui;
    private Comparator _comparator;
    private IconOverlayCache _overlayCache;
    private Map _filterCache;
    private KeyNavigationManager _keyMgr;
    private WeakReference _lastActiveNodeWeakRef;
    private CellRendererAttributes _attributes;
    private final Timer _timer;
    private static final String FILTER_PROP = "filter";
    private static final String KEY_PROP = ".key";
    private static final String FILTER_CLS_PROP = ".filterCls";
    private static final String FILTER_OPTS_PROP = ".options";
    private static final String DISABLE_EXPLORER_DRAG_AND_DROP_PROP = "TreeExplorer.DisableDragAndDrop";
    private final ArrayList _updates;

    private void $init$() {
        this._gui = new JScrollPane();
        this._filterCache = new HashMap();
        this._updates = new ArrayList();
    }

    public BaseTreeExplorer() {
        this.$init$();
        if (Themes.isThemed()) {
            this._gui.setOpaque(false);
            this._gui.getViewport().setOpaque(false);
        }
        this._gui.setBorder(BorderFactory.createEmptyBorder());
        if (this.coalesceObserverUpdates()) {
            this._timer = new Timer(200, new 1());
            this._timer.setRepeats(false);
        } else {
            this._timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cacheFilter(TNode tnode, ChildFilter filter) {
        if (filter != null) {
            String key = this.buildPathKey(tnode);
            Map map = this._filterCache;
            synchronized (map) {
                this._filterCache.put(key, new FilterInfo(filter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ChildFilter findCacheFilter(TNode tnode) {
        FilterInfo info;
        String key = this.buildPathKey(tnode);
        Map map = this._filterCache;
        synchronized (map) {
            info = (FilterInfo)this._filterCache.get(key);
        }
        return info != null ? info.getFilter() : null;
    }

    public final TNode createTNode(Element element) {
        ExplorerNode tnode = new ExplorerNode(element);
        this.checkLeafState(tnode);
        tnode.addNodeUpdateListener(this);
        return tnode;
    }

    public final TNode findTNode(Element element, TNode root) {
        return this.findNodeDepthFirst(element, root, true, null);
    }

    public final TNode findTNode(Element element, TNode root, Context context) {
        return this.findNodeDepthFirst(element, root, true, context);
    }

    public final TNode findTNodeBreadthFirst(Element element, TNode root) {
        return this.findNodeBreadthFirst(element, root, true);
    }

    public final TNode searchTNode(Element element, TNode root) {
        return this.findNodeDepthFirst(element, root, false, null);
    }

    public final TNode searchTNode(Element element, TNode root, Context context) {
        return this.findNodeDepthFirst(element, root, false, context);
    }

    public final TNode searchTNodeBreadthFirst(Element element, TNode root) {
        return this.findNodeBreadthFirst(element, root, false);
    }

    public final void expand(TNode node, boolean all) {
        this.expand(node, all, true);
    }

    public final void expand(TNode node, boolean all, boolean select) {
        ExplorerNode tnode = (ExplorerNode)node;
        if (tnode == null || tnode.isLeaf()) {
            return;
        }
        TreePath path = new TreePath(tnode.getPath());
        this.open(tnode);
        this.tree.expandPath(path);
        if (select) {
            this.setSelected(tnode);
        }
        if (all) {
            Enumeration children = tnode.children();
            while (children.hasMoreElements()) {
                this.expand((TNode)children.nextElement(), all);
            }
        }
    }

    public final void refresh(TNode tnode) {
        this.refreshImpl(tnode, tnode);
    }

    public final void refresh(TNode tnode, Class cls) {
        TNode target = tnode.getAncestorTNode(cls, true);
        this.refreshImpl(target, tnode);
    }

    public final void collapse(TNode tnode, boolean drop) {
        if (!tnode.isLeaf()) {
            TreePath path = new TreePath(tnode.getPath());
            if (this.tree.isExpanded(path)) {
                this.tree.collapsePath(path);
            }
            if (drop) {
                this.dropNodeSubtree((ExplorerNode)tnode);
            }
        }
    }

    public void addChildren(TNode troot) {
        ExplorerNode parent;
        ExplorerNode root = (ExplorerNode)troot;
        if (root == null || root.isSet(TNodeConstants.IS_OPENED)) {
            return;
        }
        if (root.getChildCount() > 0) {
            root.removeAllChildren();
            try {
                ChildFilter filter = root.getChildFilter();
                if (filter != null) {
                    filter.closeChildren();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Iterator iter = null;
        ChildFilter filter = root.getChildFilter();
        iter = filter != null ? filter.getChildren() : root.getChildNodes();
        if (iter == null) {
            return;
        }
        if (filter == null && (parent = (ExplorerNode)root.getParent()) != null) {
            filter = parent.findChildFilter();
        }
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            ExplorerNode node = (ExplorerNode)this.createTNode(child);
            root.add(node);
            if (filter == null) continue;
            filter.cache((TNode)node);
        }
        root.setBit(TNodeConstants.IS_OPENED);
    }

    public final JTree getJTree() {
        return this.getTree(null);
    }

    public final DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    public final void nodeChanged(TNode tnode) {
        if (tnode == null) {
            return;
        }
        DefaultTreeModel model = this.getTreeModel();
        if (model != null) {
            model.nodeChanged((TreeNode)tnode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveFilters(PropertyAccess layout) {
        Map map = this._filterCache;
        synchronized (map) {
            int size = this._filterCache.size();
            if (size == 0) {
                return;
            }
            String prop = FILTER_PROP;
            layout.setProperty(prop, Integer.toString(size));
            int ctr = 0;
            for (Map.Entry entry : this._filterCache.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null) continue;
                FilterInfo info = (FilterInfo)entry.getValue();
                String filterClass = null;
                int filterOptions = 0;
                if (info != null) {
                    filterClass = info.getClassName();
                    filterOptions = info.getOptions();
                }
                prop = new StringBuffer().append(FILTER_PROP).append(ctr).append(KEY_PROP).toString();
                layout.setProperty(prop, key);
                prop = new StringBuffer().append(FILTER_PROP).append(ctr).append(FILTER_CLS_PROP).toString();
                layout.setProperty(prop, filterClass);
                if (filterOptions != -1) {
                    prop = new StringBuffer().append(FILTER_PROP).append(ctr).append(FILTER_OPTS_PROP).toString();
                    layout.setProperty(prop, Integer.toString(filterOptions));
                }
                ++ctr;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openFilters(PropertyAccess layout) {
        Element element;
        String prop = FILTER_PROP;
        int size = Integer.parseInt(layout.getProperty(prop, "0"));
        if (size == 0) {
            return;
        }
        Map map = this._filterCache;
        synchronized (map) {
            int i = 0;
            while (i < size) {
                prop = new StringBuffer().append(FILTER_PROP).append(i).append(KEY_PROP).toString();
                String key = layout.getProperty(prop, null);
                prop = new StringBuffer().append(FILTER_PROP).append(i).append(FILTER_CLS_PROP).toString();
                String filterCls = layout.getProperty(prop, null);
                if (key != null && filterCls != null) {
                    prop = new StringBuffer().append(FILTER_PROP).append(i).append(FILTER_OPTS_PROP).toString();
                    String options = layout.getProperty(prop, null);
                    int filterOptions = options != null ? Integer.parseInt(options) : 0;
                    FilterInfo info = (FilterInfo)this._filterCache.get(key);
                    if (info == null || !info.getClassName().equals(filterCls) || info.getOptions() != filterOptions) {
                        this._filterCache.put(key, new FilterInfo(filterCls, filterOptions));
                    }
                }
                ++i;
            }
        }
        ExplorerNode root = (ExplorerNode)this.getRoot();
        if (root != null && root.getFilter() != this.findCacheFilter(root) && (element = root.getData()) != null) {
            this.setRoot(element);
            this.collapse(this.getRoot(), false);
        }
    }

    private void renameFilters(TNode parent, TNode child, UpdateMessage rename) {
        TreePath path;
        if (child.getParent() == null) {
            TreePath parentPath = new TreePath(parent.getPath());
            path = parentPath.pathByAddingChild(child);
        } else {
            path = new TreePath(child.getPath());
        }
        String pathKey = this.buildPathKey(path);
        if (RenameMessage.isPreRenameMessage((UpdateMessage)rename)) {
            HashMap renamedKeys = new HashMap();
            this._filterCache.put(null, renamedKeys);
            int pathKeyLength = pathKey.length();
            Iterator i = this._filterCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith(pathKey)) continue;
                i.remove();
                key = key.substring(pathKeyLength);
                renamedKeys.put(key, entry.getValue());
            }
        } else {
            Map renamedKeys = (Map)this._filterCache.remove(null);
            if (renamedKeys == null) {
                return;
            }
            for (Map.Entry entry : renamedKeys.entrySet()) {
                String key = (String)entry.getKey();
                FilterInfo info = (FilterInfo)entry.getValue();
                ChildFilter filter = info.getFilter();
                if (filter == null) continue;
                this._filterCache.put(pathKey + key, new FilterInfo(filter));
                if (key.length() != 0) continue;
                child.setChildFilter(filter);
                filter.setOwner(child);
                filter.refresh(null);
            }
            renamedKeys.clear();
        }
    }

    public final Comparator getComparator() {
        return this._comparator;
    }

    public final void setComparator(Comparator comparator) {
        if (!ModelUtil.areEqual((Object)comparator, (Object)this._comparator)) {
            this._comparator = comparator;
            TNode root = this.getRoot();
            if (root != null) {
                Element element = root.getData();
                this.setRoot(element);
            }
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.getTree(context);
    }

    public final Context getContext(EventObject event) {
        TNode lastTNode;
        Project prj;
        this.tryForceUpdateImpl();
        Context context = super.getContext(event);
        TreePath[] paths = this.getTree(null).getSelectionPaths();
        TNode[] tnodes = new TNode[paths != null ? paths.length : 0];
        int i = 0;
        while (i < tnodes.length) {
            tnodes[i] = (TNode)paths[i].getLastPathComponent();
            ++i;
        }
        if (context.getWorkspace() == null && tnodes.length > 0) {
            TNode lastTNode2 = tnodes[tnodes.length - 1];
            Workspace wsp = (Workspace)lastTNode2.getAncestor(Workspace.class, true);
            context.setWorkspace(wsp);
        }
        if (tnodes.length > 0 && (prj = (Project)(lastTNode = tnodes[tnodes.length - 1]).getAncestor(Project.class, true)) != null) {
            context.setProject(prj);
        }
        ExplorerContext.setTNodes((Context)context, (TNode[])tnodes);
        this.initializeContextNode(context, tnodes);
        return context;
    }

    public final Component getGUI() {
        return this._gui;
    }

    public final void setSelected(TNode tnode) {
        if (tnode == null) {
            return;
        }
        TreePath path = new TreePath(tnode.getPath());
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    public final void setSelected(TNode[] tnodes) {
        if (tnodes == null) {
            return;
        }
        TreePath[] treePaths = new TreePath[tnodes.length];
        int i = 0;
        while (i < tnodes.length) {
            treePaths[i] = new TreePath(tnodes[i].getPath());
            ++i;
        }
        this.tree.setSelectionPaths(treePaths);
    }

    public final void updateTitle(Object object) {
        if (this.owner() == null) {
            return;
        }
        this.owner().updateTitle(object);
    }

    public final TNode removeChild(TNode tchild, DefaultTreeModel model) {
        ExplorerNode child = (ExplorerNode)tchild;
        child.removeNodeUpdateListener(this);
        ExplorerNode tnode = BaseTreeExplorer.getClosestTNode(child);
        model.removeNodeFromParent(child);
        return tnode;
    }

    private TNode removeChildren(TNode parent, List removed, DefaultTreeModel model) {
        ArrayList<TNode> childNodes = new ArrayList<TNode>(removed.size());
        Enumeration e = parent.children();
        while (e.hasMoreElements()) {
            TNode tnode = (TNode)e.nextElement();
            if (!removed.contains(tnode.getData())) continue;
            childNodes.add(tnode);
        }
        if (childNodes.isEmpty()) {
            return null;
        }
        Assert.check((boolean)(model instanceof TreeExplorerModel));
        Assert.check((boolean)(parent instanceof MutableTreeNode));
        int size = childNodes.size();
        MutableTreeNode[] children = childNodes.toArray(new ExplorerNode[size]);
        int i = 0;
        while (i < size) {
            ExplorerNode tnode = children[i];
            tnode.removeNodeUpdateListener(this);
            ++i;
        }
        ExplorerNode ret = BaseTreeExplorer.getClosestTNode(children[size - 1]);
        TreeExplorerModel.mav$removeNodesFromParent((TreeExplorerModel)model, (MutableTreeNode)parent, children);
        return ret;
    }

    public final TNode childrenRemoved(UpdateMessage updateMessage, TNode node, DefaultTreeModel model, ChildFilter filter) {
        TreePath tp;
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        TreePath adjustedSelection = this.adjustSelectionForChildRemoval();
        this.tree.clearSelection();
        TNode child = filter == null ? this.removeChildren(node, updateMessage.getRemoveObjects(), model) : filter.childrenRemoved(updateMessage, node, (TreeExplorer)this);
        if (selectionPaths != null && selectionPaths.length > 0) {
            int i = 0;
            while (i < selectionPaths.length) {
                TreePath path = ExplorerContext.findNewPath((TNode)this.getRoot(), (TreePath)selectionPaths[i], (boolean)true);
                if (path != null) {
                    this.tree.addSelectionPath(path);
                }
                ++i;
            }
        }
        if (adjustedSelection != null && this.tree.isSelectionEmpty() && (tp = ExplorerContext.findNewPath((TNode)this.getRoot(), (TreePath)adjustedSelection, (boolean)false)) != null) {
            this.tree.setSelectionPath(tp);
        }
        if (child != null && this.tree.isSelectionEmpty()) {
            this.setSelected(child);
        }
        return child;
    }

    private TreePath adjustSelectionForChildRemoval() {
        int leadSelectionRow = this.tree.getLeadSelectionRow();
        if (leadSelectionRow == -1) {
            return null;
        }
        SiblingIterator iter = new SiblingIterator(leadSelectionRow);
        TreePath tp = iter.nextSiblingPath();
        while (tp != null) {
            if (!this.tree.isPathSelected(tp)) {
                return tp;
            }
            tp = iter.nextSiblingPath();
        }
        TreePath leadSelectionPath = this.tree.getLeadSelectionPath();
        return leadSelectionPath.getParentPath();
    }

    public final TNode addChild(Element element, TNode parent, DefaultTreeModel model) {
        return this.addChild(element, parent.getChildCount(), parent, model);
    }

    private TNode addChild(Element element, int elementIndex, TNode parent, DefaultTreeModel model) {
        ExplorerNode child = (ExplorerNode)this.createTNode(element);
        model.insertNodeInto(child, (ExplorerNode)parent, elementIndex);
        return child;
    }

    public final TNode childrenAdded(UpdateMessage updateMessage, TNode parent, DefaultTreeModel model, ChildFilter filter, boolean select) {
        if (this.isHideChildren(parent)) {
            return null;
        }
        TNode child = this.open(parent) ? parent : null;
        List children = updateMessage.getAddObjects();
        if (filter == null) {
            ArrayList arList = new ArrayList(children);
            Enumeration echildren = parent.children();
            while (echildren.hasMoreElements()) {
                child = (TNode)echildren.nextElement();
                Element element = child.getData();
                if (!arList.contains(element)) continue;
                arList.remove(element);
            }
            for (Element element : arList) {
                child = this.addChild(element, parent, model);
            }
            arList.clear();
        } else {
            child = filter.childrenAdded(updateMessage, parent, (TreeExplorer)this);
        }
        if (select && child != null && this.isViewActive()) {
            TreePath path = new TreePath(child.getPath());
            this.tree.scrollPathToVisible(path);
            int row = this.tree.getRowForPath(path);
            this.tree.setSelectionRow(row);
            if (child == parent && !child.isLeaf()) {
                this.tree.expandPath(path);
            }
        }
        return child;
    }

    public final boolean open(TNode node) {
        DefaultTreeModel model;
        if (node.isSet(TNodeConstants.IS_OPENED)) {
            return false;
        }
        this.addChildren(node);
        Element data = node.getData();
        if (data instanceof Node) {
            NodeOpeningExecutor.getInstance().execute(new 2(this, data));
        }
        if ((model = this.getTreeModel()) != null) {
            model.reload((TreeNode)node);
        }
        return true;
    }

    public final boolean updateActiveNode(TNode newActiveNode) {
        ExplorerNode lastActiveNode;
        if (newActiveNode == null) {
            return false;
        }
        if (this._lastActiveNodeWeakRef != null && (lastActiveNode = (ExplorerNode)this._lastActiveNodeWeakRef.get()) != null) {
            if (lastActiveNode == newActiveNode) {
                return false;
            }
            lastActiveNode.unsetBit(ElementAttributes.ACTIVE);
            this.nodeChanged(lastActiveNode);
        }
        this._lastActiveNodeWeakRef = new WeakReference<TNode>(newActiveNode);
        newActiveNode.setBit(ElementAttributes.ACTIVE);
        this.nodeChanged(newActiveNode);
        return true;
    }

    public final TNode getRoot() {
        TreeModel model = this.tree.getModel();
        return model != null ? (TNode)model.getRoot() : null;
    }

    public final void setRootElement(Element element) {
        if (element != null) {
            this.setContext(Context.newIdeContext((Element)element));
        }
    }

    public final Attributes getCellRendererAttributes() {
        if (this._attributes == null) {
            this._attributes = new CellRendererAttributes();
        }
        return this._attributes;
    }

    private static boolean refreshNodes(TNode[] tnodes, boolean doRefresh) {
        boolean ret = false;
        if (tnodes != null && tnodes.length > 0) {
            boolean ancestorsRefreshed = false;
            int i = 0;
            while (i < tnodes.length) {
                ChildFilter filter;
                TNode tnode = tnodes[i];
                if ((doRefresh || tnode.isSet(TNodeConstants.IS_OPENED)) && (filter = tnode.findChildFilter()) != null && tnode != filter.getOwner()) {
                    if (BaseTreeExplorer.refreshAncestor(tnode, doRefresh)) {
                        ret = true;
                    }
                    ancestorsRefreshed = true;
                    if (!filter.canRefresh(tnodes)) break;
                    ret = true;
                    if (!doRefresh) break;
                    filter.refresh(tnodes);
                    break;
                }
                ++i;
            }
            if (!ancestorsRefreshed && BaseTreeExplorer.refreshAncestor(tnodes[0], doRefresh)) {
                ret = true;
            }
            int i2 = 0;
            while (i2 < tnodes.length) {
                ChildFilter filter;
                TNode tnode = tnodes[i2];
                if ((doRefresh || tnode.isSet(TNodeConstants.IS_OPENED)) && (filter = tnode.findChildFilter()) != null && tnode == filter.getOwner() && filter.canRefresh(tnodes)) {
                    ret = true;
                    if (doRefresh) {
                        filter.refresh(tnodes);
                    }
                }
                ++i2;
            }
        }
        return ret;
    }

    public final boolean canRefresh(TNode tnode, Class cls) {
        TNode target = tnode.getAncestorTNode(cls, true);
        if (target == null || target.isLeaf()) {
            TNode[] tnodes = new TNode[]{tnode};
            return BaseTreeExplorer.refreshNodes(tnodes, false);
        }
        if (!target.isSet(TNodeConstants.IS_OPENED)) {
            return false;
        }
        ChildFilter filter = target.findChildFilter();
        TNode[] tnodes = new TNode[]{target};
        return filter != null && target == filter.getOwner() && filter.canRefresh(tnodes);
    }

    private static boolean refreshAncestor(TNode tnode, boolean doRefresh) {
        ChildFilter parentFilter;
        TNode parent;
        boolean ret = false;
        if (tnode != null && (parent = (TNode)tnode.getParent()) != null && (parentFilter = parent.findChildFilter()) != null) {
            TNode[] tnodes;
            if (BaseTreeExplorer.refreshAncestor(parentFilter.getOwner(), doRefresh)) {
                ret = true;
            }
            if (parentFilter.canRefresh(tnodes = new TNode[]{tnode})) {
                if (doRefresh) {
                    parentFilter.refresh(tnodes);
                }
                ret = true;
            }
        }
        return ret;
    }

    public final IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    public final void setOverlayCache(IconOverlayCache cache) {
        this._overlayCache = cache;
    }

    public final Element getElement(Object value) {
        Element elem;
        if (value instanceof ExplorerNode) {
            Object wrapped;
            ExplorerNode tnode = (ExplorerNode)value;
            elem = (Element)tnode.getUserObject();
            if (!elem.getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT) && (wrapped = elem.getData()) instanceof Element) {
                elem = (Element)wrapped;
            }
        } else {
            elem = ((TNode)value).getData();
        }
        return elem;
    }

    protected void nodeExpanded(TNode tnode, boolean expansionAlsoTriggeredOpen) {
    }

    protected boolean coalesceObserverUpdates() {
        return true;
    }

    protected void initializeContextNode(Context context, TNode[] tnodes) {
        switch (tnodes.length) {
            case 0: {
                context.setNode(this.defaultNode);
                break;
            }
            case 1: {
                Node node = (Node)tnodes[0].getAncestor(Node.class, true);
                context.setNode(node != null ? node : this.defaultNode);
                break;
            }
            default: {
                TNode tnode = tnodes[0];
                if (tnode.getData() instanceof Node) {
                    context.setNode(null);
                    break;
                }
                Node node = (Node)tnode.getAncestor(Node.class, true);
                context.setNode(node != null ? node : this.defaultNode);
                break;
            }
        }
    }

    protected Element[] getSelectionFromUI() {
        TreePath[] paths = this.getTree(null).getSelectionPaths();
        Element[] selection = new Element[paths != null ? paths.length : 0];
        int n = selection.length;
        int i = 0;
        while (i < n) {
            TNode tnode = (TNode)paths[i].getLastPathComponent();
            selection[i] = ContextMenu.unwrapDecoratedElement((Element)tnode.getData());
            ++i;
        }
        return selection;
    }

    protected synchronized CustomTree getTree(Context context) {
        if (this.tree == null) {
            String dftName;
            this.tree = this.createCustomTree();
            this.tree.putClientProperty("JTree.expandOnMouseRelease", Boolean.TRUE);
            if (this._overlayCache != null) {
                this.tree.setCellRenderer((TreeCellRenderer)new IconOverlayTreeCellRenderer((IconOverlayConsumer)this, (DefaultTreeCellRenderer)this.tree.getCellRenderer()));
            }
            if ((dftName = this.getDFTName()) != null) {
                this.tree.setName(dftName);
            }
            this.tree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.tree.setCellRendererAttributes(this.getCellRendererAttributes());
            this.installTreeKeyManager();
            if (context != null) {
                this.setRoot(this.annotate(context));
            }
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setScrollsOnExpand(true);
            this.tree.addTreeSelectionListener(this);
            this.tree.addTreeExpansionListener(this);
            this.tree.setPreMouseListener(this);
            this.tree.addFocusListener(this);
            this.tree.getActionMap().put(20, (Action)IdeAction.get((int)20, (String)"oracle.ide.cmd.DeleteTNodeCommand", (String)ExplorerArb.getString((int)5)));
            if (Ide.isStarting()) {
                Ide.addIdeListener((IdeListener)this);
            } else {
                this.createDragDropSupportIfEnabled();
            }
            this._gui.setViewportView(this.tree);
        } else if (context != null) {
            TNode tnode = this.getRoot();
            Element oldRoot = tnode != null ? tnode.getData() : null;
            Element newRoot = this.annotate(context);
            if (newRoot == null || newRoot != oldRoot && !newRoot.equals(oldRoot) || context.getBoolean("NAVIGATOR.ForceExplorerReroot")) {
                this.setRoot(newRoot);
            }
        }
        return this.tree;
    }

    protected void createDragSource() {
        new JTreeDragHandler(this.tree, 3, this);
    }

    protected void createDropTarget() {
        new JTreeDropHandler(this.tree, 3);
    }

    protected Element annotate(Context context) {
        return context != null ? context.getElement() : null;
    }

    protected final void setRoot(Element element) {
        ExplorerNode root = (ExplorerNode)this.getRoot();
        if (root != null) {
            this.dropNodeSubtree(root);
            root.setOwner(null);
            root.removeNodeUpdateListener(this);
        }
        root = new ExplorerNode(element);
        root.setOwner(this);
        root.addNodeUpdateListener(this);
        this.addChildren(root);
        this.tree.setModel(new TreeExplorerModel(root, null));
    }

    private void refreshImpl(TNode target, TNode tnode) {
        if (target == null || target.isLeaf()) {
            if (tnode != null) {
                this.refreshTNode(tnode);
            }
        } else if (target.isSet(TNodeConstants.IS_OPENED)) {
            this.refreshTNode(target);
        }
    }

    private void refreshTNode(TNode target) {
        List selectedNodes = ExplorerContext.storeSelectionState((TreeExplorer)this);
        List expandedSet = ExplorerContext.storeExpansionState((TNode)target, (TreeExplorer)this);
        this.releaseFilters(target, false);
        this.collapse(target, true);
        ExplorerContext.restoreExpansionState((TNode)target, (TreeExplorer)this, (List)expandedSet);
        ExplorerContext.restoreSelectionState((TreeExplorer)this, (List)selectedNodes);
    }

    private TNode findNodeBreadthFirst(Element element, TNode root, boolean searchUnopened) {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
        if (root == null) {
            root = this.getRoot();
        }
        ArrayList output = new ArrayList();
        ArrayList<Object> sources = new ArrayList<Object>();
        sources.add(root);
        TNode result = null;
        while ((result = this.findNodeBreadthFirst(element, sources, searchUnopened, output)) == null) {
            if (output.size() == 0) {
                return null;
            }
            sources.clear();
            sources.addAll(output);
            output.clear();
        }
        return result;
    }

    private TNode findNodeDepthFirst(Element element, TNode root, boolean searchUnopened, Context expansionContext) {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
        if (root == null) {
            root = this.getRoot();
        }
        if (root.getData() == element) {
            return root;
        }
        if (root.isLeaf()) {
            return null;
        }
        if (!(root.isSet(TNodeConstants.IS_OPENED) || searchUnopened && this.open(root))) {
            return null;
        }
        Enumeration children = root.children();
        TNode result = null;
        while (children.hasMoreElements()) {
            AutoExpandable autoExpandable;
            Element elem;
            TNode child = (TNode)children.nextElement();
            result = this.findNodeDepthFirst(element, child, searchUnopened, expansionContext);
            if (result == null) continue;
            if (expansionContext == null || !expansionContext.getBoolean("oracle.ide.model.ProjectContent.AutoSelecter") || !((elem = child.getData()) instanceof AutoExpandable) || (autoExpandable = (AutoExpandable)elem).shouldAutoExpand(expansionContext)) break;
            result = child;
            break;
        }
        return result;
    }

    private String buildPathKey(TreePath path) {
        int count = path.getPathCount();
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        while (i < count) {
            Element elem = ((TNode)path.getPathComponent(i)).getData();
            String label = elem.getLongLabel();
            tmp.append(ModelUtil.hasLength((String)label) ? label : " ");
            ++i;
        }
        return tmp.toString();
    }

    private void installTreeKeyManager() {
        CustomTreeKeyNavigation kca = new CustomTreeKeyNavigation(this.tree);
        this._keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)kca);
        this.tree.setPreKeyListener(new 3());
        this.tree.setPostKeyListener(this);
    }

    protected CustomTree createCustomTree() {
        CustomTree newCustomTree = new CustomTree();
        newCustomTree.putClientProperty("JTree.expandOnMouseRelease", Boolean.TRUE);
        return newCustomTree;
    }

    protected String getDFTName() {
        try {
            String simpleName = this.getClass().getSimpleName();
            if (simpleName.length() > 1 && !simpleName.startsWith("$")) {
                String newName = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1, simpleName.length());
                String string = "der-" + newName;
                return string;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return null;
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        this.createDragDropSupportIfEnabled();
        Ide.removeIdeListener((IdeListener)this);
    }

    private void createDragDropSupportIfEnabled() {
        if (!Ide.getIdeProperties().isPropertySet(DISABLE_EXPLORER_DRAG_AND_DROP_PROP, Boolean.toString(true), Boolean.toString(false))) {
            this.createDragSource();
            this.createDropTarget();
        }
    }

    public void dispose() {
        ExplorerNode root = (ExplorerNode)this.getRoot();
        if (root != null) {
            root.removeNodeUpdateListener(this);
            if (root.getChildCount() > 0) {
                Enumeration<TreeNode> descendants = root.breadthFirstEnumeration();
                descendants.nextElement();
                while (descendants.hasMoreElements()) {
                    ExplorerNode descendant = (ExplorerNode)descendants.nextElement();
                    descendant.removeNodeUpdateListener(this);
                }
            }
        }
    }

    private static final ExplorerNode getClosestTNode(ExplorerNode tnode) {
        TreeNode nextTNode = tnode.getNextSibling();
        if (nextTNode == null && (nextTNode = tnode.getPreviousSibling()) == null && (nextTNode = tnode.getParent()) == null) {
            nextTNode = tnode.getNextNode();
        }
        return (ExplorerNode)nextTNode;
    }

    private void fireDefaultAction(InputEvent e) {
        ContextMenu menu = this.getContextMenu();
        if (menu == null) {
            return;
        }
        View view = this.owner();
        Context context = view != null ? view.getContext((EventObject)e) : this.getContext();
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null && nodes.length > 0 && menu.fireDefaultAction(context)) {
            e.consume();
        }
    }

    private String buildPathKey(TNode tnode) {
        TreePath path = new TreePath(tnode.getPath());
        return this.buildPathKey(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFilters(TNode tnode, boolean recurse) {
        if (tnode.isLeaf()) {
            return;
        }
        String key = this.buildPathKey(tnode);
        Map map = this._filterCache;
        synchronized (map) {
            FilterInfo info = (FilterInfo)this._filterCache.get(key);
            if (info != null) {
                tnode.setChildFilter(null);
                info.releaseFilter();
            }
        }
        if (recurse && tnode.isSet(TNodeConstants.IS_OPENED)) {
            Enumeration children = tnode.children();
            while (children.hasMoreElements()) {
                this.releaseFilters((TNode)children.nextElement(), true);
            }
        }
    }

    private boolean isViewActive() {
        return this.owner() != null && this.owner() == Ide.getMainWindow().getLastActiveView();
    }

    private TNode findNodeBreadthFirst(Element element, List sources, boolean searchUnopened, List output) {
        for (TNode node : sources) {
            if (element == node.getData()) {
                return node;
            }
            if (node.isLeaf() || !node.isSet(TNodeConstants.IS_OPENED) && (!searchUnopened || !this.open(node))) continue;
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                output.add(children.nextElement());
            }
        }
        return null;
    }

    private void dropNodeSubtree(ExplorerNode node) {
        ChildFilter filter = node.getFilter();
        if (filter != null) {
            filter.uncache((TNode)node);
        }
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> descendants = node.breadthFirstEnumeration();
            descendants.nextElement();
            while (descendants.hasMoreElements()) {
                ExplorerNode descendant = (ExplorerNode)descendants.nextElement();
                descendant.removeNodeUpdateListener(this);
                this.releaseFilters(descendant, false);
                if (filter == null) continue;
                filter.uncache((TNode)descendant);
            }
            node.removeAllChildren();
            this.collapse(node, false);
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(node);
        }
        node.unsetBit(TNodeConstants.IS_OPENED);
    }

    private void checkLeafState(TNode node) {
        if (this.isHideChildren(node)) {
            ((ExplorerNode)node).makeLeaf();
        }
    }

    private boolean isHideChildren(TNode node) {
        Element element = node.getData();
        return this.getCellRendererAttributes().isSet(CellRendererAttributes.HIDE_CHILDREN) && element.getAttributes().isSet(ElementAttributes.HIDE_CHILDREN) && element.mayHaveChildren();
    }

    public void focusGained(FocusEvent e) {
        ExplorerNode lastActiveNode;
        this.nodeChanged(this.getRoot());
        if (this._lastActiveNodeWeakRef != null && (lastActiveNode = (ExplorerNode)this._lastActiveNodeWeakRef.get()) != null) {
            this.nodeChanged(lastActiveNode);
        }
    }

    public void focusLost(FocusEvent e) {
        this.focusGained(e);
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.scheduleUpdateSelection();
    }

    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        TNode tnode = (TNode)path.getLastPathComponent();
        if (!tnode.isLeaf()) {
            4 runnable = new 4(this, tnode);
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        int keyCode;
        this._keyMgr.postKeyPressed(event);
        if (!event.isConsumed() && (keyCode = event.getKeyCode()) == 10) {
            this.fireDefaultAction(event);
        }
    }

    public void keyTyped(KeyEvent event) {
        this._keyMgr.postKeyTyped(event);
    }

    public void keyReleased(KeyEvent event) {
        this._keyMgr.postKeyReleased(event);
    }

    private void dblClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getClickCount() == 2) {
            if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                this.fireDefaultAction(e);
            }
        } else if (e.getClickCount() > 2) {
            e.consume();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.tryPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.dblClicked(e);
        } else {
            this.tryPopup(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            View view;
            Context context;
            ContextMenu menu = this.getContextMenu();
            if (menu == null) {
                return;
            }
            TreePath current = this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (current == null) {
                this.tryPopupInBlankSpace(menu, e);
                return;
            }
            TreePath[] paths = this.tree.getSelectionPaths();
            boolean isSelected = false;
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    if (paths[i].getLastPathComponent() == current.getLastPathComponent()) {
                        isSelected = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!isSelected) {
                this.tree.setSelectionPath(current);
            }
            Context context2 = context = (view = this.owner()) != null ? view.getContext((EventObject)e) : this.getContext(e);
            if (context.getElement() == null) {
                return;
            }
            menu.show(context);
        }
    }

    protected void tryPopupInBlankSpace(ContextMenu contextMenu, MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TNode node, UpdateMessage change) {
        ArrayList arrayList = this._updates;
        synchronized (arrayList) {
            this._updates.add(node);
            this._updates.add(change);
        }
        if (this._timer != null) {
            this._timer.restart();
        } else {
            this.updateImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImpl() {
        ArrayList updates = new ArrayList();
        ArrayList arrayList = this._updates;
        synchronized (arrayList) {
            if (this._updates.isEmpty()) {
                return;
            }
            updates.addAll(this._updates);
            this._updates.clear();
        }
        Iterator iter = updates.iterator();
        while (iter.hasNext()) {
            TNode tnode = (TNode)iter.next();
            UpdateMessage change = (UpdateMessage)iter.next();
            this.updateImpl(tnode, change);
        }
    }

    private void tryForceUpdateImpl() {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
    }

    private void updateImpl(TNode node, UpdateMessage change) {
        DefaultTreeModel model = this.getTreeModel();
        int id = change.getMessageID();
        if (id == UpdateMessage.OBJECT_RENAMED) {
            this.nodeChanged(node);
            if (node != this.getRoot()) {
                return;
            }
            this.updateTitle(node);
            this.setSelected(node);
        }
        if (id == UpdateMessage.OBJECT_RENAMED || id == UpdateMessage.CHILD_RENAMED) {
            TNode tchild;
            List addedObjects;
            ChildFilter filter = node.getChildFilter();
            List removedObjects = change.getRemoveObjects();
            if (removedObjects.size() > 0) {
                this.childrenRemoved(change, node, model, filter);
            }
            if ((addedObjects = change.getAddObjects()).size() > 0 && (tchild = this.childrenAdded(change, node, model, filter, true)) != null) {
                this.renameFilters(node, tchild, change);
                this.nodeChanged(tchild);
                this.setSelected(tchild);
            }
        } else if (id == UpdateMessage.CHILD_REMOVED) {
            this.childrenRemoved(change, node, model, node.getChildFilter());
        } else if (id == UpdateMessage.CHILD_ADDED) {
            boolean select = TreeExplorer.isSelectAddedChild((UpdateMessage)change, (boolean)true);
            this.childrenAdded(change, node, model, node.getChildFilter(), select);
        } else if (id == UpdateMessage.STRUCTURE_CHANGED) {
            this.update(node, change, false);
        } else if (id == UpdateMessage.PROPERTY_SET) {
            this.update(node, change, true);
        } else if (id == UpdateMessage.OBJECT_CLOSED) {
            this.releaseFilters(node, true);
            this.collapse(node, true);
            node.unsetBit(TNodeConstants.IS_OPENED);
            if (node == this.getRoot() && !this.tree.isRootVisible()) {
                EventQueue.invokeLater(new 5(this, node));
            }
        } else if (id == UpdateMessage.ATTRIBUTE_CHANGED) {
            this.nodeChanged(node);
        } else if (this.owner() instanceof NodeUpdateListener) {
            ((NodeUpdateListener)this.owner()).update(node, change);
        }
    }

    private void update(TNode node, UpdateMessage change, boolean propertySet) {
        ChildFilter filter = node.getChildFilter();
        if (filter != null) {
            if (!propertySet || filter.canUpdate(node, change)) {
                this.refresh(node, Project.class);
            }
        } else if (!node.isLeaf()) {
            this.refresh(node);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.updateSelection();
    }

    public Transferable[] dragStarted(DragGestureEvent event) {
        Point origin = event.getDragOrigin();
        if (this.tree.getPathForLocation(origin.x, origin.y) == null) {
            return new Transferable[0];
        }
        Context context = this.getContext(event);
        TransferableContext transferableContext = new TransferableContext(context);
        InputEvent inputEvent = event.getTriggerEvent();
        6 triggerEventTransferable = new 6(this, inputEvent);
        return new Transferable[]{transferableContext, triggerEventTransferable};
    }

    public void dropOccurred(DragSourceDropEvent dsde, Object dropTargetObject) {
        if (dsde.getDropSuccess()) {
            this.nodeChanged((TNode)dropTargetObject);
        }
    }

    static KeyNavigationManager ra$_keyMgr(BaseTreeExplorer baseTreeExplorer) {
        return baseTreeExplorer._keyMgr;
    }

    static void mav$updateImpl(BaseTreeExplorer baseTreeExplorer) {
        baseTreeExplorer.updateImpl();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            BaseTreeExplorer.mav$updateImpl(BaseTreeExplorer.this);
        }
    }

    private class SiblingIterator {
        private int _relativeToRow;
        private TreePath _relativeToPath;
        private TNode _relativeToParent;
        private int _searchRow;
        private boolean _backward;

        SiblingIterator(int relativeToRow) {
            this._relativeToRow = relativeToRow;
            this._searchRow = relativeToRow;
            this._relativeToPath = BaseTreeExplorer.this.tree.getPathForRow(relativeToRow);
            this._relativeToParent = this.getParentNode(this._relativeToPath);
        }

        TreePath nextSiblingPath() {
            if (!this._backward) {
                while (this._searchRow + 1 <= BaseTreeExplorer.this.tree.getRowCount()) {
                    ++this._searchRow;
                    TreePath tp = BaseTreeExplorer.this.tree.getPathForRow(this._searchRow);
                    if (tp == null) continue;
                    if (this.isSiblingPath(tp)) {
                        return tp;
                    }
                    if (!this.sameSubtree(tp)) break;
                }
                this._backward = true;
                this._searchRow = this._relativeToRow;
            }
            while (this._searchRow - 1 >= 0) {
                --this._searchRow;
                TreePath tp = BaseTreeExplorer.this.tree.getPathForRow(this._searchRow);
                if (tp == null) continue;
                if (this.isSiblingPath(tp)) {
                    return tp;
                }
                if (!this.sameSubtree(tp)) break;
            }
            return null;
        }

        private boolean isSiblingPath(TreePath tp) {
            return this.getParentNode(tp) == this._relativeToParent;
        }

        private boolean sameSubtree(TreePath tp) {
            TreePath search = tp;
            while (search != null) {
                if (search == this._relativeToParent) {
                    return true;
                }
                search = search.getParentPath();
            }
            return false;
        }

        private TNode getParentNode(TreePath tp) {
            int pathCount = tp.getPathCount();
            if (pathCount >= 2) {
                return (TNode)tp.getPathComponent(pathCount - 2);
            }
            return null;
        }
    }

    private static class NodeOpeningExecutor {
        private static Executor executor = null;

        private NodeOpeningExecutor() {
        }

        static Executor getInstance() {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            return executor;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Element v$data;
        final /* synthetic */ BaseTreeExplorer this$0;

        public void run() {
            try {
                ((Node)this.v$data).open();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }

        public 2(BaseTreeExplorer baseTreeExplorer, Element element) {
            this.v$data = element;
            this.this$0 = baseTreeExplorer;
        }
    }

    final class 3
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            BaseTreeExplorer.ra$_keyMgr(BaseTreeExplorer.this).preKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            BaseTreeExplorer.ra$_keyMgr(BaseTreeExplorer.this).preKeyReleased(e);
        }

        public void keyTyped(KeyEvent e) {
            BaseTreeExplorer.ra$_keyMgr(BaseTreeExplorer.this).preKeyTyped(e);
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ TNode v$tnode;
        final /* synthetic */ BaseTreeExplorer this$0;

        public void run() {
            String key1 = this.getClass().getName() + ".treeExpanded.1." + this.v$tnode;
            String key2 = this.getClass().getName() + ".treeExpanded.2." + this.v$tnode;
            Assert.startTiming((String)key1, null, (boolean)false, (boolean)false);
            Assert.startTiming((String)key2, null, (boolean)false, (boolean)false);
            boolean starting = Ide.isStarting();
            if (!starting) {
                Ide.getWaitCursor().show();
            }
            boolean tnodeWasClosed = this.v$tnode.isSet(TNodeConstants.IS_OPENED) ^ true;
            try {
                if (tnodeWasClosed) {
                    this.this$0.open(this.v$tnode);
                    IdeMainWindow.updateVisibleActions();
                    Assert.execute((Runnable)new 1(this, key1));
                }
                this.this$0.nodeExpanded(this.v$tnode, tnodeWasClosed);
            }
            finally {
                if (!starting) {
                    Ide.getWaitCursor().hide();
                    Assert.execute((Runnable)new 2(this, tnodeWasClosed, key2));
                }
            }
        }

        public 4(BaseTreeExplorer baseTreeExplorer, TNode tNode) {
            this.v$tnode = tNode;
            this.this$0 = baseTreeExplorer;
        }

        static TNode ra$v$tnode(4 var0) {
            return var0.v$tnode;
        }

        final class oracle.ideimpl.explorer.BaseTreeExplorer$4$1
        implements Runnable {
            private final /* synthetic */ String v$key1;
            final /* synthetic */ 4 this$0;

            public void run() {
                String autoExpandProp;
                Element data = 4.ra$v$tnode(this.this$0).getData();
                if (data instanceof Workspace && Boolean.valueOf(autoExpandProp = System.getProperty("jdev.autoexpand.workspace")).booleanValue()) {
                    Assert.println((String)"Autoexpanding {0}...", (Object)data.getLongLabel());
                    this.this$0.this$0.expand(4.ra$v$tnode(this.this$0), true);
                    SwingUtilities.invokeLater(new 1(this, data));
                }
            }

            public oracle.ideimpl.explorer.BaseTreeExplorer$4$1(4 var1_1, String string) {
                this.v$key1 = string;
                this.this$0 = var1_1;
            }

            static String ra$v$key1(oracle.ideimpl.explorer.BaseTreeExplorer$4$1 var0) {
                return var0.v$key1;
            }

            final class 1
            implements Runnable {
                private final /* synthetic */ Element v$data;
                final /* synthetic */ oracle.ideimpl.explorer.BaseTreeExplorer$4$1 this$0;

                public void run() {
                    Assert.endTiming((String)oracle.ideimpl.explorer.BaseTreeExplorer$4$1.ra$v$key1(this.this$0), (String)("Autoexpanded " + this.v$data.getLongLabel()), null, (boolean)false, (boolean)false);
                }

                public 1(oracle.ideimpl.explorer.BaseTreeExplorer$4$1 var1_1, Element element) {
                    this.v$data = element;
                    this.this$0 = var1_1;
                }
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ boolean v$tnodeWasClosed;
            private final /* synthetic */ String v$key2;
            final /* synthetic */ 4 this$0;

            public void run() {
                if (this.v$tnodeWasClosed) {
                    Assert.endTiming((String)this.v$key2, (String)("Expanded node for " + 4.ra$v$tnode(this.this$0)), null, (boolean)false, (boolean)false);
                }
            }

            public 2(4 var1_1, boolean bl, String string) {
                this.v$key2 = string;
                this.v$tnodeWasClosed = bl;
                this.this$0 = var1_1;
            }
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ TNode v$node;
        final /* synthetic */ BaseTreeExplorer this$0;

        public void run() {
            UpdateMessage.fireStructureChanged((Subject)((Subject)this.v$node.getData()));
        }

        public 5(BaseTreeExplorer baseTreeExplorer, TNode tNode) {
            this.v$node = tNode;
            this.this$0 = baseTreeExplorer;
        }
    }

    private final class TreeExplorerModel
    extends DefaultTreeModel {
        private TreeExplorerModel(TreeNode root) {
            super(root);
        }

        public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int index) {
            if (parent instanceof ExplorerNode && !((ExplorerNode)parent).isSet(TNodeConstants.IS_OPENED)) {
                ((ExplorerNode)parent).removeAllChildren();
            }
            parent.insert(child, index);
            int[] childIndices = new int[1];
            int i = parent.getIndex(child);
            if (i >= 0) {
                childIndices[0] = parent.getIndex(child);
                this.nodesWereInserted(parent, childIndices);
            } else {
                Assert.println((String)("Unable to insert child " + child.toString() + " into parent " + parent.toString()));
            }
        }

        private void removeNodesFromParent(MutableTreeNode parent, MutableTreeNode[] children) {
            int size = children.length;
            int[] childIndices = new int[size];
            int i = 0;
            while (i < size) {
                childIndices[i] = parent.getIndex(children[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < size) {
                parent.remove(children[i2]);
                ++i2;
            }
            this.nodesWereRemoved(parent, childIndices, children);
        }

        TreeExplorerModel(TreeNode treeNode, 1 var3_3) {
            this(treeNode);
        }

        static void mav$removeNodesFromParent(TreeExplorerModel treeExplorerModel, MutableTreeNode mutableTreeNode, MutableTreeNode[] mutableTreeNodeArray) {
            treeExplorerModel.removeNodesFromParent(mutableTreeNode, mutableTreeNodeArray);
        }

        public final class 1 {
        }
    }

    private static final class FilterInfo {
        private String _className;
        private int _options;
        private ChildFilter _filter;

        FilterInfo(String className, int options) {
            this._className = className;
            this._options = options;
        }

        FilterInfo(ChildFilter filter) {
            this._className = filter.getClass().getName();
            this._options = filter.getOptions();
            this._filter = filter;
        }

        ChildFilter getFilter() {
            if (this._filter == null) {
                try {
                    Class<?> filterClass = Class.forName(this._className);
                    this._filter = (ChildFilter)filterClass.newInstance();
                    this._filter.setOptions(this._options);
                    ChildFilter childFilter = this._filter;
                    return childFilter;
                }
                catch (Exception e) {
                    ChildFilter childFilter = null;
                    return childFilter;
                }
            }
            return this._filter;
        }

        String getClassName() {
            return this._className;
        }

        int getOptions() {
            return this._options;
        }

        ChildFilter releaseFilter() {
            ChildFilter filter = this._filter;
            this._filter = null;
            if (filter != null) {
                filter.closeChildren();
            }
            return filter;
        }
    }

    final class 6
    implements Transferable {
        private final /* synthetic */ Object v$inputEvent;
        final /* synthetic */ BaseTreeExplorer this$0;

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DndUtils.FLAVOR_TRIGGER_EVENT};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DndUtils.FLAVOR_TRIGGER_EVENT.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.v$inputEvent;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public 6(BaseTreeExplorer baseTreeExplorer, Object object) {
            this.v$inputEvent = object;
            this.this$0 = baseTreeExplorer;
        }
    }
}

