/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.controls.TreeAutoExpander;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Attributes;
import oracle.ideimpl.explorer.CustomTreeCellRenderer;
import oracle.ideimpl.explorer.CustomTreeSelectionModel;
import oracle.javatools.ui.ExpansionTreeTip;
import oracle.javatools.ui.themes.Themes;

public class CustomTree
extends JTree {
    private KeyListener _preKeyListener;
    private KeyListener _postKeyListener;
    private MouseListener _preMouseListener;
    private CustomTreeCellRenderer _cellRenderer;
    private ExpansionTreeTip _expansionTip;

    private void $init$() {
        this._cellRenderer = new CustomTreeCellRenderer();
    }

    public CustomTree() {
        this((TreeModel)null);
    }

    public CustomTree(TreeModel model) {
        super(model);
        this.$init$();
        if (Themes.isThemed()) {
            this.setOpaque(false);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(this._cellRenderer);
        this.setSelectionModel(new CustomTreeSelectionModel());
        TreeAutoExpander.install((JTree)this);
        KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(65, 2)};
        KeyUtil.removeKeyStrokesFromInputMap((JComponent)this, (KeyStroke[])keyStrokes, (int)0);
        this._expansionTip = new ExpansionTreeTip((JTree)this);
    }

    public ExpansionTreeTip getExpansionTip() {
        return this._expansionTip;
    }

    public void setPostKeyListener(KeyListener l) {
        this._postKeyListener = l;
    }

    public void setPreKeyListener(KeyListener l) {
        this._preKeyListener = l;
    }

    public void setPreMouseListener(MouseListener l) {
        this._preMouseListener = l;
    }

    protected Attributes getCellRendererAttributes() {
        return this._cellRenderer.getAttributes();
    }

    protected void setCellRendererAttributes(Attributes attributes) {
        this._cellRenderer.setAttributes(attributes);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this._preKeyListener != null) {
            switch (e.getID()) {
                case 401: {
                    this._preKeyListener.keyPressed(e);
                    break;
                }
                case 400: {
                    this._preKeyListener.keyTyped(e);
                    break;
                }
                case 402: {
                    this._preKeyListener.keyReleased(e);
                    break;
                }
            }
        }
        if (e.isConsumed()) {
            return;
        }
        super.processKeyEvent(e);
        if (e.isConsumed()) {
            return;
        }
        if (this._postKeyListener != null) {
            switch (e.getID()) {
                case 401: {
                    this._postKeyListener.keyPressed(e);
                    break;
                }
                case 400: {
                    this._postKeyListener.keyTyped(e);
                    break;
                }
                case 402: {
                    this._postKeyListener.keyReleased(e);
                    break;
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this._preMouseListener != null) {
            if (e.getID() == 502 && e.getClickCount() == 2) {
                this._preMouseListener.mouseReleased(e);
            }
            if (e.isConsumed()) {
                return;
            }
        }
        super.processMouseEvent(e);
        if (this._preMouseListener != null) {
            switch (e.getID()) {
                case 501: {
                    this._preMouseListener.mousePressed(e);
                    break;
                }
                case 502: {
                    this._preMouseListener.mouseReleased(e);
                    break;
                }
                case 500: {
                    this._preMouseListener.mouseClicked(e);
                    break;
                }
                case 505: {
                    this._preMouseListener.mouseExited(e);
                    break;
                }
                case 504: {
                    this._preMouseListener.mouseEntered(e);
                    break;
                }
            }
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String result = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        return result != null ? result : "";
    }

    public TreeSelectionModel getSelectionModel() {
        return super.getSelectionModel();
    }

    public void setSelectionModel(TreeSelectionModel selectionModel) {
        super.setSelectionModel(selectionModel);
    }
}

