/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.ide.explorer.TNode;
import oracle.ide.model.ElementAttributes;

public class CustomTreeSelectionModel
extends DefaultTreeSelectionModel {
    public void setSelectionPaths(TreePath[] paths) {
        if (paths == null || this.hasNullPaths(paths)) {
            return;
        }
        if (paths.length == 0) {
            super.setSelectionPaths(paths);
            return;
        }
        if (this.areParentsEqual(paths, paths[0].getParentPath())) {
            super.setSelectionPaths(paths);
            return;
        }
        if (this.areContainerAncestorsEqual(paths, this.getContainerAncestorPath(paths[0]))) {
            super.setSelectionPaths(paths);
            return;
        }
    }

    public void addSelectionPaths(TreePath[] paths) {
        if (paths == null || paths.length == 0 || this.hasNullPaths(paths)) {
            return;
        }
        TreePath selectedPath = this.getSelectionPath();
        if (selectedPath == null) {
            super.addSelectionPaths(paths);
            return;
        }
        if (this.areParentsEqual(paths, selectedPath.getParentPath())) {
            super.addSelectionPaths(paths);
            return;
        }
        if (this.areContainerAncestorsEqual(paths, this.getContainerAncestorPath(selectedPath))) {
            super.addSelectionPaths(paths);
            return;
        }
    }

    private boolean areParentsEqual(TreePath[] paths, TreePath parent) {
        int i = 0;
        while (i < paths.length) {
            TreePath currentParent = paths[i].getParentPath();
            if (parent == null || currentParent == null) {
                if (parent != null || currentParent != null) {
                    return false;
                }
            } else if (!currentParent.equals(parent)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean areContainerAncestorsEqual(TreePath[] paths, TreePath ancestor) {
        if (ancestor == null) {
            return false;
        }
        int i = 0;
        while (i < paths.length) {
            TreePath currentAncestor = this.getContainerAncestorPath(paths[i]);
            if (ancestor == null || currentAncestor == null) {
                if (ancestor != null || currentAncestor != null) {
                    return false;
                }
            } else if (!currentAncestor.equals(ancestor)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private TreePath getContainerAncestorPath(TreePath path) {
        TreePath parent = path.getParentPath();
        while (parent != null) {
            if (this.isContainerAncestorPath(parent)) {
                return parent;
            }
            parent = parent.getParentPath();
        }
        return null;
    }

    private boolean isContainerAncestorPath(TreePath path) {
        TNode node = (TNode)path.getLastPathComponent();
        return node.getData().getAttributes().isSet(ElementAttributes.SELECTION_CONTAINER);
    }

    private boolean hasNullPaths(TreePath[] paths) {
        int i = 0;
        while (i < paths.length) {
            if (paths[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setSelectionMode(int mode) {
        super.setSelectionMode(mode);
    }
}

