/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.ExplorerInfo;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.Pair;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.ideimpl.explorer.ExplorerArb;
import oracle.ideimpl.explorer.ExplorerDockableFactory;
import oracle.ideimpl.explorer.ExplorerWindowImpl;
import oracle.ideri.util.Product;

public class ExplorerManagerImpl
extends ExplorerManager
implements Addin {
    public static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"Explorer.TOGGLE_TOOLBAR_CMD_ID");
    public static final int TOGGLE_EXPLORER_CMD_ID = Ide.findOrCreateCmdID((String)"Explorer.TOGGLE_EXPLORER_CMD_ID");
    public static final String EXPLORER_WINDOW_ID = "ExplorerWindow";
    public static final String SINGLETON = "SingletonExplorerWindow";
    private static final String SUPPORTERS_PROP = "Structure.structuredViews";
    private static final DockableFactory FACTORY = new ExplorerDockableFactory();
    private static final List STRUCTURE_SUPPORTERS = new ArrayList();
    private static ContextMenu CONTEXT_MENU;
    private static final Map DATA_TYPE_TO_EXPLORER_TYPES;
    private static final Map EXPLORER_TYPE_TO_VIEW_TYPES;
    private static final Map EXPLORER_TYPE_TO_CAPTION;
    private static final Map EXPLORER_TYPE_TO_ICON;
    private static final Map DOC_INSTANCE_TO_EXPLORER_INSTANCES;
    private static final Map VIEW_INSTANCE_TO_EXPLORER_INSTANCES;
    private static final Map HOST_INSTANCE_TO_EXPLORER_INSTANCES;
    private static final Map EXPLORER_INSTANCE_TO_DOC_INSTANCE;
    private static final Map EXPLORER_INSTANCE_TO_VIEW_INSTANCES;
    private static final Map EXPLORER_INSTANCE_TO_HOST_INSTANCE;
    private static final List DYNAMIC_INFO;
    private static final List DELAYED_ICONS;
    private static final Object DELAYED_ICON;
    private static final Object DUMMY_ICON;
    private static final Object DUMMY_CAPTION;
    private static final Class DUMMY_DATA_TYPE;
    private static final Observer DOC_LISTENER;
    private static final ViewListener HOST_LISTENER;
    private static final ViewListener VIEW_LISTENER;

    static {
        DATA_TYPE_TO_EXPLORER_TYPES = new HashMap();
        EXPLORER_TYPE_TO_VIEW_TYPES = new HashMap();
        EXPLORER_TYPE_TO_CAPTION = new HashMap();
        EXPLORER_TYPE_TO_ICON = new HashMap();
        DOC_INSTANCE_TO_EXPLORER_INSTANCES = new HashMap();
        VIEW_INSTANCE_TO_EXPLORER_INSTANCES = new HashMap();
        HOST_INSTANCE_TO_EXPLORER_INSTANCES = new HashMap();
        EXPLORER_INSTANCE_TO_DOC_INSTANCE = new HashMap();
        EXPLORER_INSTANCE_TO_VIEW_INSTANCES = new HashMap();
        EXPLORER_INSTANCE_TO_HOST_INSTANCE = new HashMap();
        DYNAMIC_INFO = new ArrayList();
        DELAYED_ICONS = new ArrayList();
        DELAYED_ICON = new Object();
        DUMMY_ICON = new Object();
        DUMMY_CAPTION = new Object();
        DUMMY_DATA_TYPE = Object.class;
        DOC_LISTENER = new DocLsnr(null);
        HOST_LISTENER = new HostLsnr(null);
        VIEW_LISTENER = new ViewLsnr(null);
        STRUCTURE_SUPPORTERS.add(NavigatorWindow.class);
        STRUCTURE_SUPPORTERS.add(Editor.class);
        String supporters = Ide.getProperty((String)SUPPORTERS_PROP);
        if (supporters != null) {
            StringTokenizer tokenizer = new StringTokenizer(supporters, ";");
            while (tokenizer.hasMoreTokens()) {
                String supporter = tokenizer.nextToken();
                Class<?> cls = null;
                try {
                    cls = Class.forName(supporter);
                    STRUCTURE_SUPPORTERS.add(cls);
                }
                catch (Exception e) {
                    System.out.println(IdeArb.format((int)399, (Object[])new String[]{supporter}));
                }
            }
        }
    }

    protected ExplorerManagerImpl() {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id;
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == 70) {
            ExplorerWindowImpl window;
            CustomTab tabs;
            View view = context.getView();
            if (view instanceof ExplorerWindowImpl && (tabs = (window = (ExplorerWindowImpl)view).getTabs()) != null) {
                tabs.setSelectedPage(tabs.getSelectedPage() - 1);
            }
            return true;
        }
        if (id == 71) {
            ExplorerWindowImpl window;
            CustomTab tabs;
            View view = context.getView();
            if (view instanceof ExplorerWindowImpl && (tabs = (window = (ExplorerWindowImpl)view).getTabs()) != null) {
                tabs.setSelectedPage(tabs.getSelectedPage() + 1);
            }
            return true;
        }
        if (id == 67) {
            ExplorerWindowImpl window = (ExplorerWindowImpl)this.showView(null);
            if (window != null) {
                window.setContext(context);
            }
            return true;
        }
        return super.handleEvent(action, context);
    }

    public boolean update(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == 70) {
            View view = context.getView();
            if (view instanceof ExplorerWindowImpl) {
                ExplorerWindowImpl window = (ExplorerWindowImpl)view;
                CustomTab tabs = window.getTabs();
                action.setEnabled(tabs != null && tabs.getSelectedPage() > 0);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == 71) {
            View view = context.getView();
            if (view instanceof ExplorerWindowImpl) {
                ExplorerWindowImpl window = (ExplorerWindowImpl)view;
                CustomTab tabs = window.getTabs();
                action.setEnabled(tabs != null && tabs.getSelectedPage() < tabs.getPageCount() - 1);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return super.update(action, context);
    }

    public void initialize() {
        Menubar menuMgr;
        super.initialize();
        ExplorerManager.setExplorerManager((ExplorerManager)this);
        Object object = menuMgr = Ide.getIdeArgs().getCreateUI() ? Ide.getMenubar() : null;
        if (Ide.getIdeArgs().getCreateUI() && !Product.isRaptor()) {
            IdeAction action = this.getShowAction();
            JMenuItem explorerMenuItem = menuMgr.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_VIEW_STRUCTURE);
            JMenu viewMenu = MenuManager.getJMenu((String)"View");
            menuMgr.add((Component)explorerMenuItem, viewMenu, MenuConstants.SECTION_VIEW_SUPPORTING);
            AddinManager addMgr = AddinManager.getAddinManager();
            IdeAction selectAction = IdeAction.get((int)ExplorerManager.SELECT_IN_STRUCTURE_CMD_ID, (String)addMgr.getCommand(ExplorerManager.SELECT_IN_STRUCTURE_CMD_ID, "Explorer.SELECT_IN_STRUCTURE_CMD_ID"), (String)IdeArb.getString((int)7), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)IdeArb.getInteger((int)95), (ArrayResourceBundle)IdeArb.getInstance(), (int)350, null, (boolean)false);
            JMenuItem selectInStructureMenuItem = menuMgr.createMenuItem((ToggleAction)selectAction, MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_STRUCTURE);
            JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
            menuMgr.add((Component)selectInStructureMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_SELECT);
        }
    }

    protected ViewId getViewId(Context context) {
        if (context != null) {
            Collection collection;
            Node node = context.getNode();
            Collection collection2 = collection = node != null ? this.getViews() : null;
            if (collection != null) {
                View[] views = new View[collection.size()];
                collection.toArray(views);
                int i = views.length - 1;
                while (i >= 0) {
                    Node doc;
                    Context ctx = views[i] != null ? views[i].getContext() : null;
                    Node node2 = doc = ctx != null ? ctx.getNode() : null;
                    if (doc != null && doc == node) {
                        return new ViewId(views[i].getId());
                    }
                    --i;
                }
            }
        }
        return new ViewId(this.getViewCategory());
    }

    protected DockableView createDockableView(Context context, ViewId viewId) {
        ExplorerWindowImpl view = new ExplorerWindowImpl(viewId.getId());
        view.setContext(context);
        return view;
    }

    protected DockableFactory getDockableFactory() {
        return FACTORY;
    }

    protected IdeAction createShowAction() {
        return IdeAction.get((int)49, (String)AddinManager.getAddinManager().getCommand(49, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)454), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)IdeArb.getInteger((int)268), (ArrayResourceBundle)IdeArb.getInstance(), (int)90, null, (boolean)true);
    }

    protected String getViewCategory() {
        return EXPLORER_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return "oracle/ide/explorer/accelerators.xml";
    }

    protected String getDefaultName() {
        return SINGLETON;
    }

    public DockableView showView(Context context) {
        Class explorerType;
        DockableView view = super.showView(context);
        if (view != null && context != null && (explorerType = ExplorerContext.getExplorerType((Context)context)) != null) {
            ((ExplorerWindow)view).toggleExplorer(explorerType);
        }
        return view;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_STRUCTURE;
    }

    protected IdeAction createToggleToolbarAction() {
        if (!Product.isRaptor()) {
            return IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)ExplorerArb.getString(1), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)ExplorerArb.getInteger(2), (ArrayResourceBundle)ExplorerArb.getInstance(), (int)0, null, (boolean)true);
        }
        return null;
    }

    protected DockableView getRelativeView(Context context, ViewId viewId) {
        String name = viewId != null ? viewId.getName() : null;
        NavigatorManager mgr = NavigatorManager.getWorkspaceNavigatorManager();
        if (name != null && name.equals(this.getDefaultName())) {
            return mgr != null ? mgr.getNavigatorWindow() : null;
        }
        DockableView last = this.getLastView();
        return last != null ? last : (mgr != null ? mgr.getNavigatorWindow() : null);
    }

    protected int getOrientation(ViewId view, DockableView relative) {
        NavigatorManager mgr = NavigatorManager.getWorkspaceNavigatorManager();
        if (relative == (mgr != null ? mgr.getNavigatorWindow() : null)) {
            return 3;
        }
        if (relative == null) {
            return 0;
        }
        return 4;
    }

    public boolean supportsStructure(View view) {
        if (view != null) {
            Class cls = view.getClass();
            for (Class supporter : STRUCTURE_SUPPORTERS) {
                if (cls != supporter && !supporter.isAssignableFrom(cls)) continue;
                return true;
            }
        }
        return false;
    }

    public final synchronized ContextMenu getContextMenu() {
        if (CONTEXT_MENU == null) {
            CONTEXT_MENU = new ContextMenu();
            ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            if (hook != null) {
                CONTEXT_MENU.addContextMenuListener(hook.getListener("explorer"));
            }
        }
        return CONTEXT_MENU;
    }

    public void register(Class dataType, Class explorerType, Class viewType) {
        this.register(dataType, explorerType, viewType, null, null);
    }

    public synchronized void register(Class dataType, Class explorerType, Class viewType, String caption, ArrayResourceBundle bundle, int key) {
        if (dataType == null || explorerType == null) {
            return;
        }
        this.register(dataType, explorerType, viewType, caption, null);
        if (bundle != null && key >= 0) {
            int i = DELAYED_ICONS.indexOf(explorerType);
            while (i >= 0) {
                if (DELAYED_ICONS.get(i + 1) == dataType) {
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    break;
                }
                int subIndex = DELAYED_ICONS.subList(i + 4, DELAYED_ICONS.size()).indexOf(explorerType);
                if (subIndex < 0) break;
                i += subIndex + 4;
            }
            DELAYED_ICONS.add(explorerType);
            DELAYED_ICONS.add(dataType);
            DELAYED_ICONS.add(bundle);
            DELAYED_ICONS.add(key);
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), DELAYED_ICON);
        }
    }

    public void register(Class dataType, Class explorerType, Class viewType, String caption, ResourceBundle bundle, String key) {
        if (dataType == null || explorerType == null) {
            return;
        }
        this.register(dataType, explorerType, viewType, caption, null);
        key = key != null ? key.trim() : null;
        String string = key = key != null && key.length() > 0 ? key : null;
        if (bundle != null && key != null) {
            int i = DELAYED_ICONS.indexOf(explorerType);
            while (i >= 0) {
                if (DELAYED_ICONS.get(i + 1) == dataType) {
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    DELAYED_ICONS.remove(i);
                    break;
                }
                int subIndex = DELAYED_ICONS.subList(i + 4, DELAYED_ICONS.size()).indexOf(explorerType);
                if (subIndex < 0) break;
                i += subIndex + 4;
            }
            DELAYED_ICONS.add(explorerType);
            DELAYED_ICONS.add(dataType);
            DELAYED_ICONS.add(bundle);
            DELAYED_ICONS.add(key);
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), DELAYED_ICON);
        }
    }

    public void register(Class dataType, Class explorerType, Class viewType, String caption, Icon icon) {
        if (dataType == null || explorerType == null) {
            return;
        }
        if (caption == null) {
            EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), DUMMY_CAPTION);
        } else {
            EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), caption);
        }
        if (icon == null) {
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), DUMMY_ICON);
        } else {
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), icon);
        }
        List<Object> list = (ArrayList<Class>)DATA_TYPE_TO_EXPLORER_TYPES.get(dataType);
        if (list == null) {
            list = new ArrayList<Class>(5);
            list.add(explorerType);
            DATA_TYPE_TO_EXPLORER_TYPES.put(dataType, list);
        } else if (!list.contains(explorerType)) {
            list.add(explorerType);
        }
        list = (List)EXPLORER_TYPE_TO_VIEW_TYPES.get(explorerType);
        if (list == null) {
            list = new ArrayList(5);
            EXPLORER_TYPE_TO_VIEW_TYPES.put(explorerType, list);
        } else if (list.get(0) == null) {
            return;
        }
        if (viewType == null) {
            list.clear();
            list.add(null);
        } else if (!list.contains(viewType)) {
            list.add(viewType);
        }
    }

    public void registerDynamic(ExplorerInfo info) {
        Class explorerType;
        if (info != null && !DYNAMIC_INFO.contains(info) && (explorerType = info.getExplorerType()) != null) {
            Pair key = new Pair((Object)explorerType, (Object)DUMMY_DATA_TYPE);
            DYNAMIC_INFO.add(info);
            if (info.getExplorerCaption() != null) {
                EXPLORER_TYPE_TO_CAPTION.put(key, info.getExplorerCaption());
            }
            EXPLORER_TYPE_TO_ICON.put(key, info);
        }
    }

    public void unregister(ExplorerInfo info) {
        if (info != null && DYNAMIC_INFO.contains(info)) {
            DYNAMIC_INFO.remove(info);
        }
    }

    public List getExplorerTypes(Class dataType) {
        return this.getExplorerTypes(dataType, null);
    }

    public List getExplorerTypes(Element node) {
        if (node != null) {
            Object data = node.getData();
            if (data == null) {
                data = node;
            }
            return this.getExplorerTypes(data.getClass(), node);
        }
        return null;
    }

    private List getExplorerTypes(Class dataType, Element node) {
        if (dataType == null) {
            return null;
        }
        HashMap<Object, Float> types = new HashMap<Object, Float>();
        List list = (List)DATA_TYPE_TO_EXPLORER_TYPES.get(dataType);
        if (list == null) {
            Class superType = dataType.getSuperclass();
            while (superType != null) {
                list = (List)DATA_TYPE_TO_EXPLORER_TYPES.get(superType);
                if (list != null) {
                    DATA_TYPE_TO_EXPLORER_TYPES.put(dataType, list);
                    break;
                }
                superType = superType.getSuperclass();
            }
        }
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                types.put(list.get(i), new Float(0.5 - (double)i * 0.01));
                ++i;
            }
        }
        if (node != null) {
            int i = 0;
            while (i < DYNAMIC_INFO.size()) {
                float weight;
                ExplorerInfo info = (ExplorerInfo)DYNAMIC_INFO.get(i);
                Class type = info.getExplorerType();
                if (type != null && !types.containsKey(type) && !Float.isNaN(weight = info.getExplorerWeight(node))) {
                    types.put(type, new Float(weight));
                }
                ++i;
            }
        }
        ArrayList result = new ArrayList(types.keySet());
        Collections.sort(result, new 1(this, types));
        return result;
    }

    public Icon getExplorerIcon(Class explorerType, Class dataType) {
        Icon icon = null;
        Class registeredType = dataType;
        if (explorerType != null) {
            if (registeredType != null) {
                Pair key = new Pair((Object)explorerType, (Object)registeredType);
                while (registeredType != null) {
                    key.second = registeredType;
                    icon = EXPLORER_TYPE_TO_ICON.get(key);
                    if (icon == DUMMY_ICON) {
                        Set keys = EXPLORER_TYPE_TO_ICON.keySet();
                        for (Pair pair : keys) {
                            if (pair.first != explorerType) continue;
                            icon = EXPLORER_TYPE_TO_ICON.get(pair);
                            if (icon == DUMMY_ICON || pair.second == DUMMY_DATA_TYPE) {
                                icon = null;
                                continue;
                            }
                            if (icon == null) continue;
                            registeredType = (Class)pair.second;
                            break;
                        }
                    }
                    if (icon == null) {
                        registeredType = registeredType.getSuperclass();
                        continue;
                    }
                    break;
                }
            } else {
                icon = EXPLORER_TYPE_TO_ICON.get(new Pair((Object)explorerType, (Object)DUMMY_DATA_TYPE));
                if (icon != null) {
                    dataType = DUMMY_DATA_TYPE;
                    if (icon instanceof ExplorerInfo) {
                        icon = ((ExplorerInfo)icon).getExplorerIcon();
                    }
                }
            }
        }
        if (icon == DELAYED_ICON) {
            int i = DELAYED_ICONS.indexOf(explorerType);
            while (i >= 0) {
                int subIndex;
                if (DELAYED_ICONS.get(i + 1) == registeredType || (subIndex = DELAYED_ICONS.subList(i + 4, DELAYED_ICONS.size()).indexOf(explorerType)) < 0) break;
                i += subIndex + 4;
            }
            ++i;
            ResourceBundle bundle = (ResourceBundle)DELAYED_ICONS.get(++i);
            Object key = DELAYED_ICONS.get(++i);
            if (bundle instanceof ArrayResourceBundle) {
                icon = ((ArrayResourceBundle)bundle).getIconImpl(((Integer)key).intValue());
            } else {
                try {
                    ImageIcon imageIcon;
                    Image image;
                    URL url = bundle.getClass().getResource((String)key);
                    if (url != null && (image = Toolkit.getDefaultToolkit().createImage(url)) != null && (imageIcon = GraphicsUtils.createImageIcon((Image)image)).getImageLoadStatus() == 8) {
                        icon = imageIcon;
                    }
                }
                catch (Exception e) {
                    icon = null;
                }
            }
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, registeredType), icon);
            DELAYED_ICONS.remove(i--);
            DELAYED_ICONS.remove(i--);
            DELAYED_ICONS.remove(i--);
            DELAYED_ICONS.remove(i);
        }
        if (icon != null) {
            if (registeredType != dataType) {
                if (icon instanceof ExplorerInfo && (icon = ((ExplorerInfo)icon).getExplorerIcon()) == null) {
                    icon = IdeArb.getIcon((int)90);
                }
                EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), icon);
            }
        } else {
            icon = IdeArb.getIcon((int)90);
            EXPLORER_TYPE_TO_ICON.put(new Pair((Object)explorerType, (Object)dataType), icon);
        }
        return icon;
    }

    public String getExplorerCaption(Class explorerType, Class dataType) {
        if (explorerType == null) {
            return null;
        }
        String caption = null;
        Class registeredType = dataType;
        if (registeredType != null) {
            Pair key = new Pair((Object)explorerType, (Object)registeredType);
            while (registeredType != null) {
                key.second = registeredType;
                caption = EXPLORER_TYPE_TO_CAPTION.get(key);
                if (caption == DUMMY_CAPTION) {
                    Set keys = EXPLORER_TYPE_TO_CAPTION.keySet();
                    for (Pair pair : keys) {
                        if (pair.first != explorerType) continue;
                        caption = EXPLORER_TYPE_TO_CAPTION.get(pair);
                        if (caption == DUMMY_CAPTION) {
                            caption = null;
                            continue;
                        }
                        if (caption == null) continue;
                        registeredType = (Class)pair.second;
                        break;
                    }
                }
                if (caption == null) {
                    registeredType = registeredType.getSuperclass();
                    continue;
                }
                break;
            }
        } else {
            caption = (String)EXPLORER_TYPE_TO_CAPTION.get(new Pair((Object)explorerType, (Object)DUMMY_DATA_TYPE));
            if (caption != null) {
                dataType = DUMMY_DATA_TYPE;
            }
        }
        if (caption != null) {
            if (registeredType != dataType) {
                EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), caption);
            }
        } else {
            caption = explorerType.getName();
            EXPLORER_TYPE_TO_CAPTION.put(new Pair((Object)explorerType, (Object)dataType), caption);
        }
        return caption;
    }

    public Explorer getExplorerForHost(View host, Context context) {
        Node node = context != null ? context.getNode() : null;
        List<Explorer> list = this.getExplorerTypes((Element)node);
        if (list == null) {
            return null;
        }
        Class preferred = ExplorerContext.getExplorerType((Context)context);
        View view = context.getView();
        Class explorerType = null;
        Iterator i = list.iterator();
        if (preferred != null) {
            while (i.hasNext()) {
                if (i.next() != preferred) continue;
                explorerType = preferred;
                break;
            }
        }
        if (explorerType == null) {
            Class viewType;
            Class clazz = viewType = view != null ? view.getClass() : null;
            if (viewType == null) {
                return null;
            }
            for (Object e : list) {
                list = (List)EXPLORER_TYPE_TO_VIEW_TYPES.get(e);
                if (list != null) {
                    if (list.contains(viewType)) {
                        explorerType = (Class)e;
                        break;
                    }
                    if (explorerType != null || list.get(0) != null) continue;
                    explorerType = (Class)e;
                    continue;
                }
                if (explorerType != null) continue;
                explorerType = (Class)e;
            }
        }
        if (explorerType == null) {
            return null;
        }
        Explorer explorer = null;
        list = (List)DOC_INSTANCE_TO_EXPLORER_INSTANCES.get(node);
        if (list != null) {
            for (Object e : list) {
                if (!explorerType.isAssignableFrom(e.getClass()) || EXPLORER_INSTANCE_TO_HOST_INSTANCE.get(e) != host) continue;
                ArrayList<Object> temp = (ArrayList<Object>)EXPLORER_INSTANCE_TO_VIEW_INSTANCES.get(e);
                if (!temp.contains(view)) {
                    temp.add(view);
                    temp = (List)VIEW_INSTANCE_TO_EXPLORER_INSTANCES.get(view);
                    if (temp == null) {
                        temp = new ArrayList<Object>(5);
                        VIEW_INSTANCE_TO_EXPLORER_INSTANCES.put(view, temp);
                        view.addViewListener(VIEW_LISTENER);
                    }
                    temp.add(e);
                }
                explorer = (Explorer)e;
                break;
            }
        } else {
            list = new ArrayList(5);
            DOC_INSTANCE_TO_EXPLORER_INSTANCES.put(node, list);
            node.attach(DOC_LISTENER);
        }
        if (explorer == null) {
            try {
                explorer = (Explorer)explorerType.newInstance();
                list.add(explorer);
                EXPLORER_INSTANCE_TO_DOC_INSTANCE.put(explorer, node);
                list = (List)HOST_INSTANCE_TO_EXPLORER_INSTANCES.get(host);
                if (list == null) {
                    list = new ArrayList(5);
                    HOST_INSTANCE_TO_EXPLORER_INSTANCES.put(host, list);
                    host.addViewListener(HOST_LISTENER);
                }
                list.add(explorer);
                EXPLORER_INSTANCE_TO_HOST_INSTANCE.put(explorer, host);
                explorer.setOwner(host);
                list = (List)VIEW_INSTANCE_TO_EXPLORER_INSTANCES.get(view);
                if (list == null) {
                    list = new ArrayList(5);
                    VIEW_INSTANCE_TO_EXPLORER_INSTANCES.put(view, list);
                    view.addViewListener(VIEW_LISTENER);
                }
                list.add(explorer);
                list = new ArrayList(5);
                list.add((Explorer)view);
                EXPLORER_INSTANCE_TO_VIEW_INSTANCES.put(explorer, list);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                Explorer explorer2 = null;
                return explorer2;
            }
        }
        explorer.setContext(context);
        return explorer;
    }

    public TreeExplorer createTreeExplorer(Folder folder) {
        BaseTreeExplorer tree = new BaseTreeExplorer();
        if (folder != null) {
            tree.setContext(Context.newIdeContext((Element)folder));
        }
        return tree;
    }

    static Map ra$DOC_INSTANCE_TO_EXPLORER_INSTANCES() {
        return DOC_INSTANCE_TO_EXPLORER_INSTANCES;
    }

    static Map ra$EXPLORER_INSTANCE_TO_HOST_INSTANCE() {
        return EXPLORER_INSTANCE_TO_HOST_INSTANCE;
    }

    static Map ra$EXPLORER_INSTANCE_TO_VIEW_INSTANCES() {
        return EXPLORER_INSTANCE_TO_VIEW_INSTANCES;
    }

    static Map ra$EXPLORER_INSTANCE_TO_DOC_INSTANCE() {
        return EXPLORER_INSTANCE_TO_DOC_INSTANCE;
    }

    static Map ra$VIEW_INSTANCE_TO_EXPLORER_INSTANCES() {
        return VIEW_INSTANCE_TO_EXPLORER_INSTANCES;
    }

    static ViewListener ra$VIEW_LISTENER() {
        return VIEW_LISTENER;
    }

    static Map ra$HOST_INSTANCE_TO_EXPLORER_INSTANCES() {
        return HOST_INSTANCE_TO_EXPLORER_INSTANCES;
    }

    static ViewListener ra$HOST_LISTENER() {
        return HOST_LISTENER;
    }

    static Observer ra$DOC_LISTENER() {
        return DOC_LISTENER;
    }

    final class 1
    implements Comparator {
        private final /* synthetic */ HashMap v$types;
        final /* synthetic */ ExplorerManagerImpl this$0;

        public int compare(Object o1, Object o2) {
            Float value1 = (Float)this.v$types.get(o1);
            Float value2 = (Float)this.v$types.get(o2);
            return Float.compare(value2.floatValue(), value1.floatValue());
        }

        public 1(ExplorerManagerImpl explorerManagerImpl, HashMap hashMap) {
            this.v$types = hashMap;
            this.this$0 = explorerManagerImpl;
        }
    }

    private static class DocLsnr
    implements Observer {
        /*
         * Unable to fully structure code
         */
        public void update(Object doc, UpdateMessage change) {
            block2: {
                id = change.getMessageID();
                if (id != UpdateMessage.OBJECT_CLOSED) break block2;
                master = (List)ExplorerManagerImpl.ra$DOC_INSTANCE_TO_EXPLORER_INSTANCES().get(doc);
                v0 = i = master != null ? master.iterator() : null;
                if (i != null) ** GOTO lbl33
                return;
lbl-1000:
                // 1 sources

                {
                    explorer = (Explorer)i.next();
                    host = ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_HOST_INSTANCE().get(explorer);
                    detail = (List)ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_VIEW_INSTANCES().get(explorer);
                    explorer.stateChanged(2);
                    ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_DOC_INSTANCE().remove(explorer);
                    ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_VIEW_INSTANCES().remove(explorer);
                    ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_HOST_INSTANCE().remove(explorer);
                    for (E view : detail) {
                        detail = (List)ExplorerManagerImpl.ra$VIEW_INSTANCE_TO_EXPLORER_INSTANCES().get(view);
                        detail.remove(explorer);
                        if (!detail.isEmpty()) continue;
                        ((View)view).removeViewListener(ExplorerManagerImpl.ra$VIEW_LISTENER());
                        ExplorerManagerImpl.ra$VIEW_INSTANCE_TO_EXPLORER_INSTANCES().remove(view);
                    }
                    detail = (List)ExplorerManagerImpl.ra$HOST_INSTANCE_TO_EXPLORER_INSTANCES().get(host);
                    detail.remove(explorer);
                    if (!detail.isEmpty()) continue;
                    ((View)host).removeViewListener(ExplorerManagerImpl.ra$HOST_LISTENER());
                    ExplorerManagerImpl.ra$HOST_INSTANCE_TO_EXPLORER_INSTANCES().remove(host);
lbl33:
                    // 3 sources

                    ** while (i.hasNext())
                }
lbl34:
                // 1 sources

                master.clear();
                ExplorerManagerImpl.ra$DOC_INSTANCE_TO_EXPLORER_INSTANCES().remove(doc);
                ((Node)doc).detach(ExplorerManagerImpl.ra$DOC_LISTENER());
            }
        }

        private DocLsnr() {
        }

        DocLsnr(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class HostLsnr
    implements ViewListener {
        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
            View host = e.getView();
            List list = (List)ExplorerManagerImpl.ra$HOST_INSTANCE_TO_EXPLORER_INSTANCES().get(host);
            for (Explorer explorer : list) {
                Object node = ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_DOC_INSTANCE().get(explorer);
                list = (List)ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_VIEW_INSTANCES().get(explorer);
                explorer.stateChanged(2);
                ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_DOC_INSTANCE().remove(explorer);
                ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_HOST_INSTANCE().remove(explorer);
                ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_VIEW_INSTANCES().remove(explorer);
                for (Object view : list) {
                    list = (List)ExplorerManagerImpl.ra$VIEW_INSTANCE_TO_EXPLORER_INSTANCES().get(view);
                    list.remove(explorer);
                    if (!list.isEmpty()) continue;
                    ((View)view).removeViewListener(ExplorerManagerImpl.ra$VIEW_LISTENER());
                    ExplorerManagerImpl.ra$VIEW_INSTANCE_TO_EXPLORER_INSTANCES().remove(view);
                }
                list = (List)ExplorerManagerImpl.ra$DOC_INSTANCE_TO_EXPLORER_INSTANCES().get(node);
                list.remove(explorer);
                if (!list.isEmpty()) continue;
                ExplorerManagerImpl.ra$DOC_INSTANCE_TO_EXPLORER_INSTANCES().remove(node);
                ((Node)node).detach(ExplorerManagerImpl.ra$DOC_LISTENER());
            }
            ExplorerManagerImpl.ra$HOST_INSTANCE_TO_EXPLORER_INSTANCES().remove(host);
            host.removeViewListener((ViewListener)this);
        }

        private HostLsnr() {
        }

        HostLsnr(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ViewLsnr
    implements ViewListener {
        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
            View view = e.getView();
            List list = (List)ExplorerManagerImpl.ra$VIEW_INSTANCE_TO_EXPLORER_INSTANCES().get(view);
            if (list != null) {
                for (Explorer explorer : list) {
                    Object host = ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_HOST_INSTANCE().get(explorer);
                    Object node = ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_DOC_INSTANCE().get(explorer);
                    list = (List)ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_VIEW_INSTANCES().get(explorer);
                    list.remove(view);
                    if (!list.isEmpty()) continue;
                    explorer.stateChanged(2);
                    ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_DOC_INSTANCE().remove(explorer);
                    ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_HOST_INSTANCE().remove(explorer);
                    ExplorerManagerImpl.ra$EXPLORER_INSTANCE_TO_VIEW_INSTANCES().remove(explorer);
                    list = (List)ExplorerManagerImpl.ra$HOST_INSTANCE_TO_EXPLORER_INSTANCES().get(host);
                    list.remove(explorer);
                    if (list.isEmpty()) {
                        ((View)host).removeViewListener(ExplorerManagerImpl.ra$HOST_LISTENER());
                        ExplorerManagerImpl.ra$HOST_INSTANCE_TO_EXPLORER_INSTANCES().remove(host);
                    }
                    list = (List)ExplorerManagerImpl.ra$DOC_INSTANCE_TO_EXPLORER_INSTANCES().get(node);
                    list.remove(explorer);
                    if (!list.isEmpty()) continue;
                    ExplorerManagerImpl.ra$DOC_INSTANCE_TO_EXPLORER_INSTANCES().remove(node);
                    ((Node)node).detach(ExplorerManagerImpl.ra$DOC_LISTENER());
                }
                ExplorerManagerImpl.ra$VIEW_INSTANCE_TO_EXPLORER_INSTANCES().remove(view);
            }
            view.removeViewListener((ViewListener)this);
        }

        private ViewLsnr() {
        }

        ViewLsnr(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

