/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.util.TimedCache;

class ExplorerMutableTreeNode
extends DefaultMutableTreeNode {
    private static TimedCache childLists = new TimedCache(1);
    protected Collection _children;

    public ExplorerMutableTreeNode() {
    }

    public ExplorerMutableTreeNode(Object userObject) {
        super(userObject);
    }

    public ExplorerMutableTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public Enumeration children() {
        if (this._children == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return Collections.enumeration(new ArrayList(this._children));
    }

    public TreeNode getChildAt(int index) {
        if (this._children == null || index < 0 || index > this._children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._children instanceof List) {
            return (TreeNode)((List)this._children).get(index);
        }
        if (this._children.size() > 5) {
            ArrayList childrenList = (ArrayList)childLists.get((Object)this);
            if (childrenList == null) {
                childrenList = new ArrayList(this._children);
                childLists.put((Object)this, childrenList);
            }
            return (TreeNode)childrenList.get(index);
        }
        for (TreeNode node : this._children) {
            if (index-- != 0) continue;
            return node;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public int getIndex(TreeNode node) {
        if (this._children == null) {
            return -1;
        }
        if (this._children instanceof List) {
            return ((List)this._children).indexOf(node);
        }
        Iterator iterator = this._children.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            if (node == iterator.next()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void insert(MutableTreeNode node, int index) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (node == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(node)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode oldParent = (MutableTreeNode)node.getParent();
        if (oldParent != null) {
            oldParent.remove(node);
        }
        node.setParent(this);
        if (this._children == null) {
            this._children = this.createChildren();
        }
        if (this._children instanceof List) {
            ((List)this._children).add(index, node);
        } else {
            this._children.add(node);
            childLists.remove((Object)this);
        }
    }

    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this._children.remove(child);
        child.setParent(null);
        childLists.remove((Object)this);
    }

    public void remove(MutableTreeNode node) {
        if (this._children == null || !this.isNodeChild(node)) {
            throw new IllegalArgumentException();
        }
        this._children.remove(node);
        childLists.remove((Object)this);
    }

    public void removeAllChildren() {
        if (this._children != null) {
            this._children.clear();
        }
        childLists.remove((Object)this);
    }

    protected Collection createChildren() {
        return new ArrayList();
    }
}

