/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.controller.ContextMenu;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ChildFilterFactory;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.ExplorerMutableTreeNode;
import oracle.ideimpl.explorer.NodeUpdateListener;

public class ExplorerNode
extends ExplorerMutableTreeNode
implements TNode,
Observer {
    private CopyOnWriteArrayList<NodeUpdateListener> _nodeUpdateListeners;
    private ChildFilter _filter;
    private int _bits;
    private TreeExplorer _owner;
    private Comparator comparator;
    private boolean _leaf;
    private static final Element LABEL_ELEMENT = new 1();

    private void $init$() {
        this._nodeUpdateListeners = new CopyOnWriteArrayList();
    }

    public ExplorerNode(Element data) {
        super(data);
        this.$init$();
        this.addLoadingElement();
    }

    public Element getData() {
        Element elem = (Element)this.getUserObject();
        return ContextMenu.unwrapDecoratedElement((Element)elem);
    }

    public boolean isLeaf() {
        if (this._leaf) {
            return true;
        }
        Element data = this.getData();
        return data == null || !data.mayHaveChildren();
    }

    public void update(Object subject, UpdateMessage change) {
        this.triggerNodeUpdateListener(change);
    }

    final void addNodeUpdateListener(NodeUpdateListener l) {
        if (l != null && !this._nodeUpdateListeners.contains(l)) {
            Element data = this.getData();
            if (data instanceof Subject) {
                ((Subject)data).attach((Observer)this);
            }
            this._nodeUpdateListeners.add(l);
        }
    }

    final void removeNodeUpdateListener(NodeUpdateListener l) {
        if (l != null) {
            Element data = this.getData();
            if (data instanceof Subject) {
                ((Subject)data).detach((Observer)this);
            }
            this._nodeUpdateListeners.remove(l);
        }
    }

    public ChildFilter getChildFilter() {
        if (this.isLeaf() || this.isSet(TNodeConstants.IS_UNFILTERED)) {
            return null;
        }
        if (this._filter != null) {
            return this._filter;
        }
        TreeExplorer exp = this.getOwner();
        if (exp != null) {
            this._filter = exp.findCacheFilter((TNode)this);
        }
        if (this._filter == null) {
            ChildFilterFactory childFilterFactory = this.findFilterFactory(exp);
            if (childFilterFactory != null) {
                try {
                    ChildFilter childFilter = childFilterFactory.newChildFilter();
                    if (childFilter != null) {
                        this.setChildFilter(childFilter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.initURLFilter(this._filter);
            this.updateComparator();
        }
        if (this._filter != null) {
            this._filter.setOwner((TNode)this);
            if (this.isSet(TNodeConstants.IS_OPENED)) {
                this._filter.refresh(null);
            }
        } else {
            this.setBit(TNodeConstants.IS_UNFILTERED);
        }
        return this._filter;
    }

    public void setChildFilter(ChildFilter filter) {
        this.setChildFilter(filter, false);
    }

    public void setChildFilter(ChildFilter filter, boolean force) {
        boolean changedFilter = false;
        if (this._filter != filter) {
            if (this._filter != null) {
                this._filter.setOwner(null);
            }
            this._filter = filter;
            changedFilter = true;
        }
        if (this._filter != null && (changedFilter || force)) {
            if (this._filter.getOwner() == null || this._filter.getOwner() != this) {
                this._filter.setOwner((TNode)this);
            }
            this.getOwner().cacheFilter((TNode)this, this._filter);
            this.initURLFilter(this._filter);
            this.updateComparator();
        }
    }

    public ChildFilter findChildFilter() {
        ChildFilter cfilter = this.getChildFilter();
        if (cfilter == null) {
            TNode parent = (TNode)this.getParent();
            while (parent != null) {
                cfilter = parent.getChildFilter();
                if (cfilter != null) break;
                parent = (TNode)parent.getParent();
            }
        }
        return cfilter;
    }

    public Iterator getChildNodes() {
        Element data = this.getData();
        return data != null ? data.getChildren() : null;
    }

    public Enumeration getChildTNodes() {
        if (this.isLeaf() || this.isSet(TNodeConstants.IS_OPENED)) {
            return this.children();
        }
        TreeExplorer treeExplorer = this.getOwner();
        if (treeExplorer != null) {
            treeExplorer.addChildren((TNode)this);
        }
        return this.children();
    }

    public int getBits() {
        return this._bits;
    }

    public void setBits(int bits) {
        int oldBits = this._bits;
        this._bits = bits;
        this.updateBits(oldBits);
    }

    public void setBit(int bit) {
        int oldBits = this._bits;
        this._bits |= bit;
        this.updateBits(oldBits);
    }

    public void unsetBit(int bit) {
        int oldBits = this._bits;
        this._bits &= ~bit;
        this.updateBits(oldBits);
    }

    public boolean isSet(int bit) {
        return (this._bits & bit) == bit;
    }

    public void setOwner(TreeExplorer owner) {
        this._owner = owner;
        this.updateComparator();
    }

    public TreeExplorer getOwner() {
        if (this._owner == null && this.getParent() != null) {
            this.setOwner(((TNode)this.getParent()).getOwner());
        }
        return this._owner;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        if (!this.isLeaf() && !ModelUtil.areEqual((Object)comparator, (Object)this.comparator)) {
            this.comparator = comparator;
            this.resetChildren();
        }
    }

    ChildFilter getFilter() {
        return this._filter;
    }

    private ChildFilterFactory findFilterFactory(TreeExplorer explorer) {
        NavigatorWindow navWin;
        NavigatorManager navMan;
        View owner;
        Element data = this.getData();
        if (data != null && explorer != null && (owner = explorer.owner()) instanceof NavigatorWindow && (navMan = (navWin = (NavigatorWindow)owner).getManager()) != null) {
            return navMan.getChildFilterFactoryForType(data.getClass());
        }
        return null;
    }

    public TNode getAncestorTNode(Class clazz, boolean checkBaseClass) {
        Element elem = this.getData();
        if (elem == null) {
            return null;
        }
        if (checkBaseClass ? clazz.isAssignableFrom(elem.getClass()) : elem.getClass() == clazz) {
            return this;
        }
        if (this.getParent() == null) {
            return null;
        }
        return ((TNode)this.getParent()).getAncestorTNode(clazz, checkBaseClass);
    }

    public Element getAncestor(Class clazz, boolean checkBaseClass) {
        TNode rtn = this.getAncestorTNode(clazz, checkBaseClass);
        return rtn == null ? null : rtn.getData();
    }

    public Element getAncestor(Class clazz) {
        return this.getAncestor(clazz, false);
    }

    protected Collection createChildren() {
        if (this.comparator == null) {
            return super.createChildren();
        }
        return new TreeSet(this.comparator);
    }

    void makeLeaf() {
        this._leaf = true;
    }

    private void triggerNodeUpdateListener(UpdateMessage change) {
        for (NodeUpdateListener listener : this._nodeUpdateListeners) {
            listener.update(this, change);
        }
    }

    private void updateBits(int oldBits) {
        if (!this.isSet(TNodeConstants.IS_OPENED) && (oldBits & TNodeConstants.IS_OPENED) != 0) {
            this.addLoadingElement();
        }
    }

    private void resetChildren() {
        if (this._children != null) {
            if (this.isSet(TNodeConstants.IS_OPENED)) {
                TreeExplorer explorer = this.getOwner();
                if (explorer != null) {
                    this.removeNodeUpdateListeners(this._children, (NodeUpdateListener)explorer);
                    this._children = null;
                    this.unsetBit(TNodeConstants.IS_OPENED);
                    explorer.addChildren((TNode)this);
                    explorer.getTreeModel().nodeStructureChanged(this);
                }
            } else {
                Collection children = this.createChildren();
                children.addAll(this._children);
                this._children = children;
            }
        }
    }

    private void removeNodeUpdateListeners(Collection children, NodeUpdateListener listener) {
        if (children == null) {
            return;
        }
        for (ExplorerNode node : children) {
            node.removeNodeUpdateListener(listener);
            if (!node.isSet(TNodeConstants.IS_OPENED)) continue;
            this.removeNodeUpdateListeners(node._children, listener);
        }
    }

    private void initURLFilter(ChildFilter childFilter) {
        View owner;
        Element data = this.getData();
        if (data != null && (owner = this.getOwner().owner()) != null) {
            URLFilter urlFilter;
            NavigatorWindow navWin;
            NavigatorManager navMan;
            Class<?> dataType = data.getClass();
            if (owner instanceof NavigatorWindow && (navMan = (navWin = (NavigatorWindow)owner).getManager()) != null && (urlFilter = navMan.getURLFilter(dataType)) != null) {
                childFilter.setURLFilter(urlFilter);
            }
        }
    }

    private void updateComparator() {
        if (this._filter != null) {
            this.setComparator(this._filter.getComparator());
        } else if (this._owner != null) {
            this.setComparator(this._owner.getComparator());
        } else {
            this.setComparator(null);
        }
    }

    private void addLoadingElement() {
        if (!this.isLeaf()) {
            this.removeAllChildren();
            this.add(new ExplorerNode(LABEL_ELEMENT));
        }
    }

    static final class 1
    extends DefaultElement {
        private String _label;
        private Icon _icon;

        private void $init$() {
            this._label = ExplorerArb.getString((int)8);
            this._icon = null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = ExplorerArb.getIcon((int)6);
            }
            return this._icon;
        }

        public 1() {
            this.$init$();
        }
    }
}

