/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.AbstractLayoutListener;
import oracle.ide.layout.Layout;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.Pinnable;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideri.util.Product;

public class ExplorerWindowImpl
extends ExplorerWindow
implements ListSelectionListener,
DynamicStatusProvider {
    private static final String TARGET_PROP = ".pinTarget";
    private static final String EXPLORER_PROP = ".explorerType";
    private static ExplorerManager MANAGER = ExplorerManager.getExplorerManager();
    private JPanel gui;
    private CustomTab tabs;
    private FocusableLabel defaultLabel;
    private JScrollPane defaultStructure;
    private String defaultText;
    private Explorer explorer;
    private URL pinTarget;
    private Class explorerType;
    private TargetMonitor targetMonitor;
    private Context context;
    private PropertyAccess properties;
    private ArrayList changeListeners;
    private Controller controller;
    private boolean shownCalled;
    private boolean loading;
    private boolean _alreadyUpdating;

    private void $init$() {
        this.changeListeners = new ArrayList();
        this.controller = new ChainedController(null);
        this.shownCalled = false;
        this.loading = false;
        this._alreadyUpdating = false;
    }

    protected ExplorerWindowImpl(String viewId) {
        super(viewId);
        this.$init$();
    }

    public int getType() {
        return super.getType() | 1 | 0x20;
    }

    CustomTab getTabs() {
        return this.tabs;
    }

    public void setToolbarVisible(boolean visible) {
        super.setToolbarVisible(visible);
        if (this.gui != null) {
            if (this.isToolbarVisible) {
                if (this.toolbar == null) {
                    this.tabs = new CustomTab(3);
                    this.tabs.setShowIcons(false);
                    this.tabs.setGapBeforeTabs(-1);
                    this.tabs.setOffsetSelected(0);
                    this.tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
                    this.tabs.addSelectionListener((ListSelectionListener)this);
                    this.toolbar = new Toolbar();
                    this.updateToolbar();
                    this.gui.add((Component)this.toolbar, "North");
                    this.gui.add((Component)this.tabs, "South");
                    this.gui.revalidate();
                }
            } else if (this.toolbar != null) {
                this.gui.remove((Component)this.toolbar);
                this.gui.remove((Component)this.tabs);
                this.toolbar.dispose();
                this.toolbar.removeAll();
                this.toolbar = null;
                this.tabs.removeSelectionListener((ListSelectionListener)this);
                this.tabs = null;
                this.gui.revalidate();
            }
        }
    }

    public synchronized Explorer getExplorer() {
        return this.explorer;
    }

    protected String getDefaultText() {
        return this.defaultText;
    }

    protected void setDefaultText(String text) {
        this.defaultText = text;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setContext(Context context) {
        if (this.gui == null) {
            this.context = context;
        } else {
            super.setContext(context);
        }
    }

    public Context getContext(EventObject e) {
        Context context = null;
        if (this.explorer != null && (context = this.explorer.getContext(e)) != null) {
            context = new Context(context);
            context.setView((View)this);
        }
        if (context == null) {
            context = Context.newIdeContext((View)this, (EventObject)e);
            context.setEvent(e);
        }
        return context;
    }

    public HelpInfo getHelpInfo() {
        HelpInfo info;
        HelpInfo helpInfo = info = this.explorer != null ? this.explorer.getHelpInfo() : null;
        if (info == null || info.getHelpTopicID() == null || info == HelpInfo.getDefaultHelpInfo()) {
            info = new HelpInfo(this.getDefaultHelpTag());
            info.setContext(this.getContext());
        }
        return info;
    }

    protected String getDefaultHelpTag() {
        return "f1_idestructurepane_html";
    }

    public ContextMenu getContextMenu() {
        return MANAGER.getContextMenu();
    }

    protected Element[] getSelectionFromUI() {
        if (this.explorer != null) {
            if (!this._alreadyUpdating) {
                this._alreadyUpdating = true;
                try {
                    this.explorer.updateSelection();
                }
                finally {
                    this._alreadyUpdating = false;
                }
            }
            return this.explorer.getSelection();
        }
        return super.getSelectionFromUI();
    }

    public String getMenuTitle() {
        return IdeArb.getString((int)454);
    }

    public String getTabName() {
        if (this.getPinState() != 0) {
            String name = null;
            if (this._node != null) {
                name = this._node.getShortLabel();
            } else if (this.targetMonitor != null && this.targetMonitor.target != null) {
                name = this.targetMonitor.target.getShortLabel();
            }
            return name != null ? name : ExplorerArb.getString((int)4);
        }
        return ExplorerArb.getString((int)4);
    }

    public Icon getTabIcon() {
        return IdeArb.getIcon((int)90);
    }

    public String getTitleName() {
        String name;
        Explorer exp = this.getExplorer();
        String string = name = exp != null ? exp.getTitle() : null;
        if (name == null) {
            name = this._node != null ? this._node.getShortLabel() : null;
        }
        return name != null ? name + " - " + ExplorerArb.getString((int)4) : ExplorerArb.getString((int)4);
    }

    public int getDefaultVisibility(Layout layout) {
        String defaultVisibility = Product.isRaptor() ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
        String showStructure = layout.getProperty("Layout.ShowStructure", defaultVisibility);
        boolean visible = Boolean.valueOf(showStructure);
        return visible ? 1 : 0;
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = new JPanel();
            this.gui.setOpaque(false);
            this.defaultLabel = new FocusableLabel();
            this.defaultStructure = new JScrollPane();
            this.defaultStructure.setOpaque(false);
            this.defaultStructure.getViewport().setOpaque(false);
            this.defaultStructure.setBorder(BorderFactory.createEmptyBorder());
            if (this.defaultText == null) {
                this.defaultText = ExplorerArb.getString((int)0);
            }
            this.defaultLabel.setText(this.defaultText);
            this.defaultLabel.setOpaque(false);
            this.defaultStructure.setViewportView((Component)this.defaultLabel);
            this.gui.setLayout(new BorderLayout());
            this.gui.add((Component)this.defaultStructure, "Center");
            this.setToolbarVisible(this.isToolbarVisible);
            if (this.context != null) {
                this.setContext(this.context);
                this.context = null;
            }
            if (this.properties != null) {
                this.loadLayout(this.properties);
                this.properties = null;
            }
            if (this.explorer != null) {
                this._setExplorer(this.explorer);
                this.updateTitle(this.getTitleName());
                this.fireStateChanged();
            }
        }
        return this.gui;
    }

    public void activate() {
        if (this.explorer != null) {
            AccessibleContext ac;
            this.explorer.activate();
            JComponent deepestComp = GraphicsUtils.getFocusableComponentOrChild((Component)this.explorer.getGUI(), (boolean)true);
            if (deepestComp != null && deepestComp instanceof Accessible && (ac = ((Accessible)((Object)deepestComp)).getAccessibleContext()) != null && ac.getAccessibleName() == null) {
                ac.setAccessibleName(ExplorerArb.getString((int)4));
            }
        } else {
            super.activate();
        }
    }

    public void deactivate() {
        if (this.explorer != null) {
            this.explorer.deactivate();
        } else {
            super.deactivate();
        }
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 2: {
                if (this.explorer == null) break;
                this.explorer.removeViewSelectionListener((ViewSelectionListener)this);
                if (!this.shownCalled) break;
                this.shownCalled = false;
                this.explorer.stateChanged(1);
                break;
            }
            case 1: {
                if (this.explorer == null) break;
                this.explorer.addViewSelectionListener((ViewSelectionListener)this);
                if (this.shownCalled) break;
                this.shownCalled = true;
                this.explorer.stateChanged(0);
                break;
            }
            case 3: {
                this.setToolbarVisible(false);
                break;
            }
        }
        super.stateChange(newState);
    }

    public synchronized void viewSelectionChanged(ViewSelectionEvent e) {
        View view = e.getView();
        if (view == this.explorer) {
            this.updateSelection();
        } else {
            super.viewSelectionChanged(e);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        DefaultCustomTabPage page = (DefaultCustomTabPage)this.tabs.getPage(e.getFirstIndex());
        Class type = (Class)page.getUserObject();
        this.toggleExplorer(type);
    }

    public void toggleExplorer(Class type) {
        if (type == null) {
            return;
        }
        if (this.explorer == null || this.explorer.getClass() != type) {
            boolean hadFocus = GraphicsUtils.isAncestorOfFocusedComponent((Component)this.getGUI());
            Context ctx = new Context(this.getContext());
            ExplorerContext.setExplorerType((Context)ctx, (Class)type);
            if (hadFocus) {
                this.getGUI().requestFocus();
                if (this.explorer != null) {
                    this.explorer.deactivate();
                }
            }
            this.viewSelectionChanged(ctx);
            if (this.explorer != null) {
                GraphicsUtils.focusComponentOrChild((Component)this.explorer.getGUI(), (boolean)true);
                if (hadFocus) {
                    this.explorer.activate();
                }
            }
        }
    }

    public void saveLayout(PropertyAccess layout) {
        Context ctx;
        if (this.gui == null) {
            return;
        }
        String id = this.getId();
        Context context = ctx = this.explorer != null ? this.explorer.getContext() : null;
        if (this.getPinState() == 2) {
            this.persistPinTarget(ctx != null ? ctx.getNode() : null, false);
            if (this.pinTarget != null) {
                layout.setProperty(id + TARGET_PROP, URL2String.toString((URL)this.pinTarget));
                if (this.explorerType != null) {
                    layout.setProperty(id + EXPLORER_PROP, this.explorerType.getName());
                }
            } else {
                layout.removeProperty(id + TARGET_PROP);
                layout.removeProperty(id + EXPLORER_PROP);
            }
        } else {
            layout.removeProperty(id + TARGET_PROP);
            layout.removeProperty(id + EXPLORER_PROP);
        }
    }

    public void loadLayout(PropertyAccess properties) {
        if (this.gui == null) {
            this.properties = properties;
            return;
        }
        this.loading = true;
        this.pinTarget = null;
        this.explorerType = null;
        this.setPinState(0);
        String id = this.getId();
        Node node = AbstractLayoutListener.getNode((String)(id + TARGET_PROP), (PropertyAccess)properties, (boolean)true);
        if (node != null) {
            this.pinTarget = node.getURL();
            String clsName = properties.getProperty(id + EXPLORER_PROP, null);
            try {
                this.explorerType = Class.forName(clsName);
            }
            catch (Exception e) {
                this.explorerType = null;
            }
            this.setPinState(2);
        }
        this.loading = false;
        Explorer exp = this.getExplorer();
        if (exp instanceof Pinnable) {
            ((Pinnable)exp).setPinState(this.getPinState());
        }
    }

    public JComponent[] getCustomCells() {
        Explorer view = this.getExplorer();
        if (view instanceof StatusProvider) {
            return ((StatusProvider)view).getCustomCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent customCell) {
        Explorer view = this.getExplorer();
        if (view instanceof StatusProvider) {
            return ((StatusProvider)view).isExpandable(customCell);
        }
        return false;
    }

    public void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners.contains(l)) {
            this.changeListeners.remove(l);
        }
    }

    public synchronized void setPinState(int newState) {
        Explorer exp;
        super.setPinState(newState);
        if (!this.loading && (exp = this.getExplorer()) instanceof Pinnable) {
            ((Pinnable)exp).setPinState(this.getPinState());
        }
    }

    private void fireStateChanged() {
        ArrayList list = (ArrayList)this.changeListeners.clone();
        Iterator i = list.iterator();
        if (i != null) {
            ChangeEvent e = new ChangeEvent(this);
            while (i.hasNext()) {
                ((ChangeListener)i.next()).stateChanged(e);
            }
        }
    }

    protected boolean isViewSupported(View view) {
        return MANAGER.supportsStructure(view);
    }

    protected void viewSelectionChanged(Context context) {
        super.viewSelectionChanged(context);
        this.setExplorer(MANAGER.getExplorerForHost((View)this, context));
        this.updateSelection();
    }

    protected void clear() {
        super.clear();
        this.setExplorer(null);
    }

    private void _setExplorer(Explorer explorer) {
        IconOverlayConsumer consumer;
        IconOverlayCache overlayCache;
        Component child;
        this.gui.removeAll();
        if (this.explorer != null) {
            IconOverlayConsumer consumer2;
            IconOverlayCache overlayCache2;
            this.explorer.removeViewSelectionListener((ViewSelectionListener)this);
            if (this.shownCalled) {
                this.shownCalled = false;
                this.explorer.stateChanged(1);
            }
            if (this.explorer instanceof IconOverlayConsumer && (overlayCache2 = (consumer2 = (IconOverlayConsumer)this.explorer).getOverlayCache()) != null) {
                overlayCache2.deregisterOverlayConsumer(consumer2);
            }
        }
        this.explorer = explorer;
        if (!this.loading && explorer instanceof Pinnable) {
            ((Pinnable)explorer).setPinState(this.getPinState());
        }
        Component component = child = explorer != null ? explorer.getGUI() : null;
        if (child == null) {
            child = this.defaultStructure;
            this.defaultLabel.setText(this.getDefaultText());
        }
        this.gui.add(child, "Center");
        if (this.toolbar != null) {
            this.updateToolbar();
            this.gui.add((Component)this.toolbar, "North");
            this.gui.add((Component)this.tabs, "South");
        }
        if (explorer != null) {
            explorer.addViewSelectionListener((ViewSelectionListener)this);
            if (!this.shownCalled) {
                this.shownCalled = true;
                explorer.stateChanged(0);
            }
        }
        if (explorer instanceof IconOverlayConsumer && (overlayCache = (consumer = (IconOverlayConsumer)explorer).getOverlayCache()) != null) {
            overlayCache.registerOverlayConsumer(consumer);
        }
        this.gui.revalidate();
        this.gui.repaint();
    }

    protected synchronized void setExplorer(Explorer explorer) {
        if (this.gui != null) {
            if (this.explorer != explorer) {
                this._setExplorer(explorer);
            } else if (this.explorer == null) {
                this.defaultLabel.setText(this.getDefaultText());
                this.gui.repaint();
            }
            this.updateTitle(this.getTitleName());
            this.fireStateChanged();
        } else {
            this.explorer = explorer;
        }
    }

    protected void persistPinTarget() {
        this.persistPinTarget(this._node, true);
    }

    private void persistPinTarget(Node node, boolean attachMonitor) {
        if (this.getPinState() == 0) {
            this.pinTarget = null;
            this.explorerType = null;
            return;
        }
        this.pinTarget = node != null ? node.getURL() : null;
        Class clazz = this.explorerType = this.explorer != null ? this.explorer.getClass() : null;
        if (attachMonitor && this.pinTarget != null) {
            this.getTargetMonitor().monitor(node);
        }
    }

    protected void restorePinTarget() {
        if (this.targetMonitor != null) {
            this.targetMonitor.reset();
        }
        if (this.pinTarget != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)this.pinTarget);
                Context ctx = this.getContext();
                ctx.setNode(node);
                ExplorerContext.setExplorerType((Context)ctx, (Class)this.explorerType);
                this.viewSelectionChanged(ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pinTarget = null;
            this.explorerType = null;
        }
    }

    protected void objectClosed(Subject subject, UpdateMessage msg) {
        String oldText = this.getDefaultText();
        this.setDefaultText(ExplorerArb.getString((int)1));
        super.objectClosed(subject, msg);
        this.setDefaultText(oldText);
    }

    protected void objectRenamed(Subject subject, UpdateMessage msg) {
        Node target = null;
        List list = msg.getAddObjects();
        if (!list.isEmpty()) {
            target = (Node)list.get(0);
        } else {
            target = RenameMessage.getRenamedNode((UpdateMessage)msg);
            if (target == null) {
                target = this._node;
            }
        }
        this.persistPinTarget(target, false);
        this.clear();
        this.restorePinTarget();
        this.setPinState(this.getPinState());
    }

    private TargetMonitor getTargetMonitor() {
        if (this.targetMonitor == null) {
            this.targetMonitor = new TargetMonitor(null);
        }
        return this.targetMonitor;
    }

    private void updateToolbar() {
        Iterator i;
        if (this.toolbar == null) {
            return;
        }
        this.tabs.removeSelectionListener((ListSelectionListener)this);
        this.tabs.removeAllPages();
        this.toolbar.dispose();
        this.toolbar.removeAll();
        List types = MANAGER.getExplorerTypes((Element)this._node);
        Iterator iterator = i = types != null ? types.iterator() : null;
        if (i != null && i.hasNext()) {
            DefaultListModel<DefaultCustomTabPage> model = new DefaultListModel<DefaultCustomTabPage>();
            Explorer exp = this.getExplorer();
            Class current = exp != null ? exp.getClass() : null;
            DefaultCustomTabPage active = null;
            Object data = this._node.getData();
            Class<?> dataType = data != null ? data.getClass() : null;
            while (i.hasNext()) {
                Class type = (Class)i.next();
                String caption = MANAGER.getExplorerCaption(type, dataType);
                Icon icon = MANAGER.getExplorerIcon(type, dataType);
                DefaultCustomTabPage page = new DefaultCustomTabPage(icon, null, (Object)type);
                page.setLabel(caption);
                model.addElement(page);
                if (type != current) continue;
                active = page;
            }
            this.tabs.setModel(model);
            this.toolbar.setVisible(true);
            this.tabs.setVisible(model.getSize() > 1);
            this.tabs.setPreferredSize(null);
            this.tabs.setSelectedPage(this.tabs.searchPage(active));
            this.tabs.addSelectionListener((ListSelectionListener)this);
        } else {
            this.toolbar.setVisible(false);
            this.tabs.setVisible(false);
        }
        IdeAction action = IdeAction.find((int)68);
        if (action != null) {
            action = action.newLocalAction((View)this);
            action.putValue("State", (Object)(this.getPinState() == 2 ? Boolean.TRUE : Boolean.FALSE));
            this.toolbar.addToggleButton((ToggleAction)action);
        }
        if ((action = IdeAction.find((int)67)) != null) {
            action = action.newLocalAction((View)this);
            this.toolbar.add((ToggleAction)action);
        }
        ExplorerWindowImpl.updateToolbarActions((Toolbar)this.getToolbar());
    }

    static void wa$pinTarget(ExplorerWindowImpl explorerWindowImpl, URL uRL) {
        explorerWindowImpl.pinTarget = uRL;
    }

    private final class TargetMonitor
    implements Observer {
        Node target;

        public void reset() {
            if (this.target != null) {
                this.target.detach((Observer)this);
                this.target = null;
            }
        }

        public void monitor(Node target) {
            this.reset();
            this.target = target;
            if (this.target != null) {
                this.target.attach((Observer)this);
            }
        }

        public void update(Object observed, UpdateMessage msg) {
            if (msg.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
                List list = msg.getAddObjects();
                Node node = null;
                if (!list.isEmpty()) {
                    node = (Node)list.get(0);
                } else {
                    node = RenameMessage.getRenamedNode((UpdateMessage)msg);
                    if (node == null) {
                        node = (Node)observed;
                    }
                }
                ExplorerWindowImpl.wa$pinTarget(ExplorerWindowImpl.this, node != null ? node.getURL() : null);
                if (node != this.target) {
                    this.monitor(node);
                }
            }
        }

        private TargetMonitor() {
        }

        TargetMonitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ChainedController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            Controller controller;
            Explorer view = ExplorerWindowImpl.this.getExplorer();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller != null && controller.handleEvent(action, context)) {
                return true;
            }
            if (controller != ExplorerManager.getExplorerManager()) {
                return ExplorerManager.getExplorerManager().handleEvent(action, context);
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            Controller controller;
            Explorer view = ExplorerWindowImpl.this.getExplorer();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller != null) {
                try {
                    if (controller.update(action, context)) {
                        action.putValue("controller-handling-update", (Object)controller.getClass().getName());
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (controller != ExplorerManager.getExplorerManager()) {
                return ExplorerManager.getExplorerManager().update(action, context);
            }
            return false;
        }

        private ChainedController() {
        }

        ChainedController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

