/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer.dnd;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.DragDropListener;
import oracle.ideimpl.explorer.dnd.MultiTransferable;

public class JTreeDragHandler
implements DragGestureListener,
DragSourceListener {
    private final JTree tree;
    private final DragSource dragSource;
    private final DragDropListener dragDropListener;
    private DefaultMutableTreeNode targetDropNode;

    public JTreeDragHandler(JTree jtree, int action, DragDropListener listener) {
        this.tree = jtree;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.tree, action, this);
        this.dragDropListener = listener;
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dragDropListener.dropOccurred(dsde, this.targetDropNode);
    }

    public final void dragEnter(DragSourceDragEvent dsde) {
        this.updateCursor(dsde);
    }

    public final void dragOver(DragSourceDragEvent dsde) {
        TreePath p = this.tree.getSelectionPath();
        this.targetDropNode = p != null ? (DefaultMutableTreeNode)p.getLastPathComponent() : null;
        this.updateCursor(dsde);
    }

    public final void dropActionChanged(DragSourceDragEvent dsde) {
        this.updateCursor(dsde);
    }

    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public final void dragGestureRecognized(DragGestureEvent dge) {
        TreePath[] selection = this.tree.getSelectionPaths();
        if (selection != null) {
            ArrayList<Transferable> allTransferables = new ArrayList<Transferable>();
            Transferable[] customTransferables = this.dragDropListener.dragStarted(dge);
            List<Transferable> customTransferablesList = customTransferables.length > 0 ? Arrays.asList(customTransferables) : Collections.EMPTY_LIST;
            allTransferables.addAll(customTransferablesList);
            ArrayList transferablesForSelection = this.getTransferablesForSelection(customTransferablesList);
            if (transferablesForSelection.size() == 1) {
                allTransferables.addAll(transferablesForSelection);
            } else {
                TransferablesList tList = TransferablesList.getInstance();
                tList.initialize(transferablesForSelection);
                allTransferables.add((Transferable)tList);
            }
            MultiTransferable mTransferable = new MultiTransferable(allTransferables);
            this.dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, mTransferable, this);
        }
    }

    private void updateCursor(DragSourceDragEvent dragSourceDragEvent) {
        int action = dragSourceDragEvent.getDropAction();
        if (action == 1) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    private ArrayList getTransferablesForSelection(List existingTransferables) {
        ArrayList<MultiTransferable> list = new ArrayList<MultiTransferable>();
        TreePath[] selectionPath = this.tree.getSelectionPaths();
        if (selectionPath != null) {
            DragDropManager dndMgr = DragDropManager.getInstance();
            int i = 0;
            while (i < selectionPath.length) {
                ArrayList<Transferable> transferables = new ArrayList<Transferable>();
                TreePath p = selectionPath[i];
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)p.getLastPathComponent();
                Object userData = node.getUserObject();
                Iterator helperIterator = dndMgr.getDragHelpers(userData.getClass());
                while (helperIterator.hasNext()) {
                    DragHelper helper = (DragHelper)helperIterator.next();
                    Transferable t = helper.getTransferable(userData);
                    if (t == null) continue;
                    transferables.add(t);
                }
                transferables.add((Transferable)new TransferableTreeNode(node));
                transferables.addAll(existingTransferables);
                list.add(new MultiTransferable(transferables));
                ++i;
            }
        }
        return list;
    }
}

