/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferablesList;

public class JTreeDropHandler
implements DropTargetListener {
    private final JTree tree;
    private final DropTarget dropTarget;
    private DropHelper activeDropHelper;
    private DefaultMutableTreeNode targetDropNode;

    public JTreeDropHandler(JTree jtree, int action) {
        this.tree = jtree;
        this.dropTarget = new DropTarget(this.tree, action, this);
    }

    public final void dragEnter(DropTargetDragEvent dtde) {
        this.updateDragFeedback(dtde);
    }

    public final void dragOver(DropTargetDragEvent dtde) {
        this.updateDragFeedback(dtde);
    }

    public final void dropActionChanged(DropTargetDragEvent dtde) {
        this.updateDragFeedback(dtde);
    }

    public final void dragExit(DropTargetEvent dte) {
    }

    public final void drop(DropTargetDropEvent dtde) {
        boolean dropSuccess = false;
        try {
            try {
                int action = dtde.getDropAction();
                Point pt = dtde.getLocation();
                TreePath p = this.tree.getPathForLocation(pt.x, pt.y);
                DefaultMutableTreeNode defaultMutableTreeNode = this.targetDropNode = p != null ? (DefaultMutableTreeNode)p.getLastPathComponent() : null;
                if (this.targetDropNode != null && this.activeDropHelper != null) {
                    Transferable t = dtde.getTransferable();
                    if (t.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                        ArrayList transferables = (ArrayList)t.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR);
                        Transferable[] array = new Transferable[transferables.size()];
                        transferables.toArray(array);
                        if (this.canTransferSelection(this.activeDropHelper, transferables, action) && this.activeDropHelper.transferData((Object)this.targetDropNode, array, action)) {
                            dtde.acceptDrop(action);
                            dropSuccess = true;
                        }
                    } else if (this.activeDropHelper.canTransferData((Object)this.targetDropNode, t.getTransferDataFlavors(), action)) {
                        dtde.acceptDrop(this.tree.getDropTarget().getDefaultActions());
                        if (this.activeDropHelper.transferData((Object)this.targetDropNode, new Transferable[]{t}, action)) {
                            dropSuccess = true;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            dtde.dropComplete(dropSuccess);
            this.cleanUp();
        }
    }

    private boolean canTransferSelection(DropHelper dropHelper, List transferables, int action) {
        for (Transferable t : transferables) {
            if (dropHelper.canTransferData((Object)this.targetDropNode, t.getTransferDataFlavors(), action)) continue;
            return false;
        }
        return true;
    }

    private void updateDragFeedback(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        TreePath dropTargetPath = this.tree.getPathForLocation(pt.x, pt.y);
        DefaultMutableTreeNode defaultMutableTreeNode = this.targetDropNode = dropTargetPath != null ? (DefaultMutableTreeNode)dropTargetPath.getLastPathComponent() : null;
        if (this.targetDropNode != null) {
            Object data = this.targetDropNode.getUserObject();
            Iterator iter = DragDropManager.getInstance().getDropHelpers(data.getClass());
            while (iter.hasNext()) {
                DropHelper helper = (DropHelper)iter.next();
                DataFlavor[] flavors = dtde.getCurrentDataFlavors();
                if (dtde.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                    try {
                        List transferables = (List)TransferablesList.getInstance().getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR);
                        if (this.canTransferSelection(helper, transferables, action)) {
                            this.tree.setSelectionPath(dropTargetPath);
                            this.activeDropHelper = helper;
                            dtde.acceptDrag(action);
                            return;
                        }
                        dtde.rejectDrag();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        dtde.rejectDrag();
                    }
                }
                if (!helper.canTransferData((Object)this.targetDropNode, flavors, action)) continue;
                this.tree.setSelectionPath(dropTargetPath);
                this.activeDropHelper = helper;
                dtde.acceptDrag(action);
                return;
            }
        }
        dtde.rejectDrag();
    }

    private void cleanUp() {
        this.activeDropHelper = null;
        this.targetDropNode = null;
        TransferablesList.getInstance().clear();
    }
}

