/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiTransferable
implements Transferable {
    private List _transferables;

    public MultiTransferable(List transferables) {
        this._transferables = transferables;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        for (Transferable t : this._transferables) {
            if (!t.isDataFlavorSupported(flavor)) continue;
            return t.getTransferData(flavor);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> flavorList = new ArrayList<DataFlavor>();
        for (Transferable t : this._transferables) {
            DataFlavor[] flavors = t.getTransferDataFlavors();
            if (flavors.length <= 0) continue;
            int i = 0;
            while (i < flavors.length) {
                if (!flavorList.contains(flavors[i])) {
                    flavorList.add(flavors[i]);
                }
                ++i;
            }
        }
        return flavorList.toArray(new DataFlavor[flavorList.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (Transferable t : this._transferables) {
            if (!t.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }
}

