/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Connections;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideimpl.navigator.NavigatorArb;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.ideri.util.Product;

public class ConnectionNavigatorManager
extends DefaultNavigatorManager {
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"ConnectionNavigator.TOGGLE_TOOLBAR_CMD_ID");
    private static final String CONNECTION_NAVIGATOR_WINDOW_ID = "ConnectionNavigatorWindow";

    public void initialize() {
        super.initialize();
        IdeAction action = this.getShowAction();
        Menubar menuMgr = Ide.getMenubar();
        JMenuItem connectionNavigatorMenuItem = menuMgr.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        menuMgr.add((Component)connectionNavigatorMenuItem, viewMenu, MenuConstants.SECTION_VIEW_NAVIGATOR);
    }

    protected String getViewCategory() {
        return CONNECTION_NAVIGATOR_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return "oracle/ideimpl/navigator/cn-accelerators.xml";
    }

    protected String getDefaultName() {
        return "Connections";
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)66, (String)AddinManager.getAddinManager().getCommand(66, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)103), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)IdeArb.getInteger((int)130), (ArrayResourceBundle)IdeArb.getInstance(), (int)132, null, (boolean)true);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam param = new DockingParam();
        NavigatorManager navMgr = NavigatorManager.getWorkspaceNavigatorManager();
        if (navMgr != null && navMgr.getNavigatorWindow() != null) {
            param.setTabbedWith((Dockable)navMgr.getNavigatorWindow());
        } else {
            ExplorerManager mgr = ExplorerManager.getExplorerManager();
            Dockable host = null;
            if (mgr != null) {
                ViewId id = mgr.getDefaultViewId();
                host = DockStation.getDockStation().findDockable(id);
            }
            param.setPosition(host, 2, 0);
            NavigatorManager.setWorkspaceNavigatorManager((NavigatorManager)this);
        }
        return param;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)NavigatorArb.getString(2), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)NavigatorArb.getInteger(9), (ArrayResourceBundle)NavigatorArb.getInstance(), (int)6, null, (boolean)true);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideconnectionnavigator_html");
    }

    protected void configureNavigator(NavigatorWindow navigator) {
    }

    protected NavigatorWindow createNavigatorWindow() {
        boolean showRoot = Product.isRaptor() ^ true;
        Connections conn = (Connections)Ide.getSystem().getChild(Connections.class);
        if (conn != null) {
            return this.createNavigatorWindow((Folder)conn, showRoot, 1);
        }
        return null;
    }

    protected NavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return Product.isRaptor() ? new 1(context, viewId.getId()) : super.createNavigatorWindow(context, viewId);
    }

    final class 1
    extends DefaultNavigatorWindow {
        public String getTitleName() {
            return this.getTabName();
        }

        public 1(Context context, String string) {
            super(context, string);
        }
    }
}

