/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import oracle.javatools.ui.themes.Themes;

public final class TaskButton
extends JButton {
    private static final String PART_ID = "taskbutton";
    private final Rectangle _scratch;

    private void $init$() {
        this._scratch = new Rectangle();
    }

    public TaskButton() {
        this.$init$();
        this.setOpaque(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 5));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
    }

    protected void paintComponent(Graphics g) {
        this.updateForeground();
        Themes.paintBackground((Graphics)g, (String)PART_ID, (String)this.themeState(), (Rectangle)this.rectangle(0, 0, this.getWidth(), this.getHeight()));
        super.paintComponent(g);
        g.setColor(this.themeColor("linecolor"));
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private void updateForeground() {
        this.setForeground(this.themeColor("foreground"));
    }

    private Color themeColor(String colorName) {
        return Themes.getActiveTheme().getStateProperties(PART_ID, this.themeState()).getColor(colorName);
    }

    private String themeState() {
        if (this.getModel().isArmed() || this.getModel().isPressed()) {
            return "mousedown";
        }
        if (this.getModel().isRollover() || this.hasFocus()) {
            return "mouseover";
        }
        return "normal";
    }

    private Rectangle rectangle(int x, int y, int width, int height) {
        this._scratch.setBounds(x, y, width, height);
        return this._scratch;
    }
}

