/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.index.file.FileTableManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingUtils;

final class NavigatorController
implements Controller {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean handleEvent(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        CommandProcessor cmdProc = CommandProcessor.getInstance();
        Command command = null;
        int cmdId = action.getCommandId();
        if (cmdId == 67) {
            NavigatorWindow navWin;
            NavigatorManager navMgr;
            View view;
            if (context == null || !((view = context.getView()) instanceof NavigatorWindow) || (navMgr = (navWin = (NavigatorWindow)view).getManager()) == null) return true;
            navMgr.showView(context);
            return true;
        }
        if (cmdId == 20) {
            TNode[] tnodes = ExplorerContext.getTNodes((Context)context);
            ArrayList<Element> nonDeleteFiles = new ArrayList<Element>();
            if (tnodes != null) {
                int i = 0;
                while (i < tnodes.length) {
                    TNode tnode = tnodes[i];
                    Element element = tnode.getData();
                    if (element instanceof Project || element instanceof Workspace) {
                        nonDeleteFiles.add(element);
                    }
                    ++i;
                }
            }
            if (nonDeleteFiles.size() == 0) {
                command = CommandProcessor.createCommand((String)"oracle.ide.cmd.RemoveFromDiskCommand", (Context)context);
            } else {
                if (!MessageDialog.optionalConfirm((String)"oracle.ideri.NavigatorController.deleteRemove", (Component)SwingUtils.getMainWindow(), (String)IdeArb.getString((int)441), (String)IdeArb.getString((int)297), null)) return true;
                command = CommandProcessor.createCommand((String)"oracle.ide.cmd.RemoveFileCommand", (Context)context);
            }
        } else {
            if (cmdId == 51) {
                TNode[] tnodesArr;
                if (context == null || (tnodesArr = ExplorerContext.getTNodes((Context)context)) == null) return true;
                WaitCursor wc = Ide.getWaitCursor();
                wc.show();
                Project project = context.getProject();
                if (project != null) {
                    LinkedList<TNode> tnodes = new LinkedList<TNode>();
                    tnodes.addAll(Arrays.asList(tnodesArr));
                    URLPath dirsToRefresh = new URLPath();
                    ArrayList<Element> nodes = new ArrayList<Element>(tnodesArr.length);
                    while (tnodes.size() > 0) {
                        TNode tnode = (TNode)tnodes.removeFirst();
                        Element data = tnode.getData();
                        nodes.add(data);
                        if (data instanceof Project) {
                            ContentSet allContents = ProjectContent.getInstance((PropertyStorage)((Project)data)).getAllContents();
                            dirsToRefresh.add(allContents.getAllRootDirs());
                            continue;
                        }
                        if (data instanceof RelativeDirectoryContextFolder) {
                            RelativeDirectoryContextFolder dirFolder = (RelativeDirectoryContextFolder)data;
                            dirsToRefresh.add(dirFolder.getRootDirectories());
                            continue;
                        }
                        if (!(data instanceof Locatable)) continue;
                        Locatable loc = (Locatable)data;
                        dirsToRefresh.add(URLFileSystem.getParent((URL)loc.getURL()));
                    }
                    FileTableManager fileTableManager = FileTableManager.getFileTableManager();
                    for (URL dirURL : dirsToRefresh) {
                        VirtualFileSystemHelper.invalidateDirectoryTree((URL)dirURL);
                        if (fileTableManager == null) continue;
                        fileTableManager.invalidateDir(dirURL, true);
                    }
                    UpdateMessage.fireStructureChanged((Subject)project, nodes);
                }
                wc.hide();
                return true;
            }
            if (cmdId == 5) {
                try {
                    CommandProcessor.getInstance().undo(null);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            if (cmdId == 6) {
                try {
                    CommandProcessor.getInstance().redo(null);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        if (command == null) return false;
        try {
            cmdProc.invoke(command);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public final boolean update(IdeAction action, Context context) {
        int cmdId;
        block19: {
            boolean enabled;
            block20: {
                TNode[] tnodes;
                cmdId = action.getCommandId();
                if (cmdId != 20 && cmdId != 47 && cmdId != 21) break block19;
                enabled = false;
                Folder ownerFolder = null;
                if (context == null || ExplorerContext.hasNonSiblingTNodes((Context)context) || (tnodes = ExplorerContext.getTNodes((Context)context)) == null || tnodes.length <= 0) break block20;
                enabled = true;
                Workspaces workspaces = (Workspaces)tnodes[0].getAncestor(Workspaces.class);
                int i = 0;
                while (i < tnodes.length) {
                    block22: {
                        block21: {
                            Folder owner;
                            TNode tnode = tnodes[i];
                            if (tnode == null || tnode.isRoot()) break block21;
                            Element element = tnode.getData();
                            boolean canDelete = element.getAttributes().isSet(ElementAttributes.DELETEABLE);
                            boolean canErase = element.getAttributes().isSet(ElementAttributes.ERASEABLE);
                            boolean canRemove = element.getAttributes().isSet(ElementAttributes.REMOVEABLE);
                            if (!(canDelete || canErase || canRemove)) {
                                enabled = false;
                                break;
                            }
                            if (element instanceof Node || element instanceof RelativeDirectoryContextFolder) {
                                enabled = cmdId == 21 && (canDelete || canRemove) ? true : (cmdId == 47 && (canDelete || canErase) ? true : cmdId == 20 && (canDelete || canErase));
                            } else if (cmdId == 21) {
                                enabled = false;
                            } else if (cmdId == 47) {
                                enabled = false;
                            } else if (canDelete) {
                                enabled = true;
                            }
                            if (!enabled) break;
                            Folder parentFolder = null;
                            TNode parNode = (TNode)tnode.getParent();
                            if (parNode != null) {
                                parentFolder = (Folder)parNode.getAncestor(Folder.class, true);
                            }
                            if (parentFolder == null || element == null) break block21;
                            ownerFolder = parentFolder;
                            if (workspaces != null && (owner = Workspaces.findOwner((Element)element, (Context)context)) != null) {
                                ownerFolder = owner;
                            }
                            if (ownerFolder.canRemove(element)) break block22;
                        }
                        enabled = false;
                        break;
                    }
                    ++i;
                }
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 51) {
            TNode[] tnodes;
            boolean enabled = false;
            if (context != null && context.getProject() != null && (tnodes = ExplorerContext.getTNodes((Context)context)) != null && tnodes.length > 0) {
                TreeExplorer treeExplorer = tnodes[0].getOwner();
                enabled = treeExplorer != null ? treeExplorer.canRefresh(tnodes[0], Project.class) : true;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 67) {
            boolean enabled = false;
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 5) {
            CommandProcessor cp = CommandProcessor.getInstance();
            action.setEnabled(cp != null ? cp.canUndo(null) : false);
            action.putValue("Name", (Object)IdeArb.format((int)469, (Object)(cp != null ? cp.getUndoLabel(null) : "")));
            return true;
        }
        if (cmdId == 6) {
            CommandProcessor cp = CommandProcessor.getInstance();
            action.setEnabled(cp != null ? cp.canRedo(null) : false);
            action.putValue("Name", (Object)IdeArb.format((int)371, (Object)(cp != null ? cp.getRedoLabel(null) : "")));
            return true;
        }
        return false;
    }

    NavigatorController() {
    }
}

