/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.util.List;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.Assert;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class NavigatorDockableFactory
implements DockableFactory {
    private final NavigatorManager _navMgr;
    private final boolean _useDrawer;

    public NavigatorDockableFactory(NavigatorManager navMgr) {
        this(navMgr, false);
    }

    public NavigatorDockableFactory(NavigatorManager navMgr, boolean useDrawer) {
        if (navMgr == null) {
            throw new IllegalArgumentException();
        }
        this._navMgr = navMgr;
        this._useDrawer = useDrawer;
    }

    private void createDrawers(DefaultNavigatorWindow nav) {
        DockableWindow firstAccordion = null;
        List hosted = this._navMgr.getHostedDockables();
        for (ViewId viewId : hosted) {
            Dockable hostedDockable = DockStation.getDockStation().findDockable(viewId);
            if (!(hostedDockable instanceof DockableWindow)) continue;
            DockableWindow toHost = (DockableWindow)hostedDockable;
            nav.addHostedWindow(toHost);
            if (firstAccordion != null) continue;
            firstAccordion = (DockableWindow)hostedDockable;
        }
    }

    public void install() {
        NavigatorWindow dockable = this._navMgr.getNavigatorWindow();
        if (dockable == null) {
            return;
        }
        if (dockable.isUsingDrawer() && dockable instanceof DefaultNavigatorWindow) {
            DefaultNavigatorWindow nav = (DefaultNavigatorWindow)dockable;
            DockStation.getDockStation().dock((Dockable)nav, this.createDockingParam());
            this.createDrawers(nav);
        } else {
            DockingParam dockingParam = this.createDockingParam();
            DockStation.getDockStation().dock((Dockable)dockable, dockingParam);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return this.createView(viewId);
    }

    protected DockingParam createDockingParam() {
        return new DockingParam();
    }

    private Dockable createView(ViewId viewId) {
        NavigatorWindow navigator = null;
        if (this._navMgr.isSystemNavigator(viewId)) {
            navigator = this._navMgr.getNavigatorWindow();
        } else {
            String idStr = viewId.getId();
            Context context = DefaultNavigatorWindow.loadContext(idStr);
            try {
                try {
                    navigator = this._navMgr.getNewView(context, viewId);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            finally {
                DefaultNavigatorWindow.clearContext(idStr);
            }
        }
        return navigator;
    }
}

