/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mysql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.mysql.MySQLConnectionPanel;
import oracle.dbtools.thirdparty.mysql.MySQLExplorerResource;
import oracle.ide.util.ResourceUtils;

class BasicPanel
extends JPanel
implements CDComponentView {
    public static final String KEY_ZERODATE_BEHAVIOUR = "zeroDateTimeBehavior";
    public static final String ZERODATE_BEHAVIOUR_NULL = "convertToNull";
    public static final String ZERODATE_BEHAVIOUR_ROUND = "round";
    private static final long serialVersionUID = 1L;
    private JButton m_chooseDatabaseButton = new JButton();
    private JComboBox m_mysqlDbComboBox = new JComboBox();
    private final MySQLConnectionPanel m_basicPanel;
    private JLabel m_hostLbl = new JLabel();
    protected JTextField m_tfdHost = new JTextField(15);
    private JLabel m_portLbl = new JLabel();
    protected JTextField m_tfdPort = new JTextField(15);
    protected ButtonGroup m_group = new ButtonGroup();
    private JLabel m_zeroDataLbl = new JLabel();
    private JRadioButton m_optionNull = new JRadioButton();
    private JRadioButton m_optionRound = new JRadioButton();

    public BasicPanel(MySQLConnectionPanel mySQLConnectionPanel) {
        this.m_basicPanel = mySQLConnectionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void clear() {
        this.m_tfdHost.setText("");
        this.m_tfdPort.setText("");
        this.m_mysqlDbComboBox.removeAllItems();
    }

    public void setZeroDateOption(Object object) {
        String string;
        if (object instanceof String && ((string = (String)object) == null || string.trim().length() == 0 || string.equals(ZERODATE_BEHAVIOUR_ROUND))) {
            this.m_optionRound.setSelected(true);
            this.m_optionNull.setSelected(false);
            return;
        }
        this.m_optionNull.setSelected(true);
        this.m_optionRound.setSelected(false);
    }

    public void populateComponent(Properties properties) {
        String string = "";
        String string2 = "";
        Object object = this.m_mysqlDbComboBox.getSelectedItem();
        properties.setProperty("hostname", this.m_tfdHost.getText());
        properties.put("port", this.m_tfdPort.getText());
        if (object != null) {
            string = object.toString();
        }
        string2 = string.length() < 1 ? "jdbc:mysql://" + this.m_tfdHost.getText() + ":" + this.m_tfdPort.getText() + "/" : "jdbc:mysql://" + this.m_tfdHost.getText() + ":" + this.m_tfdPort.getText() + "/" + string;
        properties.setProperty("customUrl", string2);
        if (this.m_optionNull.isSelected()) {
            properties.setProperty(KEY_ZERODATE_BEHAVIOUR, ZERODATE_BEHAVIOUR_NULL);
        } else {
            properties.setProperty(KEY_ZERODATE_BEHAVIOUR, ZERODATE_BEHAVIOUR_ROUND);
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.m_chooseDatabaseButton, (String)MySQLExplorerResource.getString(0));
        ResourceUtils.resButton((AbstractButton)this.m_optionNull, (String)MySQLExplorerResource.getString(1));
        ResourceUtils.resButton((AbstractButton)this.m_optionRound, (String)MySQLExplorerResource.getString(2));
        this.m_group.add(this.m_optionNull);
        this.m_group.add(this.m_optionRound);
        ResourceUtils.resLabel((JLabel)this.m_zeroDataLbl, (Component)this.m_optionNull, (String)MySQLExplorerResource.getString(3));
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("3306");
        this.setZeroDateOption(null);
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_hostLbl, (Component)this.m_tfdHost, (String)ConnectionDialogArb.getString((int)7));
        ResourceUtils.resLabel((JLabel)this.m_portLbl, (Component)this.m_tfdPort, (String)ConnectionDialogArb.getString((int)8));
        this.add((Component)this.m_hostLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdHost, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_portLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdPort, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_chooseDatabaseButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_mysqlDbComboBox, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_zeroDataLbl, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_optionNull, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_optionRound, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.m_chooseDatabaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (BasicPanel.this.m_basicPanel.getUserName().length() < 1 || BasicPanel.this.m_basicPanel.getUserName().length() < 1 || BasicPanel.this.m_basicPanel.getConnectionName().length() < 1) {
                        BasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + "Select the Connection Name / User Name / Password");
                        return;
                    }
                    BasicPanel.this.m_basicPanel.setStatus("");
                    ClassLoader classLoader = RaptorClassLoader.findClassLoader((String)"com.mysql.jdbc.Driver");
                    Class<?> clazz = null;
                    if (classLoader != null) {
                        clazz = classLoader.loadClass("com.mysql.jdbc.Driver");
                    } else {
                        Class.forName("com.mysql.jdbc.Driver");
                    }
                    Driver driver = (Driver)clazz.newInstance();
                    Properties properties = new Properties();
                    String string = BasicPanel.this.m_basicPanel.getUserName();
                    String string2 = BasicPanel.this.m_basicPanel.getPassword();
                    String string3 = "jdbc:mysql://" + BasicPanel.this.m_tfdHost.getText() + ":" + BasicPanel.this.m_tfdPort.getText() + "/";
                    if (null != string) {
                        properties.setProperty("user", string);
                    }
                    if (null != string2) {
                        properties.setProperty("password", string2);
                    }
                    Connection connection = driver.connect(string3, properties);
                    PreparedStatement preparedStatement = connection.prepareStatement("show databases");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    BasicPanel.this.m_mysqlDbComboBox.removeAllItems();
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        if (string4 == null) continue;
                        BasicPanel.this.m_mysqlDbComboBox.addItem(string4);
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getClass().getName().equals("com.mysql.jdbc.CommunicationsException")) {
                        BasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + ConnectionDialogArb.format((int)35, (Object)BasicPanel.this.m_tfdHost.getText()));
                    } else {
                        BasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + sQLException.getLocalizedMessage());
                    }
                }
                catch (InstantiationException instantiationException) {
                    BasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    BasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + illegalAccessException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    BasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + classNotFoundException.getMessage());
                }
            }
        });
    }

    protected void retrieveDatabase(Properties properties) {
        String string;
        this.m_mysqlDbComboBox.removeAllItems();
        String string2 = properties.getProperty("customUrl");
        if (string2 != null && (string = string2.substring(string2.lastIndexOf(47) + 1)) != null) {
            this.m_mysqlDbComboBox.addItem(string);
            this.m_mysqlDbComboBox.setSelectedItem(string);
        }
    }

    public void setDefaultPrompts() {
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("3306");
        this.m_mysqlDbComboBox.removeAllItems();
    }
}

