/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mysql;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.mysql.BasicPanel;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

public class MySQLConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _panel;
    private BasicPanel _basicPanel;
    private CardLayout _layout;
    private static final String DRIVER_CLASSNAME = "com.mysql.jdbc.Driver";
    public static final String HOST = "localhost";
    public static final String PORT = "3306";

    public MySQLConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this._basicPanel = new BasicPanel(this);
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((int)34));
        this._panel.add((Component)this._basicPanel, "Basic");
        this.add(this._panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._layout.show(this._panel, "Basic");
    }

    private Properties getInput(Properties properties) {
        properties.setProperty("subtype", "MYSQL");
        properties.setProperty("driver", DRIVER_CLASSNAME);
        properties.setProperty("RaptorConnectionType", "MySQL");
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.populateComponent(properties);
        if (this.getDialog().getPassword() == null || this.getDialog().getPassword().length() == 0) {
            try {
                this.testConnection(properties);
                properties.setProperty("NoPasswordConnection", Boolean.FALSE.toString());
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
        return properties;
    }

    private CDComponentView getPanel() {
        return this._basicPanel;
    }

    public void clear() {
        this._basicPanel.clear();
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        this._basicPanel.m_tfdHost.setText(string);
        String string2 = properties.getProperty("port");
        this._basicPanel.m_tfdPort.setText(string2 != null ? string2 : "1433");
        properties.setProperty("ConnName", this.getConnectionName());
        this._basicPanel.setZeroDateOption(properties.getProperty("zeroDateTimeBehavior"));
        this._basicPanel.retrieveDatabase(properties);
    }

    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    public String getDriver() {
        return DRIVER_CLASSNAME;
    }

    public void setDefaultPrompts() {
        this._basicPanel.setDefaultPrompts();
        this.getDialog().useUserName(true);
        this.getDialog().usePassword(true);
    }

    public String getConnectionType() {
        return "MySQL";
    }
}

