/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.view.View;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateLrb;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.balloon.Balloon;
import oracle.javatools.ui.balloon.BalloonConstraint;
import oracle.javatools.ui.balloon.BalloonManager;

public final class AutomaticCheckForUpdates {
    public static final String CONTEXT_KEY_MASTER_LIST = "autoCfuMasterList";
    private static final int HIDE_ACTION_ID = Ide.findOrCreateCmdID((String)"AutoUpdateHide");
    private static final int PREFS_ACTION_ID = Ide.findOrCreateCmdID((String)"AutoUpdatePrefs");
    private Collection _masterList;
    private JComponent _notificationIcon;
    private JCheckBox _skipCheckbox;
    private Controller _controller;
    private ContextMenu _contextMenu;
    private MouseListener _mouseListener;

    private void $init$() {
        this._masterList = null;
        this._notificationIcon = null;
        this._skipCheckbox = null;
        this._controller = null;
        this._contextMenu = null;
        this._mouseListener = null;
    }

    AutomaticCheckForUpdates() {
        this.$init$();
    }

    public void check() {
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoskip")).booleanValue()) {
            return;
        }
        if (Ide.getIdeArgs().hasArg("-nonag")) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoforce")).booleanValue()) {
            this.installBalloon();
        }
        1 cfuRunnable = new 1();
        Thread t = new Thread((Runnable)cfuRunnable, "Automatic check for updates");
        t.setPriority(1);
        t.start();
    }

    private void checkMasterList() {
        2 masterListCheck = new 2(UpdateManager.getInstance().getMasterServerURL());
        masterListCheck.setAutomaticUpdateMode(true);
        masterListCheck.run();
    }

    private void checkForUpdates(List masterList) {
        this._masterList = masterList;
        3 r = new 3(masterList);
        r.setAutomaticUpdatesMode(true);
        r.run();
    }

    private void installBalloon() {
        this.installBalloon(false);
    }

    private String _(String s) {
        return UpdateLrb.getBundle().getString(s);
    }

    private void installBalloon(boolean havePatches) {
        Balloon b = new Balloon();
        JLabel header = new JLabel();
        header.setFont(header.getFont().deriveFont(1));
        header.setIcon(havePatches ? UpdateArb.getIcon(27) : OracleIcons.getIcon((String)"update2.png"));
        header.setText(havePatches ? this._("SERVICE_UPDATES_AVAILABLE") : this._("UPDATES_AVAILABLE"));
        MultiLineLabel mll = new MultiLineLabel();
        mll.setTextWrapper(WordWrapper.getTextWrapper());
        mll.setPreferredColumns(40);
        mll.setText(havePatches ? this._("CRITICAL_UPDATE") : this._("REGULAR_UPDATE"));
        b.add((Component)header, (Object)BalloonConstraint.HEADER);
        b.add((Component)mll, (Object)BalloonConstraint.TEXT);
        JCheckBox cbSkipNextTime = new JCheckBox(this._("SKIP_CHECK"));
        cbSkipNextTime.setOpaque(false);
        b.add((Component)cbSkipNextTime, (Object)BalloonConstraint.FOOTER);
        this._skipCheckbox = cbSkipNextTime;
        4 al = new 4();
        b.addActionListener((ActionListener)al);
        b.addComponentListener((ComponentListener)new 5(this, b, al, cbSkipNextTime));
        this.installNotificationIcon();
        BalloonManager.forTarget((JComponent)this._notificationIcon).show(b, 25000);
    }

    private void installNotificationIcon() {
        if (this._notificationIcon == null) {
            JLabel icon = new JLabel();
            icon.setIcon(OracleIcons.getIcon((String)"update2.png"));
            Ide.getStatusBar().getToolbar().add((Component)icon, 0);
            Ide.getStatusBar().getToolbar().revalidate();
            this._mouseListener = new 6();
            icon.addMouseListener(this._mouseListener);
            this._notificationIcon = icon;
        }
    }

    public void uninstallNotificationIcon() {
        if (this._notificationIcon != null) {
            Ide.getStatusBar().getToolbar().remove((Component)this._notificationIcon);
            Ide.getStatusBar().getToolbar().invalidate();
            this._notificationIcon.removeMouseListener(this._mouseListener);
            this._notificationIcon = null;
            UpdateManager.getInstance().clearAutomaticCheckForUpdates();
            this.unregisterActions();
            this._contextMenu = null;
        }
    }

    public void updateSkipCheckbox() {
        if (this._skipCheckbox != null) {
            boolean autoCheck = WebUpdateAddin.getPreferences().getCheckOnStartup();
            this._skipCheckbox.setSelected(autoCheck ^ true);
        }
    }

    private ContextMenu getOrCreateContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this.registerActions();
        }
        return this._contextMenu;
    }

    private void registerActions() {
        this._controller = new MyController(null);
        IdeAction hide = IdeAction.find((int)HIDE_ACTION_ID);
        if (hide == null) {
            hide = IdeAction.get((int)HIDE_ACTION_ID, null, (String)this._("HIDE"));
        }
        hide.addController(this._controller);
        IdeAction prefs = IdeAction.find((int)PREFS_ACTION_ID);
        if (prefs == null) {
            prefs = IdeAction.get((int)PREFS_ACTION_ID, null, (String)this._("PREFERENCES"));
        }
        prefs.addController(this._controller);
    }

    private void unregisterActions() {
        IdeAction prefs;
        IdeAction hide = IdeAction.find((int)HIDE_ACTION_ID);
        if (hide != null) {
            hide.removeController(this._controller);
        }
        if ((prefs = IdeAction.find((int)PREFS_ACTION_ID)) != null) {
            prefs.removeController(this._controller);
        }
        this._controller = null;
    }

    static int ra$HIDE_ACTION_ID() {
        return HIDE_ACTION_ID;
    }

    static int ra$PREFS_ACTION_ID() {
        return PREFS_ACTION_ID;
    }

    static ContextMenu mav$getOrCreateContextMenu(AutomaticCheckForUpdates automaticCheckForUpdates) {
        return automaticCheckForUpdates.getOrCreateContextMenu();
    }

    static Collection ra$_masterList(AutomaticCheckForUpdates automaticCheckForUpdates) {
        return automaticCheckForUpdates._masterList;
    }

    static void wa$_skipCheckbox(AutomaticCheckForUpdates automaticCheckForUpdates, JCheckBox jCheckBox) {
        automaticCheckForUpdates._skipCheckbox = jCheckBox;
    }

    static void wa$_masterList(AutomaticCheckForUpdates automaticCheckForUpdates, Collection collection) {
        automaticCheckForUpdates._masterList = collection;
    }

    static void mav$checkForUpdates(AutomaticCheckForUpdates automaticCheckForUpdates, List list) {
        automaticCheckForUpdates.checkForUpdates(list);
    }

    static void mav$checkMasterList(AutomaticCheckForUpdates automaticCheckForUpdates) {
        automaticCheckForUpdates.checkMasterList();
    }

    static void mav$installBalloon(AutomaticCheckForUpdates automaticCheckForUpdates, boolean bl) {
        automaticCheckForUpdates.installBalloon(bl);
    }

    final class 1
    implements Runnable {
        public void run() {
            if (WebUpdateAddin.getPreferences().getCheckOnStartup()) {
                AutomaticCheckForUpdates.mav$checkMasterList(AutomaticCheckForUpdates.this);
            }
        }
    }

    final class 2
    extends CheckMasterListRunnable {
        protected void failed(Throwable exception) {
            CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
            prefs.setLastErrorType("generic");
            prefs.setLastError(exception.getMessage());
        }

        protected void finished(List masterList) {
            ArrayList<UpdateCenter> centers = new ArrayList<UpdateCenter>(masterList);
            UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
            centers.addAll(updateHook.getUpdateCenters());
            for (UpdateCenter c : centers) {
                c.setEnabled(c.isSelectedByDefault());
            }
            AutomaticCheckForUpdates.mav$checkForUpdates(AutomaticCheckForUpdates.this, masterList);
        }

        public 2(String string) {
            super(string);
        }
    }

    final class 3
    extends CheckUpdatesRunnable {
        protected void updateCenterError(UpdateCenter center, Throwable exception) {
            CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
            prefs.setLastErrorType("generic");
            prefs.setLastError(exception.getMessage());
        }

        protected void finished(Collection updates) {
            CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
            prefs.setLastErrorType("none");
            boolean foundNewUpdates = false;
            HashStructure oldUpdates = prefs.getPreviousUpdates();
            if (oldUpdates == null) {
                oldUpdates = HashStructure.newInstance();
            }
            HashStructure newUpdates = HashStructure.newInstance();
            for (UpdateInfo update : updates) {
                String id = update.getID();
                String oldVersionString = oldUpdates.getString(id);
                newUpdates.putString(id, update.getVersion().toCanonicalString());
                if (oldVersionString == null) {
                    foundNewUpdates = true;
                    continue;
                }
                Version oldVersion = new Version(oldVersionString);
                if (update.getVersion().compareTo(oldVersion) <= 0) continue;
                foundNewUpdates = true;
            }
            boolean havePatches = false;
            for (UpdateInfo update : updates) {
                if (update.getType() != UpdateInfo.Type.PATCH) continue;
                havePatches = true;
                break;
            }
            if (havePatches || foundNewUpdates) {
                boolean fHavePatches = havePatches;
                EventQueue.invokeLater(new 1(this, fHavePatches));
            } else {
                AutomaticCheckForUpdates.wa$_masterList(AutomaticCheckForUpdates.this, null);
                UpdateManager.getInstance().clearAutomaticCheckForUpdates();
            }
            prefs.setPreviousUpdates(newUpdates);
        }

        protected void stopped() {
        }

        public 3(List list) {
            super(list);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ boolean v$fHavePatches;
            final /* synthetic */ 3 this$0;

            public void run() {
                AutomaticCheckForUpdates.mav$installBalloon(this.this$0.AutomaticCheckForUpdates.this, this.v$fHavePatches);
            }

            public 1(3 var1_1, boolean bl) {
                this.v$fHavePatches = bl;
                this.this$0 = var1_1;
            }
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            IdeAction cfuAction = IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID);
            Context context = Context.newIdeContext();
            context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, (Object)AutomaticCheckForUpdates.ra$_masterList(AutomaticCheckForUpdates.this));
            try {
                cfuAction.performAction(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    final class 5
    extends ComponentAdapter {
        private final /* synthetic */ Balloon v$b;
        private final /* synthetic */ ActionListener v$al;
        private final /* synthetic */ JCheckBox v$cbSkipNextTime;
        final /* synthetic */ AutomaticCheckForUpdates this$0;

        public void componentHidden(ComponentEvent ce) {
            ce.getComponent().removeComponentListener(this);
            this.v$b.removeActionListener(this.v$al);
            WebUpdateAddin.getPreferences().setCheckOnStartup(this.v$cbSkipNextTime.isSelected() ^ true);
            if (this.v$cbSkipNextTime.isSelected()) {
                this.this$0.uninstallNotificationIcon();
            }
            AutomaticCheckForUpdates.wa$_skipCheckbox(this.this$0, null);
        }

        public 5(AutomaticCheckForUpdates automaticCheckForUpdates, Balloon balloon, ActionListener actionListener, JCheckBox jCheckBox) {
            this.v$cbSkipNextTime = jCheckBox;
            this.v$al = actionListener;
            this.v$b = balloon;
            this.this$0 = automaticCheckForUpdates;
        }
    }

    final class 6
    extends MouseAdapter {
        private Context createContext(MouseEvent me) {
            Context context = Context.newIdeContext((View)Ide.getMainWindow().getIdeMainWindowView(), (EventObject)me);
            context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, (Object)AutomaticCheckForUpdates.ra$_masterList(AutomaticCheckForUpdates.this));
            return context;
        }

        private ContextMenu createContextMenu() {
            ContextMenu contextMenu = AutomaticCheckForUpdates.mav$getOrCreateContextMenu(AutomaticCheckForUpdates.this);
            1 cml = new 1();
            contextMenu.addContextMenuListener((ContextMenuListener)cml);
            return contextMenu;
        }

        private void showContextMenu(MouseEvent me) {
            this.createContextMenu().show(this.createContext(me));
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.showContextMenu(me);
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.showContextMenu(me);
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2) {
                this.createContextMenu().fireDefaultAction(this.createContext(me));
            }
        }

        final class 1
        implements ContextMenuListener {
            public void menuWillShow(ContextMenu contextMenu) {
                float section = 0.0f;
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID)), section);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)AutomaticCheckForUpdates.ra$HIDE_ACTION_ID())), section += 0.1f);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)AutomaticCheckForUpdates.ra$PREFS_ACTION_ID())), section);
            }

            public void menuWillHide(ContextMenu contextMenu) {
                contextMenu.removeContextMenuListener((ContextMenuListener)this);
            }

            public boolean handleDefaultAction(Context context) {
                try {
                    IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID).performAction(context);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
    }

    private final class MyController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() == AutomaticCheckForUpdates.ra$HIDE_ACTION_ID()) {
                AutomaticCheckForUpdates.this.uninstallNotificationIcon();
                return true;
            }
            if (action.getCommandId() == AutomaticCheckForUpdates.ra$PREFS_ACTION_ID()) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{"Extensions"});
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            return action.getCommandId() == AutomaticCheckForUpdates.ra$HIDE_ACTION_ID() || action.getCommandId() == AutomaticCheckForUpdates.ra$PREFS_ACTION_ID();
        }

        private MyController() {
        }

        MyController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

