/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.ideimpl.webupdate.ProgressMonitor;

public class BasicProgressMonitor
extends JPanel
implements ProgressMonitor {
    private final JLabel _message;
    private final JProgressBar _progress;
    private final JLabel _note;
    private final JButton _stopButton;
    private int _jumpPerStep;
    private int _stepsElapsed;
    private boolean _canceled;
    private static final int MAX_PROGRESS = 100000;

    private void $init$() {
        this._message = new JLabel();
        this._progress = new JProgressBar();
        this._note = new JLabel();
        this._stopButton = new JButton("Stop");
    }

    public BasicProgressMonitor() {
        this.$init$();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._message, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this._progress, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._stopButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._note, gbc);
        this._stopButton.setEnabled(false);
        this._progress.setMaximum(100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int numberOfSteps) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            this._jumpPerStep = 100000 / numberOfSteps;
            System.err.println(numberOfSteps + " steps at " + this._jumpPerStep + " ticks per step");
        }
        EventQueue.invokeLater(new 1());
    }

    public void finished() {
        EventQueue.invokeLater(new 2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanced(int steps) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            this._stepsElapsed += steps;
        }
        EventQueue.invokeLater(new 3());
    }

    public synchronized boolean isCanceled() {
        return this._canceled;
    }

    public synchronized void setCanceled(boolean canceled) {
        this._canceled = canceled;
    }

    public void setMessage(String message) {
        EventQueue.invokeLater(new 4(this, message));
    }

    public void setDetailMessage(String detailMessage) {
        EventQueue.invokeLater(new 5(this, detailMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressMonitor createSubMonitor(int steps) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            SubMonitor subMonitor = new SubMonitor(this, steps * this._jumpPerStep, this._stepsElapsed * this._jumpPerStep);
            return subMonitor;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        BasicProgressMonitor mon = new BasicProgressMonitor();
        f.setContentPane(mon);
        mon.setMessage("Test Message");
        mon.setDetailMessage("Test Note");
        Random random = new Random();
        6 t = new 6(mon, random);
        t.start();
        f.pack();
        f.setVisible(true);
    }

    static JLabel ra$_note(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._note;
    }

    static JLabel ra$_message(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._message;
    }

    static JProgressBar ra$_progress(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._progress;
    }

    static int ra$_stepsElapsed(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._stepsElapsed;
    }

    static int ra$_jumpPerStep(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._jumpPerStep;
    }

    static JButton ra$_stopButton(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._stopButton;
    }

    final class 1
    implements Runnable {
        public void run() {
            BasicProgressMonitor.ra$_stopButton(BasicProgressMonitor.this).setEnabled(true);
            BasicProgressMonitor.ra$_progress(BasicProgressMonitor.this).setValue(0);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            BasicProgressMonitor.ra$_stopButton(BasicProgressMonitor.this).setEnabled(false);
            BasicProgressMonitor.ra$_progress(BasicProgressMonitor.this).setValue(100000);
        }
    }

    final class 3
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasicProgressMonitor basicProgressMonitor = BasicProgressMonitor.this;
            synchronized (basicProgressMonitor) {
                BasicProgressMonitor.ra$_progress(BasicProgressMonitor.this).setValue(BasicProgressMonitor.ra$_stepsElapsed(BasicProgressMonitor.this) * BasicProgressMonitor.ra$_jumpPerStep(BasicProgressMonitor.this));
            }
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ String v$message;
        final /* synthetic */ BasicProgressMonitor this$0;

        public void run() {
            BasicProgressMonitor.ra$_message(this.this$0).setText(this.v$message);
        }

        public 4(BasicProgressMonitor basicProgressMonitor, String string) {
            this.v$message = string;
            this.this$0 = basicProgressMonitor;
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ String v$detailMessage;
        final /* synthetic */ BasicProgressMonitor this$0;

        public void run() {
            BasicProgressMonitor.ra$_note(this.this$0).setText(this.v$detailMessage);
        }

        public 5(BasicProgressMonitor basicProgressMonitor, String string) {
            this.v$detailMessage = string;
            this.this$0 = basicProgressMonitor;
        }
    }

    private static class SubMonitor
    implements ProgressMonitor {
        private final ProgressMonitor _parent;
        private final int _allocatedTicks;
        private int _jumpPerStep;
        private int _startProgress;
        private int _stepsElapsed;

        SubMonitor(ProgressMonitor parent, int allocatedTicks, int startProgress) {
            this._parent = parent;
            this._allocatedTicks = allocatedTicks;
            this._startProgress = startProgress;
        }

        private ProgressMonitor getParent() {
            return this._parent;
        }

        private BasicProgressMonitor getRootMonitor() {
            ProgressMonitor pm = this;
            while (!(pm instanceof BasicProgressMonitor)) {
                pm = pm.getParent();
            }
            return (BasicProgressMonitor)pm;
        }

        public synchronized void start(int numberOfSteps) {
            this._jumpPerStep = this._allocatedTicks / numberOfSteps;
        }

        public void finished() {
            EventQueue.invokeLater(new 1());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void advanced(int steps) {
            SubMonitor subMonitor = this;
            synchronized (subMonitor) {
                ++this._stepsElapsed;
            }
            EventQueue.invokeLater(new 2());
        }

        public boolean isCanceled() {
            return this.getRootMonitor().isCanceled();
        }

        public void setCanceled(boolean canceled) {
            this.getRootMonitor().setCanceled(canceled);
        }

        public void setMessage(String message) {
            this.getRootMonitor().setMessage(message);
        }

        public void setDetailMessage(String detailMessage) {
            this.getRootMonitor().setDetailMessage(detailMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProgressMonitor createSubMonitor(int steps) {
            SubMonitor subMonitor = this;
            synchronized (subMonitor) {
                SubMonitor subMonitor2 = new SubMonitor(this, steps * this._jumpPerStep, this._stepsElapsed * this._jumpPerStep);
                return subMonitor2;
            }
        }

        static BasicProgressMonitor mav$getRootMonitor(SubMonitor subMonitor) {
            return subMonitor.getRootMonitor();
        }

        static int ra$_startProgress(SubMonitor subMonitor) {
            return subMonitor._startProgress;
        }

        static int ra$_stepsElapsed(SubMonitor subMonitor) {
            return subMonitor._stepsElapsed;
        }

        static int ra$_jumpPerStep(SubMonitor subMonitor) {
            return subMonitor._jumpPerStep;
        }

        static int ra$_allocatedTicks(SubMonitor subMonitor) {
            return subMonitor._allocatedTicks;
        }

        final class 1
        implements Runnable {
            public void run() {
                JProgressBar pb = BasicProgressMonitor.ra$_progress(SubMonitor.mav$getRootMonitor(SubMonitor.this));
                pb.setValue(SubMonitor.ra$_startProgress(SubMonitor.this) + SubMonitor.ra$_allocatedTicks(SubMonitor.this));
            }
        }

        final class 2
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SubMonitor subMonitor = SubMonitor.this;
                synchronized (subMonitor) {
                    JProgressBar pb = BasicProgressMonitor.ra$_progress(SubMonitor.mav$getRootMonitor(SubMonitor.this));
                    pb.setValue(SubMonitor.ra$_startProgress(SubMonitor.this) + SubMonitor.ra$_stepsElapsed(SubMonitor.this) * SubMonitor.ra$_jumpPerStep(SubMonitor.this));
                }
            }
        }
    }

    static final class 6
    extends Thread {
        private final /* synthetic */ BasicProgressMonitor v$mon;
        private final /* synthetic */ Random v$random;

        public void run() {
            this.v$mon.start(10);
            int i = 0;
            while (i < 10) {
                this.v$mon.setMessage("Step " + (i + 1) + " of 10");
                this.subtask(this.v$mon);
                this.v$mon.advanced(1);
                ++i;
            }
            this.v$mon.finished();
        }

        private void subtask(ProgressMonitor parent) {
            int steps = this.v$random.nextInt(100);
            steps = Math.max(steps, 1);
            ProgressMonitor monitor = parent.createSubMonitor(1);
            monitor.start(steps);
            int i = 0;
            while (i < steps) {
                monitor.setDetailMessage("SubStep " + (i + 1) + " of " + steps);
                try {
                    Thread.sleep(this.v$random.nextInt(200));
                }
                catch (InterruptedException ie) {
                    return;
                }
                monitor.advanced(1);
                ++i;
            }
            monitor.finished();
        }

        public 6(BasicProgressMonitor basicProgressMonitor, Random random) {
            this.v$random = random;
            this.v$mon = basicProgressMonitor;
        }
    }
}

