/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.BufferedInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.net.URLFactory;
import oracle.ide.webbrowser.internal.Util;
import oracle.ideimpl.webupdate.MasterListEntry;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.parser.MasterListParser;

public abstract class CheckMasterListRunnable
implements Runnable {
    private boolean _isRunning;
    private final String[] _localHostNames;
    private final String _masterURL;
    private UpdateCenterMonitor _monitor;
    private boolean _isAutomaticUpdateMode;

    public CheckMasterListRunnable(String masterURL) {
        this._masterURL = masterURL;
        this._localHostNames = this.buildLocalHostNames();
    }

    void setAutomaticUpdateMode(boolean autoMode) {
        this._isAutomaticUpdateMode = autoMode;
    }

    private String[] buildLocalHostNames() {
        try {
            InetAddress[] inets = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            String[] hostNames = new String[inets.length];
            int i = 0;
            while (i < inets.length) {
                InetAddress inet = inets[i];
                if (inet != null) {
                    hostNames[i] = inet.getCanonicalHostName();
                }
                ++i;
            }
            String[] stringArray = hostNames;
            return stringArray;
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            return new String[0];
        }
    }

    public final void setMonitor(UpdateCenterMonitor monitor) {
        this._monitor = monitor;
    }

    protected final UpdateCenterMonitor getMonitor() {
        if (this._monitor == null) {
            this._monitor = new 1();
        }
        return this._monitor;
    }

    private boolean matchesLocalDomains(MasterListEntry entry) {
        if (".*\\.oracle.com".equals(entry.getDomainRegexp())) {
            return Util.isInsideOracle();
        }
        int i = 0;
        while (i < this._localHostNames.length) {
            if (entry.matchesDomain(this._localHostNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        if (this.getMonitor().isStopped()) {
            return;
        }
        try {
            this.setRunning(true);
            this.getMonitor().start();
            this.getMonitor().setMessage(UpdateArb.getString(119));
            ArrayList<UpdateCenter> masterList = new ArrayList<UpdateCenter>();
            URL masterURL = URLFactory.newURL((String)this._masterURL);
            BufferedInputStream bis = null;
            try {
                URLConnection conn = masterURL.openConnection();
                conn.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(masterURL.toString(), this._isAutomaticUpdateMode));
                bis = new BufferedInputStream(conn.getInputStream());
                List masterEntries = new MasterListParser().parse(bis);
                for (MasterListEntry entry : masterEntries) {
                    if (!this.matchesLocalDomains(entry)) continue;
                    masterList.add(entry.getUpdateCenter());
                }
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
            this.getMonitor().finish();
            this.setRunning(false);
            this.finished(masterList);
        }
        catch (Throwable t) {
            this.getMonitor().finish();
            this.setRunning(false);
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.failed(t);
        }
    }

    public synchronized boolean isRunning() {
        return this._isRunning;
    }

    private synchronized void setRunning(boolean running) {
        this._isRunning = running;
    }

    protected abstract void failed(Throwable var1);

    protected abstract void finished(List var1);

    final class 1
    implements UpdateCenterMonitor {
        public void setMessage(String message) {
        }

        public void setProgress(int i) {
        }

        public void start() {
        }

        public void finish() {
        }

        public boolean isStopped() {
            return false;
        }

        public void setMaximum(int max) {
        }
    }
}

