/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.GuidGen;
import oracle.ideimpl.webupdate.AutomaticCheckForUpdates;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.MasterServerAdapter;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.dialogs.ExceptionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateManager {
    private AutomaticCheckForUpdates _autoCheck;
    private static UpdateManager s_instance = null;
    private UpdateCenter[] m_updateCenters;
    private static final String DEFERRED_FILE = "deferred-updates.xml";
    private static final String CENTER_LIST_FILE = "updatecenters.xml";
    private static final String CENTER_LIST_ROOT = "updatecenters";
    private static final String CENTER_LIST_NS = Version.BASE_NAMESPACE_URI + "updatecenters";
    private Directories m_directories;
    private boolean m_singleUserMode;
    private static String s_masterServerURL;

    private void $init$() {
        this.m_singleUserMode = true;
    }

    private UpdateManager() throws SingletonClassException {
        this.$init$();
        if (s_instance != null) {
            throw new SingletonClassException("");
        }
    }

    public synchronized AutomaticCheckForUpdates getAutomaticCheckForUpdates() {
        if (this._autoCheck == null) {
            this._autoCheck = new AutomaticCheckForUpdates();
        }
        return this._autoCheck;
    }

    synchronized void clearAutomaticCheckForUpdates() {
        this._autoCheck = null;
    }

    public String getMasterServerURL() {
        if (s_masterServerURL == null) {
            String masterServer = System.getProperty("ide.update.masterserver");
            if (masterServer == null) {
                MasterServerAdapter adapter = MasterServerAdapter.getInstance(ProductInformation.getProductInformation().getHashStructure());
                masterServer = adapter.getMasterServerURL();
            }
            s_masterServerURL = masterServer;
        }
        return s_masterServerURL;
    }

    public void setDirectories(Directories d) {
        this.m_directories = d;
    }

    public Directories getDirectories() {
        return this.m_directories;
    }

    private boolean canWriteToDir(File dir) {
        File f = new File(dir, "tempfile.tmp");
        if (f.exists() && f.delete()) {
            return false;
        }
        try {
            if (f.createNewFile()) {
                f.delete();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        return false;
    }

    public boolean isGlobalExtensionInstallationAllowed() {
        File f = new File(this.getDirectories().getGlobalExtensionsHome());
        if (!f.exists()) {
            return false;
        }
        return this.canWriteToDir(f);
    }

    public boolean isSingleUserMode() {
        return this.m_singleUserMode;
    }

    public Collection<UpdateCenter> getUpdateCenters() {
        if (this.m_updateCenters == null) {
            this.loadUpdateCenterList();
        }
        return Collections.unmodifiableCollection(Arrays.asList(this.m_updateCenters));
    }

    private URL getCenterListFile() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL systemDir = er.getSystemDirectory("oracle.ide");
        return URLFactory.newURL((URL)systemDir, (String)CENTER_LIST_FILE);
    }

    private void loadUpdateCenterList() {
        URL listFile = this.getCenterListFile();
        if (!URLFileSystem.exists((URL)listFile)) {
            this.m_updateCenters = new UpdateCenter[0];
            return;
        }
        ListStructureIO io = new ListStructureIO(CENTER_LIST_NS, CENTER_LIST_ROOT);
        try {
            ListStructure ls = (ListStructure)io.load(listFile);
            this.m_updateCenters = new UpdateCenter[ls.size()];
            int i = 0;
            while (i < ls.size()) {
                HashStructure props = (HashStructure)ls.get(i);
                UpdateCenter uc = new UpdateCenter();
                uc.setProperties(props);
                this.m_updateCenters[i] = uc;
                ++i;
            }
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
    }

    private void saveUpdateCenterList() throws IOException {
        if (this.m_updateCenters == null) {
            throw new IllegalStateException("Attempted to save update center list before it has been loaded.");
        }
        URL listFile = this.getCenterListFile();
        ListStructureIO io = new ListStructureIO(CENTER_LIST_NS, CENTER_LIST_ROOT);
        ListStructure ls = ListStructure.newInstance();
        int i = 0;
        while (i < this.m_updateCenters.length) {
            ls.add((Object)this.m_updateCenters[i].getProperties());
            ++i;
        }
        io.save(listFile, (Object)ls);
    }

    public void setUpdateCenters(List updateCenters) throws IOException {
        this.m_updateCenters = new UpdateCenter[updateCenters.size()];
        updateCenters.toArray(this.m_updateCenters);
        this.saveUpdateCenterList();
    }

    public static UpdateManager getInstance() {
        if (s_instance == null) {
            try {
                s_instance = new UpdateManager();
            }
            catch (SingletonClassException singleton) {
                Assert.fail((Exception)((Object)singleton));
            }
        }
        return s_instance;
    }

    public File getDeferredUpdatesFile() {
        String baseDir = System.getProperty("ide.user.dir");
        if (baseDir == null || baseDir.trim().length() == 0) {
            baseDir = System.getProperty("oracle.home");
        }
        return new File(baseDir, DEFERRED_FILE);
    }

    public String getUserAgent(String targetUrl, boolean automaticPing) {
        StringBuffer sb = new StringBuffer();
        sb.append(Ide.getProgramShortName());
        sb.append("/");
        sb.append(Version.VER);
        sb.append(" (");
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append("; ");
        sb.append(System.getProperty("os.arch"));
        sb.append("; Java ");
        sb.append(System.getProperty("java.version"));
        sb.append("; ");
        sb.append(this.isFirstTime(targetUrl) ? "Y" : "N");
        sb.append(automaticPing ? "A" : "M");
        sb.append("; ");
        sb.append(this.getSystemGuid());
        sb.append("; ");
        sb.append(ProductInformation.getProductInformation().getUserAgentExtras());
        sb.append(") ");
        sb.append(Version.VER_FULL);
        return sb.toString();
    }

    private String getSystemGuid() {
        CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
        String guid = prefs.getInstanceGuid();
        if (guid == null) {
            guid = GuidGen.toString((byte[])GuidGen.uuidCreate());
            prefs.setInstanceGuid(guid);
        }
        return guid;
    }

    private boolean isFirstTime(String targetUrl) {
        boolean firstTime;
        ListStructure pingsForVersion;
        CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
        HashStructure pings = prefs.getPingedVersions();
        if (pings == null) {
            pings = HashStructure.newInstance();
            prefs.setPingedVersions(pings);
        }
        if ((pingsForVersion = pings.getListStructure(Version.VER_FULL)) == null) {
            pingsForVersion = ListStructure.newInstance();
            pings.putListStructure(Version.VER_FULL, pingsForVersion);
        }
        if (firstTime = pingsForVersion.contains((Object)targetUrl) ^ true) {
            pingsForVersion.add((Object)targetUrl);
        }
        return firstTime;
    }
}

