/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.text.MessageFormat;
import javax.ide.util.Version;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateLrb;
import oracle.ideimpl.webupdate.parser.RequirementsHandler;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.Key;

abstract class UpdateHandler
extends ElementHandler {
    private static final Key KEY_UPDATE = new Key("update");
    static final String NAMESPACE = "http://xmlns.oracle.com/jdeveloper/update";
    private ElementHandler _nameHandler;
    private ElementHandler _versionHandler;
    private ElementHandler _authorHandler;
    private ElementHandler _authorUrlHandler;
    private ElementHandler _descriptionHandler;
    private ElementHandler _requirementsHandler;
    private ElementHandler _bundleUrlHandler;
    private ElementHandler _destinationHandler;
    private ElementHandler _postStartupHookHandler;

    private void $init$() {
        this._nameHandler = new NameHandler(null);
        this._versionHandler = new VersionHandler(null);
        this._authorHandler = new AuthorHandler(null);
        this._authorUrlHandler = new AuthorUrlHandler(null);
        this._descriptionHandler = new DescriptionHandler(null);
        this._requirementsHandler = new RequirementsHandler();
        this._bundleUrlHandler = new BundleUrlHandler(null);
        this._destinationHandler = new DestinationHandler(null);
        this._postStartupHookHandler = new PostStartupHookHandler(null);
    }

    public void handleStart(ElementStartContext context) throws HandlerException {
        UpdateInfo updateInfo = new UpdateInfo();
        String id = context.getAttributeValue("id");
        if (id == null) {
            context.getMessageReporter().error(context.getLocator(), "_id attribute of extension element is required.", null);
            return;
        }
        updateInfo.setID(context.getAttributeValue("id"));
        String type = context.getAttributeValue("type");
        if (type == null || type.trim().length() == 0) {
            type = UpdateInfo.Type.EXTENSION.name();
        }
        try {
            UpdateInfo.Type actualType = UpdateInfo.Type.valueOf(type.toUpperCase());
            updateInfo.setType(actualType);
        }
        catch (IllegalArgumentException ie) {
            context.getMessageReporter().error(context.getLocator(), "_type attribute of extension element must be either 'patch' or 'extension'", null);
            return;
        }
        context.putValue(KEY_UPDATE, (Object)updateInfo);
        context.registerChildHandler(NAMESPACE, "name", this._nameHandler);
        context.registerChildHandler(NAMESPACE, "version", this._versionHandler);
        context.registerChildHandler(NAMESPACE, "author", this._authorHandler);
        context.registerChildHandler(NAMESPACE, "author-url", this._authorUrlHandler);
        context.registerChildHandler(NAMESPACE, "description", this._descriptionHandler);
        context.registerChildHandler(NAMESPACE, "requirements", this._requirementsHandler);
        context.registerChildHandler(NAMESPACE, "bundle-url", this._bundleUrlHandler);
        context.registerChildHandler(NAMESPACE, "destination", this._destinationHandler);
        context.registerChildHandler(NAMESPACE, "post-startup-hook", this._postStartupHookHandler);
    }

    abstract void handleUpdate(ElementContext var1, UpdateInfo var2);

    public void handleEnd(ElementEndContext context) {
        this.handleUpdate((ElementContext)context, UpdateHandler.getUpdate((ElementContext)context));
    }

    static UpdateInfo getUpdate(ElementContext context) {
        return (UpdateInfo)context.getValue(KEY_UPDATE);
    }

    static void setUpdate(ElementContext context, UpdateInfo update) {
        context.putValue(KEY_UPDATE, (Object)update);
    }

    static String getText(ElementEndContext context) {
        String text = context.getText();
        if (text == null) {
            return null;
        }
        return text.trim();
    }

    static Version parseVersion(ElementContext context, String versionString, String logMessageIfBad) {
        if (versionString == null) {
            return null;
        }
        if (!Version.isValid((String)versionString)) {
            context.getMessageReporter().error(context.getLocator(), logMessageIfBad, null);
            return null;
        }
        return new Version(versionString);
    }

    UpdateHandler() {
        this.$init$();
    }

    private static class NameHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            update.setName(UpdateHandler.getText(context));
        }

        private NameHandler() {
        }

        NameHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class VersionHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            String versionString = UpdateHandler.getText(context);
            String messageIfBad = MessageFormat.format(UpdateLrb.get("BAD_BUNDLE_VERSION"), update.getID(), versionString);
            update.setVersion(UpdateHandler.parseVersion((ElementContext)context, versionString, messageIfBad));
        }

        private VersionHandler() {
        }

        VersionHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class AuthorHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            update.setAuthor(UpdateHandler.getText(context));
        }

        private AuthorHandler() {
        }

        AuthorHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class AuthorUrlHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            update.setAuthorURL(UpdateHandler.getText(context));
        }

        private AuthorUrlHandler() {
        }

        AuthorUrlHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DescriptionHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            update.setDescription(UpdateHandler.getText(context));
        }

        private DescriptionHandler() {
        }

        DescriptionHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BundleUrlHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            update.setDownloadURL(UpdateHandler.getText(context));
        }

        private BundleUrlHandler() {
        }

        BundleUrlHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DestinationHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateHandler.getUpdate((ElementContext)context).setPreferredInstallLocation(UpdateHandler.getText(context));
        }

        private DestinationHandler() {
        }

        DestinationHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class PostStartupHookHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext context) {
            UpdateHandler.getUpdate((ElementContext)context).setPostStartupHookClass(UpdateHandler.getText(context));
        }

        private PostStartupHookHandler() {
        }

        PostStartupHookHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

