/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

public class DeleteFile
extends AtomicTask {
    private final File _fileToDelete;
    private File _backupFile;

    public DeleteFile(File file) {
        this._fileToDelete = file;
    }

    public void perform(TaskContext tc) throws TaskFailedException {
        String suffix = ".DeleteFile";
        File backupFile = new File(this._fileToDelete.getPath() + suffix);
        int i = 0;
        while (backupFile.exists()) {
            backupFile = new File(this._fileToDelete.getPath() + suffix + "." + ++i);
        }
        if (!this._fileToDelete.renameTo(backupFile)) {
            throw new TaskFailedException(UpdateArb.format(159, this._fileToDelete.getPath(), backupFile.getPath()));
        }
        this._backupFile = backupFile;
    }

    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._fileToDelete.exists()) {
            throw new TaskFailedException("Unable to restore original file " + this._fileToDelete + " because a new file exists in its place.");
        }
        if (!this._backupFile.renameTo(this._fileToDelete)) {
            throw new TaskFailedException("Failed to restore deleted file " + this._fileToDelete + ": a backup is in " + this._backupFile);
        }
    }

    public void commit(TaskContext tc) throws TaskFailedException {
        if (!this._backupFile.delete()) {
            throw new TaskFailedException("Backup file " + this._backupFile + " could not be deleted.");
        }
    }
}

