/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.CreateFile;
import oracle.ideimpl.webupdate.task.ReadPropertiesFile;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.task.TaskStack;
import oracle.ideimpl.webupdate.task.WritePropertiesFile;

public class ScheduleHookTask
extends AtomicTask {
    private static final String KEY_HOOK_CLASS = "hookClass";
    private static final String KEY_HOOK_REGISTRY_FILE = "hookRegistry";
    private TaskStack _tasks;

    public ScheduleHookTask() {
    }

    public ScheduleHookTask(String hookClass, String hookRegistryFile) {
        this.getProperties().putString(KEY_HOOK_CLASS, hookClass);
        this.getProperties().putString(KEY_HOOK_REGISTRY_FILE, hookRegistryFile);
    }

    public void perform(TaskContext tc) throws TaskFailedException {
        this._tasks = new TaskStack();
        String hookClass = this.getProperties().getString(KEY_HOOK_CLASS);
        String hookRegistryFile = this.getProperties().getString(KEY_HOOK_REGISTRY_FILE);
        File regFile = new File(hookRegistryFile);
        if (!regFile.exists()) {
            this._tasks.performTask(new CreateFile(regFile), tc);
        }
        ReadPropertiesFile readProperties = new ReadPropertiesFile(regFile);
        this._tasks.performTask(readProperties, tc);
        Properties originalProperties = readProperties.getLoadedProperties();
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)originalProperties);
        newProperties.put(hookClass, "");
        this._tasks.performTask(new WritePropertiesFile(regFile, originalProperties, newProperties), tc);
    }

    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks == null) {
            throw new IllegalStateException("Cannot rollback");
        }
        this._tasks.rollbackTasks(tc);
    }

    public void commit(TaskContext tc) throws TaskFailedException {
        this._tasks.commitTasks(tc);
    }
}

