/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.javatools.util.Pair;

final class UnzipTask
extends AtomicTask {
    private static final Logger LOG = Logger.getLogger(UnzipTask.class.getName());
    private final File _zipFile;
    private final File _destinationDir;
    private final ArrayList _backedUpFiles;
    private final ArrayList _createdDirectories;
    private final ArrayList _createdFiles;
    private final ArrayList _skipPatterns;
    private final ArrayList _skipEntries;

    private void $init$() {
        this._backedUpFiles = new ArrayList();
        this._createdDirectories = new ArrayList();
        this._createdFiles = new ArrayList();
        this._skipPatterns = new ArrayList();
        this._skipEntries = new ArrayList();
    }

    UnzipTask(File zipFile, File destinationDir) {
        this.$init$();
        this._zipFile = zipFile;
        this._destinationDir = destinationDir;
    }

    void addSkipPattern(String regexp) {
        this._skipPatterns.add(Pattern.compile(regexp.toLowerCase()));
    }

    private void addSkipEntry(String skipEntry) {
        this._skipEntries.add(skipEntry.toLowerCase());
    }

    private boolean isSkipped(ZipEntry entry) {
        String name = entry.getName().toLowerCase();
        if (this._skipEntries.contains(name = name.replace('\\', '/'))) {
            return true;
        }
        for (Pattern p : this._skipPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private void processPatchManifest(TaskContext tc, ZipFile zip) {
        try {
            ZipEntry entry = zip.getEntry("META-INF/ofcp-patch.mf");
            if (entry == null) {
                return;
            }
            HashMap patchManifestEntries = new HashMap();
            this.loadManifest(zip, entry, patchManifestEntries);
            HashMap<String, Boolean> extensionExistMap = new HashMap<String, Boolean>();
            for (Map.Entry e : patchManifestEntries.entrySet()) {
                String extId = (String)e.getKey();
                Boolean b = (Boolean)extensionExistMap.get(extId);
                if (b == null) {
                    b = this.isExtensionInstalled(tc, extId);
                    extensionExistMap.put(extId, b);
                }
                if (b.booleanValue()) continue;
                LOG.fine("Extension " + extId + " is not installed.");
                List values = (List)e.getValue();
                for (String skipEntry : values) {
                    LOG.fine("  Skipping zip entry " + skipEntry);
                    this.addSkipEntry(skipEntry);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void loadManifest(ZipFile zip, ZipEntry entry, Map patchManifestEntries) throws IOException {
        String extensionId = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
            String line = reader.readLine();
            while (line != null) {
                if (line.endsWith(":")) {
                    if (line.length() > 1) {
                        extensionId = line.substring(0, line.length() - 2);
                        if (patchManifestEntries.get(extensionId) == null) {
                            patchManifestEntries.put(extensionId, new ArrayList());
                        }
                    } else {
                        LOG.severe("Bad line in META-INF/ofcp-patch.mf: " + line);
                    }
                } else if (extensionId == null) {
                    LOG.severe("File entry before extension id in META-INF/ofcp-patch.mf: " + line);
                } else {
                    List entries = (List)patchManifestEntries.get(extensionId);
                    entries.add(line);
                }
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private boolean isExtensionInstalled(TaskContext tc, String extensionId) {
        String extHomeGlobal = tc.getDirectories().getGlobalExtensionsHome();
        File f = new File(extHomeGlobal);
        String[] files = f.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].startsWith(extensionId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(TaskContext tc) throws TaskFailedException {
        ZipFile zip;
        try {
            zip = new ZipFile(this._zipFile);
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format(140, this._zipFile.getPath()));
        }
        this.processPatchManifest(tc, zip);
        try {
            int i = 0;
            Random random = new Random();
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                double pctProgress = (double)i / (double)zip.size();
                tc.getProgress().setPercentProgress(pctProgress);
                ++i;
                this.pause();
                if (this.isSkipped(entry)) continue;
                File outFile = new File(this._destinationDir + File.separator + entry.getName());
                if (outFile.exists() && !outFile.isDirectory()) {
                    if (!tc.confirmOverwrite(outFile)) {
                        throw new TaskFailedException(UpdateArb.getString(45));
                    }
                    File backupFile = new File(outFile + ".backup");
                    while (backupFile.exists()) {
                        int suffix = random.nextInt(99999);
                        backupFile = new File(outFile + ".backup." + suffix);
                    }
                    if (!outFile.renameTo(backupFile)) throw new TaskFailedException(UpdateArb.format(41, outFile.getPath(), backupFile.getPath()));
                    this._backedUpFiles.add(new Pair((Object)outFile, (Object)backupFile));
                } else if (!outFile.exists() && entry.isDirectory() && !this.mkdirs(outFile)) {
                    throw new TaskFailedException(UpdateArb.format(37, outFile.getPath()));
                }
                if (entry.isDirectory()) continue;
                if (!this.mkdirs(outFile.getParentFile())) {
                    throw new TaskFailedException(UpdateArb.format(37, outFile.getParentFile().getPath()));
                }
                try {
                    if (!outFile.createNewFile()) throw new IOException("createNewFile() returned false.");
                    this._createdFiles.add(outFile);
                }
                catch (IOException ioe) {
                    throw new TaskFailedException(UpdateArb.format(35, outFile.getPath()), ioe);
                }
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(outFile);
                        this.copy(zip.getInputStream(entry), fos);
                    }
                    catch (IOException ioe) {
                        throw new TaskFailedException(UpdateArb.format(104, outFile.getPath()), ioe);
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }
            tc.getProgress().setPercentProgress(1.0);
            LOG.log(Level.FINE, "Extracted " + this._zipFile + " to " + this._destinationDir);
            return;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead;
        while ((bytesRead = is.read(buffer)) >= 0) {
            os.write(buffer, 0, bytesRead);
        }
        return;
    }

    private boolean mkdirs(File dir) {
        boolean result;
        if (dir.isDirectory()) {
            return true;
        }
        File parentDir = dir.getParentFile();
        if (!parentDir.exists() && !(result = this.mkdirs(parentDir))) {
            return false;
        }
        if (dir.mkdir()) {
            this._createdDirectories.add(dir);
            return true;
        }
        return false;
    }

    public void rollback(TaskContext tc) throws TaskFailedException {
        for (File file : this._createdFiles) {
            if (file.delete()) continue;
            throw new TaskFailedException(UpdateArb.format(152, file.getPath()));
        }
        Collections.reverse(this._createdDirectories);
        for (File file : this._createdDirectories) {
            if (file.delete()) continue;
            throw new TaskFailedException(UpdateArb.format(152, file.getPath()));
        }
        for (Pair p : this._backedUpFiles) {
            File original = (File)p.getFirst();
            File backup = (File)p.getSecond();
            if (backup.renameTo(original)) continue;
            throw new TaskFailedException(UpdateArb.format(0, backup.getPath(), original.getPath()));
        }
    }
}

