/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

public class WritePropertiesFile
extends AtomicTask {
    private final File _file;
    private final Properties _oldProperties;
    private final Properties _newProperties;
    private boolean _wrote;

    public WritePropertiesFile(File file, Properties oldProps, Properties newProps) {
        this._file = file;
        this._oldProperties = oldProps;
        this._newProperties = newProps;
    }

    public void perform(TaskContext tc) throws TaskFailedException {
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(this._file);
                this._newProperties.store(os, "");
                this._wrote = true;
            }
            catch (IOException ioe) {
                throw new TaskFailedException("Failed to write properties file " + this._file);
            }
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ioe) {
                    throw new TaskFailedException("Failed to write properties file " + this._file);
                }
            }
        }
    }

    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._wrote) {
            FileOutputStream os = null;
            try {
                try {
                    os = new FileOutputStream(this._file);
                    this._oldProperties.store(os, "");
                    this._wrote = false;
                }
                catch (IOException ioe) {
                    throw new TaskFailedException("Failed to write properties file " + this._file);
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ioe) {
                        throw new TaskFailedException("Failed to write properties file " + this._file);
                    }
                }
            }
        }
    }
}

