/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.panels.TraversableContext;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;

public final class SummaryPage
extends UpdateWizardPage {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JScrollPane m_summaryScroller = new JScrollPane();
    private JLabel m_finishLabel = new JLabel();
    private JTree m_summaryTree = new JTree();

    public SummaryPage() {
        this.jbInit();
    }

    private void jbInit() {
        this.m_summaryTree.setRootVisible(false);
        this.m_summaryTree.setShowsRootHandles(true);
        this.m_summaryTree.setCellRenderer(new Renderer(null));
        this.setLayout(this.gridBagLayout1);
        this.m_summaryScroller.setPreferredSize(new Dimension(0, 0));
        this.m_finishLabel.setText(UpdateArb.getString(90));
        this.m_summaryScroller.getViewport().add((Component)this.m_summaryTree, null);
        this.add(this.m_summaryScroller, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_finishLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected boolean canGoBack() {
        return false;
    }

    public boolean isComplete() {
        return false;
    }

    public boolean canFinish() {
        return true;
    }

    public Component getInitialFocus() {
        return this.m_summaryTree;
    }

    private DefaultMutableTreeNode createNode(UpdateInfo info) {
        return new DefaultMutableTreeNode(UpdateArb.format(165, info.getName(), info.getVersion().toString()));
    }

    private DefaultMutableTreeNode createNewExtensionsNode() {
        return new DefaultMutableTreeNode(UpdateArb.getString(60));
    }

    private DefaultMutableTreeNode createUpgradedExtensionsNode() {
        return new DefaultMutableTreeNode(UpdateArb.getString(80));
    }

    protected void pageSelected(TraversableContext context) {
        this.completeValueChanged();
        if (context.getDirection() == 1) {
            Map downloadedUpdates;
            boolean haveUpdates = false;
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
            DefaultTreeModel model = new DefaultTreeModel(root);
            Set<UpdateBundle> bundles = null;
            bundles = this.getModel(context).getLocalBundle() != null ? Collections.singleton(this.getModel(context).getLocalBundle().getBundle()) : ((downloadedUpdates = this.getModel(context).getDownloadedUpdates()) == null ? null : downloadedUpdates.keySet());
            DefaultMutableTreeNode newExtensions = null;
            DefaultMutableTreeNode upgExtensions = null;
            if (bundles != null) {
                for (UpdateBundle bundle : bundles) {
                    for (UpdateInfo update : bundle.getUpdates()) {
                        if (update.isNew()) {
                            if (newExtensions == null) {
                                newExtensions = this.createNewExtensionsNode();
                                root.add(newExtensions);
                            }
                            newExtensions.add(this.createNode(update));
                        } else {
                            if (upgExtensions == null) {
                                upgExtensions = this.createUpgradedExtensionsNode();
                                root.add(upgExtensions);
                            }
                            upgExtensions.add(this.createNode(update));
                        }
                        haveUpdates = true;
                    }
                }
            }
            if (!haveUpdates) {
                root.add(new DefaultMutableTreeNode(UpdateArb.getString(178)));
            }
            this.m_summaryTree.setModel(model);
            int row = 0;
            while (row < this.m_summaryTree.getRowCount()) {
                this.m_summaryTree.expandRow(row);
                ++row;
            }
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            return c;
        }

        private Renderer() {
        }

        Renderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

