/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.URLHyperlinkButton;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;

final class UpdateInfoPanel
extends JPanel {
    private final JLabel _updateName;
    private final JLabel _creatorName;
    private final URLHyperlinkButton _creatorUrl;
    private final JLabel _descriptionLabel;
    private final JTextArea _descriptionArea;
    private final JLabel _infoLabel;

    private void $init$() {
        this._updateName = new JLabel();
        this._creatorName = new JLabel();
        this._creatorUrl = new URLHyperlinkButton();
        this._descriptionLabel = new JLabel();
        this._descriptionArea = new JTextArea();
        this._infoLabel = new JLabel();
    }

    UpdateInfoPanel() {
        this.$init$();
        this._descriptionArea.setRows(5);
        this._descriptionArea.setColumns(40);
        this._descriptionArea.setEditable(false);
        this._descriptionArea.setOpaque(false);
        this._descriptionArea.setLineWrap(true);
        this._descriptionArea.setWrapStyleWord(true);
        this.resControls();
        this.layoutControls();
    }

    private void resControls() {
        ResourceUtils.resLabel((JLabel)this._descriptionLabel, (Component)this._descriptionArea, (String)UpdateArb.getString(134));
        ResourceUtils.resButton((AbstractButton)this._creatorUrl, (String)UpdateArb.getString(84));
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._updateName, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._creatorName, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this._creatorUrl, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._descriptionLabel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JScrollPane(this._descriptionArea), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this._infoLabel, gbc);
    }

    public void setUpdate(UpdateInfo update) {
        this._updateName.setText(UpdateArb.format(18, update.getName(), update.getVersion()));
        this._creatorUrl.setVisible((update.getAuthorURL() == null || update.getAuthorURL().trim().length() == 0 || "null".equals(update.getAuthorURL())) ^ true);
        if (update.getAuthorURL() != null) {
            this._creatorUrl.setURL(URLFactory.newURL((String)update.getAuthorURL()));
        }
        this._creatorName.setText(UpdateArb.format(4, update.getAuthor()));
        if (update.getType() == UpdateInfo.Type.EXTENSION) {
            if (update.isNew()) {
                this._infoLabel.setText(UpdateArb.getString(168));
            } else {
                Extension currentExtension = ExtensionRegistry.getExtensionRegistry().findExtension(update.getID());
                this._infoLabel.setText(UpdateArb.format(181, currentExtension.getName(), currentExtension.getVersion()));
            }
        } else {
            this._infoLabel.setText(UpdateArb.getString(123));
        }
        this._descriptionArea.setText(update.getDescription());
    }

    public void runDialog(Component parent, UpdateInfo update) {
        JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)UpdateArb.format(2, update.getName()), (int)1);
        jd.setContent((Component)this);
        jd.setOKButtonText(UpdateArb.getString(70));
        jd.setInitialFocus((Component)this._descriptionArea);
        this.setUpdate(update);
        jd.runDialog();
    }
}

