/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.dialogs.ExceptionDialog;

final class UpdateLicensePage
extends UpdateWizardPage {
    private final JMultiLineLabel _hintText;
    private final JLabel _title;
    private final JEditorPane _licensePane;
    private final JScrollPane _licenseScroll;
    private final JButton _agree;
    private List _updates;
    private int _listPos;
    private boolean _errorOccurred;

    private void $init$() {
        this._hintText = new JMultiLineLabel();
        this._title = new JLabel();
        this._licensePane = new JEditorPane();
        this._licenseScroll = new JScrollPane();
        this._agree = new JButton();
        this._errorOccurred = false;
    }

    UpdateLicensePage() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        this._licenseScroll.getViewport().add(this._licensePane);
        this._licensePane.setEditable(false);
    }

    private void resControls() {
        this._hintText.setText(UpdateArb.getString(79));
        ResourceUtils.resLabel((JLabel)this._title, (Component)this._licensePane, (String)UpdateArb.getString(151));
        ResourceUtils.resButton((AbstractButton)this._agree, (String)UpdateArb.getString(173));
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = UpdateWizardPage.INSETS_HINT;
        this.add((Component)this._hintText, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add(this._title, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add(this._licenseScroll, gbc);
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        this.add(this._agree, gbc);
    }

    private void installListeners() {
        this._agree.addActionListener(new Listener(null));
    }

    public Component getInitialFocus() {
        return this._agree;
    }

    protected void pageSelected(TraversableContext context) {
        context.getWizardCallbacks().wizardUpdateExpectedTransition(this.getExitTransition());
        this._agree.setEnabled(false);
        this._errorOccurred = false;
        if (context.getDirection() == 1) {
            try {
                this._hintText.setText(UpdateArb.getString(79));
                this._licenseScroll.setVisible(true);
                this._title.setVisible(true);
                this._agree.setVisible(true);
                this._updates = this.getModel(context).getUpdatesRequiringAgreement();
                this.selectUpdate(0);
            }
            catch (Throwable t) {
                t.printStackTrace();
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)t);
                this.error(UpdateArb.format(130, t instanceof NullPointerException ? UpdateArb.getString(112) : t.getLocalizedMessage()));
                this._errorOccurred = true;
            }
            this.completeValueChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectUpdate(int listIndex) {
        URL url;
        String centerUrl;
        int lastSlash;
        String updateUrl;
        this._agree.setEnabled(false);
        if (listIndex >= this._updates.size()) {
            this.completeValueChanged();
            this._hintText.setText(UpdateArb.getString(102));
            this._licenseScroll.setVisible(false);
            this._title.setVisible(false);
            this._agree.setVisible(false);
            this.invalidate();
            this.validate();
            return;
        }
        this._listPos = listIndex;
        UpdateInfo update = (UpdateInfo)this._updates.get(listIndex);
        if (this._updates.size() == 1) {
            ResourceUtils.resLabel((JLabel)this._title, (Component)this._licensePane, (String)UpdateArb.format(162, new Object[]{update.getName(), update.getVersion()}));
        } else {
            ResourceUtils.resLabel((JLabel)this._title, (Component)this._licensePane, (String)UpdateArb.format(149, new Object[]{update.getName(), update.getVersion(), String.valueOf(listIndex + 1), String.valueOf(this._updates.size())}));
        }
        if (this.getModel(this.getTraversableContext()).getLocalBundle() != null && update.getClickThroughURL() != null && update.getClickThroughURL().indexOf(58) == -1) {
            try {
                String licenseText = this.getModel(this.getTraversableContext()).getLocalBundle().getContent(update.getClickThroughURL());
                if (update.getClickThroughURL().toLowerCase().indexOf("htm") == -1) {
                    this._licensePane.setContentType("text/plain");
                } else {
                    this._licensePane.setContentType("text/html");
                }
                this._licensePane.setText(licenseText);
                this._licensePane.setCaretPosition(0);
                if (this._licensePane.getText().trim().length() == 0) {
                    this.error(update, UpdateArb.getString(150));
                    return;
                }
                this._agree.setEnabled(true);
                return;
            }
            catch (Exception e) {
                this.error(update, UpdateArb.format(89, update.getClickThroughURL()));
            }
        }
        if ((updateUrl = update.getClickThroughURL()).indexOf(58) == -1 && update.getSourceCenter() != null && (lastSlash = (centerUrl = update.getSourceCenter().getURL()).lastIndexOf(47)) > 1) {
            updateUrl = centerUrl.substring(0, lastSlash + 1) + updateUrl;
        }
        if ((url = URLFactory.newURL((String)updateUrl)) == null) {
            this.error(update, UpdateArb.format(114, update.getClickThroughURL()));
            return;
        }
        HttpURLConnection connection = null;
        try {
            try {
                connection = (HttpURLConnection)url.openConnection();
                int responseCode = connection.getResponseCode();
                if (responseCode < 200 || responseCode > 299) {
                    if (responseCode == 404) {
                        this.error(update, UpdateArb.format(89, url));
                        return;
                    }
                    this.error(update, UpdateArb.format(101, String.valueOf(responseCode), url));
                }
                this._licensePane.setPage(url);
                this._agree.setEnabled(true);
                return;
            }
            finally {
                if (connection == null) return;
                connection.disconnect();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error(update, ioe.getMessage());
            return;
        }
    }

    public Object getExitTransition() {
        UpdateWizardModel model = this.getModel(this.getTraversableContext());
        UpdatePageConditions state = model.getConditions();
        if (state.isSingleUser()) {
            if (state.isLocal()) {
                return "licenseToSummary";
            }
            return "licenseToDownload";
        }
        return "licenseToDlLocation";
    }

    public boolean isComplete() {
        if (this._errorOccurred) {
            return false;
        }
        return this.getModel(this.getTraversableContext()).getUpdatesRequiringAgreement().isEmpty();
    }

    private void error(String message) {
        this.error(null, message);
    }

    private void error(UpdateInfo update, String message) {
        if (update != null) {
            this._hintText.setText(UpdateArb.format(55, update.getName(), message));
        } else {
            this._hintText.setText(message);
        }
        this._licenseScroll.setVisible(false);
        this._title.setVisible(false);
        this._agree.setVisible(false);
    }

    static List ra$_updates(UpdateLicensePage updateLicensePage) {
        return updateLicensePage._updates;
    }

    static int ra$_listPos(UpdateLicensePage updateLicensePage) {
        return updateLicensePage._listPos;
    }

    static void mav$selectUpdate(UpdateLicensePage updateLicensePage, int n) {
        updateLicensePage.selectUpdate(n);
    }

    private class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            UpdateInfo update = (UpdateInfo)UpdateLicensePage.ra$_updates(UpdateLicensePage.this).get(UpdateLicensePage.ra$_listPos(UpdateLicensePage.this));
            UpdateLicensePage.this.getModel(UpdateLicensePage.this.getTraversableContext()).setLicenseAgreed(update, true);
            UpdateLicensePage.mav$selectUpdate(UpdateLicensePage.this, UpdateLicensePage.ra$_listPos(UpdateLicensePage.this) + 1);
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

