/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.ideimpl.webupdate.parser.Problems;
import oracle.ideimpl.webupdate.wizard.UpdateCenterPanel;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.icons.OracleIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UpdateSourcePage
extends UpdateWizardPage {
    private final JMultiLineLabel _lbHint;
    private final JRadioButton _rbUpdateCenter;
    private final NiceList _lstUpdateCenters;
    private final JButton _btnAddCenter;
    private final JButton _btnRemoveCenter;
    private final JButton _btnEditCenter;
    private final JRadioButton _rbLocalFile;
    private final JLabel _lbFileName;
    private final URLTextField _tfLocalFileName;
    private final JButton _btnBrowse;
    private final JPanel _panProgress;
    private final JProgressBar _pbUpdates;
    private final JLabel _lbProgress;
    private final JLabel _lbError;
    private final HyperlinkButton _hlError;
    private final GridBagLayout _layout;
    private SimpleListModel _listModel;
    private boolean _checkedMasterList;
    private boolean _firstTime;
    private boolean _firstTimeForAutoupdate;
    private transient CheckMasterListRunnable _masterListChecker;
    private ActionListener _errorDetailsListener;
    private transient LocalUpdateBundle _localBundle;
    private boolean _isSaved;

    private void $init$() {
        this._lbHint = new JMultiLineLabel();
        this._rbUpdateCenter = new JRadioButton();
        this._lstUpdateCenters = new NiceList();
        this._btnAddCenter = new JButton();
        this._btnRemoveCenter = new JButton();
        this._btnEditCenter = new JButton();
        this._rbLocalFile = new JRadioButton();
        this._lbFileName = new JLabel();
        this._tfLocalFileName = new 1();
        this._btnBrowse = new JButton();
        this._panProgress = new JPanel();
        this._pbUpdates = new JProgressBar();
        this._lbProgress = new JLabel();
        this._lbError = new JLabel();
        this._hlError = new HyperlinkButton();
        this._layout = new GridBagLayout();
        this._checkedMasterList = false;
        this._firstTime = true;
        this._firstTimeForAutoupdate = true;
        this._masterListChecker = null;
        this._isSaved = false;
    }

    UpdateSourcePage() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        2 renderer = new 2();
        renderer.setGradientColor(IdeUIManager.getActiveTitleGradientLightColor(), IdeUIManager.getActiveTitleGradientDarkColor());
        this._lstUpdateCenters.setCellRenderer((ListCellRenderer)((Object)renderer));
        this._lstUpdateCenters.setFireCheckboxActionOnDoubleClick(true);
        this._lstUpdateCenters.setSelectionMode(0);
        this._tfLocalFileName.setValidateExistingFile(true);
    }

    private void resControls() {
        this._lbHint.setText(UpdateArb.getString(32));
        ResourceUtils.resButton((AbstractButton)this._rbUpdateCenter, (String)UpdateArb.getString(138));
        ResourceUtils.resButton((AbstractButton)this._btnAddCenter, (String)UpdateArb.getString(174));
        ResourceUtils.resButton((AbstractButton)this._btnEditCenter, (String)UpdateArb.getString(75));
        ResourceUtils.resButton((AbstractButton)this._btnRemoveCenter, (String)UpdateArb.getString(110));
        ResourceUtils.resButton((AbstractButton)this._rbLocalFile, (String)UpdateArb.getString(148));
        ResourceUtils.resLabel((JLabel)this._lbFileName, (Component)this._tfLocalFileName, (String)UpdateArb.getString(58));
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)UpdateArb.getString(67));
        this._pbUpdates.setIndeterminate(true);
        this._tfLocalFileName.setDirectoryOnly(false);
        this._tfLocalFileName.setChooserInit((URLChooserInit)new 3());
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = UpdateWizardPage.INSETS_HINT;
        this.add((Component)this._lbHint, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add(this._rbUpdateCenter, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 24, 5, 0);
        this.add(new JScrollPane((Component)this._lstUpdateCenters), gbc);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setOrientation(1);
        buttonBar.setAlignment(1);
        buttonBar.add((Component)this._btnAddCenter);
        buttonBar.add((Component)this._btnRemoveCenter);
        buttonBar.add((Component)this._btnEditCenter);
        gbc.gridx += 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 5, 0);
        this.add((Component)buttonBar, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 24, 5, 0);
        this._panProgress.setLayout(new BorderLayout(5, 0));
        this._panProgress.setVisible(false);
        this.add(this._panProgress, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 3;
        gbc.fill = 0;
        gbc.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add(this._rbLocalFile, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 24, 0, 12);
        this.add(this._lbFileName, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = UpdateWizardPage.INSETS_ZERO;
        this.add((Component)this._tfLocalFileName, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.add(this._btnBrowse, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._rbUpdateCenter);
        bg.add(this._rbLocalFile);
    }

    private void installListeners() {
        Listener l = new Listener(null);
        this._rbUpdateCenter.addActionListener(l);
        this._rbLocalFile.addActionListener(l);
        this._btnBrowse.addActionListener(l);
        this._btnAddCenter.addActionListener(l);
        this._btnEditCenter.addActionListener(l);
        this._btnRemoveCenter.addActionListener(l);
        this._tfLocalFileName.getDocument().addDocumentListener(l);
        this._lstUpdateCenters.getSelectionModel().addListSelectionListener(l);
        this._lstUpdateCenters.addListActionListener((NiceListActionListener)l);
        this._lstUpdateCenters.addKeyListener((KeyListener)l);
        this._rbUpdateCenter.setSelected(true);
        this.updateEnabledControls();
    }

    @Override
    public boolean isComplete() {
        if (this._rbUpdateCenter.isSelected()) {
            if (this._masterListChecker != null && this._masterListChecker.isRunning()) {
                return false;
            }
            int i = 0;
            while (i < this._lstUpdateCenters.getModel().getSize()) {
                UpdateCenter center = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(i);
                if (center.isEnabled()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this._tfLocalFileName.getText().trim().length() > 0;
    }

    @Override
    public Component getInitialFocus() {
        return this._rbUpdateCenter;
    }

    @Override
    public void pageSelected(TraversableContext context) {
        this._isSaved = false;
        if (this._firstTimeForAutoupdate && this.getModel(context).isSourceSkipped()) {
            SwingUtilities.invokeLater(new 4());
            this._firstTimeForAutoupdate = false;
            return;
        }
        if (this._firstTime) {
            this._listModel = new SimpleListModel(this.getModel(context).getAllUpdateCenters());
            this._lstUpdateCenters.setModel((ListModel)this._listModel);
            this._firstTime = false;
        }
        if (!this._checkedMasterList) {
            this.checkMasterList(context);
            this._checkedMasterList = true;
        }
        this.defaultLocalFilename();
    }

    private void defaultLocalFilename() {
        if (this._tfLocalFileName.getText().trim().length() > 0) {
            return;
        }
        URL lastLocalBundle = WebUpdateAddin.getPreferences().getLastLocalBundleURL();
        if (lastLocalBundle == null) {
            return;
        }
        this._tfLocalFileName.setURL(lastLocalBundle);
    }

    private void storeLocalFilename() {
        if (this._tfLocalFileName.getText().trim().length() == 0) {
            return;
        }
        URL url = this._tfLocalFileName.getURL();
        if (url == null) {
            return;
        }
        WebUpdateAddin.getPreferences().setLastLocalBundleURL(url);
    }

    private void checkMasterList(TraversableContext context) {
        this._masterListChecker = new 5(this, this.getModel(context).getUpdateManager().getMasterServerURL(), context);
        ProgressMonitor monitor = new ProgressMonitor(null);
        this._masterListChecker.setMonitor(monitor);
        Thread t = new Thread((Runnable)this._masterListChecker, "Update Master List Checker");
        t.start();
    }

    private boolean proxyPrompt() {
        ProxyOptions options = ProxyOptions.getProxyOptions();
        ProxySettingsPanel psp = new ProxySettingsPanel();
        psp.setProxyOptions(options);
        MessagePanel mp = new MessagePanel();
        mp.setMessageType(4);
        mp.setMessageText(UpdateArb.getString(39));
        mp.addMessageComponent((Component)psp);
        HelpUtils.setHelpID((JComponent)mp, (String)"f1_idewideupdatetimeout_html");
        JEWTDialog jd = JEWTDialog.createDialog((Component)((Object)this), (String)UpdateArb.getString(105), (int)7);
        jd.setContent((Component)mp);
        try {
            if (jd.runDialog()) {
                ProxyOptions.setProxyOptions((ProxyOptions)psp.getProxyOptions());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            jd.dispose();
        }
    }

    private void masterListUpdateError(TraversableContext context, Throwable t) {
        if (this.proxyPrompt()) {
            this.checkMasterList(context);
            return;
        }
        this._panProgress.removeAll();
        this._panProgress.add((Component)this._lbError, "West");
        this._panProgress.add((Component)this._hlError, "East");
        this._lbError.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._lbError.setText(UpdateArb.getString(96));
        this._hlError.setText(UpdateArb.getString(179));
        if (this._errorDetailsListener != null) {
            this._hlError.removeActionListener(this._errorDetailsListener);
        }
        this._errorDetailsListener = new ErrorDetailsListener(t);
        this._hlError.addActionListener(this._errorDetailsListener);
        this._panProgress.invalidate();
        this._panProgress.validate();
        this._panProgress.setVisible(true);
    }

    private void processMasterList(TraversableContext context, List masterListCenters) {
        UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
        masterListCenters.addAll(updateHook.getUpdateCenters());
        for (UpdateCenter masterServer : masterListCenters) {
            if (masterServer.getMasterId() == null) continue;
            UpdateCenter existingEntry = this.findCenterByMasterId(masterServer.getMasterId(), this.getModel(context).getAllUpdateCenters());
            if (existingEntry == null) {
                masterServer.setEnabled(masterServer.isSelectedByDefault());
                this._listModel.addElement((Object)masterServer);
                continue;
            }
            boolean different = false;
            if (!existingEntry.isEnabledChangedByUser()) {
                existingEntry.setEnabled(masterServer.isSelectedByDefault());
            }
            if (!existingEntry.getURL().equals(masterServer.getURL())) {
                existingEntry.setURL(masterServer.getURL());
                different = true;
            }
            if (!existingEntry.getName().equals(masterServer.getName())) {
                existingEntry.setName(masterServer.getName());
                different = true;
            }
            if (existingEntry.isProtected() != masterServer.isProtected()) {
                existingEntry.setProtected(masterServer.isProtected());
                different = true;
            }
            if (!different) continue;
            int index = this.getModel(context).getAllUpdateCenters().indexOf(existingEntry);
            this._listModel.changed(index);
        }
        ArrayList<UpdateCenter> serversToRemove = new ArrayList<UpdateCenter>();
        for (UpdateCenter localServer : this.getModel(context).getAllUpdateCenters()) {
            UpdateCenter masterEntry;
            if (localServer.getMasterId() == null || (masterEntry = this.findCenterByMasterId(localServer.getMasterId(), masterListCenters)) != null) continue;
            serversToRemove.add(localServer);
        }
        Iterator i = serversToRemove.iterator();
        while (i.hasNext()) {
            this._listModel.removeElement(i.next());
        }
    }

    private UpdateCenter findCenterByMasterId(String masterId, List centers) {
        for (UpdateCenter thisCenter : centers) {
            if (!masterId.equals(thisCenter.getMasterId())) continue;
            return thisCenter;
        }
        return null;
    }

    private boolean haveLicenseAgreement(UpdateBundle bundle) {
        if (bundle == null) {
            return false;
        }
        for (UpdateInfo update : bundle.getUpdates()) {
            if (update.getClickThroughURL() == null) continue;
            return true;
        }
        return false;
    }

    public Object getExitTransition() {
        try {
            this.doSave(this.getTraversableContext());
            UpdateWizardModel model = this.getModel(this.getTraversableContext());
            UpdatePageConditions state = new UpdatePageConditions(this._rbLocalFile.isSelected(), this._rbLocalFile.isSelected() && model.getLocalBundle() != null && this.haveLicenseAgreement(model.getLocalBundle().getBundle()), this._rbLocalFile.isSelected() ? model.getLocalBundle().getBundle().getUpdates() : Collections.EMPTY_SET);
            if (state.isLocal()) {
                if (state.isLicense()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToLicence");
                    String string = "sourceToLicence";
                    return string;
                }
                if (state.isSingleUser()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToSummary");
                    String string = "sourceToSummary";
                    return string;
                }
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToDlLocation");
                String string = "sourceToDlLocation";
                return string;
            }
            Object var7_6 = null;
            return var7_6;
        }
        catch (TraversalException te) {
            Object var8_8 = null;
            return var8_8;
        }
    }

    private void doSave(TraversableContext context) throws TraversalException {
        if (!this._isSaved) {
            if (!this.doValidation(context)) {
                throw new TraversalException(null);
            }
            this.save(context);
            this._isSaved = true;
        }
    }

    @Override
    public final void onExit(TraversableContext context) throws TraversalException {
        this.doSave(context);
        this.pageDeselected(context);
    }

    @Override
    public void save(TraversableContext context) {
        try {
            UpdateManager.getInstance().setUpdateCenters(this.getModel(context).getAllUpdateCenters());
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
        if (this._rbLocalFile.isSelected()) {
            this.getModel(context).setLocalBundle(this._localBundle);
        } else {
            this.getModel(context).setLocalBundle(null);
        }
    }

    @Override
    public boolean doValidation(TraversableContext context) {
        if (context.getDirection() == 2) {
            return true;
        }
        if (this._rbLocalFile.isSelected()) {
            return this.validateLocalBundle();
        }
        return true;
    }

    private boolean validateLocalBundle() {
        this.storeLocalFilename();
        URL theURL = this._tfLocalFileName.getURL();
        if (theURL != null && "file".equals(theURL.getProtocol())) {
            File f = new File(URLFileSystem.getPlatformPathName((URL)theURL));
            try {
                this._localBundle = LocalUpdateBundle.createInstance(f);
                if (this._localBundle.getBundle().getUpdates().size() == 0) {
                    MessageDialog.error((Component)((Object)this), (Object)UpdateArb.getString(17), (String)UpdateArb.getString(19), null);
                    boolean bl = false;
                    return bl;
                }
                ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
                for (UpdateInfo update : this._localBundle.getBundle().getUpdates()) {
                    boolean result;
                    boolean result2;
                    if (!this.validateUpdateDependencies(update)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (update.isNew()) continue;
                    Version currentVersion = extReg.findExtension(update.getID()).getVersion();
                    Version newVersion = update.getVersion();
                    int diff = newVersion.compareTo(currentVersion);
                    if (diff == 0 && !(result2 = MessageDialog.confirm((Component)((Object)this), (Object)UpdateArb.format(147, newVersion.toString(), update.getName()), (String)UpdateArb.getString(137), null, (boolean)false, (String)UpdateArb.getString(1), (String)UpdateArb.getString(63)))) {
                        boolean bl = false;
                        return bl;
                    }
                    if (diff >= 0 || (result = MessageDialog.confirm((Component)((Object)this), (Object)UpdateArb.format(74, newVersion.toString(), update.getName(), currentVersion.toString()), (String)UpdateArb.getString(93), null, (boolean)true, (String)UpdateArb.getString(177), (String)UpdateArb.getString(65)))) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (InvalidLocalBundleException nabe) {
                if (nabe.problems() != null) {
                    this.logLocalBundleProblems(theURL, nabe.problems());
                }
                MessageDialog.error((Component)((Object)this), (Object)nabe.getMessage(), (String)UpdateArb.getString(34), null);
                boolean bl = false;
                return bl;
            }
        }
        MessageDialog.error((Component)((Object)this), (Object)UpdateArb.getString(131), (String)UpdateArb.getString(11), null);
        return false;
    }

    private void logLocalBundleProblems(URL url, Problems problems) {
        LogManager logManager = LogManager.getLogManager();
        LogPage msgPage = logManager.getMsgPage();
        msgPage.log((Object)UpdateArb.format(91, URLFileSystem.getPlatformPathName((URL)url), this.descriptionsAsString(problems)));
    }

    private String descriptionsAsString(Problems problems) {
        StringBuilder sb = new StringBuilder();
        for (String s : problems.descriptions()) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    private boolean validateUpdateDependencies(UpdateInfo update) {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection requiredIds = update.getRequiredIds();
        ArrayList<String> missingIds = new ArrayList<String>();
        for (String id : requiredIds) {
            Extension extension = extReg.findExtension(id);
            if (extension == null) {
                missingIds.add(id);
                continue;
            }
            boolean compatible = CheckUpdatesRunnable.testCompatibleVersion(update, id, extension.getVersion());
            if (compatible) continue;
            missingIds.add(id);
        }
        if (!missingIds.isEmpty()) {
            TableModel model = this.createMissingDependenciesTableModel(update, missingIds);
            NiceTable table = new NiceTable(model);
            BaseMessageDialog bmd = BaseMessageDialog.createMessageDialogImpl((Component)((Object)this), (String)UpdateArb.getString(121), (int)3);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout(0, 5));
            p.add((Component)new JWrappedLabel(UpdateArb.getString(25)), "North");
            p.add((Component)new JScrollPane((Component)table), "Center");
            bmd.setMessage((Object)p);
            table.setAutoResizeMode(0);
            table.autoSizeColumnsToFit();
            table.autoSizeViewportToFit(new Dimension(100, 100), new Dimension(800, 400));
            bmd.runDialog();
            return false;
        }
        return true;
    }

    private TableModel createMissingDependenciesTableModel(UpdateInfo info, List<String> missingIds) {
        return new 1TM(this, missingIds, info);
    }

    private void addUpdateCenter() {
        UpdateCenter newCenter = UpdateCenterPanel.runCreateDialog((Component)((Object)this));
        if (newCenter != null) {
            newCenter.setEnabled(true);
            this._listModel.addElement((Object)newCenter);
            this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            this._lstUpdateCenters.ensureIndexIsVisible(this._listModel.getSize() - 1);
            this.completeValueChanged();
        }
    }

    private void removeUpdateCenter() {
        int[] sel = this._lstUpdateCenters.getSelectedIndices();
        if (sel != null && sel.length > 0) {
            int firstSel = sel[0];
            this._listModel.removeIndices(sel);
            if (this._listModel.getSize() > firstSel) {
                this._lstUpdateCenters.setSelectedIndex(firstSel);
            } else if (this._listModel.getSize() > 0) {
                this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            }
        }
    }

    private void editUpdateCenter() {
        UpdateCenter selected = (UpdateCenter)this._lstUpdateCenters.getSelectedValue();
        if (UpdateCenterPanel.runEditDialog((Component)((Object)this), selected)) {
            int selIdx = this._lstUpdateCenters.getSelectedIndex();
            this._listModel.changed(selIdx);
        }
    }

    private void updateEnabledControls() {
        boolean remote = this._rbUpdateCenter.isSelected();
        if (this.getTraversableContext() != null) {
            if (remote) {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToUpdates");
            } else {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToLicence");
            }
        }
        this._lstUpdateCenters.setEnabled(remote);
        this._lstUpdateCenters.setBackground(remote ? UIManager.getColor("window") : UIManager.getColor("control"));
        Object[] sel = this._lstUpdateCenters.getSelectedValues();
        this._btnAddCenter.setEnabled(remote);
        if (!remote || sel == null || sel.length == 0) {
            this._btnEditCenter.setEnabled(false);
            this._btnRemoveCenter.setEnabled(false);
        } else {
            if (sel.length == 1) {
                UpdateCenter center = (UpdateCenter)sel[0];
                this._btnEditCenter.setEnabled(center.isFromMasterList() ^ true);
            }
            boolean removeEnabled = true;
            int i = 0;
            while (i < sel.length) {
                UpdateCenter thisCenter = (UpdateCenter)sel[i];
                if (thisCenter.isFromMasterList()) {
                    removeEnabled = false;
                    break;
                }
                ++i;
            }
            this._btnRemoveCenter.setEnabled(removeEnabled);
        }
        this._lbFileName.setEnabled(remote ^ true);
        this._tfLocalFileName.setEnabled(remote ^ true);
        this._btnBrowse.setEnabled(remote ^ true);
    }

    private void toggleCenterEnabled(int row) {
        UpdateCenter center = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(row);
        center.setEnabled(center.isEnabled() ^ true);
        center.setEnabledChangedByUser(true);
        this._listModel.changed(row);
        this.completeValueChanged();
    }

    static void mav$toggleCenterEnabled(UpdateSourcePage updateSourcePage, int n) {
        updateSourcePage.toggleCenterEnabled(n);
    }

    static JButton ra$_btnRemoveCenter(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnRemoveCenter;
    }

    static void mav$removeUpdateCenter(UpdateSourcePage updateSourcePage) {
        updateSourcePage.removeUpdateCenter();
    }

    static void mav$updateEnabledControls(UpdateSourcePage updateSourcePage) {
        updateSourcePage.updateEnabledControls();
    }

    static JButton ra$_btnAddCenter(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnAddCenter;
    }

    static void mav$addUpdateCenter(UpdateSourcePage updateSourcePage) {
        updateSourcePage.addUpdateCenter();
    }

    static JButton ra$_btnEditCenter(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnEditCenter;
    }

    static void mav$editUpdateCenter(UpdateSourcePage updateSourcePage) {
        updateSourcePage.editUpdateCenter();
    }

    static JButton ra$_btnBrowse(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnBrowse;
    }

    static URLTextField ra$_tfLocalFileName(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._tfLocalFileName;
    }

    static JPanel ra$_panProgress(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._panProgress;
    }

    static JLabel ra$_lbProgress(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._lbProgress;
    }

    static JProgressBar ra$_pbUpdates(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._pbUpdates;
    }

    static void wa$_masterListChecker(UpdateSourcePage updateSourcePage, CheckMasterListRunnable checkMasterListRunnable) {
        updateSourcePage._masterListChecker = checkMasterListRunnable;
    }

    static void mav$processMasterList(UpdateSourcePage updateSourcePage, TraversableContext traversableContext, List list) {
        updateSourcePage.processMasterList(traversableContext, list);
    }

    static void mav$masterListUpdateError(UpdateSourcePage updateSourcePage, TraversableContext traversableContext, Throwable throwable) {
        updateSourcePage.masterListUpdateError(traversableContext, throwable);
    }

    final class 1
    extends URLTextField {
        protected URLChooser createChooser(URL url) {
            URLChooser chooser = super.createChooser(url);
            chooser.setShowJarsAsDirs(false);
            return chooser;
        }
    }

    final class 2
    extends NiceListRenderer {
        public String getTitle(Object center) {
            return ((UpdateCenter)center).getName();
        }

        public String getDescription(Object center) {
            return URLFileSystem.getPlatformPathName((URL)URLFactory.newURL((String)((UpdateCenter)center).getURL()));
        }

        public boolean isItemSelected(Object center) {
            return ((UpdateCenter)center).isEnabled();
        }
    }

    final class 3
    implements URLChooserInit {
        public void initURLChooser(URLChooser urlChooser) {
            urlChooser.clearChooseableURLFilters();
            urlChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
            WildcardURLFilter allFilesFilter = new WildcardURLFilter("*.zip", false, UpdateArb.getString(77));
            urlChooser.addChooseableURLFilter((URLFilter)allFilesFilter);
            urlChooser.setURLFilter((URLFilter)allFilesFilter);
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            UpdateSourcePage.this.getTraversableContext().getWizardCallbacks().nextPage();
        }
    }

    final class 5
    extends CheckMasterListRunnable {
        private final /* synthetic */ TraversableContext v$context;
        final /* synthetic */ UpdateSourcePage this$0;

        protected void failed(Throwable t) {
            EventQueue.invokeLater(new 1(this, t));
        }

        protected void finished(List l) {
            EventQueue.invokeLater(new 2(this, l));
        }

        public 5(UpdateSourcePage updateSourcePage, String string, TraversableContext traversableContext) {
            this.v$context = traversableContext;
            this.this$0 = updateSourcePage;
            super(string);
        }

        static TraversableContext ra$v$context(5 var0) {
            return var0.v$context;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Throwable v$t;
            final /* synthetic */ 5 this$0;

            public void run() {
                UpdateSourcePage.wa$_masterListChecker(this.this$0.this$0, null);
                UpdateSourcePage.mav$masterListUpdateError(this.this$0.this$0, 5.ra$v$context(this.this$0), this.v$t);
                this.this$0.this$0.completeValueChanged();
            }

            public 1(5 var1_1, Throwable throwable) {
                this.v$t = throwable;
                this.this$0 = var1_1;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ List v$l;
            final /* synthetic */ 5 this$0;

            public void run() {
                UpdateSourcePage.wa$_masterListChecker(this.this$0.this$0, null);
                UpdateSourcePage.mav$processMasterList(this.this$0.this$0, 5.ra$v$context(this.this$0), this.v$l);
                this.this$0.this$0.completeValueChanged();
            }

            public 2(5 var1_1, List list) {
                this.v$l = list;
                this.this$0 = var1_1;
            }
        }
    }

    class 1TM
    extends AbstractTableModel
    implements NiceTableModel {
        private final /* synthetic */ List v$missingIds;
        private final /* synthetic */ UpdateInfo v$info;
        final /* synthetic */ UpdateSourcePage this$0;

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return null;
        }

        public int getRowCount() {
            return this.v$missingIds.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String id = (String)this.v$missingIds.get(rowIndex);
            Version max = this.v$info.getRequiredMaxVersion(id);
            Version min = this.v$info.getRequiredMinVersion(id);
            Extension installed = ExtensionRegistry.getExtensionRegistry().findExtension(id);
            switch (columnIndex) {
                case 0: {
                    return id;
                }
                case 1: {
                    if (max != null && min != null) {
                        return UpdateArb.format(5, min.toString(), max.toString());
                    }
                    if (max != null) {
                        return UpdateArb.format(47, max.toString());
                    }
                    if (min != null) {
                        return UpdateArb.format(122, min.toString());
                    }
                    return "";
                }
                case 2: {
                    return installed != null ? installed.getVersion().toString() : UpdateArb.getString(132);
                }
            }
            return null;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return UpdateArb.getString(12);
                }
                case 1: {
                    return UpdateArb.getString(48);
                }
                case 2: {
                    return UpdateArb.getString(128);
                }
            }
            return "";
        }

        1TM(UpdateSourcePage updateSourcePage, List list, UpdateInfo updateInfo) {
            this.v$info = updateInfo;
            this.v$missingIds = list;
            this.this$0 = updateSourcePage;
        }
    }

    private class Listener
    implements DocumentListener,
    ActionListener,
    ListSelectionListener,
    KeyListener,
    NiceListActionListener {
        public void insertUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        public void removeUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        public void changedUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == UpdateSourcePage.ra$_btnAddCenter(UpdateSourcePage.this)) {
                UpdateSourcePage.mav$addUpdateCenter(UpdateSourcePage.this);
            } else if (src == UpdateSourcePage.ra$_btnRemoveCenter(UpdateSourcePage.this)) {
                UpdateSourcePage.mav$removeUpdateCenter(UpdateSourcePage.this);
            } else if (src == UpdateSourcePage.ra$_btnEditCenter(UpdateSourcePage.this)) {
                UpdateSourcePage.mav$editUpdateCenter(UpdateSourcePage.this);
            } else if (src == UpdateSourcePage.ra$_btnBrowse(UpdateSourcePage.this)) {
                UpdateSourcePage.ra$_tfLocalFileName(UpdateSourcePage.this).actionPerformed(ae);
            }
            UpdateSourcePage.this.completeValueChanged();
            UpdateSourcePage.mav$updateEnabledControls(UpdateSourcePage.this);
        }

        public void valueChanged(ListSelectionEvent e) {
            UpdateSourcePage.mav$updateEnabledControls(UpdateSourcePage.this);
        }

        public void keyPressed(KeyEvent ke) {
        }

        public void keyTyped(KeyEvent ke) {
        }

        public void keyReleased(KeyEvent ke) {
            if (ke.getKeyCode() == 127) {
                if (UpdateSourcePage.ra$_btnRemoveCenter(UpdateSourcePage.this).isEnabled()) {
                    UpdateSourcePage.mav$removeUpdateCenter(UpdateSourcePage.this);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public void listActionPerformed(NiceListActionEvent lae) {
            if (lae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                UpdateSourcePage.mav$toggleCenterEnabled(UpdateSourcePage.this, lae.getRow());
            }
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProgressMonitor
    implements UpdateCenterMonitor {
        public void setMessage(String message) {
            EventQueue.invokeLater(new 1(this, message));
        }

        public void setMaximum(int max) {
        }

        public void setProgress(int progress) {
        }

        public void start() {
            EventQueue.invokeLater(new 2());
        }

        public void finish() {
            EventQueue.invokeLater(new 3());
        }

        public boolean isStopped() {
            return false;
        }

        private ProgressMonitor() {
        }

        ProgressMonitor(3 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ String v$message;
            final /* synthetic */ ProgressMonitor this$0;

            public void run() {
                UpdateSourcePage.ra$_lbProgress(this.this$0.UpdateSourcePage.this).setText(this.v$message);
                UpdateSourcePage.ra$_panProgress(this.this$0.UpdateSourcePage.this).invalidate();
                UpdateSourcePage.ra$_panProgress(this.this$0.UpdateSourcePage.this).validate();
            }

            public 1(ProgressMonitor progressMonitor, String string) {
                this.v$message = string;
                this.this$0 = progressMonitor;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).add((Component)UpdateSourcePage.ra$_lbProgress(UpdateSourcePage.this), "West");
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).add((Component)UpdateSourcePage.ra$_pbUpdates(UpdateSourcePage.this), "Center");
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).setVisible(true);
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).invalidate();
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).validate();
            }
        }

        final class 3
        implements Runnable {
            public void run() {
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).setVisible(false);
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).invalidate();
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).validate();
            }
        }
    }

    private class ErrorDetailsListener
    implements ActionListener {
        private final Throwable _throwable;

        ErrorDetailsListener(Throwable throwable) {
            this._throwable = throwable;
        }

        public void actionPerformed(ActionEvent ae) {
            ExceptionDialog.showExceptionDialog((Component)((Object)UpdateSourcePage.this), (Throwable)this._throwable, (String)UpdateArb.getString(97), (String)UpdateArb.format(50, Ide.getProgramShortName()), null);
        }
    }
}

