/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.task.DeinstallExtensionTask;
import oracle.ideimpl.webupdate.task.InstallExtensionTask;
import oracle.ideimpl.webupdate.task.ScheduleHookTask;
import oracle.ideimpl.webupdate.task.TaskList;
import oracle.ideimpl.webupdate.wizard.DownloadLocationPage;
import oracle.ideimpl.webupdate.wizard.DownloadPage;
import oracle.ideimpl.webupdate.wizard.SummaryPage;
import oracle.ideimpl.webupdate.wizard.UpdateLicensePage;
import oracle.ideimpl.webupdate.wizard.UpdatePage;
import oracle.ideimpl.webupdate.wizard.UpdateSourcePage;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public final class UpdateWizard {
    static final String STATE_WELCOME = "welcome";
    static final String STATE_SOURCE = "source";
    static final String STATE_UPDATE = "update";
    static final String STATE_LICENSE = "license";
    static final String STATE_DOWNLOAD_LOCATION = "downloadLocation";
    static final String STATE_DOWNLOAD = "download";
    static final String STATE_SUMMARY = "summary";
    static final String KEY_MODEL = "updateWizardModel";
    static final String TRANS_UPDATES_TO_DOWNLOAD = "updatesToDownload";
    static final String TRANS_UPDATES_TO_DL_LOC = "updatesToDlLocation";
    static final String TRANS_UPDATES_TO_LICENSE = "updatesToLicense";
    static final String TRANS_UPDATES_TO_SUMMARY = "updatesToSummary";
    static final String TRANS_LICENSE_TO_DL_LOC = "licenseToDlLocation";
    static final String TRANS_LICENSE_TO_DOWNLOAD = "licenseToDownload";
    static final String TRANS_LICENSE_TO_SUMMARY = "licenseToSummary";
    static final String TRANS_SOURCE_TO_LICENSE = "sourceToLicence";
    static final String TRANS_SOURCE_TO_DL_LOC = "sourceToDlLocation";
    static final String TRANS_SOURCE_TO_SUMMARY = "sourceToSummary";
    static final String TRANS_SOURCE_TO_UPDATES = "sourceToUpdates";
    static final String TRANS_DL_LOC_TO_SUMMARY = "dlLocationToSummary";
    private UpdateManager m_updateManager;
    private UpdateWizardModel m_model;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UpdateWizard(UpdateManager um) {
        this.m_updateManager = um;
    }

    static {
        $assertionsDisabled = UpdateWizard.class.desiredAssertionStatus() ^ true;
    }

    public boolean runWizard(Component parent, Context context) {
        UpdateManager.getInstance().getAutomaticCheckForUpdates().uninstallNotificationIcon();
        if (UpdateManager.getInstance().getDeferredUpdatesFile().exists() && !MessageDialog.confirm((Component)parent, (Object)UpdateArb.format(180, Ide.getProgramShortName()), (String)UpdateArb.getString(163), null)) {
            return false;
        }
        List masterServers = context == null ? null : (List)context.getProperty("autoCfuMasterList");
        boolean showDlLoc = !UpdateManager.getInstance().isSingleUserMode() && UpdateManager.getInstance().isGlobalExtensionInstallationAllowed();
        FSMBuilder fsmBuilder = new FSMBuilder();
        if (masterServers == null) {
            Step welcomeStep = WelcomePanel.newStep((String)UpdateArb.getString(31), (String)UpdateArb.getString(64), (String)UpdateArb.format(28, Ide.getProgramName()), (String)(UpdateWizard.class.getName() + "1013"), (String)"f1_idewideupdatewelcome_html");
            fsmBuilder.newStartState(welcomeStep, (Object)STATE_SOURCE);
        }
        Step step = new Step(UpdateArb.getString(141), UpdateSourcePage.class, "f1_idewideupdatesource_html");
        if (masterServers != null) {
            fsmBuilder.newStartState(step, (Object)STATE_UPDATE);
        } else {
            fsmBuilder.newState((Object)STATE_SOURCE, step, (Object)STATE_UPDATE);
        }
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_DL_LOC, (Object)STATE_DOWNLOAD_LOCATION);
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_LICENSE, (Object)STATE_LICENSE);
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_SUMMARY, (Object)STATE_SUMMARY);
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_UPDATES, (Object)STATE_UPDATE);
        step = new Step(UpdateArb.getString(21), UpdatePage.class, "f1_idewideupdateupdates_html");
        fsmBuilder.newState((Object)STATE_UPDATE, step, (Object)(showDlLoc ? STATE_DOWNLOAD_LOCATION : STATE_DOWNLOAD));
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_DL_LOC, (Object)STATE_DOWNLOAD_LOCATION);
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_DOWNLOAD, (Object)STATE_DOWNLOAD);
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_LICENSE, (Object)STATE_LICENSE);
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_SUMMARY, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(71), UpdateLicensePage.class, "f1_idewideupdatelicense_html");
        fsmBuilder.newState((Object)STATE_LICENSE, step, (Object)(showDlLoc ? STATE_DOWNLOAD_LOCATION : STATE_DOWNLOAD));
        fsmBuilder.addStateTrans((Object)TRANS_LICENSE_TO_DL_LOC, (Object)STATE_DOWNLOAD_LOCATION);
        fsmBuilder.addStateTrans((Object)TRANS_LICENSE_TO_DOWNLOAD, (Object)STATE_DOWNLOAD);
        fsmBuilder.addStateTrans((Object)TRANS_LICENSE_TO_SUMMARY, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(183), DownloadLocationPage.class, "f1_idewideupdatedownloadlocation_html");
        fsmBuilder.newState((Object)STATE_DOWNLOAD_LOCATION, step, (Object)STATE_DOWNLOAD);
        fsmBuilder.addStateTrans((Object)TRANS_DL_LOC_TO_SUMMARY, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(129), DownloadPage.class, "f1_idewideupdatedownload_html");
        fsmBuilder.newState((Object)STATE_DOWNLOAD, step, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(166), SummaryPage.class, "f1_idewideupdatesummary_html");
        fsmBuilder.newFinalState((Object)STATE_SUMMARY, step);
        try {
            WizardDialog wd;
            FSM stateMachine = fsmBuilder.getFSM();
            Namespace ns = new Namespace();
            this.m_model = new UpdateWizardModel(this.getUpdateManager());
            if (masterServers != null) {
                this.m_model.setForcedCenters(masterServers);
            }
            ns.put(KEY_MODEL, (Object)this.m_model);
            FSMWizard wizard = new FSMWizard(stateMachine, ns);
            wizard.setWelcomePageAdded(masterServers == null);
            wizard.setFinishPageAdded(true);
            wizard.setWizardTitle(UpdateArb.getString(31));
            wizard.setShowStepNumber(true);
            wizard.setLogoImage(new ImageIcon(UpdateWizard.class.getResource("wizard.png")).getImage());
            Dialog dlg = DialogUtil.getAncestorDialog((Component)parent);
            if (dlg != null) {
                wd = wizard.getDialog(dlg);
            } else {
                Frame f = DialogUtil.getAncestorFrame((Component)parent);
                wd = wizard.getDialog(f);
            }
            wizard.addCommitListener((CommitListener)new 1());
            boolean bl = WizardLauncher.runDialog((JDialog)wd);
            return bl;
        }
        catch (FSMInvalidException fie) {
            fie.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unexpected FSMInvalidException");
            }
            return false;
        }
    }

    private File getInstallHookFile() {
        String homeDir = Ide.getOracleHomeDirectory();
        return new File(homeDir, "installhooks.properties");
    }

    private void commit() {
        TaskList tl = new TaskList();
        if (this.getModel().getLocalBundle() != null) {
            LocalUpdateBundle localBundle = this.getModel().getLocalBundle();
            this.seedInstaller(tl, localBundle.getBundle(), localBundle.getBundleFile());
        } else {
            Map zipFilesByBundle = this.getModel().getDownloadedUpdates();
            if (zipFilesByBundle == null) {
                return;
            }
            ArrayList deinstallTasks = new ArrayList();
            ArrayList installTasks = new ArrayList();
            for (Map.Entry entry : zipFilesByBundle.entrySet()) {
                UpdateBundle bundle = (UpdateBundle)entry.getKey();
                File zipFile = (File)entry.getValue();
                this.seedInstaller(tl, bundle, zipFile);
            }
            tl.addAll(deinstallTasks);
            tl.addAll(installTasks);
        }
        File duFile = UpdateManager.getInstance().getDeferredUpdatesFile();
        try {
            tl.save(URLFactory.newFileURL((File)duFile));
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
        try {
            UpdateManager.getInstance().setUpdateCenters(this.getModel().getAllUpdateCenters());
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
    }

    private void seedInstaller(TaskList tl, UpdateBundle bundle, File zipFile) {
        for (UpdateInfo update : bundle.getUpdates()) {
            Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(update.getID());
            if (extension == null) continue;
            tl.add(new DeinstallExtensionTask(update.getID()));
        }
        File destinationDir = this.getDestinationDir(bundle);
        tl.add(new InstallExtensionTask(zipFile.getPath(), destinationDir.getPath(), false));
        for (UpdateInfo update : bundle.getUpdates()) {
            String postStartupHook = update.getPostStartupHookClass();
            if (postStartupHook == null || (postStartupHook = postStartupHook.trim()).length() <= 0) continue;
            tl.add(new ScheduleHookTask(postStartupHook, this.getInstallHookFile().getPath()));
        }
    }

    private File getDestinationDir(UpdateBundle bundle) {
        if (bundle.getInstallLocation() != null && "${oracle.home}".equals(bundle.getInstallLocation())) {
            return new File(Ide.getOracleHomeDirectory());
        }
        Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(((UpdateInfo)bundle.getUpdates().iterator().next()).getID());
        if (extension == null) {
            return new File(this.getModel().isInstallForEveryone() ? UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome() : UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        ExtensionRegistry extReg = (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
        if (extReg.isUserExtension(extension.getID())) {
            return new File(UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        return new File(UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome());
    }

    UpdateWizardModel getModel() {
        return this.m_model;
    }

    private UpdateManager getUpdateManager() {
        return this.m_updateManager;
    }

    static void mav$commit(UpdateWizard updateWizard) {
        updateWizard.commit();
    }

    final class 1
    implements CommitListener {
        public void checkCommit(ApplyEvent event) throws TraversalException {
        }

        public void commit(ApplyEvent event) throws TraversalException {
            UpdateWizard.mav$commit(UpdateWizard.this);
        }

        public void rollback(ApplyEvent event) {
        }

        public void cancel(ApplyEvent event) {
            UpdateWizard.this.getModel().setWizardCancelled(true);
        }
    }
}

