/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.IdeUIManager;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMessage;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.ideimpl.webupdate.wizard.UpdateInfoPanel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.data.ListStructure;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import org.xml.sax.SAXParseException;

public class UpdatesPanel
extends JPanel {
    private final GridBagLayout _layout;
    private final JLabel _updatesLabel;
    private final JCheckBox _onlyUpgrades;
    private final NiceList _updatesList;
    private final SimpleListModel<UpdateItem> _allListModel;
    private final Map _itemsByUpdateInfo;
    private final JPanel _progressPanel;
    private final JButton _progressStop;
    private final JProgressBar _progressBar;
    private final HyperlinkButton _statusLink;
    private final ButtonBar _selectButtonBar;
    private final JButton _selectAllButton;
    private final JButton _deselectAllButton;
    private final SearchField _searchField;
    private transient CheckUpdatesRunnable _checkRunnable;
    private transient Thread _checkRunnableThread;
    private ActionListener _statusLinkListener;
    private boolean _stoppedCheck;
    private boolean _checkedForUpdates;
    private final transient ListDataListener _listDataListener;

    private void $init$() {
        this._layout = new GridBagLayout();
        this._updatesLabel = new JLabel();
        this._onlyUpgrades = new JCheckBox();
        this._updatesList = new NiceList();
        this._allListModel = new SimpleListModel();
        this._itemsByUpdateInfo = new HashMap();
        this._progressPanel = new JPanel();
        this._progressStop = new JButton();
        this._progressBar = new JProgressBar();
        this._statusLink = new HyperlinkButton();
        this._selectButtonBar = new ButtonBar();
        this._selectAllButton = new JButton();
        this._deselectAllButton = new JButton();
        this._searchField = new SearchField();
        this._stoppedCheck = false;
        this._checkedForUpdates = false;
        this._listDataListener = new 1();
    }

    public UpdatesPanel() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        2 renderer = new 2();
        renderer.setGradientColor(IdeUIManager.getActiveTitleGradientLightColor(), IdeUIManager.getActiveTitleGradientDarkColor());
        renderer.setTwoLineDescription(true);
        this._updatesList.setCellRenderer((ListCellRenderer)((Object)renderer));
        this._updatesList.setModel(this._allListModel);
        this._updatesList.setSelectionMode(0);
        this._updatesList.setFireCheckboxActionOnDoubleClick(true);
        this._onlyUpgrades.setSelected(false);
        this._progressBar.setStringPainted(true);
    }

    boolean isCheckedForUpdates() {
        return this._checkedForUpdates;
    }

    boolean hasUpdates() {
        return this._allListModel.getSize() != 0;
    }

    private synchronized void setStopped(boolean stopped) {
        this._stoppedCheck = stopped;
        this._progressStop.setEnabled(stopped ^ true);
    }

    private synchronized boolean isStopped() {
        return this._stoppedCheck;
    }

    private SimpleListModel getListModel() {
        return (SimpleListModel)this._updatesList.getModel();
    }

    private void installListeners() {
        Listener l = new Listener(null);
        this._updatesList.addListActionListener((NiceListActionListener)l);
        this._onlyUpgrades.addActionListener(l);
        this._selectAllButton.addActionListener(l);
        this._deselectAllButton.addActionListener(l);
        this._progressStop.addActionListener(l);
        this._allListModel.addListDataListener(this._listDataListener);
        this._searchField.addSearchListener((SearchListener)new 3());
    }

    private void resControls() {
        this._statusLink.setText(UpdateArb.getString(179));
        ResourceUtils.resLabel((JLabel)this._updatesLabel, (Component)this._updatesList, (String)UpdateArb.getString(42));
        ResourceUtils.resButton((AbstractButton)this._onlyUpgrades, (String)UpdateArb.getString(56));
        ResourceUtils.resButton((AbstractButton)this._progressStop, (String)UpdateArb.getString(136));
        ResourceUtils.resButton((AbstractButton)this._selectAllButton, (String)UpdateArb.getString(69));
        ResourceUtils.resButton((AbstractButton)this._deselectAllButton, (String)UpdateArb.getString(117));
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        gbc.anchor = 17;
        JPanel north = new JPanel();
        north.setLayout(new BorderLayout(30, 0));
        north.add((Component)this._updatesLabel, "West");
        north.add((Component)this._searchField, "Center");
        this.add((Component)north, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        JScrollPane scrollPane = new JScrollPane((Component)this._updatesList);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPane, gbc);
        JPanel checkBoxAndButtons = new JPanel();
        checkBoxAndButtons.setLayout(new BorderLayout());
        checkBoxAndButtons.add((Component)this._onlyUpgrades, "West");
        checkBoxAndButtons.add((Component)this._selectButtonBar, "East");
        this._selectButtonBar.setAlignment(4);
        this._selectButtonBar.add((Component)this._selectAllButton);
        this._selectButtonBar.add((Component)this._deselectAllButton);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        this.add((Component)checkBoxAndButtons, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        this.add((Component)this._progressPanel, gbc);
        this._progressPanel.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 17;
        this._progressPanel.add((Component)this._progressBar, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this._progressPanel.add((Component)this._progressStop, gbc);
        ++gbc.gridx;
        this._progressPanel.add((Component)this._statusLink, gbc);
    }

    private void showUpdateInformation(UpdateItem item) {
        if (item.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
            BrowserRunner.getBrowserRunner().runBrowserOnURL(URLFactory.newURL((String)item.getUpdate().getURL()), null, null);
        } else {
            new UpdateInfoPanel().runDialog(this, item.getUpdate());
        }
    }

    public Component getInitialFocus() {
        return this._updatesList;
    }

    private void populateUpdates(Collection updates) {
        this._onlyUpgrades.setEnabled(updates.isEmpty() ^ true);
        this._searchField.setEnabled(updates.isEmpty() ^ true);
        if (updates.isEmpty()) {
            this.showStatusMessage(OracleIcons.getIcon((String)"warning.png"), UpdateArb.getString(52), null);
            return;
        }
        ArrayList sortedUpdates = new ArrayList(updates);
        Collections.sort(sortedUpdates);
        4 c = new 4();
        Collections.sort(sortedUpdates, c);
        updates = sortedUpdates;
        for (UpdateInfo update : updates) {
            UpdateItem item = new UpdateItem(update);
            item.setSelected(update.getType() == UpdateInfo.Type.PATCH);
            this._itemsByUpdateInfo.put(update, item);
            this._allListModel.addElement((Object)item);
        }
    }

    protected void completeValueChanged() {
    }

    private void updateSelectAllButtons() {
        boolean isEmpty = this.getListModel().getSize() == 0;
        this._selectAllButton.setEnabled(isEmpty ^ true);
        this._deselectAllButton.setEnabled(isEmpty ^ true);
    }

    public void populate(UpdateWizardModel model) {
        this._checkedForUpdates = false;
        this.completeValueChanged();
        this.setStopped(false);
        this._allListModel.removeAll();
        this._itemsByUpdateInfo.clear();
        this._onlyUpgrades.setEnabled(false);
        this._updatesList.setModel(this._allListModel);
        this._selectAllButton.setEnabled(false);
        this._deselectAllButton.setEnabled(false);
        if (model.getLocalBundle() == null) {
            this._checkRunnable = new 5(model.getSelectedCenters());
            6 monitor = new 6();
            this._checkRunnable.setMonitor(monitor);
            Thread t = new Thread((Runnable)this._checkRunnable, "Check for updates");
            t.start();
        } else {
            this._progressPanel.setVisible(false);
            LocalUpdateBundle localBundle = model.getLocalBundle();
            for (UpdateInfo update : localBundle.getBundle().getUpdates()) {
                UpdateItem item = new UpdateItem(update);
                item.setSelected(true);
                this._allListModel.addElement((Object)item);
                this._itemsByUpdateInfo.put(update, item);
            }
            this._onlyUpgrades.setEnabled(false);
            this._onlyUpgrades.setSelected(false);
            this._updatesList.setModel(this._allListModel);
            this.completeValueChanged();
        }
    }

    private void resetFilter() {
        String currentFilter = this._searchField.getText();
        if (currentFilter.length() == 0) {
            return;
        }
        this.filterList("");
        this.filterList(currentFilter);
    }

    private void showStatusMessage(Icon icon, String message) {
        this.showStatusMessage(icon, message, null);
    }

    private void showStatusMessage(Icon icon, String message, Throwable t) {
        this._progressBar.setVisible(false);
        this._progressStop.setVisible(false);
        this._statusLink.setVisible(t != null);
        this._progressPanel.setVisible(true);
        if (t != null) {
            if (this._statusLinkListener != null) {
                this._statusLink.removeActionListener(this._statusLinkListener);
            }
            this._statusLinkListener = this.createStatusLinkListener(t, message);
            this._statusLink.addActionListener(this._statusLinkListener);
        }
    }

    private ActionListener createStatusLinkListener(Throwable t, String message) {
        if (t instanceof SAXParseException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(26));
        }
        if (t instanceof FileNotFoundException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(73));
        }
        if (t instanceof IOException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(7));
        }
        return new UnknownExceptionAction(t, message);
    }

    protected void cleanUp() {
        if (this._checkRunnableThread != null) {
            try {
                this.setStopped(true);
                this._checkRunnableThread.join();
                this._checkRunnableThread = null;
                this._checkRunnable = null;
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    public boolean isComplete() {
        if (!this._checkedForUpdates) {
            return false;
        }
        if (this.getListModel().getSize() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.getListModel().getSize()) {
            UpdateItem item = (UpdateItem)this.getListModel().getElementAt(i);
            if (item.isSelected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    List getSelectedUpdates() {
        ArrayList<UpdateInfo> selectedUpdates = new ArrayList<UpdateInfo>();
        int i = 0;
        while (i < this._allListModel.getSize()) {
            UpdateItem item = (UpdateItem)this._allListModel.getElementAt(i);
            if (item.isSelected()) {
                selectedUpdates.add(item.getUpdate());
            }
            ++i;
        }
        return selectedUpdates;
    }

    protected void save(UpdateWizardModel model) {
        model.setSelectedUpdates(this.getSelectedUpdates());
    }

    public boolean canFinish() {
        return this._checkedForUpdates && this._allListModel.getSize() == 0;
    }

    boolean isLicenseRequired() {
        List updates = this.getSelectedUpdates();
        for (UpdateInfo info : updates) {
            if (info.getClickThroughURL() == null) continue;
            return true;
        }
        return false;
    }

    private void updateDependencies(UpdateItem item) {
        UpdateInfo updateInfo = item.getUpdate();
        if (item.isSelected() && !updateInfo.getRequiredUpdates().isEmpty()) {
            for (UpdateInfo requiredInfo : updateInfo.getRequiredUpdates()) {
                UpdateItem requiredItem = (UpdateItem)this._itemsByUpdateInfo.get(requiredInfo);
                requiredItem.setSelected(true);
                this.updateDependencies(requiredItem);
            }
        } else if (!item.isSelected()) {
            int i = 0;
            while (i < this._allListModel.getSize()) {
                boolean ok;
                UpdateItem otherItem = (UpdateItem)this._allListModel.getElementAt(i);
                if (otherItem.isSelected() && otherItem.getUpdate().getRequiredUpdates().contains(updateInfo) && !(ok = MessageDialog.confirm((Component)this, (Object)UpdateArb.format(61, updateInfo.getName(), otherItem.getUpdate().getName()), (String)UpdateArb.getString(57), null))) {
                    item.setSelected(true);
                }
                ++i;
            }
        }
        UpdateBundle bundle = item.getUpdate().getBundle();
        for (UpdateInfo update : bundle.getUpdates()) {
            if (update == item.getUpdate()) continue;
            UpdateItem bundleItem = (UpdateItem)this._itemsByUpdateInfo.get(update);
            bundleItem.setSelected(item.isSelected());
        }
        this.getListModel().changed();
    }

    private void setAllSelected(boolean allSelected) {
        SimpleListModel model = this.getListModel();
        for (UpdateItem item : model) {
            item.setSelected(allSelected);
        }
        model.changed();
    }

    private void filterList(String search) {
        Object selected = this._updatesList.getSelectedValue();
        SimpleListModel<UpdateItem> newModel = null;
        if (search.length() == 0 && !this._onlyUpgrades.isSelected()) {
            if (this.getListModel() == this._allListModel) {
                return;
            }
            newModel = this._allListModel;
        } else {
            newModel = new SimpleListModel<UpdateItem>();
            for (UpdateItem update : this._allListModel) {
                if (this._onlyUpgrades.isSelected() && update.getUpdate().isNew() && update.getUpdate().getType() != UpdateInfo.Type.PATCH && update.getUpdate().getType() != UpdateInfo.Type.MESSAGE || search.length() != 0 && !update.getUpdate().getName().toLowerCase().contains(search)) continue;
                newModel.addElement((Object)update);
            }
        }
        this.getListModel().removeListDataListener(this._listDataListener);
        this._updatesList.setModel(newModel);
        this.getListModel().addListDataListener(this._listDataListener);
        if (selected != null) {
            this._updatesList.setSelectedValue(selected, true);
        }
        this.updateSelectAllButtons();
        this.completeValueChanged();
    }

    static JCheckBox ra$_onlyUpgrades(UpdatesPanel updatesPanel) {
        return updatesPanel._onlyUpgrades;
    }

    static SearchField ra$_searchField(UpdatesPanel updatesPanel) {
        return updatesPanel._searchField;
    }

    static void mav$filterList(UpdatesPanel updatesPanel, String string) {
        updatesPanel.filterList(string);
    }

    static JButton ra$_progressStop(UpdatesPanel updatesPanel) {
        return updatesPanel._progressStop;
    }

    static void mav$setStopped(UpdatesPanel updatesPanel, boolean bl) {
        updatesPanel.setStopped(bl);
    }

    static JButton ra$_selectAllButton(UpdatesPanel updatesPanel) {
        return updatesPanel._selectAllButton;
    }

    static void mav$setAllSelected(UpdatesPanel updatesPanel, boolean bl) {
        updatesPanel.setAllSelected(bl);
    }

    static JButton ra$_deselectAllButton(UpdatesPanel updatesPanel) {
        return updatesPanel._deselectAllButton;
    }

    static SimpleListModel mav$getListModel(UpdatesPanel updatesPanel) {
        return updatesPanel.getListModel();
    }

    static void mav$updateDependencies(UpdatesPanel updatesPanel, UpdateItem updateItem) {
        updatesPanel.updateDependencies(updateItem);
    }

    static void mav$showUpdateInformation(UpdatesPanel updatesPanel, UpdateItem updateItem) {
        updatesPanel.showUpdateInformation(updateItem);
    }

    static void mav$updateSelectAllButtons(UpdatesPanel updatesPanel) {
        updatesPanel.updateSelectAllButtons();
    }

    static boolean mav$isStopped(UpdatesPanel updatesPanel) {
        return updatesPanel.isStopped();
    }

    static void mav$showStatusMessage(UpdatesPanel updatesPanel, Icon icon, String string, Throwable throwable) {
        updatesPanel.showStatusMessage(icon, string, throwable);
    }

    static void wa$_checkedForUpdates(UpdatesPanel updatesPanel, boolean bl) {
        updatesPanel._checkedForUpdates = bl;
    }

    static void mav$showStatusMessage(UpdatesPanel updatesPanel, Icon icon, String string) {
        updatesPanel.showStatusMessage(icon, string);
    }

    static void mav$populateUpdates(UpdatesPanel updatesPanel, Collection collection) {
        updatesPanel.populateUpdates(collection);
    }

    static void mav$resetFilter(UpdatesPanel updatesPanel) {
        updatesPanel.resetFilter();
    }

    static SimpleListModel ra$_allListModel(UpdatesPanel updatesPanel) {
        return updatesPanel._allListModel;
    }

    static JPanel ra$_progressPanel(UpdatesPanel updatesPanel) {
        return updatesPanel._progressPanel;
    }

    static JProgressBar ra$_progressBar(UpdatesPanel updatesPanel) {
        return updatesPanel._progressBar;
    }

    static HyperlinkButton ra$_statusLink(UpdatesPanel updatesPanel) {
        return updatesPanel._statusLink;
    }

    final class 1
    implements ListDataListener {
        public void intervalAdded(ListDataEvent e) {
            UpdatesPanel.mav$updateSelectAllButtons(UpdatesPanel.this);
        }

        public void intervalRemoved(ListDataEvent e) {
            UpdatesPanel.mav$updateSelectAllButtons(UpdatesPanel.this);
        }

        public void contentsChanged(ListDataEvent e) {
            UpdatesPanel.mav$updateSelectAllButtons(UpdatesPanel.this);
        }
    }

    final class 2
    extends NiceListRenderer {
        public String getTitle(Object update) {
            UpdateItem updateItem = (UpdateItem)update;
            if (updateItem.getUpdate().getType() == UpdateInfo.Type.EXTENSION) {
                return updateItem.getUpdate().getName() + " " + updateItem.getUpdate().getVersion().toString();
            }
            return updateItem.getUpdate().getName();
        }

        public String getDescription(Object update) {
            return ((UpdateItem)update).getUpdate().getDescription();
        }

        public String getSecondDescription(Object update) {
            UpdateInfo info = ((UpdateItem)update).getUpdate();
            if (info != null) {
                if (info.getType() == UpdateInfo.Type.MESSAGE) {
                    return " ";
                }
                if (info.getSourceCenter() != null) {
                    return UpdateArb.format(72, info.getSourceCenter().getName());
                }
                return "Local Update";
            }
            return " ";
        }

        public boolean isItemSelected(Object update) {
            return ((UpdateItem)update).isSelected();
        }

        public String getHyperLinkText(Object update) {
            UpdateItem item = (UpdateItem)update;
            if (item.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
                return ((UpdateCenterMessage)item.getUpdate()).getLinkText();
            }
            return UpdateArb.getString(179);
        }

        public String getSecondaryHyperLinkText(Object update) {
            UpdateItem item = (UpdateItem)update;
            if (item.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
                return "Hide";
            }
            return "";
        }

        public Icon getIndicator(Object update) {
            UpdateItem updateItem = (UpdateItem)update;
            if (updateItem.getUpdate().getType() == UpdateInfo.Type.PATCH) {
                return UpdateArb.getIcon(27);
            }
            if (updateItem.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
                return OracleIcons.getIcon((String)"info.png");
            }
            if (updateItem.getUpdate().isNew()) {
                return UpdateArb.getIcon(81);
            }
            return OracleIcons.getIcon((String)"update2.png");
        }

        public boolean isCheckable(Object update) {
            return ((UpdateItem)update).getUpdate().getType() != UpdateInfo.Type.MESSAGE;
        }
    }

    final class 3
    implements SearchListener {
        public void searchPerformed(SearchEvent se) {
            UpdatesPanel.mav$filterList(UpdatesPanel.this, se.getSearchText().toLowerCase());
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    }

    final class 4
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof UpdateInfo) || !(o2 instanceof UpdateInfo)) {
                return -1;
            }
            UpdateInfo update1 = (UpdateInfo)o1;
            UpdateInfo update2 = (UpdateInfo)o2;
            UpdateInfo.Type type1 = update1.getType();
            UpdateInfo.Type type2 = update2.getType();
            return type1.compareTo(type2);
        }
    }

    final class 5
    extends CheckUpdatesRunnable {
        protected void finished(Collection updates) {
            EventQueue.invokeLater(new 1(this, updates));
        }

        protected void stopped() {
            EventQueue.invokeLater(new 2());
        }

        protected void updateCenterError(UpdateCenter center, Throwable t) {
            EventQueue.invokeLater(new 3(this, center, t));
        }

        public 5(List list) {
            super(list);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Collection v$updates;
            final /* synthetic */ 5 this$0;

            public void run() {
                try {
                    UpdatesPanel.mav$populateUpdates(this.this$0.UpdatesPanel.this, this.v$updates);
                }
                finally {
                    UpdatesPanel.wa$_checkedForUpdates(this.this$0.UpdatesPanel.this, true);
                    this.this$0.UpdatesPanel.this.completeValueChanged();
                    UpdatesPanel.mav$updateSelectAllButtons(this.this$0.UpdatesPanel.this);
                    UpdatesPanel.mav$resetFilter(this.this$0.UpdatesPanel.this);
                }
            }

            public 1(5 var1_1, Collection collection) {
                this.v$updates = collection;
                this.this$0 = var1_1;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                UpdatesPanel.wa$_checkedForUpdates(UpdatesPanel.this, true);
                UpdatesPanel.mav$showStatusMessage(UpdatesPanel.this, OracleIcons.getIcon((String)"warning.png"), "Check for updates was stopped.");
                UpdatesPanel.this.completeValueChanged();
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ UpdateCenter v$center;
            private final /* synthetic */ Throwable v$t;
            final /* synthetic */ 5 this$0;

            public void run() {
                UpdatesPanel.mav$showStatusMessage(this.this$0.UpdatesPanel.this, OracleIcons.getIcon((String)"error.png"), UpdateArb.format(94, this.v$center.getName()), this.v$t);
            }

            public 3(5 var1_1, UpdateCenter updateCenter, Throwable throwable) {
                this.v$t = throwable;
                this.v$center = updateCenter;
                this.this$0 = var1_1;
            }
        }
    }

    final class 6
    implements UpdateCenterMonitor {
        public void setMessage(String message) {
            EventQueue.invokeLater(new 1(this, message));
        }

        public void setProgress(int progress) {
            EventQueue.invokeLater(new 2(this, progress));
        }

        public void setMaximum(int max) {
            EventQueue.invokeLater(new 3(this, max));
        }

        public void start() {
            EventQueue.invokeLater(new 4());
        }

        public void finish() {
            EventQueue.invokeLater(new 5());
        }

        public boolean isStopped() {
            return UpdatesPanel.mav$isStopped(UpdatesPanel.this);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ String v$message;
            final /* synthetic */ 6 this$0;

            public void run() {
                UpdatesPanel.ra$_progressBar(this.this$0.UpdatesPanel.this).setString(this.v$message);
            }

            public 1(6 var1_1, String string) {
                this.v$message = string;
                this.this$0 = var1_1;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ int v$progress;
            final /* synthetic */ 6 this$0;

            public void run() {
                UpdatesPanel.ra$_progressBar(this.this$0.UpdatesPanel.this).setValue(this.v$progress);
            }

            public 2(6 var1_1, int n) {
                this.v$progress = n;
                this.this$0 = var1_1;
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ int v$max;
            final /* synthetic */ 6 this$0;

            public void run() {
                UpdatesPanel.ra$_progressBar(this.this$0.UpdatesPanel.this).setMaximum(this.v$max);
            }

            public 3(6 var1_1, int n) {
                this.v$max = n;
                this.this$0 = var1_1;
            }
        }

        final class 4
        implements Runnable {
            public void run() {
                UpdatesPanel.ra$_progressBar(UpdatesPanel.this).setValue(0);
                UpdatesPanel.ra$_progressBar(UpdatesPanel.this).setVisible(true);
                UpdatesPanel.ra$_progressStop(UpdatesPanel.this).setVisible(true);
                UpdatesPanel.ra$_progressStop(UpdatesPanel.this).setEnabled(true);
                UpdatesPanel.ra$_statusLink(UpdatesPanel.this).setVisible(false);
                UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).setVisible(true);
                UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).invalidate();
                UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).validate();
            }
        }

        final class 5
        implements Runnable {
            public void run() {
                if (UpdatesPanel.ra$_allListModel(UpdatesPanel.this).getSize() > 0) {
                    UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).setVisible(false);
                }
            }
        }
    }

    private class KnownExceptionAction
    implements ActionListener {
        private final String _baseMessage;
        private final String _detailMessage;

        public KnownExceptionAction(Throwable exception, String baseMessage, String detailMessage) {
            this._baseMessage = baseMessage;
            this._detailMessage = detailMessage;
        }

        public void actionPerformed(ActionEvent ae) {
            MessageDialog.error((Component)UpdatesPanel.this, (Object)(this._baseMessage + "\n" + this._detailMessage), (String)UpdateArb.getString(142), null);
        }
    }

    private class UnknownExceptionAction
    implements ActionListener {
        private final Throwable _exception;
        private final String _message;

        public UnknownExceptionAction(Throwable exception, String message) {
            this._exception = exception;
            this._message = message;
        }

        public void actionPerformed(ActionEvent ae) {
            ExceptionDialog.showExceptionDialog((Component)UpdatesPanel.this, (Throwable)this._exception, (String)this._message, (String)UpdateArb.getString(142), null);
        }
    }

    private static class UpdateItem {
        private boolean _isSelected;
        private final UpdateInfo _update;

        private void $init$() {
            this._isSelected = false;
        }

        UpdateItem(UpdateInfo info) {
            this.$init$();
            this._update = info;
        }

        public UpdateInfo getUpdate() {
            return this._update;
        }

        public boolean isSelected() {
            return this._isSelected;
        }

        public void setSelected(boolean selected) {
            this._isSelected = selected;
        }

        public String toString() {
            return this.getUpdate().getName();
        }
    }

    private class Listener
    implements NiceListActionListener,
    ActionListener {
        public void listActionPerformed(NiceListActionEvent ae) {
            if (ae.getRow() >= 0) {
                UpdateItem item = (UpdateItem)UpdatesPanel.mav$getListModel(UpdatesPanel.this).getElementAt(ae.getRow());
                if (ae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                    item.setSelected(item.isSelected() ^ true);
                    UpdatesPanel.mav$updateDependencies(UpdatesPanel.this, item);
                    UpdatesPanel.mav$getListModel(UpdatesPanel.this).changed(ae.getRow());
                    UpdatesPanel.this.completeValueChanged();
                } else if (ae.getType() == NiceListActionEvent.Type.HYPERLINK) {
                    UpdatesPanel.mav$showUpdateInformation(UpdatesPanel.this, item);
                } else if (ae.getType() == NiceListActionEvent.Type.SECONDARY_HYPERLINK) {
                    UpdatesPanel.mav$getListModel(UpdatesPanel.this).removeElement((Object)item);
                    CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                    ListStructure hiddenMessages = prefs.getHiddenMessages();
                    if (hiddenMessages == null) {
                        hiddenMessages = ListStructure.newInstance();
                        prefs.setHiddenMessages(hiddenMessages);
                    }
                    hiddenMessages.add(item.getUpdate().getID());
                }
            }
        }

        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == UpdatesPanel.ra$_onlyUpgrades(UpdatesPanel.this)) {
                UpdatesPanel.mav$filterList(UpdatesPanel.this, UpdatesPanel.ra$_searchField(UpdatesPanel.this).getText());
            } else if (ae.getSource() == UpdatesPanel.ra$_progressStop(UpdatesPanel.this)) {
                UpdatesPanel.mav$setStopped(UpdatesPanel.this, true);
            } else if (ae.getSource() == UpdatesPanel.ra$_selectAllButton(UpdatesPanel.this)) {
                UpdatesPanel.mav$setAllSelected(UpdatesPanel.this, true);
                UpdatesPanel.this.completeValueChanged();
            } else if (ae.getSource() == UpdatesPanel.ra$_deselectAllButton(UpdatesPanel.this)) {
                UpdatesPanel.mav$setAllSelected(UpdatesPanel.this, false);
                UpdatesPanel.this.completeValueChanged();
            }
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

