/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.collection;

import java.util.Enumeration;
import java.util.Vector;

public class ImmutableArray {
    private Object[] _array;

    public ImmutableArray() {
        this._array = new Object[0];
    }

    public ImmutableArray(Object[] objectArray) {
        this._array = (Object[])objectArray.clone();
    }

    public ImmutableArray(Vector vector) {
        if (vector == null) {
            this._array = new Object[0];
        } else {
            int n = vector.size();
            this._array = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                this._array[n2] = vector.elementAt(n2);
                ++n2;
            }
        }
    }

    public ImmutableArray(Enumeration enumeration) {
        if (enumeration == null) {
            this._array = new Object[0];
        } else {
            int n = 0;
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
                ++n;
            }
            this._array = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                this._array[n2] = vector.elementAt(n2);
                ++n2;
            }
        }
    }

    public Object get(int n) throws ArrayIndexOutOfBoundsException {
        return this._array[n];
    }

    public int size() {
        return this._array.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImmutableArray)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Object[] objectArray = this._array;
        Object[] objectArray2 = ((ImmutableArray)object)._array;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object2 = objectArray[n];
            Object object3 = objectArray2[n];
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            --n;
        }
        return true;
    }

    public int hashCode() {
        Object[] objectArray = this._array;
        int n = objectArray.length;
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            n2 = 31 * n2 + (object == null ? 0 : object.hashCode());
            ++n3;
        }
        return n2;
    }
}

