/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.collection;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class OptimisticHashMap
extends Dictionary
implements Cloneable {
    private transient Entry[] _bins;
    private transient int _entryCount;
    private transient int _realCount;
    private int _threshold;
    private float _loadFactor;

    public OptimisticHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this._loadFactor = f;
        this._bins = new Entry[n];
        this._threshold = Math.max((int)((float)n * f), 1);
    }

    public OptimisticHashMap(int n) {
        this(n, 0.75f);
    }

    public OptimisticHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this._entryCount;
    }

    public boolean isEmpty() {
        return this._entryCount == 0;
    }

    public synchronized Enumeration keys() {
        return new Enumerator(true);
    }

    public synchronized Enumeration elements() {
        return new Enumerator(false);
    }

    public boolean contains(Object object) {
        Cloneable cloneable;
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this._bins;
        int n = entryArray.length;
        while (n-- > 0) {
            cloneable = entryArray[n];
            while (cloneable != null) {
                if (object.equals(((Entry)cloneable).value)) {
                    return true;
                }
                cloneable = ((Entry)cloneable).next;
            }
        }
        cloneable = this;
        synchronized (cloneable) {
            entryArray = this._bins;
            int n2 = entryArray.length;
            while (n2-- > 0) {
                Entry entry = entryArray[n2];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = object.hashCode();
        Entry[] entryArray = this._bins;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Object object2 = null;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && object.equals(entry.key)) {
                object2 = entry.value;
                break;
            }
            entry = entry.next;
        }
        if (object2 == null) {
            OptimisticHashMap optimisticHashMap = this;
            synchronized (optimisticHashMap) {
                entryArray = this._bins;
                n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                Entry entry2 = entryArray[n2];
                while (entry2 != null) {
                    if (n == entry2.hash && object.equals(entry2.key)) {
                        Object object3 = entry2.value;
                        return object3;
                    }
                    entry2 = entry2.next;
                }
            }
        }
        return object2;
    }

    protected void rehash() {
        int n;
        Entry[] entryArray = this._bins;
        int n2 = entryArray.length;
        double d = (double)this._realCount / (double)this._entryCount;
        if (d > 0.8) {
            n = n2 * 2 + 1;
        } else {
            n = (int)((double)n2 * (1.0 / d) + 1.0);
            if ((n & 1) == 1) {
                ++n;
            }
        }
        Entry[] entryArray2 = new Entry[n];
        this._threshold = (int)((float)n * this._loadFactor);
        int n3 = n2;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                if (entry.value != null) {
                    Entry entry2;
                    int n4 = (entry.hash & Integer.MAX_VALUE) % n;
                    entryArray2[n4] = entry2 = new Entry(entry.hash, entry.key, entry.value, entryArray2[n4]);
                }
                entry = entry.next;
            }
        }
        this._realCount = this._entryCount;
        this._bins = entryArray2;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (object2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this._bins;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && object.equals(entry.key)) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        if (this._entryCount >= this._threshold) {
            this.rehash();
            entryArray = this._bins;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = new Entry(n, object, object2, entryArray[n2]);
        ++this._entryCount;
        ++this._realCount;
        return null;
    }

    public synchronized Object remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Entry[] entryArray = this._bins;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && object.equals(entry.key)) {
                Object object2 = entry.value;
                entry.value = null;
                --this._entryCount;
                return object2;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        this._entryCount = 0;
        this._realCount = 0;
        this._bins = new Entry[this._bins.length];
    }

    public synchronized Object clone() {
        try {
            OptimisticHashMap optimisticHashMap = (OptimisticHashMap)super.clone();
            Entry[] entryArray = optimisticHashMap._bins;
            Entry[] entryArray2 = new Entry[entryArray.length];
            int n = entryArray2.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                Entry entry2 = entryArray2[n] = entry != null && entry.value != null ? (Entry)entry.clone() : null;
            }
            optimisticHashMap._realCount = optimisticHashMap._entryCount;
            optimisticHashMap._bins = entryArray2;
            return optimisticHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        stringBuffer.append('{');
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            Object e = enumeration.nextElement();
            stringBuffer.append(e);
            stringBuffer.append('=');
            stringBuffer.append(this.get(e));
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private class Enumerator
    implements Enumeration {
        private Entry[] _bins;
        private Entry _currEntry;
        private int _binIndex;
        private boolean _returnKeys;

        public Enumerator(boolean bl) {
            this._returnKeys = bl;
            this._bins = OptimisticHashMap.this._bins;
            this._binIndex = this._bins.length;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this._currEntry == null) ** GOTO lbl9
            return true;
lbl-1000:
            // 1 sources

            {
                this._currEntry = this._bins[this._binIndex];
                while (this._currEntry != null && this._currEntry.value == null) {
                    this._currEntry = this._currEntry.next;
                }
                if (this._currEntry == null) continue;
                return true;
lbl9:
                // 2 sources

                ** while (this._binIndex-- > 0)
            }
lbl10:
            // 1 sources

            return false;
        }

        public Object nextElement() {
            if (this._currEntry == null && !this.hasMoreElements()) {
                throw new NoSuchElementException(this.toString());
            }
            Entry entry = this._currEntry;
            this._currEntry = this._currEntry.next;
            while (this._currEntry != null && this._currEntry.value == null) {
                this._currEntry = this._currEntry.next;
            }
            if (this._returnKeys) {
                return entry.key;
            }
            return entry.value;
        }
    }

    private static class Entry
    implements Cloneable {
        int hash;
        Object key;
        Object value;
        Entry next;

        protected Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            Entry entry = this.next;
            while (entry != null && entry.value == null) {
                entry = entry.next;
            }
            return new Entry(this.hash, this.key, this.value, entry);
        }
    }
}

