/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SpoolFile {
    private static final long LIMIT = 0x20000000L;
    private File myDirectory;
    private LinkedList myFiles;

    public SpoolFile(File directory) {
        this.myDirectory = directory;
        this.myFiles = new LinkedList();
    }

    public OutputStream openForWriting() {
        return new SpoolOutputStream();
    }

    public InputStream openForReading() {
        return new SpoolInputStream();
    }

    public void delete() throws SVNException {
        Iterator files = this.myFiles.iterator();
        while (files.hasNext()) {
            File file = (File)files.next();
            SVNFileUtil.deleteFile(file);
        }
    }

    private class SpoolOutputStream
    extends OutputStream {
        private OutputStream myCurrentOutput;
        private long myCurrentSize;

        private SpoolOutputStream() {
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)});
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.myCurrentOutput == null) {
                File file = this.createNextFile();
                SpoolFile.this.myFiles.add(file);
                this.myCurrentOutput = new BufferedOutputStream(new FileOutputStream(file));
            }
            this.myCurrentOutput.write(b, off, len);
            this.myCurrentSize += (long)len;
            if (this.myCurrentSize >= 0x20000000L) {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.myCurrentOutput != null) {
                try {
                    this.myCurrentOutput.close();
                }
                finally {
                    this.myCurrentOutput = null;
                }
            }
            this.myCurrentSize = 0L;
        }

        public void flush() throws IOException {
            if (this.myCurrentOutput != null) {
                this.myCurrentOutput.flush();
            }
        }

        private File createNextFile() throws IOException {
            File file = File.createTempFile(".svnkit.", ".spool", SpoolFile.this.myDirectory);
            file.createNewFile();
            return file;
        }
    }

    private class SpoolInputStream
    extends InputStream {
        private File myCurrentFile;
        private long myCurrentSize;
        private InputStream myCurrentInput;

        private SpoolInputStream() {
        }

        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int read = this.read(buffer);
            if (read <= 0) {
                return -1;
            }
            return read;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.myCurrentFile == null) {
                if (SpoolFile.this.myFiles.isEmpty()) {
                    return -1;
                }
                this.openNextFile();
            }
            int toRead = (int)Math.min((long)len, this.myCurrentSize);
            toRead = this.myCurrentInput.read(b, off, toRead);
            this.myCurrentSize -= (long)toRead;
            if (this.myCurrentSize == 0L) {
                this.closeCurrentFile();
            }
            return toRead;
        }

        private void openNextFile() throws FileNotFoundException {
            this.myCurrentFile = (File)SpoolFile.this.myFiles.removeFirst();
            this.myCurrentSize = this.myCurrentFile.length();
            this.myCurrentInput = new BufferedInputStream(new FileInputStream(this.myCurrentFile));
        }

        public long skip(long n) throws IOException {
            if (this.myCurrentFile == null) {
                if (SpoolFile.this.myFiles.isEmpty()) {
                    return -1L;
                }
                this.openNextFile();
            }
            long toSkip = Math.min(this.myCurrentSize, n);
            toSkip = this.myCurrentInput.skip(toSkip);
            this.myCurrentSize -= toSkip;
            if (this.myCurrentSize == 0L) {
                this.closeCurrentFile();
            }
            return toSkip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeCurrentFile() throws IOException {
            block5: {
                try {
                    this.myCurrentInput.close();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    try {
                        SVNFileUtil.deleteFile(this.myCurrentFile);
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                    this.myCurrentFile = null;
                    throw throwable;
                }
                try {
                    SVNFileUtil.deleteFile(this.myCurrentFile);
                    break block5;
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
                {
                }
            }
            this.myCurrentFile = null;
        }

        public void close() throws IOException {
            if (this.myCurrentFile != null) {
                this.closeCurrentFile();
            }
        }
    }
}

