/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.CharsetDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNInputFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNFileUtil {
    private static final String ID_COMMAND;
    private static final String LN_COMMAND;
    public static final String LS_COMMAND;
    private static final String CHMOD_COMMAND;
    private static final String ATTRIB_COMMAND;
    private static final String ENV_COMMAND;
    public static final boolean isWindows;
    public static final boolean isOS2;
    public static final boolean isOSX;
    public static final boolean isBSD;
    public static boolean isLinux;
    public static final boolean isOpenVMS;
    public static final OutputStream DUMMY_OUT;
    public static final InputStream DUMMY_IN;
    private static String nativeEOLMarker;
    private static String ourGroupID;
    private static String ourUserID;
    private static File ourAppDataPath;
    private static String ourAdminDirectoryName;
    private static File ourSystemAppDataPath;
    public static final String BINARY_MIME_TYPE = "application/octet-stream";
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$wc$SVNFileUtil;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$System;

    public static String getBasePath(File file) {
        File adminDir;
        File base;
        for (base = file.getParentFile(); !(base == null || base.isDirectory() && (adminDir = new File(base, SVNFileUtil.getAdminDirectoryName())).exists() && adminDir.isDirectory()); base = base.getParentFile()) {
        }
        String path = file.getAbsolutePath();
        if (base != null) {
            path = path.substring(base.getAbsolutePath().length());
        }
        if ((path = path.replace(File.separatorChar, '/')).startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static boolean createEmptyFile(File file) throws SVNException {
        boolean created;
        if (file != null && file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            created = file != null ? file.createNewFile() : false;
        }
        catch (IOException e) {
            created = false;
        }
        if (!created) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new file ''{0}''", file);
            SVNErrorManager.error(err);
        }
        return created;
    }

    public static File createUniqueFile(File parent, String name, String suffix) throws SVNException {
        File file = new File(parent, name + suffix);
        for (int i = 1; i < 99999; ++i) {
            if (SVNFileType.getType(file) == SVNFileType.NONE) {
                return file;
            }
            file = new File(parent, name + "." + i + suffix);
        }
        if (SVNFileType.getType(file) == SVNFileType.NONE) {
            return file;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNIQUE_NAMES_EXHAUSTED, "Unable to make name for ''{0}''", new File(parent, name));
        SVNErrorManager.error(err);
        return null;
    }

    public static void rename(File src, File dst) throws SVNException {
        if (SVNFileType.getType(src) == SVNFileType.NONE) {
            SVNFileUtil.deleteFile(dst);
            return;
        }
        if (dst.isDirectory()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot overwrite file ''{0}''; it is a directory", dst);
            SVNErrorManager.error(err);
        }
        boolean renamed = false;
        if (!isWindows) {
            renamed = src.renameTo(dst);
        } else if (SVNJNAUtil.moveFile(src, dst)) {
            renamed = true;
        } else {
            boolean wasRO = dst.exists() && !dst.canWrite();
            SVNFileUtil.setReadonly(src, false);
            SVNFileUtil.setReadonly(dst, false);
            for (int i = 0; i < 10; ++i) {
                dst.delete();
                if (src.renameTo(dst)) {
                    if (wasRO) {
                        dst.setReadOnly();
                    }
                    return;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (!renamed) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot rename file ''{0}''", src);
            SVNErrorManager.error(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setReadonly(File file, boolean readonly) {
        block11: {
            if (!file.exists()) {
                return false;
            }
            if (isOpenVMS) {
                return true;
            }
            if (readonly) {
                return file.setReadOnly();
            }
            if (isWindows ? SVNJNAUtil.setWritable(file) : (isLinux || isOSX || isBSD) && SVNJNAUtil.setWritable(file)) {
                return true;
            }
            if (file.canWrite()) {
                return true;
            }
            try {
                if (file.length() < 102400L) {
                    File tmp = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".ro");
                    SVNFileUtil.copyFile(file, tmp, false);
                    SVNFileUtil.copyFile(tmp, file, false);
                    SVNFileUtil.deleteFile(tmp);
                    break block11;
                }
                if (isWindows) {
                    Process p = null;
                    try {
                        p = Runtime.getRuntime().exec(ATTRIB_COMMAND + " -R \"" + file.getAbsolutePath() + "\"");
                        p.waitFor();
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.destroyProcess(p);
                        throw throwable;
                    }
                    SVNFileUtil.destroyProcess(p);
                    break block11;
                }
                SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, "ugo+w", file.getAbsolutePath()});
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().info(th);
                return false;
            }
        }
        return true;
    }

    public static void setExecutable(File file, boolean executable) {
        if (isWindows || isOpenVMS || file == null || !file.exists()) {
            return;
        }
        if (SVNJNAUtil.setExecutable(file, executable)) {
            return;
        }
        try {
            if (file.canWrite()) {
                SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, executable ? "ugo+x" : "ugo-x", file.getAbsolutePath()});
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().info(th);
        }
    }

    public static File resolveSymlinkToFile(File file) {
        File targetFile = file;
        while (SVNFileType.getType(targetFile) == SVNFileType.SYMLINK) {
            String symlinkName = SVNFileUtil.getSymlinkName(targetFile);
            if (symlinkName == null) {
                return null;
            }
            if (symlinkName.startsWith("/")) {
                targetFile = new File(symlinkName);
                continue;
            }
            targetFile = new File(targetFile.getParentFile(), symlinkName);
        }
        if (targetFile == null || !targetFile.isFile()) {
            return null;
        }
        return targetFile;
    }

    public static void copy(File src, File dst, boolean safe, boolean copyAdminDirectories) throws SVNException {
        String name;
        SVNFileType srcType = SVNFileType.getType(src);
        if (srcType == SVNFileType.FILE) {
            SVNFileUtil.copyFile(src, dst, safe);
        } else if (srcType == SVNFileType.DIRECTORY) {
            SVNFileUtil.copyDirectory(src, dst, copyAdminDirectories, null);
        } else if (srcType == SVNFileType.SYMLINK && (name = SVNFileUtil.getSymlinkName(src)) != null) {
            SVNFileUtil.createSymlink(dst, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyFile(File src, File dst, boolean safe) throws SVNException {
        long tstamp;
        SVNErrorMessage error;
        boolean executable;
        File tmpDst;
        block35: {
            IOException e222;
            FileOutputStream os;
            FileInputStream is;
            AbstractInterruptibleChannel dstChannel;
            FileChannel srcChannel;
            block33: {
                long totalSize;
                if (src == null || dst == null) {
                    return;
                }
                if (src.equals(dst)) {
                    return;
                }
                if (!src.exists()) {
                    dst.delete();
                    return;
                }
                tmpDst = dst;
                if (dst.exists()) {
                    if (safe) {
                        tmpDst = SVNFileUtil.createUniqueFile(dst.getParentFile(), ".copy", ".tmp");
                    } else {
                        dst.delete();
                    }
                }
                executable = SVNFileUtil.isExecutable(src);
                dst.getParentFile().mkdirs();
                srcChannel = null;
                dstChannel = null;
                is = null;
                os = null;
                error = null;
                is = new FileInputStream(src);
                srcChannel = is.getChannel();
                os = new FileOutputStream(tmpDst);
                dstChannel = os.getChannel();
                for (long toCopy = totalSize = srcChannel.size(); toCopy > 0L; toCopy -= ((FileChannel)dstChannel).transferFrom(srcChannel, totalSize - toCopy, toCopy)) {
                }
                Object var15_15 = null;
                if (srcChannel == null) break block33;
                try {
                    srcChannel.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (dstChannel != null) {
                try {
                    dstChannel.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            SVNFileUtil.closeFile(is);
            SVNFileUtil.closeFile(os);
            {
                break block35;
                catch (IOException e3) {
                    IOException e222;
                    error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy file ''{0}'' to ''{1}'': {2}", new Object[]{src, dst, e3.getLocalizedMessage()});
                    Object var15_16 = null;
                    if (srcChannel != null) {
                        try {
                            srcChannel.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (dstChannel != null) {
                        try {
                            dstChannel.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    SVNFileUtil.closeFile(is);
                    SVNFileUtil.closeFile(os);
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var15_17 = null;
                if (srcChannel != null) {
                    try {
                        srcChannel.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (dstChannel != null) {
                    try {
                        dstChannel.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                SVNFileUtil.closeFile(is);
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
        }
        if (error != null) {
            error = null;
            InputStream sis = null;
            OutputStream dos = null;
            try {
                sis = SVNFileUtil.openFileForReading(src);
                dos = SVNFileUtil.openFileForWriting(dst);
                SVNTranslator.copy(sis, dos);
            }
            catch (IOException e) {
                try {
                    error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy file ''{0}'' to ''{1}'': {2}", new Object[]{src, dst, e.getLocalizedMessage()});
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(dos);
                    SVNFileUtil.closeFile(sis);
                    throw throwable;
                }
                SVNFileUtil.closeFile(dos);
                SVNFileUtil.closeFile(sis);
            }
            SVNFileUtil.closeFile(dos);
            SVNFileUtil.closeFile(sis);
        }
        if (error != null) {
            SVNErrorManager.error(error);
        }
        if (safe && tmpDst != dst) {
            SVNFileUtil.rename(tmpDst, dst);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dst, true);
        }
        if ((tstamp = src.lastModified()) >= 0L) {
            dst.setLastModified(tstamp);
        }
    }

    public static boolean createSymlink(File link, File linkName) throws SVNException {
        if (isWindows || isOpenVMS) {
            return false;
        }
        if (SVNFileType.getType(link) != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create symbolic link ''{0}''; file already exists", link);
            SVNErrorManager.error(err);
        }
        String linkTarget = "";
        try {
            linkTarget = SVNFileUtil.readSingleLine(linkName);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        if (linkTarget.startsWith("link")) {
            linkTarget = linkTarget.substring("link".length()).trim();
        }
        return SVNFileUtil.createSymlink(link, linkTarget);
    }

    public static boolean createSymlink(File link, String linkName) {
        if (SVNJNAUtil.createSymlink(link, linkName)) {
            return true;
        }
        try {
            SVNFileUtil.execCommand(new String[]{LN_COMMAND, "-s", linkName, link.getAbsolutePath()});
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().info(th);
        }
        return SVNFileType.getType(link) == SVNFileType.SYMLINK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean detranslateSymlink(File src, File linkFile) throws SVNException {
        if (isWindows || isOpenVMS) {
            return false;
        }
        if (SVNFileType.getType(src) != SVNFileType.SYMLINK) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", src);
            SVNErrorManager.error(err);
        }
        String linkPath = SVNFileUtil.getSymlinkName(src);
        OutputStream os = SVNFileUtil.openFileForWriting(linkFile);
        try {
            os.write("link ".getBytes("UTF-8"));
            os.write(linkPath.getBytes("UTF-8"));
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
        return true;
    }

    public static String getSymlinkName(File link) {
        if (isWindows || isOpenVMS || link == null) {
            return null;
        }
        String ls = null;
        ls = SVNJNAUtil.getLinkTarget(link);
        if (ls != null) {
            return ls;
        }
        try {
            ls = SVNFileUtil.execCommand(new String[]{LS_COMMAND, "-ld", link.getAbsolutePath()});
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().info(th);
        }
        if (ls == null || ls.lastIndexOf(" -> ") < 0) {
            return null;
        }
        String[] attributes = ls.split("\\s+");
        return attributes[attributes.length - 1];
    }

    public static String computeChecksum(String line) {
        MessageDigest digest;
        if (line == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        if (digest == null) {
            return null;
        }
        digest.update(line.getBytes());
        return SVNFileUtil.toHexDigest(digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeChecksum(File file) throws SVNException {
        MessageDigest digest;
        if (file == null || file.isDirectory() || !file.exists()) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
            return null;
        }
        InputStream is = SVNFileUtil.openFileForReading(file);
        byte[] buffer = new byte[16384];
        try {
            int l;
            while ((l = is.read(buffer)) > 0) {
                digest.update(buffer, 0, l);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return SVNFileUtil.toHexDigest(digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFiles(File f1, File f2, MessageDigest digest) throws SVNException {
        if (f1 == null || f2 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "NULL paths are supported in compareFiles method");
            SVNErrorManager.error(err);
            return false;
        }
        if (f1.equals(f2)) {
            return true;
        }
        boolean equals = true;
        if (f1.length() != f2.length()) {
            if (digest == null) {
                return false;
            }
            equals = false;
        }
        InputStream is1 = SVNFileUtil.openFileForReading(f1);
        InputStream is2 = SVNFileUtil.openFileForReading(f2);
        try {
            while (true) {
                int b2;
                int b1;
                if ((b1 = is1.read()) != (b2 = is2.read())) {
                    if (digest == null) {
                        boolean bl = false;
                        return bl;
                    }
                    equals = false;
                }
                if (b1 < 0) {
                    break;
                }
                if (digest == null) continue;
                digest.update((byte)(b1 & 0xFF));
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
        }
        return equals;
    }

    public static void setHidden(File file, boolean hidden) {
        if (isWindows && SVNJNAUtil.setHidden(file)) {
            return;
        }
        if (!isWindows || file == null || !file.exists() || file.isHidden()) {
            return;
        }
        try {
            Runtime.getRuntime().exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().info(th);
        }
    }

    public static void deleteAll(File dir, ISVNEventHandler cancelBaton) throws SVNException {
        SVNFileUtil.deleteAll(dir, true, cancelBaton);
    }

    public static void deleteAll(File dir, boolean deleteDirs) {
        try {
            SVNFileUtil.deleteAll(dir, deleteDirs, null);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    public static void deleteAll(File dir, boolean deleteDirs, ISVNEventHandler cancelBaton) throws SVNException {
        File[] children;
        if (dir == null) {
            return;
        }
        SVNFileType fileType = SVNFileType.getType(dir);
        File[] fileArray = children = fileType == SVNFileType.DIRECTORY ? SVNFileListUtil.listFiles(dir) : null;
        if (children != null) {
            if (cancelBaton != null) {
                cancelBaton.checkCancelled();
            }
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                SVNFileUtil.deleteAll(child, deleteDirs, cancelBaton);
            }
            if (cancelBaton != null) {
                cancelBaton.checkCancelled();
            }
        }
        if (fileType == SVNFileType.DIRECTORY && !deleteDirs) {
            return;
        }
        SVNFileUtil.deleteFile(dir);
    }

    public static boolean deleteFile(File file) throws SVNException {
        if (file == null) {
            return true;
        }
        if (!isWindows || file.isDirectory() || !file.exists()) {
            return file.delete();
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete() && !file.exists()) {
                return true;
            }
            if (!file.exists()) {
                return true;
            }
            SVNFileUtil.setReadonly(file, false);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot delete file ''{0}''", file);
        SVNErrorManager.error(err);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readSingleLine(File file) throws IOException {
        if (!file.isFile() || !file.canRead()) {
            throw new IOException("can't open file '" + file.getAbsolutePath() + "'");
        }
        BufferedReader reader = null;
        String line = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            line = reader.readLine();
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(is);
            throw throwable;
        }
        SVNFileUtil.closeFile(is);
        return line;
    }

    public static String toHexDigest(MessageDigest digest) {
        if (digest == null) {
            return null;
        }
        byte[] result = digest.digest();
        String hexDigest = "";
        for (int i = 0; i < result.length; ++i) {
            byte b = result[i];
            int lo = b & 0xF;
            int hi = b >> 4 & 0xF;
            hexDigest = hexDigest + Integer.toHexString(hi) + Integer.toHexString(lo);
        }
        return hexDigest;
    }

    public static String toHexDigest(byte[] digest) {
        if (digest == null) {
            return null;
        }
        String hexDigest = "";
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            int lo = b & 0xF;
            int hi = b >> 4 & 0xF;
            hexDigest = hexDigest + Integer.toHexString(hi) + Integer.toHexString(lo);
        }
        return hexDigest;
    }

    public static byte[] fromHexDigest(String hexDigest) {
        if (hexDigest == null || hexDigest.length() == 0) {
            return null;
        }
        String hexMD5Digest = hexDigest.toLowerCase();
        int digestLength = hexMD5Digest.length() / 2;
        if (digestLength == 0 || 2 * digestLength != hexMD5Digest.length()) {
            return null;
        }
        byte[] digest = new byte[digestLength];
        for (int i = 0; i < hexMD5Digest.length() / 2; ++i) {
            byte b;
            if (!SVNFileUtil.isHex(hexMD5Digest.charAt(2 * i)) || !SVNFileUtil.isHex(hexMD5Digest.charAt(2 * i + 1))) {
                return null;
            }
            int hi = Character.digit(hexMD5Digest.charAt(2 * i), 16) << 4;
            int lo = Character.digit(hexMD5Digest.charAt(2 * i + 1), 16);
            Integer ib = new Integer(hi | lo);
            digest[i] = b = ib.byteValue();
        }
        return digest;
    }

    private static boolean isHex(char ch) {
        return Character.isDigit(ch) || Character.toUpperCase(ch) >= 'A' && Character.toUpperCase(ch) <= 'F';
    }

    public static String getNativeEOLMarker() {
        if (nativeEOLMarker == null) {
            nativeEOLMarker = new String(SVNTranslator.getEOL("native"));
        }
        return nativeEOLMarker;
    }

    public static long roundTimeStamp(long tstamp) {
        return tstamp / 1000L * 1000L;
    }

    public static void sleepForTimestamp() {
        long time = System.currentTimeMillis();
        time = 1100L - (time - time / 1000L * 1000L);
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String readLineFromStream(InputStream is, StringBuffer buffer, CharsetDecoder decoder) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int r = -1;
        while ((r = is.read()) != 10) {
            if (r == -1) {
                String out = SVNFileUtil.decode(decoder, byteBuffer.toByteArray());
                buffer.append(out);
                return null;
            }
            byteBuffer.write(r);
        }
        String out = SVNFileUtil.decode(decoder, byteBuffer.toByteArray());
        buffer.append(out);
        return out;
    }

    private static String decode(CharsetDecoder decoder, byte[] in) {
        ByteBuffer inBuf = ByteBuffer.wrap(in);
        CharBuffer outBuf = CharBuffer.allocate(inBuf.capacity() * Math.round(decoder.maxCharsPerByte() + 0.5f));
        decoder.decode(inBuf, outBuf, true);
        decoder.flush(outBuf);
        decoder.reset();
        return outBuf.flip().toString();
    }

    public static String detectMimeType(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        int read = 0;
        read = is.read(buffer);
        int binaryCount = 0;
        for (int i = 0; i < read; ++i) {
            byte b = buffer[i];
            if (b == 0) {
                return BINARY_MIME_TYPE;
            }
            if (b >= 7 && (b <= 13 || b >= 32) && b <= 127) continue;
            ++binaryCount;
        }
        if (read > 0 && binaryCount * 1000 / read > 850) {
            return BINARY_MIME_TYPE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectMimeType(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        InputStream is = null;
        try {
            is = SVNFileUtil.openFileForReading(file);
            String string = SVNFileUtil.detectMimeType(is);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        catch (SVNException e) {
            String string = null;
            return string;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
    }

    public static boolean isExecutable(File file) {
        if (isWindows || isOpenVMS) {
            return false;
        }
        Boolean executable = SVNJNAUtil.isExecutable(file);
        if (executable != null) {
            return executable;
        }
        String[] commandLine = new String[]{LS_COMMAND, "-ln", file.getAbsolutePath()};
        String line = null;
        try {
            if (file.canRead()) {
                line = SVNFileUtil.execCommand(commandLine);
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().info(th);
        }
        if (line == null || line.indexOf(32) < 0) {
            return false;
        }
        int index = 0;
        String mod = null;
        String fuid = null;
        String fgid = null;
        StringTokenizer tokens = new StringTokenizer(line, " \t");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (index == 0) {
                mod = token;
            } else if (index == 2) {
                fuid = token;
            } else if (index == 3) {
                fgid = token;
            } else if (index > 3) break;
            ++index;
        }
        if (mod == null) {
            return false;
        }
        if (SVNFileUtil.getCurrentUser().equals(fuid)) {
            return mod.toLowerCase().indexOf(120) >= 0 && mod.toLowerCase().indexOf(120) < 4;
        }
        if (SVNFileUtil.getCurrentGroup().equals(fgid)) {
            return mod.toLowerCase().indexOf(120, 4) >= 4 && mod.toLowerCase().indexOf(120, 4) < 7;
        }
        return mod.toLowerCase().indexOf(120, 7) >= 7;
    }

    public static void copyDirectory(File srcDir, File dstDir, boolean copyAdminDir, ISVNEventHandler cancel) throws SVNException {
        if (!dstDir.exists()) {
            dstDir.mkdirs();
            dstDir.setLastModified(srcDir.lastModified());
        }
        File[] files = SVNFileListUtil.listFiles(srcDir);
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (file.getName().equals("..") || file.getName().equals(".") || file.equals(dstDir)) continue;
            if (cancel != null) {
                cancel.checkCancelled();
            }
            if (!copyAdminDir && file.getName().equals(SVNFileUtil.getAdminDirectoryName())) continue;
            SVNFileType fileType = SVNFileType.getType(file);
            File dst = new File(dstDir, file.getName());
            if (fileType == SVNFileType.FILE) {
                boolean executable = SVNFileUtil.isExecutable(file);
                SVNFileUtil.copyFile(file, dst, false);
                if (!executable) continue;
                SVNFileUtil.setExecutable(dst, executable);
                continue;
            }
            if (fileType == SVNFileType.DIRECTORY) {
                SVNFileUtil.copyDirectory(file, dst, copyAdminDir, cancel);
                if (!file.isHidden() && !SVNFileUtil.getAdminDirectoryName().equals(file.getName())) continue;
                SVNFileUtil.setHidden(dst, true);
                continue;
            }
            if (fileType != SVNFileType.SYMLINK) continue;
            String name = SVNFileUtil.getSymlinkName(file);
            SVNFileUtil.createSymlink(dst, name);
        }
    }

    public static OutputStream openFileForWriting(File file) throws SVNException {
        return SVNFileUtil.openFileForWriting(file, false);
    }

    public static OutputStream openFileForWriting(File file, boolean append) throws SVNException {
        if (file == null) {
            return null;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.isFile() && !file.canWrite()) {
            if (append) {
                SVNFileUtil.setReadonly(file, false);
            } else {
                SVNFileUtil.deleteFile(file);
            }
        }
        try {
            return new BufferedOutputStream(new FileOutputStream(file, append));
        }
        catch (FileNotFoundException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to ''{0}'': {1}", new Object[]{file, e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
            return null;
        }
    }

    public static RandomAccessFile openRAFileForWriting(File file, boolean append) throws SVNException {
        if (file == null) {
            return null;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        RandomAccessFile raFile = null;
        try {
            raFile = new RandomAccessFile(file, "rw");
            if (append) {
                raFile.seek(raFile.length());
            }
        }
        catch (FileNotFoundException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not write to file ''{0}'': {1}", new Object[]{file, e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not set position pointer in file ''{0}'': {1}", new Object[]{file, ioe.getLocalizedMessage()});
            SVNErrorManager.error(err, ioe);
        }
        return raFile;
    }

    public static InputStream openFileForReading(File file) throws SVNException {
        if (file == null) {
            return null;
        }
        if (!file.isFile() || !file.canRead()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from to ''{0}'': path refers to directory or read access is denied", file);
            SVNErrorManager.error(err);
        }
        if (!file.exists()) {
            return DUMMY_IN;
        }
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from to ''{0}'': {1}", new Object[]{file, e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
            return null;
        }
    }

    public static RandomAccessFile openRAFileForReading(File file) throws SVNException {
        SVNErrorMessage err;
        if (file == null) {
            return null;
        }
        if (!file.isFile() || !file.canRead()) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': path refers to a directory or read access is denied", file);
            SVNErrorManager.error(err);
        }
        if (!file.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "File ''{0}'' does not exist", file);
            SVNErrorManager.error(err);
        }
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': {1}", new Object[]{file, e.getLocalizedMessage()});
            SVNErrorManager.error(err2);
            return null;
        }
    }

    public static void closeFile(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(ISVNInputFile inFile) {
        if (inFile == null) {
            return;
        }
        try {
            inFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(RandomAccessFile raf) {
        if (raf == null) {
            return;
        }
        try {
            raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void destroyProcess(Process process) {
        if (process != null) {
            SVNFileUtil.closeFile(process.getInputStream());
            SVNFileUtil.closeFile(process.getOutputStream());
            SVNFileUtil.closeFile(process.getErrorStream());
            process.destroy();
        }
    }

    public static String execCommand(String[] commandLine) {
        return SVNFileUtil.execCommand(commandLine, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execCommand(String[] commandLine, boolean waitAfterRead) {
        InputStream is = null;
        StringBuffer result = new StringBuffer();
        Process process = null;
        try {
            int rc;
            int r;
            int rc2;
            process = Runtime.getRuntime().exec(commandLine);
            is = process.getInputStream();
            if (!waitAfterRead && (rc2 = process.waitFor()) != 0) {
                String string = null;
                return string;
            }
            while ((r = is.read()) >= 0) {
                result.append((char)(r & 0xFF));
            }
            if (waitAfterRead && (rc = process.waitFor()) != 0) {
                String string = null;
                return string;
            }
            String string = result.toString().trim();
            return string;
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().info(e);
        }
        catch (InterruptedException e) {
            SVNDebugLog.getDefaultLog().info(e);
        }
        finally {
            SVNFileUtil.destroyProcess(process);
        }
        return null;
    }

    private static String getCurrentUser() {
        if (isWindows || isOpenVMS) {
            return System.getProperty("user.name");
        }
        if (ourUserID == null && (ourUserID = SVNFileUtil.execCommand(new String[]{ID_COMMAND, "-u"})) == null) {
            ourUserID = "0";
        }
        return ourUserID;
    }

    private static String getCurrentGroup() {
        if (isWindows || isOpenVMS) {
            return System.getProperty("user.name");
        }
        if (ourGroupID == null && (ourGroupID = SVNFileUtil.execCommand(new String[]{ID_COMMAND, "-g"})) == null) {
            ourGroupID = "0";
        }
        return ourGroupID;
    }

    public static void closeFile(Writer os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeFile(Reader is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getAdminDirectoryName() {
        if (ourAdminDirectoryName == null) {
            String defaultAdminDir = ".svn";
            if (SVNFileUtil.getEnvironmentVariable("SVN_ASP_DOT_NET_HACK") != null) {
                defaultAdminDir = "_svn";
            }
            if ((ourAdminDirectoryName = System.getProperty("svnkit.admindir", System.getProperty("javasvn.admindir", defaultAdminDir))) == null || "".equals(ourAdminDirectoryName.trim())) {
                ourAdminDirectoryName = defaultAdminDir;
            }
        }
        return ourAdminDirectoryName;
    }

    public static void setAdminDirectoryName(String name) {
        ourAdminDirectoryName = name;
    }

    public static File getApplicationDataPath() {
        if (ourAppDataPath != null) {
            return ourAppDataPath;
        }
        String envAppData = SVNFileUtil.getEnvironmentVariable("APPDATA");
        ourAppDataPath = envAppData == null ? new File(new File(System.getProperty("user.home")), "Application Data") : new File(envAppData);
        return ourAppDataPath;
    }

    public static File getSystemApplicationDataPath() {
        if (ourSystemAppDataPath != null) {
            return ourSystemAppDataPath;
        }
        String envAppData = SVNFileUtil.getEnvironmentVariable("ALLUSERSPROFILE");
        ourSystemAppDataPath = envAppData == null ? new File(new File("C:/Documents and Settings/All Users"), "Application Data") : new File(envAppData, "Application Data");
        return ourSystemAppDataPath;
    }

    public static String getEnvironmentVariable(String name) {
        try {
            Object value;
            Method getenv = (class$java$lang$System == null ? (class$java$lang$System = SVNFileUtil.class$("java.lang.System")) : class$java$lang$System).getMethod("getenv", class$java$lang$String == null ? (class$java$lang$String = SVNFileUtil.class$("java.lang.String")) : class$java$lang$String);
            if (getenv != null && (value = getenv.invoke(null, name)) instanceof String) {
                return (String)value;
            }
        }
        catch (Throwable e) {
            try {
                return SVNFileUtil.getEnvironment().getProperty(name);
            }
            catch (Throwable e1) {
                SVNDebugLog.getDefaultLog().info(e);
                SVNDebugLog.getDefaultLog().info(e1);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getEnvironment() throws Throwable {
        Process p = null;
        Properties envVars = new Properties();
        Runtime r = Runtime.getRuntime();
        try {
            p = isWindows ? (System.getProperty("os.name").toLowerCase().indexOf("windows 9") >= 0 ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec(ENV_COMMAND);
            if (p != null) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(61);
                    if (idx < 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    envVars.setProperty(key, value);
                }
            }
        }
        catch (Throwable throwable) {
            SVNFileUtil.destroyProcess(p);
            throw throwable;
        }
        SVNFileUtil.destroyProcess(p);
        return envVars;
    }

    public static File createTempDirectory(String name) throws SVNException {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("svnkit" + name, ".tmp");
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create temporary directory: {1}", e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        tmpFile.mkdirs();
        return tmpFile;
    }

    public static File createTempFile(String prefix, String suffix) throws SVNException {
        File tmpFile = null;
        try {
            if (prefix.length() < 3) {
                prefix = "svn" + prefix;
            }
            tmpFile = File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create temporary file: {1}", e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        return tmpFile;
    }

    public static File getSystemConfigurationDirectory() {
        if (isWindows) {
            return new File(SVNFileUtil.getSystemApplicationDataPath(), "Subversion");
        }
        if (isOpenVMS) {
            return new File("/sys$config", "subversion").getAbsoluteFile();
        }
        return new File("/etc/subversion");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean windows;
        DUMMY_OUT = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        DUMMY_IN = new InputStream(){

            public int read() throws IOException {
                return -1;
            }
        };
        String osName = System.getProperty("os.name");
        boolean bl = windows = osName != null && osName.toLowerCase().indexOf("windows") >= 0;
        isOS2 = !windows && osName != null ? (windows = osName.toLowerCase().indexOf("os/2") >= 0) : false;
        isWindows = windows;
        isOSX = !isWindows && osName != null && osName.toLowerCase().indexOf("mac") >= 0;
        isLinux = !isWindows && osName != null && osName.toLowerCase().indexOf("linux") >= 0;
        isBSD = !isWindows && !isLinux && osName != null && osName.toLowerCase().indexOf("bsd") >= 0;
        boolean bl2 = isOpenVMS = osName != null && !isWindows && !isOSX && osName.toLowerCase().indexOf("openvms") >= 0;
        if (isOpenVMS) {
            SVNFileUtil.setAdminDirectoryName("_svn");
        }
        String prefix = "svnkit.program.";
        Properties props = new Properties();
        InputStream is = (class$org$tmatesoft$svn$core$internal$wc$SVNFileUtil == null ? (class$org$tmatesoft$svn$core$internal$wc$SVNFileUtil = SVNFileUtil.class$("org.tmatesoft.svn.core.internal.wc.SVNFileUtil")) : class$org$tmatesoft$svn$core$internal$wc$SVNFileUtil).getResourceAsStream("/svnkit.runtime.properties");
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
            }
            finally {
                SVNFileUtil.closeFile(is);
            }
        }
        ID_COMMAND = props.getProperty(prefix + "id", "id");
        LN_COMMAND = props.getProperty(prefix + "ln", "ln");
        LS_COMMAND = props.getProperty(prefix + "ls", "ls");
        CHMOD_COMMAND = props.getProperty(prefix + "chmod", "chmod");
        ATTRIB_COMMAND = props.getProperty(prefix + "attrib", "attrib");
        ENV_COMMAND = props.getProperty(prefix + "env", "env");
    }
}

