/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.index.keyword;

import javax.swing.text.Segment;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Indexer;
import oracle.ide.index.IndexingContext;
import oracle.ideimpl.index.util.CharArrayPool;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

public class KeywordIndexer
implements Indexer {
    protected static final int IDENTIFIER_ARRAY_SIZE = 256;
    protected static final boolean[] IDENTIFIER_PART = new boolean[256];
    protected static final boolean[] IDENTIFIER_START = new boolean[256];

    static {
        char i = '\u0000';
        while (i < '\u0100') {
            KeywordIndexer.IDENTIFIER_PART[i] = Character.isJavaIdentifierPart(i);
            KeywordIndexer.IDENTIFIER_START[i] = Character.isJavaIdentifierStart(i);
            i = (char)(i + '\u0001');
        }
    }

    public void startIndexing(IndexingContext context) {
    }

    public void endIndexing(IndexingContext context) {
    }

    public void index(IndexingContext context, DataCollector data) {
        char[] filter = null;
        Object filterKey = context.getFilterKey();
        if (filterKey != null) {
            if ("keyword.contains".equals(filterKey)) {
                String filterString = (String)context.getFilterValue();
                filter = filterString.toCharArray();
            } else {
                return;
            }
        }
        Segment segment = new Segment();
        this.indexImpl(context, data, filter, segment);
    }

    protected void indexImpl(IndexingContext context, DataCollector data, char[] filter, Segment segment) {
        TextBuffer buffer = context.getTextBuffer();
        int hash = 0;
        int start = -1;
        int end = -1;
        int len = buffer.getLength();
        int pos = 0;
        while (pos < len) {
            char c = buffer.getChar(pos);
            if (start == -1) {
                if (c < '\u0100' && IDENTIFIER_START[c] || Character.isJavaIdentifierStart(c)) {
                    start = pos;
                    hash = data.hash(0, c);
                }
            } else if (!(c < '\u0100' && IDENTIFIER_PART[c] || Character.isJavaIdentifierPart(c))) {
                end = pos;
            } else {
                hash = data.hash(hash, c);
            }
            ++pos;
            if (start == -1) continue;
            if (pos >= len && end == -1) {
                end = len;
            }
            if (end == -1) continue;
            this.reportKeyword(data, (ReadTextBuffer)buffer, start, end, filter, hash, 0, segment);
            end = -1;
            start = -1;
        }
    }

    protected void reportKeyword(DataCollector data, ReadTextBuffer buffer, int start, int end, char[] filter, int hash, int flags, Segment segment) {
        if (this.filterKeyword(buffer, start, end, filter, segment)) {
            data.add("keyword.contains", hash, flags, start, end);
        }
    }

    protected boolean filterKeyword(ReadTextBuffer buffer, int start, int end, char[] filter, Segment segment) {
        if (filter == null) {
            return true;
        }
        buffer.getText(start, end - start, segment);
        return CharArrayPool.CHAR_ARRAY_COMPARATOR.compare(filter, segment) == 0;
    }
}

