/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.ide.index.Index;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.index.QueryProgress;
import oracle.ide.index.QueryResult;
import oracle.ide.index.ResultCallback;
import oracle.ide.index.file.FileTable;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.index.BlockingQueueResultCallback;
import oracle.ideimpl.index.BuildFailedException;
import oracle.ideimpl.index.DataLocator;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexProgressMonitor;
import oracle.ideimpl.index.IndexRoot;
import oracle.ideimpl.index.IndexThreadFactory;
import oracle.ideimpl.index.IndexingContextImpl;
import oracle.ideimpl.index.NullResultCallback;
import oracle.ideimpl.index.ResultCollector;
import oracle.ideimpl.index.file.FileTableSnapshot;
import oracle.ideimpl.index.task.BackgroundTaskImpl;
import oracle.ideimpl.index.task.ProgressMonitor;
import oracle.ideimpl.index.util.ContentSetRoot;
import oracle.javatools.data.PropertyStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexImpl
implements Index {
    protected static final ExecutorService INDEX_SCHEDULER = Executors.newCachedThreadPool(new IndexThreadFactory("indexing"));
    private IndexRoot[] roots;
    private Project project;
    private volatile boolean released;
    private final AtomicInteger lockCount;
    private final FeedbackLogOptions created;

    private void $init$() {
        this.lockCount = new AtomicInteger();
        this.created = new FeedbackLogOptions((Throwable)new IllegalStateException(), 3);
    }

    public IndexImpl(Project project) {
        this(project, ProjectContent.getInstance((PropertyStorage)project).getAllContents());
        this.created.setApiDepth(Integer.valueOf(4));
    }

    public IndexImpl(Project project, ContentSet content) {
        this.$init$();
        this.project = project;
        Collection<ContentSetRoot> contentRoots = ContentSetRoot.getContentSetRoots(project, content);
        this.roots = new IndexRoot[contentRoots.size()];
        int i = 0;
        for (ContentSetRoot root : contentRoots) {
            this.roots[i++] = IndexRoot.getIndexRoot(project, root.getURL(), root.getFilters());
        }
    }

    public IndexImpl(Project project, URLPath path) {
        this.$init$();
        this.project = project;
        this.roots = new IndexRoot[path.size()];
        URL[] entries = path.getEntries();
        int i = 0;
        while (i < entries.length) {
            this.roots[i] = IndexRoot.getIndexRoot(project, entries[i], null);
            ++i;
        }
    }

    public IndexImpl(Project project, URL url) {
        this.$init$();
        this.project = project;
        this.roots = new IndexRoot[1];
        this.roots[0] = IndexRoot.getIndexRoot(project, url, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void lock() throws InterruptedException, LockFailedException {
        block7: {
            success = false;
            locked = new boolean[this.roots.length];
            try {
                i = 0;
                while (i < this.roots.length) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    this.roots[i].lock();
                    locked[i] = true;
                    ++i;
                }
                this.lockCount.incrementAndGet();
                success = true;
            }
            finally {
                if (success) break block7;
                i = 0;
                ** while (i < this.roots.length)
            }
lbl-1000:
            // 1 sources

            {
                if (locked[i]) {
                    this.roots[i].unlock();
                }
                ++i;
                continue;
            }
        }
    }

    @Override
    public void unlock() {
        if (this.lockCount.decrementAndGet() < 0) {
            throw new IllegalStateException("Index not locked");
        }
        IndexRoot[] indexRootArray = this.roots;
        int n = 0;
        while (n < indexRootArray.length) {
            IndexRoot root = indexRootArray[n];
            root.unlock();
            ++n;
        }
    }

    @Override
    public BackgroundTask build() {
        IndexProgressMonitor progress = new IndexProgressMonitor();
        IndexBuilder builder = new IndexBuilder(progress);
        Future<?> future = INDEX_SCHEDULER.submit(builder);
        return new IndexTask(future, progress);
    }

    @Override
    public void blockingBuild() throws InterruptedException {
        this.checkEventThread();
        this.buildImpl(null);
    }

    private void buildImpl(IndexProgressMonitor progress) throws InterruptedException {
        int total = 0;
        int[] numFilesToIndex = new int[this.roots.length];
        int i = 0;
        while (i < this.roots.length) {
            numFilesToIndex[i] = this.roots[i].getChangedFileCount();
            total += numFilesToIndex[i];
            ++i;
        }
        if (total > 0) {
            int current = 0;
            if (progress != null) {
                progress.setTotal(total);
                current = progress.getCurrentValue();
            }
            int i2 = 0;
            while (i2 < this.roots.length) {
                this.roots[i2].update(progress);
                if (progress != null) {
                    progress.setCurrentValue(current += numFilesToIndex[i2]);
                }
                ++i2;
            }
        }
    }

    private void queryImpl(QueryCriteria criteria, ResultCallback<QueryResult> callback, IndexProgressMonitor progress) throws InterruptedException, QueryFailedException {
        block9: {
            boolean complete = false;
            PerformanceLogger.get().startTiming("IndexImpl.queryImpl");
            try {
                QueryCriteria copy = new QueryCriteria();
                copy.putAll(criteria);
                QueryCriteria fileCriteria = FileTableSnapshot.getFileCriteria(copy);
                copy.keySet().removeAll(fileCriteria.keySet());
                FileTable[] tables = new FileTable[this.roots.length];
                ResultCollector[] results = new ResultCollector[this.roots.length];
                int i = 0;
                while (i < this.roots.length) {
                    tables[i] = this.roots[i].getFileTable();
                    results[i] = new ResultCollector(tables[i], callback);
                    FileTableSnapshot snapshot = (FileTableSnapshot)tables[i];
                    snapshot.query(fileCriteria, results[i], copy.isEmpty());
                    ++i;
                }
                if (copy.isEmpty()) break block9;
                try {
                    this.buildImpl(progress);
                }
                catch (RejectedExecutionException e) {
                    throw new QueryFailedException(e);
                }
                int i2 = 0;
                while (i2 < this.roots.length) {
                    this.roots[i2].query(copy, results[i2]);
                    ++i2;
                }
            }
            finally {
                if (complete) {
                    PerformanceLogger.get().stopTiming("IndexImpl.queryImpl", "Index query complete", 200);
                } else {
                    PerformanceLogger.get().stopTiming("IndexImpl.queryImpl", null);
                }
            }
        }
    }

    @Override
    public URL[] blockingQuery(QueryCriteria criteria) throws InterruptedException, QueryFailedException {
        this.checkEventThread();
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Emtpy index query");
        }
        NullResultCallback<URL> callback = new NullResultCallback<URL>();
        UrlResultCollectingCallback resultCallback = new UrlResultCollectingCallback(callback);
        this.queryImpl(criteria, resultCallback, null);
        return resultCallback.getResults();
    }

    @Override
    public Collection<QueryResult> blockingQueryEx(QueryCriteria criteria) throws InterruptedException, QueryFailedException {
        this.checkEventThread();
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Emtpy index query");
        }
        NullResultCallback<QueryResult> callback = new NullResultCallback<QueryResult>();
        QueryResultCollectingCallback resultCallback = new QueryResultCollectingCallback(callback);
        this.queryImpl(criteria, resultCallback, null);
        return resultCallback.getResults();
    }

    @Override
    public BackgroundTask<URL[]> query(QueryCriteria criteria) {
        return this.query(criteria, (BlockingQueue<URL>)null);
    }

    @Override
    public BackgroundTask<Collection<QueryResult>> queryEx(QueryCriteria criteria) {
        return this.queryEx(criteria, (BlockingQueue<QueryResult>)null);
    }

    @Override
    public BackgroundTask<URL[]> query(QueryCriteria criteria, BlockingQueue<URL> queue) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Emtpy index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        BlockingQueueResultCallback<URL> callback = new BlockingQueueResultCallback<URL>(queue, Index.END_OF_RESULTS);
        UrlResultCollectingCallback resultCallback = new UrlResultCollectingCallback(callback);
        IndexQuery<URL[]> query = new IndexQuery<URL[]>(criteria, resultCallback, progress);
        Future<URL[]> future = INDEX_SCHEDULER.submit(query);
        return new IndexTask<URL[]>(future, progress);
    }

    @Override
    public BackgroundTask<Collection<QueryResult>> queryEx(QueryCriteria criteria, BlockingQueue<QueryResult> queue) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Emtpy index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        BlockingQueueResultCallback<QueryResult> callback = new BlockingQueueResultCallback<QueryResult>(queue, Index.LAST_RESULT);
        QueryResultCollectingCallback resultCallback = new QueryResultCollectingCallback(callback);
        IndexQuery<Collection<QueryResult>> query = new IndexQuery<Collection<QueryResult>>(criteria, resultCallback, progress);
        Future<Collection<QueryResult>> future = INDEX_SCHEDULER.submit(query);
        return new IndexTask<Collection<QueryResult>>(future, progress);
    }

    @Override
    public QueryProgress query(QueryCriteria criteria, ResultCallback<URL> callback) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Emtpy index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        UrlResultCollectingCallback resultCallback = new UrlResultCollectingCallback(callback);
        IndexQuery<URL[]> query = new IndexQuery<URL[]>(criteria, resultCallback, progress);
        Future<URL[]> future = INDEX_SCHEDULER.submit(query);
        return new IndexTask<URL[]>(future, progress);
    }

    @Override
    public QueryProgress queryEx(QueryCriteria criteria, ResultCallback<QueryResult> callback) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Emtpy index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        QueryResultCollectingCallback resultCallback = new QueryResultCollectingCallback(callback);
        IndexQuery<Collection<QueryResult>> query = new IndexQuery<Collection<QueryResult>>(criteria, resultCallback, progress);
        Future<Collection<QueryResult>> future = INDEX_SCHEDULER.submit(query);
        return new IndexTask<Collection<QueryResult>>(future, progress);
    }

    @Override
    public int[][] locate(URL url, Object key, Object value) {
        DataLocator data = new DataLocator(key);
        IndexingContextImpl context = new IndexingContextImpl(this.project);
        context.setFilterKey(key);
        context.setFilterValue(value);
        context.startIndexing();
        try {
            context.index(url, -1, data);
        }
        finally {
            context.endIndexing();
        }
        return data.getLocations();
    }

    @Override
    public QueryProgress findNodes(Class nodeClass, ResultCallback<Node> callback) {
        QueryCriteria criteria = new QueryCriteria();
        criteria.put("file.all", "file.all");
        return this.findNodes(criteria, nodeClass, callback);
    }

    @Override
    public QueryProgress findNodes(QueryCriteria criteria, Class nodeClass, ResultCallback<Node> callback) {
        return this.query(criteria, new FindNodesResultCallback(nodeClass, callback));
    }

    @Override
    public void release() {
        this.releaseRoots();
        this.released = true;
    }

    public void finalize() {
        if (!this.released) {
            IndexLogger.getLogger().log(Level.SEVERE, "Index not released", this.created);
        }
        if (this.lockCount.get() > 0) {
            IndexLogger.getLogger().log(Level.SEVERE, "Index not unlocked", this.created);
        }
    }

    private void acquireRoots() {
        IndexRoot[] indexRootArray = this.roots;
        int n = 0;
        while (n < indexRootArray.length) {
            IndexRoot root = indexRootArray[n];
            root.acquire();
            ++n;
        }
    }

    private void releaseRoots() {
        IndexRoot[] indexRootArray = this.roots;
        int n = 0;
        while (n < indexRootArray.length) {
            IndexRoot root = indexRootArray[n];
            root.release();
            ++n;
        }
    }

    private void checkEventThread() {
        if (EventQueue.isDispatchThread()) {
            IndexLogger.getLogger().log(Level.FINEST, "Blocking index call on event thread", new IllegalStateException());
        }
    }

    static void mav$acquireRoots(IndexImpl indexImpl) {
        indexImpl.acquireRoots();
    }

    static void mav$queryImpl(IndexImpl indexImpl, QueryCriteria queryCriteria, ResultCallback resultCallback, IndexProgressMonitor indexProgressMonitor) {
        indexImpl.queryImpl(queryCriteria, resultCallback, indexProgressMonitor);
    }

    static void mav$releaseRoots(IndexImpl indexImpl) {
        indexImpl.releaseRoots();
    }

    static void mav$buildImpl(IndexImpl indexImpl, IndexProgressMonitor indexProgressMonitor) {
        indexImpl.buildImpl(indexProgressMonitor);
    }

    static void mav$checkEventThread(IndexImpl indexImpl) {
        indexImpl.checkEventThread();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexQuery<E>
    implements Callable<E> {
        private QueryCriteria criteria;
        private ResultCollectingCallback<E> callback;
        private IndexProgressMonitor progress;

        public IndexQuery(QueryCriteria criteria, ResultCollectingCallback<E> callback, IndexProgressMonitor progress) {
            this.criteria = criteria;
            this.callback = callback;
            this.progress = progress;
        }

        @Override
        public E call() throws QueryFailedException {
            try {
                IndexImpl.mav$acquireRoots(IndexImpl.this);
                try {
                    try {
                        IndexImpl.this.lock();
                        try {
                            IndexImpl.mav$queryImpl(IndexImpl.this, this.criteria, this.callback, this.progress);
                        }
                        finally {
                            IndexImpl.this.unlock();
                        }
                    }
                    catch (LockFailedException lfe) {
                        throw new QueryFailedException(lfe);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    IndexImpl.mav$releaseRoots(IndexImpl.this);
                }
            }
            finally {
                try {
                    this.callback.done();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    IndexLogger.getLogger().log(Level.SEVERE, "Exception in ResultCallback", e);
                }
            }
            return this.callback.getResults();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private interface ResultCollectingCallback<E>
    extends ResultCallback<QueryResult> {
        public E getResults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlResultCollectingCallback
    implements ResultCollectingCallback<URL[]> {
        private final ResultCallback<URL> callback;
        private final HashSet<URL> results;

        private void $init$() {
            this.results = new HashSet();
        }

        public UrlResultCollectingCallback(ResultCallback<URL> callback) {
            this.$init$();
            this.callback = callback;
        }

        @Override
        public void result(QueryResult result) throws InterruptedException {
            URL url = result.getURL();
            if (this.results.add(url)) {
                this.callback.result(url);
            }
        }

        @Override
        public void done() throws InterruptedException {
            this.callback.done();
        }

        @Override
        public URL[] getResults() {
            return this.results.toArray(new URL[this.results.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryResultCollectingCallback
    implements ResultCollectingCallback<Collection<QueryResult>> {
        private final ResultCallback<QueryResult> callback;
        private final ArrayList<QueryResult> results;

        private void $init$() {
            this.results = new ArrayList();
        }

        public QueryResultCollectingCallback(ResultCallback<QueryResult> callback) {
            this.$init$();
            this.callback = callback;
        }

        @Override
        public void result(QueryResult result) throws InterruptedException {
            this.results.add(result);
            this.callback.result(result);
        }

        @Override
        public void done() throws InterruptedException {
            this.callback.done();
        }

        @Override
        public Collection<QueryResult> getResults() {
            return Collections.unmodifiableList(this.results);
        }
    }

    private class IndexBuilder
    implements Runnable {
        private IndexProgressMonitor progress;

        public IndexBuilder(IndexProgressMonitor progress) {
            this.progress = progress;
        }

        public void run() {
            IndexImpl.mav$acquireRoots(IndexImpl.this);
            try {
                try {
                    IndexImpl.this.lock();
                    try {
                        IndexImpl.mav$buildImpl(IndexImpl.this, this.progress);
                    }
                    finally {
                        IndexImpl.this.unlock();
                    }
                }
                catch (LockFailedException lfe) {
                    throw new BuildFailedException(lfe);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                IndexImpl.mav$releaseRoots(IndexImpl.this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindNodesResultCallback
    implements ResultCallback<URL> {
        private Class nodeClass;
        private ResultCallback<Node> callback;

        public FindNodesResultCallback(Class nodeClass, ResultCallback<Node> callback) {
            this.nodeClass = nodeClass;
            this.callback = callback;
        }

        @Override
        public void result(URL url) throws InterruptedException {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (this.nodeClass.isAssignableFrom(node.getClass())) {
                    this.callback.result(node);
                }
            }
            catch (IllegalAccessException iae) {
                IndexLogger.getLogger().log(Level.SEVERE, "Unable to find node", iae);
            }
            catch (InstantiationException ie) {
                IndexLogger.getLogger().log(Level.SEVERE, "Unable to find node", ie);
            }
        }

        @Override
        public void done() throws InterruptedException {
            this.callback.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexTask<V>
    extends BackgroundTaskImpl<V> {
        public IndexTask(Future<V> future) {
            super(future);
        }

        public IndexTask(Future<V> future, ProgressMonitor progress) {
            super(future, progress);
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            IndexImpl.mav$checkEventThread(IndexImpl.this);
            return super.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            IndexImpl.mav$checkEventThread(IndexImpl.this);
            return super.get(timeout, unit);
        }
    }
}

