/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;

public class IndexInfo {
    public static final AssemblyFactory INDEX_INFO_FACTORY = new IndexInfoFactory();
    private static final int INDEX_INFO_VERSION = 3;
    private static final byte STORAGE_CODE = -22;
    private int indexInfoVersion;
    protected long version;
    protected long lastCleanup;

    public IndexInfo(long version, long lastCleanup) {
        this(3, version, lastCleanup);
    }

    public IndexInfo(int indexInfoVersion, long version, long lastCleanup) {
        this.indexInfoVersion = indexInfoVersion;
        this.version = version;
        this.lastCleanup = lastCleanup;
    }

    static int ra$indexInfoVersion(IndexInfo indexInfo) {
        return indexInfo.indexInfoVersion;
    }

    static final class IndexInfoFactory
    extends ObjectFactory {
        public byte getObjectCode() {
            return -22;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int indexInfoVersion = input.readInt();
            if (indexInfoVersion != 3) {
                throw new AssemblyException("Obsolete index info.  IndexInfo version: " + indexInfoVersion + "  Current version: " + 3, (AssemblyFactory)this);
            }
            long version = input.readLong();
            long lastCleanup = input.readLong();
            return new IndexInfo(indexInfoVersion, version, lastCleanup);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            IndexInfo indexInfo = (IndexInfo)object;
            output.writeInt(IndexInfo.ra$indexInfoVersion(indexInfo));
            output.writeLong(indexInfo.version);
            output.writeLong(indexInfo.lastCleanup);
        }

        IndexInfoFactory() {
        }
    }
}

