/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.Indexer;
import oracle.ide.index.keyword.KeywordIndexer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLPath;
import oracle.ideimpl.index.IndexImpl;
import oracle.ideimpl.index.xml.XMLIndexer;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexManagerImpl
extends IndexManager {
    private MultiMap<Class, Class> indexers;
    private ArrayList<Class> genericIndexers;

    private void $init$() {
        this.indexers = new MultiMap();
        this.genericIndexers = new ArrayList();
    }

    public IndexManagerImpl() {
        this.$init$();
        this.indexers.add(TextNode.class, KeywordIndexer.class);
        this.indexers.add(TextNode.class, XMLIndexer.class);
    }

    @Override
    public Index getIndex(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        return new IndexImpl(project);
    }

    @Override
    public Index getIndex(Project project, ContentSet content) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        return new IndexImpl(project, content);
    }

    @Override
    public Index getIndex(Project project, URLPath path) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        return new IndexImpl(project, path);
    }

    @Override
    public Index getIndex(Project project, URL url) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        return new IndexImpl(project, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexer(Class<? extends Indexer> indexer) {
        ArrayList<Class> arrayList = this.genericIndexers;
        synchronized (arrayList) {
            this.genericIndexers.add(indexer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addIndexer(Class<? extends Node> nodeClass, Class<? extends Indexer> indexer) {
        MultiMap<Class, Class> multiMap = this.indexers;
        synchronized (multiMap) {
            this.indexers.add(nodeClass, indexer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Class> getIndexers() {
        ArrayList<Class> arrayList = this.genericIndexers;
        synchronized (arrayList) {
            List list = (List)this.genericIndexers.clone();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiMap<Class, Class> getIndexerMap() {
        MultiMap<Class, Class> multiMap = this.indexers;
        synchronized (multiMap) {
            MultiMap multiMap2 = new MultiMap(this.indexers);
            return multiMap2;
        }
    }
}

